clear
set more off

/**************************************************************/
**　データの読み込み
import delimited "https://www.fbc.keio.ac.jp/~tyabu/keiryo/dailyint_data.csv", clear
browse

gen time = _n
tsset time

/**************************************************************/
** 変数の定義(ドル円レートは変化率に、介入額(単位億円)は介入額(単位兆円)に変換)
gen ds = 100*(ln(spot)-ln(l.spot))
gen intj = intervention/10000

/**************************************************************/
** 7.4.2節の推定結果(supF検定と構造変化日の特定)
reg ds intj
estat sbsingle, trim(15)
/* 
注意点(1) estatでは、ワルド統計量が計算される。
　　ワルド統計量=F統計量×制約数q
F値はワルド統計量÷制約数qとして計算できる。この場合、制約数qは2である。
ワルド統計量は33.899であるため、これを2で割ると、16.945
注意点(2) STATAでは、構造変化日はTB+1として定義される。構造変化日は
1057(1995/4/19)となっているので、TBは1056(1995/4/18)となる。
*/

** 前半(1995/4/18まで)と後半(1995/4/19から)で分けて、別々に推定する
reg ds intj if(time<=1056) 
reg ds intj if(time>1056) 

**推定結果の頑健性を調べるため、説明変数に新たにdsの1期前の値を加える
reg ds intj l.ds 
estat sbsingle, trim(15)
/*
構造変化日は1072(1995/5/10)となっているので、TBは1071(1995/5/9)
下では、構造変化前後で別々に推定する
*/
reg ds intj l.ds if(time<=1071) 
reg ds intj l.ds if(time>1071) 


