// ndtmain4.cc：ndtmodel4用のコントロール
// 141120 ndtmodel1をC++流に変更したことに伴う変更
// 141128 ndtmodel2へのバージョンアップ
// 141211 データ取り込み方法の変更
// 141215 ndtpara.hをこのファイルに統合
// 141218 シミュレーション対応：静的変数の扱いは難しい→この方法以外に上手くいかない。
// 141229 倒産コストの変更：ndtmodel4へ。
// 150106 シミュレーションの追加
// 150612 optsearch変更に伴う修正：結果一致。
#include <cstdio>
#include "ndtmodel4.h"
char ofile[][60] = {"data/ndtmodel4/firmval1.txt"} ;
char ofileez[][60] = {"data/ndtmodel4/ndtsimuez1.txt",
		      "data/ndtmodel4/ndttabez1.txt" };
char ofilesz[][60] = {"data/ndtmodel4/ndtsimusz1.txt",
		      "data/ndtmodel4/ndttabsz1.txt" };
char ofiletax[][60] = {"data/ndtmodel4/ndtsimutax1.txt",
		       "data/ndtmodel4/ndttabtax1.txt" };
char ofilebcpr[][60] = {"data/ndtmodel4/ndtsimubcpr1.txt",
			"data/ndtmodel4/ndttabbcpr1.txt" };
char ofileemp[][60] = {"data/ndtmodel4/ndtsimuemp1.txt",
		       "data/ndtmodel4/ndttabemp1.txt" };
char ofilecorr[][60] = {"data/ndtmodel4/ndtsimucorr1.txt",
			"data/ndtmodel4/ndttabcorr1.txt" };
char ofilerf[][60] = {"data/ndtmodel4/ndtsimurf1.txt",
		      "data/ndtmodel4/ndttabrf1.txt" };
char ofilendpr[][60] = {"data/ndtmodel4/ndtsimundpr1.txt",
			"data/ndtmodel4/ndttabndpr1.txt" };
char ofilebctax[][60] = {"data/ndtmodel4/ndtsimubctax1.txt",
			"data/ndtmodel4/ndttabbctax1.txt" };
char ofilehomgn[][60] = {"data/ndtmodel4/ndtsimuhomgn1.txt",
			"data/ndtmodel4/ndttabhomgn1.txt" };
int cntlid = 0 ;
double epsi = 0.00000001, epsi_gld = 0.0000001, misfval3 = -999.999 ;
double xmin, xmax, ymin=0.0, ymax=0.0 ;
double xini1=0.0, xini2=0.0, yini1=0.0, yini2=0.0 ; 
double tmpval, tmpval2 ;
double  year = 10.0, ez1 = 10.0, sz1 = 16.0, corrmpz = 0.4 ;
double bcprop = 0.4, t = 0.3, ndtprop = 1.0 ; //simu-no.1
//double bcprop = 0.5, t = 0.15, ndtprop = 1.0 ; //simu-no.2
//double bcprop = 0.5, t = 0.45, ndtprop = 1.0 ; //simu-no.3
//double bcprop = 0.5, t = 0.3, ndtprop = 1.0 ; //simu-no.4
//double bcprop = 0.6, t = 0.3, ndtprop = 1.0 ; //simu-no.5
//double bcprop = 0.7, t = 0.3, ndtprop = 1.0 ; //simu-no.6
double  rf1 = 0.05, emp1 = 0.13, smp1 = 0.25 ;
givendata& f1() {
  static givendata g1 ;
  g1.year = ::year ;
  g1.ez1 = ::ez1 ;
  g1.sz1 = ::sz1 ;
  g1.corrmpz = ::corrmpz ;
  g1.bcprop = ::bcprop ;
  g1.t = ::t ;
  g1.ndtprop = ::ndtprop ;
  g1.rf1 = ::rf1 ;
  g1.emp1 = ::emp1 ;
  g1.smp1 = ::smp1 ;
  return g1 ;
}
firmdata& f() {
  static firmdata fd ;
  return fd ;
}
double chgtermto1( double year, double val ) {
  return pow( 1.0 + val, 1.0 / year ) - 1.0 ;
}
void printhead( FILE* out, const basicfirm& d ) {
   fprintf( out, "\nliq.cash: 10Y average (1Y) = %6.3f (%6.3f) 10Y std.dev. (1Y)= %6.3f (%6.3f)\n", f().ez, f1().ez1, f().sz, f1().sz1 ) ;
   fprintf( out, "unlevered firm value = %8.5f\n", d.getufirmv() ) ;
   fprintf( out, "tax rate = %4.2f   bankruptcy cost proportion = %5.3f\n", f().t, f().bcpr ) ;
   fprintf( out, "non-debt tax shield = %8.5f  (proportion = %5.3f)\n", d.getndtv(), f().ndpr ) ;
   fprintf( out, "market portfolio: average = %7.4f  std.dev = %5.2f  correlation = %5.3f\n", f1().emp1, f1().smp1, f1().corrmpz ) ;
   fprintf( out, "riskless rate of interest = %7.4f  risk price = %7.4f\n\n", f1().rf1, f().lamb ) ;
   fprintf( out, "%2s%8s%8s%10s%8s%9s %9s%9s %9s%9s%9s %10s%9s\n",
	    "id", "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "valequi", "valdebt", "valfirm", "valtxsv", "valbkcs", "dbratio", "corrMM" ) ;
}
template<typename model>
void printdata( int id, FILE* out, const model& d ) {
  if (id == 1) fprintf( out, "\n%s\n", "->optimal debt corner solution" ) ;
  else if (id == 0) fprintf( out, "\n%s\n", "->optimal debt cash payment" ) ;
  fprintf( out, "%2d", d.getid() ) ;
  fprintf( out, "%8.3f%8.5f%10.5f%8.5f%9.5f %9.5f%9.5f%10.5f %8.5f %8.5f %10.5f %8.5f\n", d.getdbpay(), d.getbnkprob(), chgtermto1( f().year, d.getequirr() ), chgtermto1( f().year, d.getdebtrr() ), chgtermto1( f().year, d.getwacc() ), d.getequimv(), d.getdebtmv(), d.getfirmmv(), d.gettxsvmv(), d.getbkcsmv(), d.getdbrati(), d.getufirmv()+f().t*d.getdebtmv() ) ;
}
void proccntl( int ni, FILE* out[], double stepsize ) {
  double prncntl = 0 ;
  double dcashopt, dcashmax ;
  ndtmodel4 ufirm(0.0) ;
  printhead( out[0], ufirm.getuf() ) ;
  for (double dcash = 0.0 ; dcash <= f().ez*1.5 ; dcash += stepsize) {
    ndtmodel4 lf(dcash) ;
    if (lf.getequimv() < 0.0) break;
    else {
      printdata( 9, out[0], lf ) ;
      dcashmax = dcash ;
    }
  }
  ::xmin = 0.0 ;
  ::xmax = dcashmax ;
  optsearchx_dc op ;
  if (op.getoptvalx() >= ::xmax*0.999) prncntl = 1 ;
  ndtmodel4 lfopt(op.getoptvalx()) ;
  for (int i = 0 ; i < ni ; i++) printdata( prncntl, out[i], lfopt ) ;
}
void firmval() {
  int ni = 1 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofile[i], "w" ) ;
  proccntl( ni, out, 0.5 ) ;
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
}
void ez1change( double tmp ) {
  f1().ez1 = tmp ;
  f().ez = f1().ez1 * f().year ;
}
void ezsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofileez[i], "w" ) ;
  ::tmpval = ::ez1 ;
  for (::ez1 = 6.0 ; ::ez1 <= 18.0 ; ::ez1 += 2.0) {
    ez1change( ::ez1 ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::ez1 = ::tmpval ; ez1change( ::ez1 ) ;
}
void sz1change( double tmp ) {
  f1().sz1 = tmp ;
  f().sz = f1().sz1 * sqrt( f().year ) ;
  f().vz = f().sz * f().sz ;
  f().covz = f1().corrmpz * f().smp * f().sz ;
}
void szsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilesz[i], "w" ) ;
  ::tmpval = ::sz1 ;
  for (::sz1 = 12.0 ; ::sz1 <= 28.0 ; ::sz1 += 2.0) {
    sz1change( ::sz1 ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::sz1 = ::tmpval ; sz1change( ::sz1 ) ;
}
void taxchange( double tmp ) {
  f().t = f1().t = tmp ;
}
void taxsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofiletax[i], "w" ) ;
  ::tmpval = ::t ;
  for (::t = 0.15 ; ::t <= 0.45 ; ::t += 0.05) {
    taxchange( ::t ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::t = ::tmpval ; taxchange( ::t ) ;
}
void bcprchange( double tmp ) {
  f().bcpr = f1().bcprop = tmp ;
}
void bcprsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilebcpr[i], "w" ) ;
  ::tmpval = ::bcprop ;
  for (::bcprop = 0.1 ; ::bcprop <= 0.8 ; ::bcprop += 0.1) {
    bcprchange( ::bcprop ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::bcprop = ::tmpval ; bcprchange( ::bcprop ) ;
}
void empchange( double tmp ) {
  f1().emp1 = tmp ;
  f().emp = pow( (1.0 + f1().emp1), f().year ) - 1.0 ;
  f().lamb = ( f().emp - f().rf ) / ( f().smp * f().smp ) ;
}
void empsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofileemp[i], "w" ) ;
  ::tmpval = ::emp1 ;
  for (::emp1 = 0.0 ; ::emp1 <= 0.17 ; ::emp1 += 0.0325) {
    empchange( ::emp1 ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::emp1 = ::tmpval ; empchange( ::emp1 ) ;
}
void corrchange( double tmp ) {
  f1().corrmpz = tmp ;
  f().covz = f1().corrmpz * f().smp * f().sz ;
}
void corrsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilecorr[i], "w" ) ;
  ::tmpval = ::corrmpz ;
  for (::corrmpz = -0.2 ; ::corrmpz <= 0.7 ; ::corrmpz += 0.2) {
    corrchange( ::corrmpz ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::corrmpz = ::tmpval ; corrchange( ::corrmpz ) ;
}
void rfchange( double tmp ) {
  f1().rf1 = tmp ;
  f().rf = pow( (1.0 + f1().rf1), f().year ) - 1.0 ;
  f().lamb = ( f().emp - f().rf ) / ( f().smp * f().smp ) ;
}
void rfsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilerf[i], "w" ) ;
  ::tmpval = ::rf1 ;
  for (::rf1 = 0.03 ; ::rf1 <= 0.08 ; ::rf1 += 0.01) {
    rfchange( ::rf1 ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::rf1 = ::tmpval ; rfchange( ::rf1 ) ;
}
void ndprchange( double tmp ) {
  f().ndpr = f1().ndtprop = tmp ;
}
void ndprsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilendpr[i], "w" ) ;
  ::tmpval = ::ndtprop ;
  for (::ndtprop = 1.0 ; ::ndtprop <= 1.5 ; ::ndtprop += 0.1) {
    ndprchange( ::ndtprop ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::ndtprop = ::tmpval ; ndprchange( ::ndtprop ) ;
}
void bctaxsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilebctax[i], "w" ) ;
  ::tmpval = ::bcprop ; tmpval2 = ::t ;
  for (::bcprop = 0.1 ; ::bcprop <= 0.8 ; ::bcprop += 0.2) {
    bcprchange( ::bcprop ) ;
    for (::t = 0.15 ; ::t <= 0.45 ; ::t += 0.1) {
      taxchange( ::t ) ;
      proccntl( ni, out, 1.5 ) ;
    }
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::bcprop = ::tmpval ; bcprchange( ::bcprop ) ;
  ::t = ::tmpval2 ; taxchange( ::t ) ;
}
void homgensimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilehomgn[i], "w" ) ;
  ::tmpval = ::ez1 ; ::tmpval2 = ::sz1 ;
  for (::ez1 = 6.0 ; ::ez1 <= 15.0 ; ::ez1 += 2.0) {
    ez1change( ::ez1 ) ;
    ::sz1 = ::tmpval2*::ez1/::tmpval ; 
    sz1change( ::sz1 ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::ez1 = ::tmpval ; ez1change( ::ez1 ) ;
  ::sz1 = ::tmpval2 ; sz1change( ::sz1 ) ;
}
int main() {
  firmval() ;
  ezsimu() ;
  szsimu() ;
  taxsimu() ;
  bcprsimu() ;
  empsimu() ;
  corrsimu() ;
  rfsimu() ;
  ndprsimu() ;
  bctaxsimu() ;
  homgensimu() ;
}
