nu=1
a=2
b=6
H=30000
init=0
fin=H
s=simulateHawkes(lambda0= nu, alpha= a, beta= b, horizon= H)
obs_times=s[[1]]
likelihoodHawkes(lambda0=nu, alpha=a, beta=b,obs_times[-1] - obs_times[1])

lik2 = function(param) 
{
  if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
  {
    return(10000000)
  }
  if (param[2] > param[3] - 0.0001)
  {
    return(10000000)
  }
  o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
  leng = length(o)-1
  tn = o[leng+1]
  Aoz = 0
  f=param[1]*tn
  for (i in 2:(leng+1))
  {
    f = f-(param[2]/param[3])*(exp(-param[3]*(tn - o[i])) - 1)
    f = f- log(param[1] + param[2]*Aoz)
    Aoz = (Aoz + 1)*exp(-param[3]*(o[i+1] - o[i]))
  }
  return (f)
}

lik = function(param) 
{
  if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
  {
    return(1000000)
  }
  if (param[2] > param[3] - 0.0001)
  {
    return(1000000)
  }
  #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[-1])
  f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times)
  return (f)
}

### Chen estimator
intpoly = function(tn, param) # return the integral of param[1] + param[2]*x/tn + param[3]*(x/tn)^2 + param[4]*(x/tn)^3 between 0 and tn
{
  return(tn*(param[1] + param[2]/2 + param[3]/3 + param[4]/4))
}

nupoly = function(tn, t, param) # return the value of param[1] + param[2]*x + param[3]*x^2 + param[4]*x^3 at t when tn is final
{
  return(param[1] + param[2]*t/tn + param[3]*(t/tn)^2 + param[4]*(t/tn)^3)
}

## test on parametric model
nu=.8#.3*q
a =11# 0.85*q1
b=30# 3*q2
H=21600
s = simulateHawkes(lambda0= nu, alpha= a, beta= b, horizon= H)
obs_times=s[[1]]
init=0
fin=H
likChenpony = function(param) #we provide a polynomial of order 3 for nu (corresponding to param[1:4]) on top of alpha and beta (corresponding to param[5:6])
{
  if ((param[5] < 0) | (param[6] < 0) | (param[1] < nu - .3) | (param[1] > nu + .3))
  {
    return(10000000)
  }
  if (param[5] > param[6] - 0.0001)
  {
    return(10000000)
  }
  o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
  
  leng = length(o)-1
  tn = o[leng+1]
  if (min(nupoly(tn,o[-1],param[1:4])) <  .1)
  {
    return(10000000)
  }
  Aoz = vector(length=leng)
  Aoz[1]=0
  #f=param[1]*tn
  for (i in 2:(leng))
  {
    #f = f-(param[2]/param[3])*(exp(-param[3]*(tn - o[i])) - 1)
    #f = f- log(param[1] + param[2]*Aoz)
    Aoz[i] = (Aoz[i-1] + 1)*exp(-param[6]*(o[i+1] - o[i]))
  }
  f=intpoly(tn,param[1:4]) - sum((param[5]/param[6])*(exp(-param[6]*(tn - o[-1])) - 1)) - sum(log(nupoly(tn, o[-1],param[1:4]) + param[5]*Aoz))
  return (f)
}
p=c(nu,0,0,0,7,25)
opt=optim(par=p,fn=likChenpony, control=c(maxit=5000))
opt$par
plot(nupoly(H,(1:100)*H/100,opt$par[1:4]))
intpoly(H,opt$par[1:4])/H


##inverse of Fisher matrix with tests

#s = simulateHawkes(lambda0= nu, alpha= a, beta= b, horizon= 10000)
obs_times=s[[1]]
init=0
fin=10000
invminFisher = function(param) 
{
  F = matrix(data=0,ncol=3, nrow=3)
  o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
  leng = length(o)-1
  tn = o[leng+1]
  Aoz = 0
  Boz=0
  coz = 0
  for (i in 2:(leng+1))
  {
    F[1,1] = F[1,1] - (1/(param[1] + param[2]*Aoz)^2)
    F[1,2] = F[1,2] - (Aoz/(param[1] + param[2]*Aoz)^2)
    F[1,3] = F[1,3] + (param[2]*Boz)/(param[1] + param[2]*Aoz)^2
    F[2,2] = F[2,2] - (Aoz/(param[1] + param[2]*Aoz))^2
    F[2,3] = F[2,3] - (exp(-param[3]*(tn - o[i]))*(tn - o[i])/param[3]) - ((exp(-param[3]*(tn - o[i])) - 1)/param[3]^2) - (Boz/(param[1] + param[2]*Aoz)) + ((param[2]*Aoz*Boz)/(param[1] + param[2]*Aoz)^2)
    F[3,3] = F[3,3] + (exp(-param[3]*(tn - o[i]))*((tn - o[i])^2)*param[2]/param[3]) + (2*exp(-param[3]*(tn - o[i]))*(tn - o[i])*param[2]/param[3]^2) + (2*(exp(-param[3]*(tn - o[i]))-1)*param[2]/param[3]^3) + (coz*param[2])/(param[1] + param[2]*Aoz) - ((Boz*param[2])/(param[1] + param[2]*Aoz))^2
    Aoz = (Aoz + 1)*exp(-param[3]*(o[i+1] - o[i]))
    Boz = Boz*exp(-param[3]*(o[i+1] - o[i])) + ((o[i+1] - o[i])*Aoz)
    coz = coz*exp(-param[3]*(o[i+1] - o[i])) + (((o[i+1] - o[i])^2)*Aoz)
    #print(Aoz)
  }
  F[2,1] = F[1,2]
  F[3,1] = F[1,3]
  F[3,2] = F[2,3]
  inv = solve(-F)
  #print(F)
  return (inv)
}
invminFisher(c(nu,a,b))

### gradient function
grad = function(param) 
{
  if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
  {
    return(10000000)
  }
  if (param[2] > param[3] - 0.0001)
  {
    return(10000000)
  }
  o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
  leng = length(o)-1
  tn = o[leng+1]
  Aoz = 0
  Boz = 0 
  f1=-tn
  f2=0
  f3=0
  for (i in 2:(leng+1))
  {
    f1 = f1 + (1/(param[1] + param[2]*Aoz))
    f2 = f2 + (exp(-param[3]*(tn - o[i])) - 1)/param[3] + (Aoz/(param[1] + param[2]*Aoz))
    f3 = f3 - (exp(-param[3]*(tn - o[i]))*(tn - o[i])*param[2]/param[3]) - exp(-param[3]*(tn - o[i]))*param[2]/(param[3]^2) - Boz*param[2]/(param[1] + param[2]*Aoz)
    Aoz = (Aoz + 1)*exp(-param[3]*(o[i+1] - o[i]))
    Boz = Boz*exp(-param[3]*(o[i+1] - o[i])) + ((o[i+1] - o[i])*Aoz)
  }
  return (c(-f1,-f2,-f3))
}

ftest= function(param)
{
  return (param^2)
}
  
gradtest=function(param)
{
  return (2*param)
}