## big simulation file (Version 2)
### time-varying parameter case
####we start by sparse estimations of the bias on a grid
paths= 100000#nb of paths for Monte Carlo
## Model I-II-III
#lengthGrid=10
###
lengthGrid=125
### Model I-II
#nuGrid=seq(from=.3, to=1.3, length.out=lengthGrid)
#aGrid=seq(from=7, to=15, length.out=lengthGrid)
#bGrid=seq(from=20, to=40, length.out=lengthGrid)
### Model III
#nuGrid=seq(from=.43, to=1.03, length.out=lengthGrid)
#aGrid=seq(from=11, to=11, length.out=lengthGrid)
#bGrid=seq(from=30, to=30, length.out=lengthGrid)
### Model IV
arraynuGrid = seq(from=.3, to=1.05, length.out=(lengthGrid)^(1/3))
arrayaGrid = seq(from=9, to=15, length.out=(lengthGrid)^(1/3))
arraybGrid = seq(from=35, to=47, length.out=(lengthGrid)^(1/3))
lg=1
nuGrid=0
aGrid=0
bGrid=0
for (i in 1:(lengthGrid)^(1/3))
{
  for (j in 1:(lengthGrid)^(1/3))
  {
    for (k in 1:(lengthGrid)^(1/3))
    {
      nuGrid[lg]=arraynuGrid[i]
      aGrid[lg]=arrayaGrid[j]
      bGrid[lg]=arraybGrid[k]
      lg=lg+1
    }
  }
}

biasnuGrid =0
biasaGrid=0
biasbGrid=0
for(lg in 1:lengthGrid)
{
  print(lg)
MC1=0 
MC2=0
MC3=0
H=216 #horizon in seconds
Bu = 0 #100*(q-1) # burn part 
for (i in 1:paths)
{
  # simulation and fit in the parametric model
  s = simulateHawkes(lambda0= nuGrid[lg], alpha= aGrid[lg], beta= bGrid[lg], horizon= H + Bu)
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(1000000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(1000000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][s[[1]] > Bu] - Bu)
    return (f)
  }
  
  p=c(.8,11,30)
  opt=optim(par=p,fn=lik)
  MC1[i] = opt$par[1]
  MC2[i] = opt$par[2]
  MC3[i] = opt$par[3]
  #if (MC3[i] > 15)
  #{
  #  MC3[i]=15
  #}
}
 biasnuGrid[lg] = (mean(MC1) - nuGrid[lg])
 biasaGrid[lg] = (mean(MC2) - aGrid[lg])
 biasbGrid[lg] = (mean(MC3) - bGrid[lg])
}

biasnuGridsmall =0
biasaGridsmall=0
biasbGridsmall=0
for(lg in 1:lengthGrid)
{
  print(lg)
  MC1=0 
  MC2=0
  MC3=0
  H=432 #horizon in seconds
  Bu = 0 #100*(q-1) # burn part 
  for (i in 1:paths)
  {
    # simulation and fit in the parametric model
    s = simulateHawkes(lambda0= nuGrid[lg], alpha= aGrid[lg], beta= bGrid[lg], horizon= H + Bu)
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(1000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(1000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][s[[1]] > Bu] - Bu)
      return (f)
    }
    
    p=c(.8,11,30)
    opt=optim(par=p,fn=lik)
    MC1[i] = opt$par[1]
    MC2[i] = opt$par[2]
    MC3[i] = opt$par[3]
    #if (MC3[i] > 15)
    #{
    #  MC3[i]=15
    #}
  }
  biasnuGridsmall[lg] = (mean(MC1) - nuGrid[lg])
  biasaGridsmall[lg] = (mean(MC2) - aGrid[lg])
  biasbGridsmall[lg] = (mean(MC3) - bGrid[lg])
}

biasnuGridbig =0
biasaGridbig=0
biasbGridbig=0
for(lg in 1:lengthGrid)
{
  print(lg)
  MC1=0 
  MC2=0
  MC3=0
  H=108 #horizon in seconds
  Bu = 0 #100*(q-1) # burn part 
  for (i in 1:paths)
  {
    # simulation and fit in the parametric model
    s = simulateHawkes(lambda0= nuGrid[lg], alpha= aGrid[lg], beta= bGrid[lg], horizon= H + Bu)
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(1000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(1000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][s[[1]] > Bu] - Bu)
      return (f)
    }
    
    p=c(.8,11,30)
    opt=optim(par=p,fn=lik)
    MC1[i] = opt$par[1]
    MC2[i] = opt$par[2]
    MC3[i] = opt$par[3]
    #if (MC3[i] > 15)
    #{
    #  MC3[i]=15
    #}
  }
  biasnuGridbig[lg] = (mean(MC1) - nuGrid[lg])
  biasaGridbig[lg] = (mean(MC2) - aGrid[lg])
  biasbGridbig[lg] = (mean(MC3) - bGrid[lg])
}



M01=0 #parameters for the MLE on the whole dataset
M02=0
M03=0
M001=0 #parameters for Chen estimator
M002=0
M003=0
paths=1000
n=10000
h=sqrt(n)
B=floor(n/h)
horizon=21600 # 6 hours
T=horizon
ModelIII = function(t, param) # param a 3-dimensional parameter which corresponds to (beta1, beta2, beta3)
{
  return (exp(param[1]) + ((exp(param[2]) + exp(param[3]))^2)*(t/T - exp(param[2])/(exp(param[2]) + exp(param[3])))^2)
}
burn = 0
out1 =array(dim=c(paths,B))
out2 =array(dim=c(paths,B))
out3 =array(dim=c(paths,B))
out1BC =array(dim=c(paths,B))
out2BC =array(dim=c(paths,B))
out3BC =array(dim=c(paths,B))
estvar1 =array(dim=c(paths,B))
estvar2 =array(dim=c(paths,B))
estvar3 =array(dim=c(paths,B))
out1small =array(dim=c(paths,(B/2)))
out2small =array(dim=c(paths,(B/2)))
out3small =array(dim=c(paths,(B/2)))
out1BCsmall =array(dim=c(paths,(B/2)))
out2BCsmall =array(dim=c(paths,(B/2)))
out3BCsmall =array(dim=c(paths,(B/2)))
out1big =array(dim=c(paths,(2*B)))
out2big =array(dim=c(paths,(2*B)))
out3big =array(dim=c(paths,(2*B)))
out1BCbig =array(dim=c(paths,(2*B)))
out2BCbig =array(dim=c(paths,(2*B)))
out3BCbig =array(dim=c(paths,(2*B)))
#Model IV
targetnu=0
targeta=0
targetb=0
for(pa in 1:paths)
      {
        print(pa)
        ##Model I-II
        #nu=.8
        ##Model III-IV
        nu=0.6082734
        a = 11
        b= 30
        Alambda0=.5
        Aalpha = 4
        Abeta = 10
        #K=10000
        #h=100  
        #cos model
        #lambda0=nu + Alambda0 
        #alpha=a + Aalpha
        #beta=b + Abeta
        #linear model
        #lambda0=nu - Alambda0 
        #alpha=a - Aalpha
        #beta=b - Abeta
        #model III
        #betas = c(-0.8421864, -0.2572328, -0.3905777)
        #lambda0= ModelIII(0,betas)
        #alpha=a 
        #beta=b 
        #model IV
        betasnu = c(-0.8421864, -0.2572328, -0.3905777)
        betasa = c(2.34743451, -0.04994563,  0.40322699)
        betasb= c(3.6563998, -0.3251952, 0.6692799)
        lambda0= ModelIII(0,betasnu)
        alpha= ModelIII(0,betasa)
        beta=ModelIII(0,betasb)
        Wlambda0=0
        Walpha=0
        Wbeta=0
        intensity=lambda0
        #lambdaI = 1.5
        #lambdaF = 1
        #alphaI = 3
        #alphaF = 12
        #betaI = 10
        #betaF = 15
        u=runif(1)
        obs_times = -log(u)/intensity
        time=obs_times
        intensity[1]=lambda0[1]
        #lambda0[2] = lambda0[1]*exp(-theta*time) + mu1*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[1]
        #alpha[2] = alpha[1]*exp(-theta*time) + mu2*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[2]
        #beta[2] = beta[1]*exp(-theta*time) + mu3*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[3]
        #lambda0= seq(from=lambda0, to=lambda0, length.out=N)
        #alpha= seq(from=alpha, to=alpha, length.out=N)
        #beta= seq(from=beta, to=beta, length.out=N)
        compt=0
        i=2
        while (obs_times[i-1] < horizon + burn)
        {
          #cos model
          #lambda0[i] = nu + Alambda0*cos(obs_times[i-1]*2*pi/horizon) 
          #alpha[i] = a + Aalpha*cos(obs_times[i-1]*2*pi/horizon) 
          #beta[i] = b + Abeta*cos(obs_times[i-1]*2*pi/horizon) 
          #linear model
          #lambda0[i] = nu + Alambda0*(-1 + 2*obs_times[i-1]/horizon)
          #alpha[i] = a + Aalpha*(-1 + 2*obs_times[i-1]/horizon)
          #beta[i] = b + Abeta*(-1 + 2*obs_times[i-1]/horizon)
          #Model III
          #lambda0[i] = ModelIII(obs_times[i-1],betasnu)
          #alpha[i] = a
          #beta[i] = b
          # Model IV
          if (i > 2)
          {
            Wlambda0[i] = Wlambda0[i-1] + rnorm(n=1, mean=0, sd=.8*sqrt(obs_times[i-1] - obs_times[i-2])/(6*sqrt(horizon)))
            Walpha[i] =Walpha[i-1] + rnorm(n=1, mean=0, sd=11*sqrt(obs_times[i-1] - obs_times[i-2])/(6*sqrt(horizon)))
            Wbeta[i] =Wlambda0[i-1] + rnorm(n=1, mean=0, sd=30*sqrt(obs_times[i-1] - obs_times[i-2])/(6*sqrt(horizon)))
          }
          else
          {
            Wlambda0[i] =Wlambda0[i-1] + rnorm(n=1, mean=0, sd=.8*sqrt(obs_times[i-1])/(6*sqrt(horizon)))
            Walpha[i] =Walpha[i-1] + rnorm(n=1, mean=0, sd=11*sqrt(obs_times[i-1])/(6*sqrt(horizon)))
            Wbeta[i] =Wlambda0[i-1] + rnorm(n=1, mean=0, sd=30*sqrt(obs_times[i-1])/(6*sqrt(horizon)))
          }
          if (i < 10)
          {
          lambda0[i] = max(ModelIII(obs_times[i-1],betasnu) + Wlambda0[i],0.2)
          alpha[i] = ModelIII(obs_times[i-1],betasa) + Walpha[i]
          beta[i] = ModelIII(obs_times[i-1],betasb) + Wbeta[i]
          }
          else
          {
            lambda0[i] = max(ModelIII(obs_times[i-1],betasnu) + mean(Wlambda0[(i-9):i]),0.2)
            alpha[i] = ModelIII(obs_times[i-1],betasa) + mean(Walpha[(i-9):i])
            beta[i] = ModelIII(obs_times[i-1],betasb) + mean(Wbeta[(i-9):i])
          }
          ###
          intensity[i]=lambda0[i]
          if (i < 20)
          {
            for (j in 1:(i-1))
            {
              intensity[i] = intensity[i] + alpha[j]*exp(-beta[j]*(obs_times[i-1]-obs_times[j]))
            }
          } else {
            for (j in (i-19):(i-1))
            {
              intensity[i] = intensity[i] + alpha[j]*exp(-beta[j]*(obs_times[i-1]-obs_times[j]))
            }
          }
          intens1= intensity[i]
          time = 0
          t= TRUE
          compt[i]=1
          while (t)
          {
            u=runif(1)
            time = -log(u)/intens1 + time
            d=runif(1)
            intens2= lambda0[i]
            if (i < 20)
            {
              for (j in 1:(i-1))
              {
                intens2 = intens2 + alpha[j]*exp(-beta[j]*(obs_times[i-1]+ time-obs_times[j]))
              }
            } else {
              for (j in (i-19):(i-1))
              {
                intens2 = intens2 + alpha[j]*exp(-beta[j]*(obs_times[i-1]+ time-obs_times[j]))
              }
            }
            if (d < intens2/intens1)
            {
              t=FALSE 
            } else {
              intens1 = intens2
            }
            compt[i] = compt[i]+1
          }
          obs_times[i] = obs_times[i-1] + time
          i = i+1
          
          #brownian_increment = rnorm(n=3,mean=0,sd=(exp(2*theta*time)-1)^(1/2))
          #lambda0[i+1] = lambda0[i]*exp(-theta*time) + mu1*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[1]
          #alpha[i+1] = alpha[i]*exp(-theta*time) + mu2*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[2]
          #beta[i+1] = beta[i]*exp(-theta*time) + mu3*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[3]
        }
        
        ##Model IV target
        obs_times[(i-1)] = horizon
        obs_timesdec = 0
        obs_timesdec[2:(i-1)] = obs_times[1:(i-2)]
        targetnu[pa] = sum((obs_times - obs_timesdec)*lambda0)/horizon
        targeta[pa] = sum((obs_times - obs_timesdec)*alpha)/horizon
        targetb[pa] = sum((obs_times - obs_timesdec)*beta)/horizon
        
        lik = function(param) 
        {
          if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
          {
            return(1000000)
          }
          if (param[2] > param[3] - 0.0001)
          {
            return(1000000)
          }
          #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[-1])
          f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[1:(i-2)][obs_times[1:(i-2)] > burn] - burn)
          return (f)
        }
        
        p = c(nu,a,b)
        opt = optim(par=p,fn=lik)
        M01[pa] = opt$par[1]
        M02[pa] = opt$par[2]
        M03[pa] = opt$par[3]
        
        init=0
        fin=T
        likChenpony = function(param) #we provide a polynomial of order 3 for nu (corresponding to param[1:4]) on top of alpha and beta (corresponding to param[5:6])
        {
          if ((param[5] < 0) | (param[6] < 0) | (param[1] < nu - .3) | (param[1] > nu + .3))
          {
            return(10000000)
          }
          if (param[5] > param[6] - 0.0001)
          {
            return(10000000)
          }
          o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
          leng = length(o)-1
          tn = o[leng+1]
          if (min(nupoly(tn,o[-1],param[1:4])) <  .1)
          {
            return(10000000)
          }
          Aoz = vector(length=leng)
          Aoz[1]=0
          #f=param[1]*tn
          for (i in 2:(leng))
          {
            #f = f-(param[2]/param[3])*(exp(-param[3]*(tn - o[i])) - 1)
            #f = f- log(param[1] + param[2]*Aoz)
            Aoz[i] = (Aoz[i-1] + 1)*exp(-param[6]*(o[i+1] - o[i]))
          }
          f=intpoly(tn,param[1:4]) - sum((param[5]/param[6])*(exp(-param[6]*(tn - o[-1])) - 1)) - sum(log(nupoly(tn, o[-1],param[1:4]) + param[5]*Aoz))
          return (f)
        }
        p = c(nu,0,0,0,a,b)
        opt = optim(par=p,fn=likChenpony, control=c(maxit=1000))
        M001[pa] = intpoly(T,opt$par[1:4])/T
        M002[pa] = opt$par[5]
        M003[pa] = opt$par[6]
        
        h=216
        B=floor(horizon/h)
        for(j in 1:B)
        {
          init = burn + h*(j-1)
          fin = burn + h*j
          
          lik = function(param) 
          {
            if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
            {
              return(10000000)
            }
            if (param[2] > param[3] - 0.0001)
            {
              return(10000000)
            }
            f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
            return (f)
          }
          
          p=c(nu,a,b)
          opt = optim(par=p,fn=lik)
          out1[pa,j] = opt$par[1]
          out2[pa,j] = opt$par[2]
          out3[pa,j] = opt$par[3]
          
          whichbias1 = which.min(abs(out1[pa,j] - nuGrid))
          whichbias2 = which.min(abs(out2[pa,j] - aGrid))
          whichbias3 = which.min(abs(out3[pa,j] - bGrid))
          # Model IV
          whichbias1 = which.min(abs(out1[pa,j] - nuGrid)/.8 + abs(out2[pa,j] - aGrid)/11 + abs(out3[pa,j] - bGrid)/40)
          whichbias2 = whichbias1
          whichbias3 = whichbias1
          
          out1BC[pa,j] = out1[pa,j] - biasnuGrid[whichbias1]
          out2BC[pa,j] = out2[pa,j] - biasaGrid[whichbias2]
          out3BC[pa,j] = out3[pa,j] - biasbGrid[whichbias3]
          
          
          invminFisher = function(param) 
          {
            F = matrix(data=0,ncol=3, nrow=3)
            o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
            leng = length(o)-1
            tn = o[leng+1]
            Aoz = 0
            Boz=0
            coz = 0
            for (i in 2:(leng+1))
            {
              F[1,1] = F[1,1] - (1/(param[1] + param[2]*Aoz)^2)
              F[1,2] = F[1,2] - (Aoz/(param[1] + param[2]*Aoz)^2)
              F[1,3] = F[1,3] + (param[2]*Boz)/(param[1] + param[2]*Aoz)^2
              F[2,2] = F[2,2] - (Aoz/(param[1] + param[2]*Aoz))^2
              F[2,3] = F[2,3] - (exp(-param[3]*(tn - o[i]))*(tn - o[i])/param[3]) - ((exp(-param[3]*(tn - o[i])) - 1)/param[3]^2) - (Boz/(param[1] + param[2]*Aoz)) + ((param[2]*Aoz*Boz)/(param[1] + param[2]*Aoz)^2)
              F[3,3] = F[3,3] + (exp(-param[3]*(tn - o[i]))*((tn - o[i])^2)*param[2]/param[3]) + (2*exp(-param[3]*(tn - o[i]))*(tn - o[i])*param[2]/param[3]^2) + (2*(exp(-param[3]*(tn - o[i]))-1)*param[2]/param[3]^3) + (coz*param[2])/(param[1] + param[2]*Aoz) - ((Boz*param[2])/(param[1] + param[2]*Aoz))^2
              Aoz = (Aoz + 1)*exp(-param[3]*(o[i+1] - o[i]))
              Boz = Boz*exp(-param[3]*(o[i+1] - o[i])) + ((o[i+1] - o[i])*Aoz)
              coz = coz*exp(-param[3]*(o[i+1] - o[i])) + (((o[i+1] - o[i])^2)*Aoz)
              #print(Aoz)
            }
            F[2,1] = F[1,2]
            F[3,1] = F[1,3]
            F[3,2] = F[2,3]
            inv = solve(-F)
            #print(F)
            return (inv)
          }
          MF = invminFisher(c(out1[pa,j],out2[pa,j],out3[pa,j]))
          estvar1[pa,j] =MF[1,1]
          estvar2[pa,j] =MF[2,2]
          estvar3[pa,j] =MF[3,3]
        }
        
        h=432
        B=floor(horizon/h)
        for(j in 1:B)
        {
          init = burn + h*(j-1)
          fin = burn + h*j
          
          lik = function(param) 
          {
            if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
            {
              return(10000000)
            }
            if (param[2] > param[3] - 0.0001)
            {
              return(10000000)
            }
            f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
            return (f)
          }
          p=c(nu,a,b)
          opt = optim(par=p,fn=lik)
          out1small[pa,j] = opt$par[1]
          out2small[pa,j] = opt$par[2]
          out3small[pa,j] = opt$par[3]
          
          #whichbias1small = which.min(abs(out1small[pa,j] - nuGrid))
          #whichbias2small = which.min(abs(out2small[pa,j] - aGrid))
          #whichbias3small = which.min(abs(out3small[pa,j] - bGrid))
          # Model IV
          whichbias1small = which.min(abs(out1small[pa,j] - nuGrid)/.8 + abs(out2small[pa,j] - aGrid)/11 + abs(out3small[pa,j] - bGrid)/40)
          whichbias2small = whichbias1small
          whichbias3small = whichbias1small
          out1BCsmall[pa,j] = out1small[pa,j] - biasnuGridsmall[whichbias1small]
          out2BCsmall[pa,j] = out2small[pa,j] - biasaGridsmall[whichbias2small]
          out3BCsmall[pa,j] = out3small[pa,j] - biasbGridsmall[whichbias3small]
        }
        
        h=108
        B=floor(horizon/h)
        for(j in 1:B)
        {
          init = burn + h*(j-1)
          fin = burn + h*j
          
          lik = function(param) 
          {
            if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
            {
              return(10000000)
            }
            if (param[2] > param[3] - 0.0001)
            {
              return(10000000)
            }
            f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
            return (f)
          }
          p=c(nu,a,b)
          opt = optim(par=p,fn=lik)
          out1big[pa,j] = opt$par[1]
          out2big[pa,j] = opt$par[2]
          out3big[pa,j] = opt$par[3]
          
          #whichbias1big = which.min(abs(out1big[pa,j] - nuGrid))
          #whichbias2big = which.min(abs(out2big[pa,j] - aGrid))
          #whichbias3big = which.min(abs(out3big[pa,j] - bGrid))
          # Model IV
          whichbias1big = which.min(abs(out1big[pa,j] - nuGrid)/.8 + abs(out2big[pa,j] - aGrid)/11 + abs(out3big[pa,j] - bGrid)/40)
          whichbias2big = whichbias1big
          whichbias3big = whichbias1big
          out1BCbig[pa,j] = out1big[pa,j] - biasnuGridbig[whichbias1big]
          out2BCbig[pa,j] = out2big[pa,j] - biasaGridbig[whichbias2big]
          out3BCbig[pa,j] = out3big[pa,j] - biasbGridbig[whichbias3big]
        }
        
}

nut = nu + Alambda0*cos((1:100 - 1)*2*pi/100)# 2*Alambda0*1:100/100#
plot(nut,type='l')
mout1 = colMeans(out1)
rout1 = rowMeans(out1)
points(mout1, col="red")
window=3
mout1[(B+1):(B+window)] = mout1[B]
smoothout1 = 0
for (i in 1:B)
{
  smoothout1[i] = mean(mout1[i:(i+window - 1)])
}
#points(smoothout1, col="red", type='l')

at = a + Aalpha*cos((1:100 - 1)*2*pi/100)#2*Aalpha*1:100/100 #
plot(at,type='l')
mout2 = colMeans(out2)
rout2 = rowMeans(out2)
points(mout2, col="red")
window=3
mout2[(B+1):(B+window)] = mout2[B]
smoothout2 = 0
for (i in 1:B)
{
  smoothout2[i] = mean(mout2[i:(i+window - 1)])
}
#points(smoothout2, col="red", type='l')

bt = b + Abeta*cos((1:100 - 1)*2*pi/100)#2*Abeta*1:100/100 #
plot(bt,type='l')
mout3 = colMeans(out3)
rout3 = rowMeans(out3)
points(mout3, col="red")
window=3
mout3[(B+1):(B+window)] = mout3[B]
smoothout3 = 0
for (i in 1:B)
{
  smoothout3[i] = mean(mout3[i:(i+window - 1)])
}
#points(smoothout3, col="red", type='l')

#studentization BC
S1BC = 100*(rowMeans(out1BC)-nu)/(sqrt(rowSums(estvar1)))
S2BC = 100*(rowMeans(out2BC)-a)/(sqrt(rowSums(estvar2)))
S3BC = 100*(rowMeans(out3BC)-b)/(sqrt(rowSums(estvar3)))

#studentization BC Model IV
S1BC = 100*(rowMeans(out1BC)-targetnu)/(sqrt(rowSums(estvar1)))
S2BC = 100*(rowMeans(out2BC)-targeta)/(sqrt(rowSums(estvar2)))
S3BC = 100*(rowMeans(out3BC)-targetb)/(sqrt(rowSums(estvar3)))

#studentization naive Model IV
S1 = 100*(rowMeans(out1)-targetnu)/(sqrt(rowSums(estvar1)))
S2 = 100*(rowMeans(out2)-targeta)/(sqrt(rowSums(estvar2)))
S3 = 100*(rowMeans(out3)-targetb)/(sqrt(rowSums(estvar3)))

# tests
T=21600
ModelIII = function(t, param) # param a 3-dimensional parameter which corresponds to (beta1, beta2, beta3)
{
  return (exp(param[1]) + ((exp(param[2]) + exp(param[3]))^2)*(t/T - exp(param[2])/(exp(param[2]) + exp(param[3])))^2)
}
betasnu = c(-0.8421864, -0.2572328, -0.3905777)
betasa = c(2.34743451, -0.04994563,  0.40322699)
betasb= c(3.6563998, -0.3251952, 0.6692799)
minnu=0
mina=0
minb=0
maxnu=0
maxa=0
maxb=0
for (test in 1:10000)
{
  Wnu = cumsum(rnorm(n=1000, mean=0, sd=.8/(6*sqrt(1000))))
  #plot(ModelIII(1:1000*21600/1000,betasnu)+ Wnu)
  Wa = cumsum(rnorm(n=1000, mean=0, sd=11/(6*sqrt(1000))))
  #plot(ModelIII(1:1000*21600/1000,betasa)+ Wa)
  Wb = cumsum(rnorm(n=1000, mean=0, sd=30/(6*sqrt(1000))))
  #plot(ModelIII(1:1000*21600/1000,betasb)+ Wb)
  minnu[test]=min(ModelIII(1:1000*21600/1000,betasnu)+ Wnu)
  mina[test]=min(ModelIII(1:1000*21600/1000,betasa)+ Wa)
  minb[test]=min(ModelIII(1:1000*21600/1000,betasb)+ Wb)
  maxnu[test]=max(ModelIII(1:1000*21600/1000,betasnu)+ Wnu)
  maxa[test]=max(ModelIII(1:1000*21600/1000,betasa)+ Wa)
  maxb[test]=max(ModelIII(1:1000*21600/1000,betasb)+ Wb)
}
