import numpy as np
from pandas import DataFrame, Series
import matplotlib.pyplot as plt
from path import path

np.random.seed(1)

default_path = path('/users/Simon/desktop/boulot/these/Volatility local MLE (article 3)/Local MLE vol code/results/studentizationFinal/test/')

####Boolean for activation/desactivation of estimators
QMLE_est = True
LQMLE_est = True
RK_est = True
LRK_est = True
PA_est = False

start = 1000 #for the case sample_step =1. Adjusted otherwise
end = -1000

real_dailySeconds = 46800
ratio = (start - end - 1) / real_dailySeconds

# set simulation parameter
nbsecond = 1.  # duree entre deux trades en secondes
dailySeconds = 46800 + nbsecond * (start - (end + 1))
M = 10 #to be changed
T_obs = 1/252
T = T_obs + ratio/252

d = 1

#average_IQ = 6.5e-05#2.8e-05 (Model 2) #2.8655471018389605e-05
xi2 = 0.001

ndaily = int(dailySeconds / nbsecond)
n = int(dailySeconds * d / nbsecond)

##Model Name
modelName = "Model 2"
default_path +=modelName +"/"

####Parameters for the Heston
mu = 0.03
rho = -0.75
kappa = 5
gamma = 0.4
alpha = 0.1

###Parameters for the jump
if modelName == "Model 1":
    jump_size = 0  # in % of the vol
    jump_start,jump_end=0,1
elif modelName == "Model 2":
    jump_size = .5 #in % of the vol
    jump_start,jump_end = 0,1
elif modelName == "Model 3":
    jump_size = .5  # in % of the vol
    jump_start,jump_end = 0.05,0.7

jump_mode = "unif"

####Parameters for the daily U-shaped vol

coeff= 0
scaling = 1
if modelName == "Model 2":
    coeff = 1
    scaling = 1
elif modelName == "Model 1" :
    coeff = 1.8 #To adjust
    scaling = 1.070189
elif modelName == "Model 3":
    coeff = 1.8
    scaling = 1

A = coeff*0.75/scaling
B = coeff*0.25/scaling
C = 0.88929198/scaling
a = 10.0
b = 10.0

sigma = 1#np.sqrt(0.1)

def riemann(g,k=500):
    return np.sum([g(i/k) for i in range(k)])*1/k

def sigma_u(x):
    return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma

tab = np.array([sigma_u(i/100) for i in np.arange(100)])


def sigma_u_jumps(x):
    if x <= 0.5:
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma
    else :
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma-0.5*sigma

priceArgs = [mu, kappa, alpha, gamma, rho, sigma_u, [jump_size,jump_start,jump_end], jump_mode]


####RK parameters
kernel_type = "th2"

#PA parameters
kernel_pa = "triang_ker"

#### Local parameters

nb_block_min = 2
nb_block_max = 8
block_step = 2
block_list = np.arange(nb_block_min,nb_block_max+1, block_step)

list_size = block_list.size


## Simulate the data
print("Simulating trajectories...")
presim = Simulator(nbsecond,M,d,dailySeconds,T)

myPreSim = presim.simulGlobal(presim.simulSVHeston,priceArgs,presim.simulNoiseIIDfromXi2,[xi2,start,end,T_obs], True)
#data_path = "/Volumes/BackupResearch/Data Local Est/xi2small/"+modelName+"/"
#presim.fromCSV(data_path)

rho_mean = presim.rhoGlobal(start,end).mean()
rho_std = presim.rhoGlobal(start,end).std()
kappa_mean = presim.kappaGlobal(start,end).mean()
kappa_std = presim.kappaGlobal(start,end).std()
#presim.simulSVHeston

for sample_step in [8]:#[8,4,2,1]:
    sim = Simulator(nbsecond*sample_step,M,d,dailySeconds,T, modelName)
    sim.Y, sim.IV, sim.R, sim.Q = presim.Y[:,::sample_step], presim.IV[:,::sample_step], presim.R[:,::sample_step], presim.Q[:,::sample_step]
    sim.noiseArgs = presim.noiseArgs
    sim.noiseVar = sim.noiseArgs[0]
    a2true = sim.noiseArgs[0]


    ############################Statistical part##################################


    ######Estimating the various estimators

    start_sample = start/sample_step
    end_sample = (end+1)/sample_step-1

    Vol_Local = localize(Vol_estimator)


    QMLE = Vol_QMLE(start_sample,end_sample,sim.__dict__,"QMLE"+str(real_dailySeconds/sample_step))

    LQMLE = {nb_blocks : None for nb_blocks in block_list}
    sim.estClass = Vol_QMLE
    for nb_blocks in block_list:
        sim.b = nb_blocks
        LQMLE[nb_blocks] = Vol_Local(start_sample, end_sample,sim.__dict__,"LQMLE on {0} blocks for {1} obs".format(nb_blocks,real_dailySeconds / sample_step))

    RK = Vol_RK(start_sample,end_sample,sim.__dict__,"RK"+str(real_dailySeconds/sample_step) )
    RK.setParam(kernel_type,"adaptive",Quart_PA,Vol_PA,Noise_Realized)

    LRK = {nb_blocks: None for nb_blocks in block_list}
    sim.estClass = Vol_RK
    for nb_blocks in block_list:
        sim.b = nb_blocks
        LRK[nb_blocks] = Vol_Local(start_sample, end_sample, sim.__dict__,"LQMLE on {0} blocks for {1} obs".format(nb_blocks,real_dailySeconds / sample_step))

    PA = Vol_PA(start_sample,end_sample,sim.__dict__, "PA"+str(real_dailySeconds/sample_step))
    PA.setParam(kernel_pa,"adaptive",Vol_PA,Noise_Realized)

    for nb_blocks in block_list:
        LRK[nb_blocks].setParam(kernel_type,"adaptive",Quart_PA,Vol_PA,Noise_Realized)
        #LQMLE[nb_blocks].setParam(nb_blocks,Vol_QMLE)

    if QMLE_est :

        print("performing QMLE estimations...")
        QMLE.estim()
        QMLE.compute_avar()
        QMLE.compute_favar()
        QMLE.compute_best_avar()
        print("Done!")

    if RK_est :
        print("performing RK estimations...")
        RK.estim()
        RK.compute_avar()
        RK.compute_favar()
        RK.compute_avarH()
        RK.compute_best_avar()
        print("Done!")

    if PA_est :
        print("performing PA estimations...")
        PA.estim()
        PA.compute_avar()
        PA.compute_best_avar()
        print("Done!")

    for nb_blocks in block_list:
        if LQMLE_est :

            print("performing LQMLE estimations with {0} blocks...".format(nb_blocks))
            LQMLE[nb_blocks].estim()
            LQMLE[nb_blocks].compute_avar()
            LQMLE[nb_blocks].compute_favar()
            LQMLE[nb_blocks].compute_best_avar()
            print("Done!")

        if LRK_est:
            print("performing LRK estimations with {0} blocks...".format(nb_blocks))

            LRK[nb_blocks].estim([RK.pre_estimatorRho.IQest.k * np.sqrt(RK.delta)])
            LRK[nb_blocks].compute_avar()
            LRK[nb_blocks].compute_favar()
            LRK[nb_blocks].compute_best_avar()
            print("Done!")

    block_list2 = [1]
    block_list2.extend(block_list)
    block_list2 = np.array(block_list2)

    #refine the data by studentization
    preData = {"stud_RMSE" : np.zeros(block_list2.size),
               "stud_bias" : np.zeros(block_list2.size),
               "stud_std": np.zeros(block_list2.size),
               "empirical loss": np.zeros(block_list2.size),
               "theoretic loss": np.zeros(block_list2.size),
               "(Student Std)^2 x Theoretic Loss:": np.zeros(block_list2.size),
               "(RMSE)^2 x Theoretic Loss:": np.zeros(block_list2.size),
               "fstud_RMSE" : np.zeros(block_list2.size),
               "fstud_bias" : np.zeros(block_list2.size),
               "fstud_std": np.zeros(block_list2.size)
               }

    quantileList = [0.5,2.5,5,95,97.5,99.5]
    for q in quantileList:
        preData["quantile{0}%".format(q)] = np.zeros(block_list2.size)
        preData["fquantile{0}%".format(q)] = np.zeros(block_list2.size)

    if RK_est or QMLE_est:
        ###RK/LRK student
        studentDataRK = DataFrame(preData,index = block_list2)

        studentDataRK["stud_RMSE"][1] = RK.studentRMSE()
        studentDataRK["stud_bias"][1] = RK.studentBias()
        studentDataRK["stud_std"][1] = RK.studentStd()
        studentDataRK["fstud_RMSE"][1] = RK.fstudentRMSE()
        studentDataRK["fstud_bias"][1] = RK.fstudentBias()
        studentDataRK["fstud_std"][1] = RK.fstudentStd()
        studentDataRK["empirical loss"][1] = RK.empLoss()
        studentDataRK["theoretic loss"][1] = RK.theoLoss()
        studentDataRK["(Student Std)^2 x Theoretic Loss:"][1] = RK.studentStd()**2*RK.theoLoss()
        studentDataRK["(RMSE)^2 x Theoretic Loss:"][1] = RK.studentRMSE() ** 2 * RK.theoLoss()


        for q in quantileList:
            studentDataRK["quantile{0}%".format(q)][1] = RK.studentQuantile(q)
            studentDataRK["fquantile{0}%".format(q)][1] = RK.fstudentQuantile(q)

        for nb_blocks in block_list:

            studentDataRK["stud_RMSE"][nb_blocks] = LRK[nb_blocks].studentRMSE()
            studentDataRK["stud_bias"][nb_blocks] = LRK[nb_blocks].studentBias()
            studentDataRK["stud_std"][nb_blocks] = LRK[nb_blocks].studentStd()
            studentDataRK["fstud_RMSE"][nb_blocks] = LRK[nb_blocks].fstudentRMSE()
            studentDataRK["fstud_bias"][nb_blocks] = LRK[nb_blocks].fstudentBias()
            studentDataRK["fstud_std"][nb_blocks] = LRK[nb_blocks].fstudentStd()
            studentDataRK["empirical loss"][nb_blocks] = LRK[nb_blocks].empLoss()
            studentDataRK["theoretic loss"][nb_blocks] = LRK[nb_blocks].theoLoss()
            studentDataRK["(Student Std)^2 x Theoretic Loss:"][nb_blocks] = LRK[nb_blocks].studentStd() ** 2 * LRK[nb_blocks].theoLoss()
            studentDataRK["(RMSE)^2 x Theoretic Loss:"][nb_blocks] = LRK[nb_blocks].studentRMSE() ** 2 * LRK[nb_blocks].theoLoss()

            for q in quantileList:
                studentDataRK["quantile{0}%".format(q)][nb_blocks] = LRK[nb_blocks].studentQuantile(q)
                studentDataRK["fquantile{0}%".format(q)][nb_blocks] = LRK[nb_blocks].fstudentQuantile(q)


        ###QMLE/LQMLE student
        studentDataQMLE = DataFrame(preData,index = block_list2)

        studentDataQMLE["stud_RMSE"][1] = QMLE.studentRMSE()
        studentDataQMLE["stud_bias"][1] = QMLE.studentBias()
        studentDataQMLE["stud_std"][1] = QMLE.studentStd()
        studentDataQMLE["fstud_RMSE"][1] = QMLE.fstudentRMSE()
        studentDataQMLE["fstud_bias"][1] = QMLE.fstudentBias()
        studentDataQMLE["fstud_std"][1] = QMLE.fstudentStd()
        studentDataQMLE["empirical loss"][1] = QMLE.empLoss()
        studentDataQMLE["theoretic loss"][1] = QMLE.theoLoss()
        studentDataQMLE["(Student Std)^2 x Theoretic Loss:"][1] = QMLE.studentStd()**2*QMLE.theoLoss()
        studentDataQMLE["(RMSE)^2 x Theoretic Loss:"][1] = QMLE.studentRMSE() ** 2 * QMLE.theoLoss()

        for q in quantileList:
            studentDataQMLE["quantile{0}%".format(q)][1] = QMLE.studentQuantile(q)
            studentDataQMLE["fquantile{0}%".format(q)][1] = QMLE.fstudentQuantile(q)

        for nb_blocks in block_list:

            studentDataQMLE["stud_RMSE"][nb_blocks] = LQMLE[nb_blocks].studentRMSE()
            studentDataQMLE["stud_bias"][nb_blocks] = LQMLE[nb_blocks].studentBias()
            studentDataQMLE["stud_std"][nb_blocks] = LQMLE[nb_blocks].studentStd()
            studentDataQMLE["fstud_RMSE"][nb_blocks] = LQMLE[nb_blocks].fstudentRMSE()
            studentDataQMLE["fstud_bias"][nb_blocks] = LQMLE[nb_blocks].fstudentBias()
            studentDataQMLE["fstud_std"][nb_blocks] = LQMLE[nb_blocks].fstudentStd()
            studentDataQMLE["empirical loss"][nb_blocks] = LQMLE[nb_blocks].empLoss()
            studentDataQMLE["theoretic loss"][nb_blocks] = LQMLE[nb_blocks].theoLoss()
            studentDataQMLE["(Student Std)^2 x Theoretic Loss:"][nb_blocks] = LQMLE[nb_blocks].studentStd() ** 2 * LQMLE[nb_blocks].theoLoss()
            studentDataQMLE["(RMSE)^2 x Theoretic Loss:"][nb_blocks] = LQMLE[nb_blocks].studentRMSE() ** 2 * LQMLE[nb_blocks].theoLoss()

            for q in quantileList:
                studentDataQMLE["quantile{0}%".format(q)][nb_blocks] = LQMLE[nb_blocks].studentQuantile(q)
                studentDataQMLE["fquantile{0}%".format(q)][nb_blocks] = LQMLE[nb_blocks].fstudentQuantile(q)

        RK.toCsv(default_path)
        QMLE.toCsv(default_path)

        for est in LRK.values():
            est.toCsv(default_path)
            for sub in est.sub_estimator:
                sub.toCsv(default_path)

        for est in LQMLE.values():
            est.toCsv(default_path)
            for sub in est.sub_estimator:
                sub.toCsv(default_path)

        studentDataRK.to_csv(default_path/"stud/studentDataRK{0}.csv".format(real_dailySeconds/sample_step))
        studentDataQMLE.to_csv(default_path/"stud/studentDataQMLE{0}.csv".format(real_dailySeconds/sample_step))

    if PA_est:
        preDataPA = {"stud_RMSE" : np.zeros(1),
               "stud_bias" : np.zeros(1),
               "stud_std": np.zeros(1),
               "empirical loss": np.zeros(1),
               "theoretic loss": np.zeros(1),
               "(Student Std)^2 x Theoretic Loss:": np.zeros(1),
               "(RMSE)^2 x Theoretic Loss:": np.zeros(1)
               }

        for q in quantileList:
            preDataPA["quantile{0}%".format(q)] = np.zeros(1)
        PA.toCsv(default_path)

        studentDataPA = DataFrame(preDataPA, index = [1])

        studentDataPA["stud_RMSE"][1] = PA.studentRMSE()
        studentDataPA["stud_bias"][1] = PA.studentBias()
        studentDataPA["stud_std"][1] = PA.studentStd()
        studentDataPA["empirical loss"][1] = PA.empLoss()
        studentDataPA["theoretic loss"][1] = PA.theoLoss()
        studentDataPA["(Student Std)^2 x Theoretic Loss:"][1] = PA.studentStd() ** 2 * PA.theoLoss()
        studentDataPA["(RMSE)^2 x Theoretic Loss:"][1] = PA.studentRMSE() ** 2 * PA.theoLoss()

        for q in quantileList:
            studentDataPA["quantile{0}%".format(q)][1] = PA.studentQuantile(q)

        studentDataPA.to_csv(default_path / "stud/studentDataPA{0}.csv".format(real_dailySeconds / sample_step))

    Noise_value = 1/np.mean(1/np.sqrt(1/252*(presim.Q[:,end]-presim.Q[:,start])))

    ###saving the data
    #presim2 = Simulator(nbsecond,M,d,dailySeconds,T,modelName)
    #presim2.Y, presim2.IV, presim2.R, presim2.Q = presim.Y, presim.IV, presim.R, presim.Q
    #presim2.noiseArgs = presim.noiseArgs

#    data_path =path("/Volumes/BackupResearch/Data Local Est/xi2small/{0}".format(modelName))#path('/users/Simon/desktop/Local MLE vol code/results/')# Data/'+presim2.name+"/")
 #   presim.toCSV(data_path)


###Computing rho and kappa


