# we choose the volatility sigma_t = t

V=0
N=100
for (n in 1:N)
{
  V[n]=0
  for (i in 1:n)
  {
    I4 = (i^5 - (i-1)^5)/(5*n^5)
    I4
    I2 = (i^3 - (i-1)^3)/(3*n^3)
    I2
    V[n] = V[n] + 5*I4/(sqrt(n)*I2^(1/2)) + 3*sqrt(n)*I2^(3/2)
  }
}

### Smooth volatility
# more accepted model sigma_t = C + A*exp(-a*t) + B*exp(-b*(1-t))
# we first plot the function
L=1000
NbDays=1
NT = 10000
N= 8 # nb max of blocks in QMLE
V=matrix(nrow=NT,ncol=N)
VK=matrix(nrow=NT,ncol=N)
VP=matrix(nrow=NT,ncol=N)
delta=0
opt=0
rho=0
rhoTab=0
kappaTab=0
for (k in 533:NT)
{
g= 1.68
A = g*0.75 
B = g*0.25 
#B = g*0.5
C = 0.88929198 
a = 10 
b = 10
#for (d in 1:NbDays)
#{
#div=L/NbDays
#t = 1:div/div
#sigma=rep(1, times=L)
#sigma[(div*(d-1) + 1):(div*d)] = rnorm(1,0,0.3) + C + A*exp(-a*t) + B*exp(-b*(1-t)) #+ cumsum(rnorm(mean=0,sd=0.005, n=L))
#}
#adding jumps
#big jumps
t=(1:L)/L
del=L/NT
sigma =  C + A*exp(-a*t) + B*exp(-b*(1-t)) #+ cumsum(rnorm(mean=0,sd=0.005, n=L))
sigma[(k*del):10000] = sigma[(k*del):10000] - sigma[(k*del)]/2
#small jumps
#j=floor(cumsum(rexp(100,rate=0.0002)))
#i=1
#while (j[i] < (L+1))
#{
#  size=rnorm(1,0,0.5)
#  sigma[j[i]:10000] = sigma[j[i]:10000] + size
#  i=i+1
#}




#plot(sigma)
#sigma = 6 + cumsum(rnorm(mean=0,sd=0.02, n=L))
#plot(sigma)
#mean(sigma)
#points(sigma^2, col="red")
#mean(sigma^2)
int2=function(u,v) 
  {
  #r = C^2 * (v-u) + 2*C*A*(exp(-a*u) - exp(-a*v))/a + 2*C*B*(exp(-b*(1-v)) - exp(-b*(1-u)))/b + A^2*(exp(-2*a*u) - exp(-2*a*v))/(2*a) + B^2*(exp(-2*b*(1-v)) - exp(-2*b*(1-u)))/(2*b) + exp(-a)*(v-u) 
  r = mean(sigma[(1+L*u):(L*v)]^2)*(v-u)
  return(r)  
}
i2 = int2(0,1)
#normalize sigma
sigma= sigma/sqrt(i2)

int2=function(u,v) 
{
  #r = C^2 * (v-u) + 2*C*A*(exp(-a*u) - exp(-a*v))/a + 2*C*B*(exp(-b*(1-v)) - exp(-b*(1-u)))/b + A^2*(exp(-2*a*u) - exp(-2*a*v))/(2*a) + B^2*(exp(-2*b*(1-v)) - exp(-2*b*(1-u)))/(2*b) + exp(-a)*(v-u) 
  r = mean(sigma[(1+L*u):(L*v)]^2)*(v-u)
  return(r)  
}

#mean(sigma^3)
#need to make calculus...
int3=function(u,v) 
{
  r = mean(sigma[(1+L*u):(L*v)]^3)*(v-u)
  return(r)  
}
int3(0,1)                                                                                                                                       

#mean(sigma^4)
#need to make calculus...
int4=function(u,v) 
{
  r = mean(sigma[(1+L*u):(L*v)]^4)*(v-u)
  return(r)  
}
int4(0,1)   

rho[k] = int2(0,1)/int4(0,1)^(1/2)
rholoc=function(u,v) 
{
  r = int2(u,v)/((v-u)*int4(u,v))^(1/2)
  return(r)  
}

kappa=function(u,v) 
{
  r = int3(u,v)/((v-u)*int4(u,v))^(3/4)
  return(r)  
}


rhoTab[k]=rholoc(0,1)
kappaTab[k]=kappa(0,1)


#Computing local QMLE
V[k,1]=0
for (n in 1:N)
{
  V[k,n]=0
  for (i in 1:n)
  {
    V[k,n] = V[k,n] + 5*int4((i-1)/n, i/n)/(n^(1/2)*int2((i-1)/n, i/n)^(1/2)) + 3*n^(1/2)*int2((i-1)/n, i/n)^(3/2)
  }
}
opt[k]=8*int3(0,1)

#Computing kernels
#RK TH2
k0=0.219
k1=1.71
k2=41.7
c=5.74
for (n in 1:N)
{
  VK[k,n]=0
  for (i in 1:n)
  {
    #VK[k,n] = VK[k,n] + (16/(3*n^(1/4)))*int4((i-1)/n, i/n)^(3/4)*sqrt(rholoc((i-1)/n, i/n)*0.37)*(1/sqrt(1+sqrt(1+3*5.34/rholoc((i-1)/n, i/n))) +sqrt(1 + sqrt(1+3*5.34/rholoc((i-1)/n, i/n))))
    VK[k,n] = VK[k,n] + int4((i-1)/n, i/n)^(3/4)*4*(c*k0 +2*rholoc((i-1)/n, i/n)*k1/c + k2/c^3)/n^(1/4)
    }
}


#computing preaveraging method
phig=1/3
phigg=151/5040
phiggp=1/6
phigpgp=8/3
for (n in 1:N)
{
  VP[k,n]=0
  for (i in 1:n)
  {
    theta=(n*int2((i-1)/n,i/n)*((sqrt(phiggp^2 + 3*phigg*phigpgp) - phiggp)/(3*phigpgp)))^(-1/2)
    VP[k,n] = VP[k,n] + (4/(theta^3*phig^2))*(phigg*theta^4*int4((i-1)/n, i/n) + 2*phiggp*theta^2*int2((i-1)/n, i/n) +phigpgp/n)
  }
}
}

## plot for model 2
par(mfrow=c(2,2)) 
plot(x=rhoTab[533:10000], y=((V[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), ylim=c(0,100), xlab="rho", ylab="loss (in %)", lwd=2)
#plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), xlab="rho", ylab="loss", lwd=2)
for (i in 1:8)
{
  points(x=rhoTab[533:10000], y=((V[533:10000,i]/opt[533:10000]) - 1)*100, col=i, type="l", lwd=2, lty=i)
  #points(x=rhoTab[533:10000], y=(VK[533:10000,i]/opt[533:10000] - 1)*100, col=i, type="l", lwd=2)
  #points(x=rhoTab, y=VK[1:NT,i]/opt[1:NT], col=i, type="l")
}
title("QMLE")

plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), ylim=c(0,100), xlab="rho", ylab="loss (in %)", lwd=2)
#plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), xlab="rho", ylab="loss", lwd=2)
for (i in 1:8)
{
  points(x=rhoTab[533:10000], y=((VK[533:10000,i]/opt[533:10000]) - 1)*100, col=i, type="l", lwd=2, lty=i)
  #points(x=rhoTab[533:10000], y=(VK[533:10000,i]/opt[533:10000] - 1)*100, col=i, type="l", lwd=2)
  #points(x=rhoTab, y=VK[1:NT,i]/opt[1:NT], col=i, type="l")
}
title("RK Tukey Hanning 2")
#legend(.85,100, legend=c("B=1", "B=2", "B=3", "B=4", "B=5", "B=6", "B=7", "B=8"), lty=c(1,2, 3, 4, 5,6,7,8) , lwd=c(2,2, 2, 2, 2,2,2,2), col=c(1,2,3,4,5,6,7,8)) 

plot(x=rhoTab[533:10000], y=(VK[533:10000,1]/V[533:10000,1]), col=1, type="l", xlim=c(.4,0.9470193), ylim=c(0.75,1.05), xlab="rho", ylab="AVAR(RK)/AVAR(QMLE)", lwd=2)
#plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), xlab="rho", ylab="loss", lwd=2)
for (i in 1:8)
{
  points(x=rhoTab[533:10000], y=(VK[533:10000,i]/V[533:10000,i]), col=i, type="l", lwd=2, lty=i)
  #points(x=rhoTab[533:10000], y=(VK[533:10000,i]/opt[533:10000] - 1)*100, col=i, type="l", lwd=2)
  #points(x=rhoTab, y=VK[1:NT,i]/opt[1:NT], col=i, type="l")
}
title("ratio RK/QMLE")

plot(x=rhoTab[533:10000], y=(VP[533:10000,1]/V[533:10000,1]), col=1, type="l", xlim=c(.4,0.9470193), ylim=c(1.02,1.08), xlab="rho", ylab="AVAR(PAE)/AVAR(QMLE)", lwd=2)
#plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), xlab="rho", ylab="loss", lwd=2)
for (i in 1:8)
{
  points(x=rhoTab[533:10000], y=(VP[533:10000,i]/V[533:10000,i]), col=i, type="l", lwd=2, lty=i)
  #points(x=rhoTab[533:10000], y=(VK[533:10000,i]/opt[533:10000] - 1)*100, col=i, type="l", lwd=2)
  #points(x=rhoTab, y=VK[1:NT,i]/opt[1:NT], col=i, type="l")
}
title("ratio PAE/QMLE")

## plot for model 1
par(mfrow=c(2,2)) 
plot(x=rhoTab[1:NT], y=((V[1:NT,1]/opt[1:NT]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), ylim=c(0,100), xlab="rho", ylab="loss (in %)", lwd=2)
#plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), xlab="rho", ylab="loss", lwd=2)
for (i in 1:8)
{
  points(x=rhoTab[1:NT], y=((V[1:NT,i]/opt[1:NT]) - 1)*100, col=i, type="l", lwd=2, lty=i)
  #points(x=rhoTab[533:10000], y=(VK[533:10000,i]/opt[533:10000] - 1)*100, col=i, type="l", lwd=2)
  #points(x=rhoTab, y=VK[1:NT,i]/opt[1:NT], col=i, type="l")
}
title("QMLE")

plot(x=rhoTab[1:NT], y=((VK[1:NT,1]/opt[1:NT]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), ylim=c(0,100), xlab="rho", ylab="loss (in %)", lwd=2)
#plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), xlab="rho", ylab="loss", lwd=2)
for (i in 1:8)
{
  points(x=rhoTab[1:NT], y=((VK[1:NT,i]/opt[1:NT]) - 1)*100, col=i, type="l", lwd=2, lty=i)
  #points(x=rhoTab[533:10000], y=(VK[533:10000,i]/opt[533:10000] - 1)*100, col=i, type="l", lwd=2)
  #points(x=rhoTab, y=VK[1:NT,i]/opt[1:NT], col=i, type="l")
}
title("RK Tukey Hanning 2")
#legend(.85,100, legend=c("B=1", "B=2", "B=3", "B=4", "B=5", "B=6", "B=7", "B=8"), lty=c(1,2, 3, 4, 5,6,7,8) , lwd=c(2,2, 2, 2, 2,2,2,2), col=c(1,2,3,4,5,6,7,8)) 

plot(x=rhoTab[1:NT], y=(VK[1:NT,1]/V[1:NT,1]), col=1, type="l", xlim=c(.4,0.9470193), ylim=c(0.75,1.05), xlab="rho", ylab="AVAR(RK)/AVAR(QMLE)", lwd=2)
#plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), xlab="rho", ylab="loss", lwd=2)
for (i in 1:8)
{
  points(x=rhoTab[1:NT], y=(VK[1:NT,i]/V[1:NT,i]), col=i, type="l", lwd=2, lty=i)
  #points(x=rhoTab[533:10000], y=(VK[533:10000,i]/opt[533:10000] - 1)*100, col=i, type="l", lwd=2)
  #points(x=rhoTab, y=VK[1:NT,i]/opt[1:NT], col=i, type="l")
}
title("ratio RK/QMLE")

plot(x=rhoTab[1:NT], y=(VP[1:NT,1]/V[1:NT,1]), col=1, type="l", xlim=c(.4,0.9470193), ylim=c(1.02,1.08), xlab="rho", ylab="AVAR(PAE)/AVAR(QMLE)", lwd=2)
#plot(x=rhoTab[533:10000], y=((VK[533:10000,1]/opt[533:10000]) - 1)*100, col=1, type="l", xlim=c(.4,0.9470193), xlab="rho", ylab="loss", lwd=2)
for (i in 1:8)
{
  points(x=rhoTab[1:NT], y=(VP[1:NT,i]/V[1:NT,i]), col=i, type="l", lwd=2, lty=i)
  #points(x=rhoTab[533:10000], y=(VK[533:10000,i]/opt[533:10000] - 1)*100, col=i, type="l", lwd=2)
  #points(x=rhoTab, y=VK[1:NT,i]/opt[1:NT], col=i, type="l")
}
title("ratio PAE/QMLE")


## compute the expected gain with kappaTab and rhoTab
RKgain=0
QMLEgain=0
for (i in 1:1000)
{
  k0=0.032
  k1=10.26
  k2=14374
  
  
  rho=rhoTab[i]
  kappa=kappaTab[i]
  RKgain[i] = (1/kappa)*(16/3)*sqrt(rho*k0*k1)*((1/sqrt(1+sqrt(1+3*d/rho))) + sqrt(1+sqrt(1+3*d/rho)))/8
  QMLEgain[i] = (5+3*rho^2)/(8*kappa*rho^(1/2))
}