import numpy as np
from pandas import DataFrame, Series
import pandas as pd
#from path import path
from scipy.stats import chi2,t,norm
from statsmodels.stats.stattools import durbin_watson
from statsmodels.formula.api import ols
from statsmodels.tsa.stattools import adfuller
from arch.unitroot import PhillipsPerron
import os
import matplotlib.pyplot as plt
import matplotlib.patches as patches
desired_width = 320
pd.set_option('display.width', desired_width)
np.set_printoptions(linewidth=desired_width)
pd.set_option("display.max_columns", 20)

#auxiliary functions
def localRV(dX,start,end,T=1): #spot volatility estimate
    return np.sum(dX[start:end]**2)*(dX.size-1)/((end-start)*T)

def RV(X,start,end,T=1): #realized volatility estimator
    return np.sum(np.diff(X[start:end])**2)*(X.size-1)/((end-start)*T)

def toBrownian(dX,k,T=1,weight = ()):
    if weight == ():
        dY = dX[k:]/np.array([np.sqrt(localRV(dX,i-k,i,T)) for i in range(k,dX.size)])
    else:
        dY = dX[k:]*weight[k:]/np.array([np.sqrt(localRV(dX, i - k, i, T)) for i in range(k, dX.size)])
    return np.sum(dY)/np.sqrt(T)

def toBrownianProcess(dX,k,T=1,weight = ()):
    if weight == ():
        dY = dX[k:]/np.array([np.sqrt(localRV(dX,i-k,i,T)) for i in range(k,dX.size)])
    else:
        dY = dX[k:]*weight[k:]/np.array([np.sqrt(localRV(dX, i - k, i, T)) for i in range(k, dX.size)])
    return dY/np.sqrt(T)

def toBrownianProcess2(dX,dY,k,T=1,weight = ()):
    if weight == ():
        den = np.array([np.sqrt(localRV(dX,i-k,i,T)) for i in range(k,dX.size)])
        dXr = dX[k:]/den
        dYr = dY[k:]/den
    else:
        den = np.array([np.sqrt(localRV(dX, i - k, i, T)) for i in range(k, dX.size)])
        dXr = dX[k:]*weight[k:]/den
        dYr = dY[k:] * weight[k:] / den
    r=np.array([dXr,dYr])
    return r/np.sqrt(T)

def toBrownianProcess3(dX,dXdet,dYdet,k,T=1,weight = ()):
    if weight == ():
        den = np.array([np.sqrt(localRV(dX,i-k,i,T)) for i in range(k,dX.size)])
        dXr = dXdet[k:]/den
        dYr = dYdet[k:]/den
    else:
        den = np.array([np.sqrt(localRV(dX, i - k, i, T)) for i in range(k, dX.size)])
        dXr = dXdet[k:]*weight[k:]/den
        dYr = dYdet[k:] * weight[k:] / den
    r=np.array([dXr,dYr])
    return r/np.sqrt(T)

def toBrownianProcessFromObs(X,Y,k=30,T=1):
    den = np.array([np.sqrt(RV(X,0,i,T)) for i in range(k,X.size)])
    Xr = X[k:]/den
    Yr = Y[k:]/den
    r=np.array([Xr,Yr])
    return r/np.sqrt(T)



def pseudo_DF(dX,X,k,T=1):
    return toBrownian(dX*X[:-1],k,T)

def bipower(dX):
    return np.pi/2 * np.sum(abs(dX[:-1])*abs(dX[1:]))
#np.random.seed(1)

#def bipower_avar(dX,T=1):
#    return np.pi/2*np.sqrt(T*(1+4/np.pi-12/np.pi**2))*

def randomize(X, k=1):
    Y = np.zeros(X.shape)
    for m in range(X.shape[0]):
        for j in range(int(X.shape[1]/k)):
            Y[m,min((j*k),X.shape[1]-1):min(((j+1)*k),X.shape[1])] = X[m,min((j*k),X.shape[1]-1):min(((j+1)*k),X.shape[1])] * (2*np.random.binomial(n=1,p=0.5,size=1)-1)
    return Y

def truncate(X, dt, alpha, omega = 0.49):
    dX = np.concatenate((np.zeros(1), np.diff(X)))
    dX =dX * (abs(dX) < alpha * (dt ** omega))
    Xtrunc = X[0] + dX.cumsum()
    return Xtrunc

def addJumps(X,param, T, d, mode="poisson"):
    nsimul = X[0].__len__()
    Mind = X.__len__()
    Jprice = np.zeros((Mind, nsimul))
    if mode =="poisson":
        intensity = param[0]
        sizeJump = param[1]
        sdSizeJump = param[2]
        nb_jumps = np.random.poisson(intensity*T*d, Mind)
        #print("nb Jumps: ", nb_jumps)
        for iMC in range(Mind):
            idx_jumps = np.array([int(np.random.uniform(0, 1) * nsimul) for k in range(nb_jumps[iMC])])
            if idx_jumps.size > 0:
                Jprice[iMC, idx_jumps] = (sizeJump + np.random.normal(loc=0,scale=sdSizeJump,size=1))* (2 * np.random.binomial(1, 1 / 2, size=idx_jumps.size) - 1)
        Jprice = np.cumsum(Jprice, axis=1)
    return X+Jprice

#average_IQ = 6.5e-05#2.8e-05 (Model 2) #2.8655471018389605e-05
#xi2 = 0.0002

np.random.seed(1)


a2true = 0 #  10**(-6)

start = 1
end= -1

real_dailySeconds = 23400

# set simulation parameter
nbsecond = 600 #4680#!!!!!!Paper simulation value 600 # duree entre deux trades en secondes
dailySeconds = real_dailySeconds
M = 100
T = 1/252
d = 504 # two years

ndaily = int(dailySeconds / nbsecond)
n = int(dailySeconds * d / nbsecond)

##Model Name
modelName = "CstDvolNoHesNoUNoDriftNoJp"
U = 0# U part yes or no, should be consistent with modelName
Jp = 0 # Jp (in price) yes or no, should be consistent with modelName
drift = 0# drift yes or no, should be consistent with modelName
Heston = 0 # heston part yes or no, should be consistent with modelName
LinDVol = 0 # linear Dvol, should be consistent with modelName
JpDVol = 1 # jumps in Dvol, should be consistent with modelName
BrownDVol = 0 # Brownian motion in Dvol, should be consistent with modelName
modelUName = "Model 3" #relevent if U=1
truncate0 =1 #use the truncation if equal to 1


####drift
if drift ==1:
    driftX_fun = lambda x: 0.03
    driftZ_fun = lambda x: 0.03*np.cos(x/0.1)

####Parameters for the Heston
mu = 0
rho = -0.75
alpha = 1
kappa = 5 #ressort
gamma = .4
if Heston == 0:
    kappa = 0
    gamma = 0

sigma = np.sqrt(0.1)

def riemann(g,k=500):
    return np.sum([g(i/k) for i in range(k)])*1/k

def plot(x):
    Series(x).plot()

###Cointegration parameters
nb_coint= 2
alpha_vec = np.array([2])

rho_coint1 = 0.8
rho_coint2 = 0.9
####Parameters for the daily U-shaped vol

coeff= 0
scaling = 1
if modelUName == "Model 2":
    coeff = 1
    scaling = 1
elif modelUName == "Model 1" :
    coeff = 1.8 #To adjust
    scaling = 1.070189
elif modelUName == "Model 3":
    coeff = 1.8
    scaling = 1

A = coeff*0.75/scaling
B = coeff*0.25/scaling
C = 0.88929198/scaling
a = 10.0
b = 10.0

def sigma_u(x):
    return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma

###Parameters for the jump and model spec
jump_size = 0
jump_start,jump_end=0,1
jump_mode = "unif"
vol_fun = lambda x:1
vol_fun_global= lambda x:sigma
if LinDVol == 1:
    vol_fun_global = lambda x:sigma*(1-3*x/4)
if JpDVol == 1:
    vol_fun_global = lambda x: sigma*((x<0.2) + (1/3)*(x>=0.2))
if BrownDVol == 1:
    sizeBrown=10000
    brown = 1 + np.cumsum(np.random.normal(loc=0,scale=1,size=sizeBrown))/200
    for i in range(sizeBrown):
        brown[i] = max(0.2, brown[i])
    vol_fun_global = lambda x: sigma*brown[np.int(np.floor(x*(sizeBrown-1)))]
if U==1:
    vol_fun = sigma_u
    if modelUName == "Model 3":
        jump_size = .5  # in % of the vol
        jump_start,jump_end = 0.05,0.7

intensityJumpParam = 0
sizeJumpParam = 0
if drift==0:
    priceArgs = [[mu, kappa, alpha, gamma, rho, vol_fun, vol_fun_global, [jump_size,jump_start,jump_end, intensityJumpParam, sizeJumpParam], jump_mode] for k in range(nb_coint)]
else:
    priceArgs = [[mu, kappa, alpha, gamma, rho, vol_fun, vol_fun_global, driftX_fun, [jump_size, jump_start, jump_end, intensityJumpParam, sizeJumpParam],jump_mode] for k in range(nb_coint)]
    priceArgs[-1][7]=driftZ_fun
## Simulate the data

print("Simulating trajectories...")

####Brownian correlation parameters
correl = np.array([[1,0],[0,1]])#np.array([[1,0.5],[0.5,1]])#np.array([[1,-0.5,0.3,0],[-0.5,1,0.2,0.2],[0.3,0.2,1,0.4],[0,0.2,0.4,1]])
W =np.random.multivariate_normal((0,0), correl,size = (M,n+1)) #multidimensional correlated Brownian motion

for k in range(nb_coint):
    priceArgs[k].append(W[:,:,k])

presim = [Simulator(nbsecond,M,d,dailySeconds,T,modelName,1) for j in range(nb_coint)]

myPreSim = [presim[j].simulGlobal(presim[j].simulSVHeston,priceArgs[j],presim[j].simulNoiseIID, [a2true], (), infotype='None', brownianInput=True, priceJumps=False, recordMode=True, global_sigma_functionInput=True, driftInput=drift) for j in range(nb_coint)]
rho_mean = [presim[j].rhoGlobal(start,end).mean() for j in range(nb_coint)]
rho_std = [presim[j].rhoGlobal(start,end).std()for j in range(nb_coint)]
kappa_mean = [presim[j].kappaGlobal(start,end).mean() for j in range(nb_coint)]
kappa_std = [presim[j].kappaGlobal(start,end).std() for j in range(nb_coint)]

sampling_list = [1,3,6,12,39,78] #[1]#!!!!!!! paper values [1,3,6,12,39,78]
rejectDictH0 = {'DFdemloc2': [], 'DFdem': [], 'ADFdem': [], 'PP_taudem': [], 'PP_alphadem': []}
powerDictH11 = {name: [] for name in rejectDictH0}
powerDictH12 = {name: [] for name in rejectDictH0}
c0H11 = {name: [] for name in rejectDictH0}
c0H12 = {name: [] for name in rejectDictH0}
alphaH11 = {name: [] for name in rejectDictH0}
alphaH12 = {name: [] for name in rejectDictH0}
rhoH0 = {name: [] for name in rejectDictH0}
rhoH11 = {name: [] for name in rejectDictH0}
rhoH12 = {name: [] for name in rejectDictH0}
modelList = len(sampling_list)*[modelName]
nList = []

for sample_step in sampling_list:

    sim = [Simulator(nbsecond*sample_step,M,d,dailySeconds,T, modelName,1) for j in range(nb_coint)]
    for j in range(nb_coint):
        sim[j].Y, sim[j].IV, sim[j].R, sim[j].Q = presim[j].Y[:,::sample_step], presim[j].IV[:,::sample_step], presim[j].R[:,::sample_step], presim[j].Q[:,::sample_step]
    #####
    nsub = np.shape(sim[0].Y[0])[0]-1
    c0 = 1
    Xntnj = np.array([np.array([sim[j].Y[m,:] for j in range(0,nb_coint-1)]) for m in range(M)]) #non truncated and non jumpy X
    intensityJp=10 ## nb of jumps per year
    sizeJp=np.sqrt(1/intensityJp)*sigma
    sdSizeJp =sizeJp/10
    paramJp = [intensityJp, sizeJp, sdSizeJp]
    if Jp ==1:
        Xnt = np.array([addJumps(Xntnj[m],paramJp,T,d) for m in range(M)]) #non truncated X
    else:
        Xnt = Xntnj
    if truncate0==1:
        X = np.array([np.array([truncate(Xnt[m][j], d*T/nsub, 3, 0.49) for j in range(0,nb_coint-1)]) for m in range(M)]) # truncated X
    else:
        X = Xnt
    Z = sim[-1].Y #- sim[-1].Y[:,0].reshape((M,1))
    dZ = np.concatenate((np.zeros((M,1)),np.diff(Z)), axis = 1)
    Y0ntnj = c0 + np.array([sum(alpha_vec*Xntnj[m]) for m in range(M)])+Z # non truncated and non noisy Y0
    if Jp ==1:
        Y0nt = addJumps(Y0ntnj,paramJp,T,d) # non truncated Y0
    else:
        Y0nt = Y0ntnj
    if truncate0==1:
        Y0 = np.array([truncate(Y0nt[m], d * T / nsub, 3, 0.49) for m in range(M)])
    else:
        Y0=Y0nt
    epsilon_H1_star1 = np.zeros((M,dZ.shape[1]))
    epsilon_H1_star2 = np.zeros((M, dZ.shape[1]))
    for k in range(1,dZ.shape[1]):
        epsilon_H1_star1[:,k] = rho_coint1*epsilon_H1_star1[:,k-1]  + dZ[:,k]
        epsilon_H1_star2[:, k] = rho_coint2 * epsilon_H1_star2[:, k - 1] + dZ[:, k]
    Y1ntnj1 = c0 + np.array([sum(alpha_vec*Xntnj[m]) for m in range(M)])+epsilon_H1_star1
    Y1ntnj2 = c0 + np.array([sum(alpha_vec * Xntnj[m]) for m in range(M)]) + epsilon_H1_star2
    if Jp ==1:
        Y1nt1 = addJumps(Y1ntnj1,paramJp,T,d)
        Y1nt2 = addJumps(Y1ntnj2, paramJp, T, d)
    else:
        Y1nt1 = Y1ntnj1
        Y1nt2 = Y1ntnj2
    if truncate0==1:
        Y11 = np.array([truncate(Y1nt1[m], d * T / nsub, 3, 0.49) for m in range(M)])
        Y12 = np.array([truncate(Y1nt2[m], d * T / nsub, 3, 0.49) for m in range(M)])
    else:
        Y11 = Y1nt1
        Y12 = Y1nt2
    alpha_H0 = alpha_vec + np.array([np.dot(np.linalg.inv(np.dot(X[m],X[m].transpose())),np.dot(X[m],Z[m])) for m in range(M)])

    #### X, Y0 and Y1 demeaned from non truncated observations
    Xdet = np.array([np.array([np.array([Xnt[m][j][k] - np.mean(Xnt[m][j]) for k in range(nsub + 1)]) for j in range(0, nb_coint - 1)]) for m in range(M)])
    Y0det = np.array([np.array([Y0nt[m][k] - np.mean(Y0nt[m]) for k in range(nsub + 1)]) for m in range(M)])
    Y1det1 = np.array([np.array([Y1nt1[m][k] - np.mean(Y1nt1[m]) for k in range(nsub + 1)]) for m in range(M)])
    Y1det2 = np.array([np.array([Y1nt2[m][k] - np.mean(Y1nt2[m]) for k in range(nsub + 1)]) for m in range(M)])

    #### deflated from (truncated) returns
    X0 = X[0][0][0]
    Y00 = Y0[0][0]
    Y101 = Y11[0][0]
    Y102 = Y12[0][0]
    dX = np.array([np.array([np.concatenate((np.zeros(1),np.diff(X[m][j]))) for j in range(0,nb_coint-1)]) for m in range(M)])
    dY0 = np.array([np.concatenate((np.zeros(1), np.diff(Y0[m]))) for m in range(M)])
    dXdef = np.array([np.array([toBrownianProcess2(dX[m][j],dY0[m], int(np.sqrt(nsub)),T)[0] for j in range(0,nb_coint-1)]) for m in range(M)])
    Xdef = X0 + np.array([np.array([ dXdef[m][j].cumsum() for j in range(0,nb_coint-1)]) for m in range(M)])
    dY0def = np.array([toBrownianProcess2(dX[m][0],dY0[m], int(np.sqrt(nsub)), T)[1] for m in range(M)])
    Y0def = Y00 + np.array([dY0def[m].cumsum()  for m in range(M)])
    dY11 = np.array([np.concatenate((np.zeros(1), np.diff(Y11[m]))) for m in range(M)])
    dY12 = np.array([np.concatenate((np.zeros(1), np.diff(Y12[m]))) for m in range(M)])
    dY1def1 = np.array([toBrownianProcess2(dX[m][0],dY11[m], int(np.sqrt(nsub)), T)[1] for m in range(M)])
    dY1def2 = np.array([toBrownianProcess2(dX[m][0], dY12[m], int(np.sqrt(nsub)), T)[1] for m in range(M)])
    Y1def1 = Y101 + np.array([dY1def1[m].cumsum() for m in range(M)])
    Y1def2 = Y102 + np.array([dY1def2[m].cumsum() for m in range(M)])

    ### demeaned after deflating
    n0 = np.shape(Xdef[0][0])[0]-1
    Xdetdef2 = np.array([np.array([np.array([Xdef[m][j][k] - np.mean(Xdef[m][j]) for k in range(n0+1)]) for j in range(0, nb_coint - 1)]) for m in range(M)])
    Y0detdef2 = np.array([np.array([Y0def[m][k] - np.mean(Y0def[m]) for k in range(n0+1)]) for m in range(M)])
    Y1detdef21 = np.array([np.array([Y1def1[m][k] - np.mean(Y1def1[m]) for k in range(n0+1)]) for m in range(M)])
    Y1detdef22 = np.array([np.array([Y1def2[m][k] - np.mean(Y1def2[m]) for k in range(n0 + 1)]) for m in range(M)])

    #### deflated from observations
    #Xdef2 = np.array([np.array([toBrownianProcessFromObs(X[m][j],Y0[m], 30,T)[0] for j in range(0,nb_coint-1)]) for m in range(M)])
    #Y0def2 = np.array([toBrownianProcessFromObs(X[m][0], Y0[m], 30, T)[1] for m in range(M)])
    #Y1def2 = np.array([toBrownianProcessFromObs(X[m][0], Y1[m], 30, T)[1] for m in range(M)])

    #### estimating alpha

    #alpha_hat_H0  = np.array([np.dot(np.linalg.inv(np.dot(X[m],X[m].transpose())),np.dot(X[m],Y0[m])) for m in range(M)])
    #alpha_hat_H1  = np.array([np.dot(np.linalg.inv(np.dot(X[m],X[m].transpose())),np.dot(X[m],Y1[m])) for m in range(M)])
    alpha_hat_det_H0 = np.array([np.dot(np.linalg.inv(np.dot(Xdet[m], Xdet[m].transpose())), np.dot(Xdet[m], Y0det[m])) for m in range(M)])
    alpha_hat_det_H11 = np.array([np.dot(np.linalg.inv(np.dot(Xdet[m], Xdet[m].transpose())), np.dot(Xdet[m], Y1det1[m])) for m in range(M)])
    alpha_hat_det_H12 = np.array([np.dot(np.linalg.inv(np.dot(Xdet[m], Xdet[m].transpose())), np.dot(Xdet[m], Y1det2[m])) for m in range(M)])
    alpha_hat_detdef2_H0 = np.array([np.dot(np.linalg.inv(np.dot(Xdetdef2[m], Xdetdef2[m].transpose())), np.dot(Xdetdef2[m], Y0detdef2[m])) for m in range(M)])
    alpha_hat_detdef2_H11 = np.array([np.dot(np.linalg.inv(np.dot(Xdetdef2[m], Xdetdef2[m].transpose())), np.dot(Xdetdef2[m], Y1detdef21[m])) for m in range(M)])
    alpha_hat_detdef2_H12 = np.array([np.dot(np.linalg.inv(np.dot(Xdetdef2[m], Xdetdef2[m].transpose())), np.dot(Xdetdef2[m], Y1detdef22[m])) for m in range(M)])

    #### estimating c0
    c0_hat_det_H0 = np.array([np.mean(Y0nt[m]) - alpha_hat_det_H0[m]*np.mean(Xnt[m]) for m in range(M)])
    c0_hat_det_H11 = np.array([np.mean(Y1nt1[m]) - alpha_hat_det_H11[m] * np.mean(Xnt[m]) for m in range(M)])
    c0_hat_det_H12 = np.array([np.mean(Y1nt2[m]) - alpha_hat_det_H12[m] * np.mean(Xnt[m]) for m in range(M)])
    c0_hat_detdef2_H0 = np.array([np.mean(Y0def[m]) - alpha_hat_detdef2_H0[m] * np.mean(Xdef[m]) for m in range(M)])
    c0_hat_detdef2_H11 = np.array([np.mean(Y1def1[m]) - alpha_hat_detdef2_H11[m] * np.mean(Xdef[m]) for m in range(M)])
    c0_hat_detdef2_H12 = np.array([np.mean(Y1def2[m]) - alpha_hat_detdef2_H12[m] * np.mean(Xdef[m]) for m in range(M)])

    ###residuals: equivalence between model in the paper and the construction here
    #epsilon_H0 = np.array([Y0[m] - np.dot(alpha_hat_H0[m],X[m]) for m in range(M)])
    #epsilon_H1 = np.array([Y1[m] - np.dot(alpha_hat_H1[m],X[m]) for m in range(M)])
    epsilon_det_H0 = np.array([Y0det[m] - np.dot(alpha_hat_det_H0[m], Xdet[m]) for m in range(M)])
    epsilon_det_H11 = np.array([Y1det1[m] - np.dot(alpha_hat_det_H11[m], Xdet[m]) for m in range(M)])
    epsilon_det_H12 = np.array([Y1det2[m] - np.dot(alpha_hat_det_H12[m], Xdet[m]) for m in range(M)])
    epsilon_detdef2_H0 = np.array([Y0detdef2[m] - np.dot(alpha_hat_detdef2_H0[m], Xdetdef2[m]) for m in range(M)])
    epsilon_detdef2_H11 = np.array([Y1detdef21[m] - np.dot(alpha_hat_detdef2_H11[m], Xdetdef2[m]) for m in range(M)])
    epsilon_detdef2_H12 = np.array([Y1detdef22[m] - np.dot(alpha_hat_detdef2_H12[m], Xdetdef2[m]) for m in range(M)])

    #depsilon_H0 = np.diff(epsilon_H0)
    #depsilon_H1 = np.diff(epsilon_H1)

    ### estimating rho
    rho_hat_detdef2_H0 = np.array([np.sum(epsilon_detdef2_H0[m][0:n0-1] * np.diff(epsilon_detdef2_H0[m][1:n0 + 1])) / np.sum(epsilon_detdef2_H0[m][0:n0] * np.diff(epsilon_detdef2_H0[m][0:n0 + 1])) for m in range(M)])
    rho_hat_detdef2_H11 = np.array([np.sum(epsilon_detdef2_H11[m][0:n0 - 1] * np.diff(epsilon_detdef2_H11[m][1:n0 + 1])) / np.sum(epsilon_detdef2_H11[m][0:n0] * np.diff(epsilon_detdef2_H11[m][0:n0 + 1])) for m in range(M)])
    rho_hat_detdef2_H12 = np.array([np.sum(epsilon_detdef2_H12[m][0:n0 - 1] * np.diff(epsilon_detdef2_H12[m][1:n0 + 1])) / np.sum(epsilon_detdef2_H12[m][0:n0] * np.diff(epsilon_detdef2_H12[m][0:n0 + 1])) for m in range(M)])
    rho_hat_det_H0 = np.array([np.sum(epsilon_det_H0[m][0:n0] * epsilon_det_H0[m][1:n0 + 1]) / np.sum(epsilon_det_H0[m] ** 2) for m in range(M)])
    rho_hat_det_H11 = np.array([np.sum(epsilon_det_H11[m][0:n0] * epsilon_det_H11[m][1:n0 + 1]) / np.sum(epsilon_det_H11[m] ** 2) for m in range(M)])
    rho_hat_det_H12 = np.array([np.sum(epsilon_det_H12[m][0:n0] * epsilon_det_H12[m][1:n0 + 1]) / np.sum(epsilon_det_H12[m] ** 2) for m in range(M)])

    ###quantities required for the CLT on (alpha,c0)
    #veps_hat_H11 = np.array([np.sum(epsilon_detdef2_H11[m] ** 2)/T for m in range(M)])
    #rho_hat_H11 = np.array([np.sum(epsilon_detdef2_H11[m][0:n0] * epsilon_detdef2_H11[m][1:n0+1]) /np.sum(epsilon_detdef2_H11[m] ** 2) for m in range(M)]) #np.sum(epsilon_detdef2_H11[m][0:n0] * epsilon_detdef2_H11[m][1:n0+1]) /np.sum(epsilon_detdef2_H11[m] ** 2)
    #rinf_hat_H11 = np.array([np.array([0 for j in range(0, nb_coint - 1)]) for m in range(M)]) #np.sum(dXdef[m][j][0:n0]*(epsilon_detdef2_H11[m][1:n0+1] - rho_hat_H11[m]*epsilon_detdef2_H11[m][0:n0]))/np.sqrt(np.sum((epsilon_detdef2_H11[m][1:n0+1] - rho_hat_H11[m]*epsilon_detdef2_H11[m][0:n0]) ** 2))
    #TX_bar_H11 = np.array([np.array([np.sum(Xdef[m][j])/(n0 * np.sqrt(T)) for j in range(0, nb_coint - 1)]) for m in range(M)])
    #ITX_H11 = np.array([np.array([(Xdef[m][j][n0] ** 2)/(2*T) - 1 - Xdef[m][j][n0]*TX_bar_H11[m][j]/(T ** (1/2)) for j in range(0, nb_coint - 1)]) for m in range(M)])
    #JTX_H11 = np.array([np.array([np.sum((Xdef[m][j]/np.sqrt(T)-TX_bar_H11[m]) ** 2)/n0  for j in range(0, nb_coint - 1)]) for m in range(M)])
    #KTX_H11 = JTX_H11 + TX_bar_H11 ** 2
    #Balpha_H11 = np.array([(np.sqrt(veps_hat_H11)*rinf_hat_H11[j]/n0)*((1+ITX_H11[j])/JTX_H11[j]) for j in range(0, nb_coint - 1)])
    #Bc_H11 = np.array([(np.sqrt(T*veps_hat_H11[m])*rinf_hat_H11[m]/n0)*(Xdef[m][0][n0]/np.sqrt(T)-(1+ITX_H11[m])*TX_bar_H11[m]/JTX_H11[m]) for m in range(M)])
    #Valpha_H11 = np.array([np.array([veps_hat_H11[m]*(1-rinf_hat_H11[m][j]**2)/JTX_H11[m][j] for m in range(M)]) for j in range(0, nb_coint - 1)])
    #Vc_H11 = np.array([veps_hat_H11[m] * KTX_H11[m] * (1 - rinf_hat_H11[m] ** 2) / JTX_H11[m] for m in range(M)])
    #studentalpha_H11 = np.array([np.array([n0*(alpha_hat_detdef2_H11[m][j]-alpha_vec[j]-Balpha_H11[j][m])/np.sqrt(Valpha_H11[j][m]) for m in range(M)]) for j in range(0, nb_coint - 1)])
    #studentc_H11 = np.array([n0 * (c0_hat_detdef2_H11 - c0 - Bc_H11) / np.sqrt(Vc_H11*T) for j in range(0, nb_coint - 1)])

    ###essai
    #veps_hat_H11 = np.array([np.sum(epsilon_det_H11[m] ** 2)/T for m in range(M)])
    #rho_hat_H11 = np.array([0 for m in range(M)])  # np.sum(epsilon_detdef2_H11[m][0:n0] * epsilon_detdef2_H11[m][1:n0+1]) /np.sum(epsilon_detdef2_H11[m] ** 2)
    #rinf_hat_H11 = np.array([np.array([0 for j in range(0, nb_coint - 1)]) for m in range(M)])  # np.sum(dXdef[m][j][0:n0]*(epsilon_detdef2_H11[m][1:n0+1] - rho_hat_H11[m]*epsilon_detdef2_H11[m][0:n0]))/np.sqrt(np.sum((epsilon_detdef2_H11[m][1:n0+1] - rho_hat_H11[m]*epsilon_detdef2_H11[m][0:n0]) ** 2))
    #TX_bar_H11 = np.array([np.array([np.sum(X[m][j]) / (n0 * np.sqrt(T)) for j in range(0, nb_coint - 1)]) for m in range(M)])
    #ITX_H11 = np.array([np.array(
    #    [(Xdef[m][j][n0] ** 2) / (2 * T) - 1 - Xdef[m][j][n0] * TX_bar_H11[m][j] / (T ** (1 / 2)) for j in
    #     range(0, nb_coint - 1)]) for m in range(M)])
    #JTX_H11 = np.array([np.array([np.sum((X[m][j] / np.sqrt(T) - TX_bar_H11[m]) ** 2) / n0 for j in range(0, nb_coint - 1)]) for m in range(M)])
    #KTX_H11 = JTX_H11 + TX_bar_H11 ** 2
    #Balpha_H11 = np.array([(np.sqrt(veps_hat_H11) * rinf_hat_H11[j] / n0) * ((1 + ITX_H11[j]) / JTX_H11[j]) for j in
    #                       range(0, nb_coint - 1)])
    #Bc_H11 = np.array([(np.sqrt(T * veps_hat_H11[m]) * rinf_hat_H11[m] / n0) * (
    #Xdef[m][0][n0] / np.sqrt(T) - (1 + ITX_H11[m]) * TX_bar_H11[m] / JTX_H11[m]) for m in range(M)])
    #Valpha_H11 = np.array(
    #    [np.array([veps_hat_H11[m] * (1 - rinf_hat_H11[m][j] ** 2) / JTX_H11[m][j] for m in range(M)]) for j in
    #     range(0, nb_coint - 1)])
    #Vc_H11 = np.array([veps_hat_H11[m] * KTX_H11[m] * (1 - rinf_hat_H11[m] ** 2) / JTX_H11[m] for m in range(M)])
    #studentalpha_H11 = np.array([np.array(
    #    [n0 * (alpha_hat_det_H11[m][j] - alpha_vec[j] - Balpha_H11[j][m]) / np.sqrt(Valpha_H11[j][m]) for m in
    #     range(M)]) for j in range(0, nb_coint - 1)])
    #studentc_H11 = np.array(
    #    [n0 * (c0_hat_detdef2_H11 - c0 - Bc_H11) / np.sqrt(Vc_H11 * T) for j in range(0, nb_coint - 1)])
    #
    #veps_hat_H12 = np.array([np.sum(epsilon_detdef2_H12[m] ** 2) / T for m in range(M)])
    #rho_hat_H12 = np.array([np.sum(epsilon_detdef2_H12[m][0:n0] * epsilon_detdef2_H12[m][1:n0 + 1]) / np.sum(epsilon_detdef2_H12[m] ** 2) for m in range(M)])

    ### Tests

    #Var_HF_H0 = n/3*(depsilon_H0**4).sum(axis=1)
    #Var_HF_H1 = n/3*(depsilon_H1**4).sum(axis=1)

    #test_HF_H0 = n*(depsilon_H0[:,:-1]*depsilon_H0[:,1:]).sum(axis=1)**2/Var_HF_H0
    #test_HF_H1 = n*(depsilon_H1[:,:-1]*depsilon_H1[:,1:]).sum(axis=1)**2/Var_HF_H1

    #reject_HF_H0 = test_HF_H0 > chi2.ppf(0.95,df=1)
    #reject_HF_H1 = test_HF_H1 > chi2.ppf(0.95,df=1)

    #dU_H0 =epsilon_H0[:,:-1]*depsilon_H0# Z[:,:-1]*np.diff(Z) # epsilon_H0[:,:-1]*depsilon_H0
    #dU_H1 = epsilon_H1[:,:-1] * depsilon_H1

    #bernoulli_weight = np.random.binomial(n=1,p=0.5,size=dU_H0.shape)
    #bernoulli_weight[bernoulli_weight == 0] = -1

    #test_HF2_H0 = np.array([toBrownian(dU_H0[i,:],int(np.sqrt(n/sample_step)),T) for i in range(M)])**2
    #test_HF2_H1 = np.array([toBrownian(dU_H1[i,:], int(np.sqrt(n/sample_step)), T) for i in range(M)])**2

    #reject_HF2_H0 = test_HF2_H0 > chi2.ppf(0.95,df=1)
    #reject_HF2_H1 = test_HF2_H1 > chi2.ppf(0.95,df=1)

    #k_random = int(np.sqrt(n/sample_step))
    #random_depsilonH0 = randomize(depsilon_H0,k_random)
    #random_depsilonH1 = randomize(depsilon_H1, k_random)
    #random_epsilonH0 = np.zeros((random_depsilonH0.shape[0],random_depsilonH0.shape[1]+1))
    #random_epsilonH0[:,1:]= random_depsilonH0.cumsum(axis=1)
    #random_epsilonH1 = np.zeros((random_depsilonH1.shape[0],random_depsilonH1.shape[1]+1))
    #random_epsilonH1[:,1:]= random_depsilonH1.cumsum(axis=1)

    #dV_H0 = random_epsilonH0[:,:-1]*random_depsilonH0
    #dV_H1 = random_epsilonH1[:,:-1] * random_depsilonH1

    #dZ_bar_H0 = np.array([toBrownianProcess(depsilon_H0[i,:],int(np.sqrt(n/sample_step)),T) for i in range(M)])
    #dZ_bar_H1= np.array([toBrownianProcess(depsilon_H1[i,:],int(np.sqrt(n/sample_step)),T) for i in range(M)])

    #dZ_bar_H0 = np.array([truncate(dZ_bar_H0[i,:], T/(dZ_bar_H0.shape[1]), 4*localRV(dZ_bar_H0[i,:],0,-1,T)) for i in range(M) ])
    #dZ_bar_H1 = np.array([truncate(dZ_bar_H1[i, :], T / (dZ_bar_H1.shape[1]), 4 * localRV(dZ_bar_H1[i, :], 0, -1, T)) for i in range(M)])

    #DFHF3_H0 = np.array([adfuller(dZ_bar_H0[m,:].cumsum(), maxlag=1, store=True, regression='nc') for m in range(M)])
    #DFHF3_H1 = np.array([adfuller(dZ_bar_H1[m,:].cumsum(), maxlag=1, store=True, regression='nc') for m in range(M)])

    #test_HF3_H0 = np.array([DFHF3_H0[m][0] for m in range(M)])
    #test_HF3_H1 = np.array([DFHF3_H1[m][0] for m in range(M)])

    #p_val_DFHF3_H0 = np.array([DFHF3_H0[m][1] for m in range(M)])
    #p_val_DFHF3_H1 = np.array([DFHF3_H1[m][1] for m in range(M)])

    #reject_HF3_H0 = test_HF3_H0 < -2.76
    #reject_HF3_H1 = test_HF3_H1 < -2.76

    ## essai
    #DFessai = np.array([adfuller(Z[m,:], maxlag=1, store=True, regression='nc') for m in range(M)])
    #test_essai = np.array([DFessai[m][0] for m in range(M)])
    #np.sum(test_essai < -1.94)

    #dZ_baressai =  np.array([toBrownianProcess(dZ[i,:],int(np.sqrt(n/sample_step)),T) for i in range(M)])
    #DFessai2 = np.array([adfuller(dZ_baressai[m, :].cumsum(), maxlag=1, store=True, regression='nc') for m in range(M)])
    #test_essai2 = np.array([DFessai2[m][0] for m in range(M)])
    #np.sum(test_essai2 < -1.94)


    #test_DW_H0 = (depsilon_H0**2).sum(axis=1)/(epsilon_H0**2).sum(axis=1)
    #test_DW_H1 = (depsilon_H1**2).sum(axis=1)/(epsilon_H1**2).sum(axis=1)

    #reject_DW_H0 = test_DW_H0 > 0.386
    #reject_DW_H1 = test_DW_H1 > 0.386

    #DF_model_ols_H0 = [ols('du ~ u', DataFrame(dict(u=epsilon_H0[m,:-1], du=depsilon_H0[m,:]))).fit() for m in range(M)]
    #DF_model_ols_H1 = [ols('du ~ u', DataFrame(dict(u=epsilon_H1[m,:-1], du=depsilon_H1[m,:]))).fit() for m in range(M)]

    #DF_H0 =np.array([adfuller(epsilon_H0[m,:], maxlag=1, store=True, regression='nc') for m in range(M)])
    #DF_H1 = np.array([adfuller(epsilon_H1[m,:], maxlag=1, store=True,regression='nc') for m in range(M)])
    #test_DF_H0 = np.array([DF_H0[m][0] for m in range(M)])#np.array([DF_model_ols_H0[m].tvalues[1] for m in range(M)])
    #test_DF_H1 = np.array([DF_H1[m][0] for m in range(M)])#np.array([DF_model_ols_H1[m].tvalues[1] for m in range(M)])
    #reject_DF_H0 = test_DF_H0 < -2.76 #= p_val_DF_H0 < 0.05
    #reject_DF_H1 = test_DF_H1 < -2.76 #= p_val_DF_H1 < 0.05

    ### test with deflating X and Y prior to alpha estimation and DF
    #DF_def_H0 = np.array([adfuller(epsilon_def_H0[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    #DF_def_H1 = np.array([adfuller(epsilon_def_H1[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    #test_DF_def_H0 = np.array([DF_def_H0[m][0] for m in range(M)])
    #test_DF_def_H1 = np.array([DF_def_H1[m][0] for m in range(M)])
    #reject_DF_def_H0 = test_DF_def_H0 < -2.76  # = p_val_DF_H0 < 0.05
    #reject_DF_def_H1 = test_DF_def_H1 < -2.76  # = p_val_DF_H1 < 0.05


    ### test with second method of deflating X and Y prior to alpha estimation and DF
    #DF_def2_H0 = np.array([adfuller(epsilon_def2_H0[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    #DF_def2_H1 = np.array([adfuller(epsilon_def2_H1[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    #test_DF_def2_H0 = np.array([DF_def2_H0[m][0] for m in range(M)])
    #test_DF_def2_H1 = np.array([DF_def2_H1[m][0] for m in range(M)])

    #reject_DF_def2_H0 = test_DF_def2_H0 < -2.76  # = p_val_DF_H0 < 0.05
    #reject_DF_def2_H1 = test_DF_def2_H1 < -2.76  # = p_val_DF_H1 < 0.05

    ### DF test with demeaned data
    DF_det_H0 = np.array([adfuller(epsilon_det_H0[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    DF_det_H11 = np.array([adfuller(epsilon_det_H11[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    DF_det_H12 = np.array([adfuller(epsilon_det_H12[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    test_DF_det_H0 = np.array([DF_det_H0[m][0] for m in range(M)])  # np.array([DF_model_ols_H0[m].tvalues[1] for m in range(M)])
    test_DF_det_H11 = np.array([DF_det_H11[m][0] for m in range(M)])  # np.array([DF_model_ols_H1[m].tvalues[1] for m in range(M)])
    test_DF_det_H12 = np.array([DF_det_H12[m][0] for m in range(M)])
    reject_DF_det_H0 = test_DF_det_H0 < -3.37  # = p_val_DF_H0 < 0.05
    reject_DF_det_H11 = test_DF_det_H11 < -3.37  # = p_val_DF_H1 < 0.05
    reject_DF_det_H12 = test_DF_det_H12 < -3.37

    ### DF test with deflating and demeaned data
    #DF_detdef_H0 = np.array([adfuller(epsilon_detdef_H0[m, :], maxlag=1, store=True, regression='c') for m in range(M)])
    #DF_detdef_H1 = np.array([adfuller(epsilon_detdef_H1[m, :], maxlag=1, store=True, regression='c') for m in range(M)])
    #test_DF_detdef_H0 = np.array([DF_detdef_H0[m][0] for m in range(M)])
    #test_DF_detdef_H1 = np.array([DF_detdef_H1[m][0] for m in range(M)])

    #reject_DF_detdef_H0 = test_DF_detdef_H0 < -3.36#-3.80  # = p_val_DF_H0 < 0.05
    #reject_DF_detdef_H1 = test_DF_detdef_H1 < -3.36#-3.80  # = p_val_DF_H1 < 0.05

    ### DF test with deflating and demeaned data II
    DF_detdef2_H0 = np.array([adfuller(epsilon_detdef2_H0[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    DF_detdef2_H11 = np.array([adfuller(epsilon_detdef2_H11[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    DF_detdef2_H12 = np.array([adfuller(epsilon_detdef2_H12[m, :], maxlag=1, store=True, regression='nc') for m in range(M)])
    test_DF_detdef2_H0 = np.array([DF_detdef2_H0[m][0] for m in range(M)])
    test_DF_detdef2_H11 = np.array([DF_detdef2_H11[m][0] for m in range(M)])
    test_DF_detdef2_H12 = np.array([DF_detdef2_H12[m][0] for m in range(M)])
    reject_DF_detdef2_H0 = test_DF_detdef2_H0 < -3.37#-3.80  # = p_val_DF_H0 < 0.05
    reject_DF_detdef2_H11 = test_DF_detdef2_H11 < -3.37#-3.80  # = p_val_DF_H1 < 0.05
    reject_DF_detdef2_H12 = test_DF_detdef2_H12 < -3.37

    ### ADF
    #adf_p = 4
    #ADF_H0 =np.array([adfuller(epsilon_H0[m,:], maxlag=adf_p, store=True, regression='nc') for m in range(M)])
    #ADF_H1 = np.array([adfuller(epsilon_H1[m,:], maxlag=adf_p, store=True,regression='nc') for m in range(M)])
    #test_ADF_H0 = np.array([ADF_H0[m][0] for m in range(M)])#np.array([DF_model_ols_H0[m].tvalues[1] for m in range(M)])
    #test_ADF_H1 = np.array([ADF_H1[m][0] for m in range(M)])#np.array([DF_model_ols_H1[m].tvalues[1] for m in range(M)])
    #reject_ADF_H0 = test_ADF_H0 < -2.76
    #reject_ADF_H1 = test_ADF_H1 < -2.76

    ### ADF test with demeaned data
    adf_p = 4
    ADF_det_H0 = np.array([adfuller(epsilon_det_H0[m, :], maxlag=adf_p, store=True, regression='nc') for m in range(M)])
    ADF_det_H11 = np.array([adfuller(epsilon_det_H11[m, :], maxlag=adf_p, store=True, regression='nc') for m in range(M)])
    ADF_det_H12 = np.array([adfuller(epsilon_det_H12[m, :], maxlag=adf_p, store=True, regression='nc') for m in range(M)])
    test_ADF_det_H0 = np.array([ADF_det_H0[m][0] for m in range(M)])
    test_ADF_det_H11 = np.array([ADF_det_H11[m][0] for m in range(M)])
    test_ADF_det_H12 = np.array([ADF_det_H12[m][0] for m in range(M)])
    reject_ADF_det_H0 = test_ADF_det_H0 < -3.37
    reject_ADF_det_H11 = test_ADF_det_H11 < -3.37
    reject_ADF_det_H12 = test_ADF_det_H12 < -3.37


    ## PPtau test
    #PP_tau_H0 = [PhillipsPerron(epsilon_H0[m,:], test_type= 'tau', trend='nc') for m in range(M)] # Z_t from Phillips and Ouliaris
    #PP_tau_H1 = [PhillipsPerron(epsilon_H1[m,:], test_type= 'tau', trend='nc') for m in range(M)]
    #test_PP_tau_H0 = np.array([PP_tau_H0[m].stat for m in range(M)])
    #test_PP_tau_H1 = np.array([PP_tau_H1[m].stat for m in range(M)])
    #reject_PP_tau_H0 = test_PP_tau_H0 < -2.76
    #reject_PP_tau_H1 = test_PP_tau_H1 < -2.76

    ## PPtau test with demeaned data
    PP_tau_det_H0 = [PhillipsPerron(epsilon_det_H0[m, :], test_type='tau', trend='nc') for m in range(M)]  # Z_t from Phillips and Ouliaris
    PP_tau_det_H11 = [PhillipsPerron(epsilon_det_H11[m, :], test_type='tau', trend='nc') for m in range(M)]
    PP_tau_det_H12 = [PhillipsPerron(epsilon_det_H12[m, :], test_type='tau', trend='nc') for m in range(M)]
    test_PP_tau_det_H0 = np.array([PP_tau_det_H0[m].stat for m in range(M)])
    test_PP_tau_det_H11 = np.array([PP_tau_det_H11[m].stat for m in range(M)])
    test_PP_tau_det_H12 = np.array([PP_tau_det_H12[m].stat for m in range(M)])
    reject_PP_tau_det_H0 = test_PP_tau_det_H0 < -3.37
    reject_PP_tau_det_H11 = test_PP_tau_det_H11 < -3.37
    reject_PP_tau_det_H12 = test_PP_tau_det_H12 < -3.37

    ## PPalpha test
    #PP_alpha_H0 = [PhillipsPerron(epsilon_H0[m,:], test_type= 'rho', trend='c') for m in range(M)] # Z_alpha from Phillips and Ouliaris
    #PP_alpha_H1 = [PhillipsPerron(epsilon_H1[m,:], test_type= 'rho', trend='c') for m in range(M)]
    #test_PP_alpha_H0 = np.array([PP_alpha_H0[m].stat for m in range(M)])
    #test_PP_alpha_H1 = np.array([PP_alpha_H1[m].stat for m in range(M)])
    #reject_PP_alpha_H0 = test_PP_alpha_H0 < -20.49
    #reject_PP_alpha_H1 = test_PP_alpha_H1 < -20.49

    ## PPalpha test with demeaned data
    PP_alpha_det_H0 = [PhillipsPerron(epsilon_det_H0[m, :], test_type='rho') for m in range(M)]
    PP_alpha_det_H11 = [PhillipsPerron(epsilon_det_H11[m, :], test_type='rho') for m in range(M)]
    PP_alpha_det_H12 = [PhillipsPerron(epsilon_det_H12[m, :], test_type='rho') for m in range(M)]
    test_PP_alpha_det_H0 = np.array([PP_alpha_det_H0[m].stat for m in range(M)])
    test_PP_alpha_det_H11 = np.array([PP_alpha_det_H11[m].stat for m in range(M)])
    test_PP_alpha_det_H12 = np.array([PP_alpha_det_H12[m].stat for m in range(M)])
    reject_PP_alpha_det_H0 = test_PP_alpha_det_H0 < -20.49
    reject_PP_alpha_det_H11 = test_PP_alpha_det_H11 < -20.49
    reject_PP_alpha_det_H12 = test_PP_alpha_det_H12 < -20.49

    ###summary of the tests
    #rejectDictH0['HF'].append(sum(reject_HF_H0)/M)
    #rejectDictH0['HF2'].append(sum(reject_HF2_H0) / M)
    #rejectDictH0['DFhybrid'].append(sum(reject_HF3_H0) / M)
    #reject_rate_DW_H0 = sum(reject_DW_H0)/M
    #rejectDictH0['DF'].append(sum(reject_DF_H0)/M)
    rejectDictH0['DFdem'].append(sum(reject_DF_det_H0) / M)
    #rejectDictH0['DFloc'].append(sum(reject_DF_def_H0) / M)
    #rejectDictH0['DFdemloc'].append(sum(reject_DF_detdef_H0) / M)
    rejectDictH0['DFdemloc2'].append(sum(reject_DF_detdef2_H0) / M)
    #rejectDictH0['DFfull'].append(sum(reject_DF_def2_H0) / M)
    #rejectDictH0['ADF'].append(sum(reject_ADF_H0)/M)
    rejectDictH0['ADFdem'].append(sum(reject_ADF_det_H0) / M)
    #rejectDictH0['PP_tau'].append(sum(reject_PP_tau_H0)/M)
    rejectDictH0['PP_taudem'].append(sum(reject_PP_tau_det_H0) / M)
    #rejectDictH0['PP_alpha'].append(sum(reject_PP_alpha_H0)/M)
    rejectDictH0['PP_alphadem'].append(sum(reject_PP_alpha_det_H0) / M)

    #powerDictH1['HF'].append(sum(reject_HF_H1)/M)
    #powerDictH1['HF2'].append(sum(reject_HF2_H1) / M)
    #powerDictH1['DFhybrid'].append(sum(reject_HF3_H1) / M)
    #power_DW_H1 = sum(reject_DW_H1)/M
    #powerDictH1['DF'].append(sum(reject_DF_H1)/M)
    powerDictH11['DFdem'].append(sum(reject_DF_det_H11) / M)
    #powerDictH1['DFloc'].append(sum(reject_DF_def_H1) / M)
    #powerDictH1['DFdemloc'].append(sum(reject_DF_detdef_H1) / M)
    powerDictH11['DFdemloc2'].append(sum(reject_DF_detdef2_H11) / M)
    #powerDictH1['DFfull'].append(sum(reject_DF_def2_H1) / M)
    #powerDictH1['ADF'].append(sum(reject_ADF_H1)/M)
    powerDictH11['ADFdem'].append(sum(reject_ADF_det_H11) / M)
    #powerDictH1['PP_tau'].append(sum(reject_PP_tau_H1)/M)
    powerDictH11['PP_taudem'].append(sum(reject_PP_tau_det_H11) / M)
    #powerDictH1['PP_alpha'].append(sum(reject_PP_alpha_H1)/M)
    powerDictH11['PP_alphadem'].append(sum(reject_PP_alpha_det_H11) / M)

    powerDictH12['DFdem'].append(sum(reject_DF_det_H12) / M)
    powerDictH12['DFdemloc2'].append(sum(reject_DF_detdef2_H12) / M)
    powerDictH12['ADFdem'].append(sum(reject_ADF_det_H12) / M)
    powerDictH12['PP_taudem'].append(sum(reject_PP_tau_det_H12) / M)
    powerDictH12['PP_alphadem'].append(sum(reject_PP_alpha_det_H12) / M)

    #c0H11['DFdem'].append(sum(c0_hat_det_H11) / M)
    #c0H11['DFdemloc2'].append(sum(c0_hat_detdef2_H11) / M)
    #c0H11['ADFdem'].append(sum(c0_hat_det_H11) / M)
    #c0H11['PP_taudem'].append(sum(c0_hat_det_H11) / M)
    #c0H11['PP_alphadem'].append(sum(c0_hat_det_H11) / M)

    #c0H12['DFdem'].append(sum(c0_hat_det_H12) / M)
    #c0H12['DFdemloc2'].append(sum(c0_hat_detdef2_H12) / M)
    #c0H12['ADFdem'].append(sum(c0_hat_det_H12) / M)
    #c0H12['PP_taudem'].append(sum(c0_hat_det_H12) / M)
    #c0H12['PP_alphadem'].append(sum(c0_hat_det_H12) / M)

    #c0H11['DFdem'].append(np.std(c0_hat_det_H11))
    #c0H11['DFdemloc2'].append(np.std(c0_hat_detdef2_H11))
    #c0H11['ADFdem'].append(np.std(c0_hat_det_H11))
    #c0H11['PP_taudem'].append(np.std(c0_hat_det_H11))
    #c0H11['PP_alphadem'].append(np.std(c0_hat_det_H11))

    #c0H12['DFdem'].append(np.std(c0_hat_det_H12))
    #c0H12['DFdemloc2'].append(np.std(c0_hat_detdef2_H12))
    #c0H12['ADFdem'].append(np.std(c0_hat_det_H12))
    #c0H12['PP_taudem'].append(np.std(c0_hat_det_H12))
    #c0H12['PP_alphadem'].append(np.std(c0_hat_det_H12))

    #alphaH11['DFdem'].append(sum(alpha_hat_det_H11) / M)
    #alphaH11['DFdemloc2'].append(sum(alpha_hat_detdef2_H11) / M)
    #alphaH11['ADFdem'].append(sum(alpha_hat_det_H11) / M)
    #alphaH11['PP_taudem'].append(sum(alpha_hat_det_H11) / M)
    #alphaH11['PP_alphadem'].append(sum(alpha_hat_det_H11) / M)

    #alphaH12['DFdem'].append(sum(alpha_hat_det_H12) / M)
    #alphaH12['DFdemloc2'].append(sum(alpha_hat_detdef2_H12) / M)
    #alphaH12['ADFdem'].append(sum(alpha_hat_det_H12) / M)
    #alphaH12['PP_taudem'].append(sum(alpha_hat_det_H12) / M)
    #alphaH12['PP_alphadem'].append(sum(alpha_hat_det_H12) / M)

    #alphaH11['DFdem'].append(np.std(alpha_hat_det_H11))
    #alphaH11['DFdemloc2'].append(np.std(alpha_hat_detdef2_H11))
    #alphaH11['ADFdem'].append(np.std(alpha_hat_det_H11))
    #alphaH11['PP_taudem'].append(np.std(alpha_hat_det_H11))
    #alphaH11['PP_alphadem'].append(np.std(alpha_hat_det_H11))

    #alphaH12['DFdem'].append(np.std(alpha_hat_det_H12))
    #alphaH12['DFdemloc2'].append(np.std(alpha_hat_detdef2_H12))
    #alphaH12['ADFdem'].append(np.std(alpha_hat_det_H12))
    #alphaH12['PP_taudem'].append(np.std(alpha_hat_det_H12))
    #alphaH12['PP_alphadem'].append(np.std(alpha_hat_det_H12))

    rhoH0['DFdem'].append(sum(rho_hat_det_H0) / M)
    rhoH0['DFdemloc2'].append(sum(rho_hat_detdef2_H0) / M)
    rhoH0['ADFdem'].append(sum(rho_hat_det_H0) / M)
    rhoH0['PP_taudem'].append(sum(rho_hat_det_H0) / M)
    rhoH0['PP_alphadem'].append(sum(rho_hat_det_H0) / M)

    rhoH11['DFdem'].append(sum(rho_hat_det_H11) / M)
    rhoH11['DFdemloc2'].append(sum(rho_hat_detdef2_H11) / M)
    rhoH11['ADFdem'].append(sum(rho_hat_det_H11) / M)
    rhoH11['PP_taudem'].append(sum(rho_hat_det_H11) / M)
    rhoH11['PP_alphadem'].append(sum(rho_hat_det_H11) / M)

    rhoH12['DFdem'].append(sum(rho_hat_det_H12) / M)
    rhoH12['DFdemloc2'].append(sum(rho_hat_detdef2_H12) / M)
    rhoH12['ADFdem'].append(sum(rho_hat_det_H12) / M)
    rhoH12['PP_taudem'].append(sum(rho_hat_det_H12) / M)
    rhoH12['PP_alphadem'].append(sum(rho_hat_det_H12) / M)

    nList.append(int(n/sample_step))

out = DataFrame({'n':nList,
                 'model':modelList})

for key in rejectDictH0:
    out['rejectH0'+key] = rejectDictH0[key]
    out['powerrho1'+key]= powerDictH11[key]
    out['powerrho2' + key] = powerDictH12[key]
    #out['c0_1' + key] = c0H11[key]
    #out['c0_2' + key] = c0H12[key]
    #out['alpha_1' + key] = alphaH11[key]
    #out['alpha_2' + key] = alphaH12[key]
    out['rhoH0' + key] = rhoH0[key]
    out['rhoH11' + key] = rhoH11[key]
    out['rhoH12' + key] = rhoH12[key]

print(out)

#########save

out_path = path('/Users/Simon/Pole Keio FE Dropbox/Simon Clinet/Boulot/Recherche/cointegrationHF')

if os.path.exists(out_path /'out.csv'):
    with open(out_path /'out.csv', 'a') as f:
        out.to_csv(f, header=False)
else:
    out.to_csv(out_path /'out.csv')


#for r in reject_rate:
#    print(str(r)+'\n')

#for r in power:
#    print(str(r)+'\n')

#####Analysis
data = pd.read_csv(out_path /'out.csv')
#print(data[data.columns[1:]].to_latex())


#plot(X[0,0,:])
#plot(Y0[0,:])
#plot(Y1[0,:])

#test = Series([toBrownian(np.diff(Z[i,:])*Z[i,:-1],50,T) for i in range(M)])
#test2 = Series([toBrownian(np.diff(X[i,0,:])*X[i,0,:-1],50,T) for i in range(M)])

#qlist = [0.01,0.02,0.05,0.1,0.2,0.5,0.8,0.9,0.95,0.98,0.99]
#qqtest = Series([norm.cdf(test.quantile(q)) for q in qlist])
#qqtest2 = Series([norm.cdf(test2.quantile(q)) for q in qlist])
#qqtest3 = Series([norm.cdf(Series(test_HF2_H0).quantile(q)) for q in qlist])


#reject_test = (test**2) >  chi2.ppf(0.95,df=1)

### plots
plt.plot(X[0][0]/sigma)
plt.plot(Xdef[0][0])
plt.plot(Xdef2[0][0])
plt.show()
plt.plot(Y0[0])
plt.plot(Y0def[0])
plt.plot(Y0def2[0])
plt.show()
plt.plot(presim[0].V[1])
plt.show()
plt.plot(X[1][0])
plt.plot(Z[1])
plt.show()
plt.plot(X[0][0])
plt.plot(Xntnj[0][0])
plt.plot(brown)
plt.show()


### project on error in observation times
obs = np.cumsum(np.random.normal(loc=0,scale=1,size=1000))
RV = np.sum((obs[1:]-obs[0:999]) ** 2)
times = range(0,1000) + np.random.normal(loc=0,scale=1,size=1000)
sort = np.argsort(times)
obs2 = obs[sort]
RV2 = np.sum((obs2[1:]-obs2[0:999]) ** 2)

plt.plot(obs[300:350])
plt.plot(obs2[300:350])
#plt.plot(np.abs((obs-obs2)/obs))
plt.show()

#out["rhoH0DFdemloc2"][0] -= .08
plt.plot(out["rhoH0DFdemloc2"])
plt.plot(out["rhoH0PP_alphadem"])
plt.show()


plt.plot(out["rhoH11DFdemloc2"])
plt.plot(out["rhoH11PP_alphadem"])
plt.plot([0.8,0.8,0.8,0.8,0.8,0.8])
plt.show()


plt.plot(out["rhoH12DFdemloc2"])
plt.plot(out["rhoH12PP_alphadem"])
plt.plot([0.9,0.9,0.9,0.9,0.9,0.9])
plt.show()