import numpy as np
from pandas import DataFrame, Series
import pandas as pd
from path import path
import matplotlib.pyplot as plt
import matplotlib.patches as patches
#from ivol.estim import *

rho_bool = True
QMLE_bool = True
RK_bool = True

default_path = Path('/users/Simon/desktop/boulot/these/Volatility local MLE (article 3)/Local MLE vol code/Empirical Data/')

def get_path(ticker):
    answ = default_path/"clinet.simon@gmail.com_"
    answ+=ticker
    answ+="_tradesQuotes_20150102_20160101.csv"
    return answ

path_dict = {"GE.N" : default_path/"clinet.simon@gmail.com_GE.N_tradesQuotes_20140303_20150302.csv",
             "AA.N" :  default_path/"clinet.simon@gmail.com_AA.N_tradesQuotes_20140303_20150302.csv",
             "KO.N" : default_path/"clinet.simon@gmail.com_KO.N_tradesQuotes_20140303_20150302.csv",
             "FTE.PA":  default_path/"clinet.simon@gmail.com_FTE.PA_tradesQuotes_20140303_20150302.csv",
             "AAPL.OQ":  default_path/"clinet.simon@gmail.com_AAPL.OQ_tradesQuotes_20150102_20160101.csv",
             "MSFT.OQ": default_path/"clinet.simon@gmail.com_MSFT.OQ_tradesQuotes_20150102_20160101.csv",
             "AMZN.OQ" :default_path/"clinet.simon@gmail.com_AMZN.OQ_tradesQuotes_20150102_20160101.csv",
             "NVDA.OQ" : default_path/"clinet.simon@gmail.com_NVDA.OQ_tradesQuotes_20150101_20160102.csv"}

ticker = "AAPL.OQ"

current_path = get_path(ticker)#path_dict[stock_name]

data = pd.read_csv(current_path)
del data["lastS"]
del data["lastQ"]
col_names = {"date_xl":"date", "ts":"ts", "last":"p"}
data = data.rename(columns = col_names)
data = data[data["ts"] != "ts"]

for col in data.columns:
    data[col]=pd.to_numeric(data[col])

one_day = 24*60*60
data["time"] = data["date"]*one_day+data["ts"]

###Cleaning procedure

#P1 :
ts_start = 34200.0
ts_end = 57600.0

data = data[data["ts"] >= ts_start ] #after 9:30 am and before 4 pm
data = data[data["ts"] <= ts_end ]

#P2:
data=data[data["p"] != 0.0]

#P3: NA

#Q1 :
data = data.groupby("time").mean() #Removes multiple entries

#Q2 - : NA

####remove various bad days
data["date"] -= data["date"][data.index[0]] +2
data = data[data["date"] != 356.0] #christmas day

if ticker == "YHOO.OQcaca":
    data = data[data["date"] != 171.0] #bad day for YHOO.OQ (negative quarticity)

if ticker == "INTC.OQ":
    data = data[data["date"] != 329.0]
    #data = data[data["date"] != 362.0]
    #pass

date = np.unique(data["date"])


nb_days = date.size


daily_trades = np.array([len(data[data["date"] == key]) for key in date])
len_tab = np.array([len(data[data["date"] == key]) for key in date])
len_mean = np.mean([len(data[data["date"] == key]) for key in date])

delta_secondes  = (ts_end-ts_start)/(daily_trades-1)

data["p"] = np.log(data["p"])

###saving the refined data
#out_path = path('/users/Simon/desktop/')
#data.to_csv(out_path+"appleTrades2015.csv")

#####Estimating rho and the ratio of AVAR(B block)/AVAR(1 block)
T = 1/252
d = 1

kernel_type = "th2" #for the RK

block_list = [2,4,6,8]

rho_est = {}
rho_est_local = {}
noise_est = {}

Rho_Local = localize(Rho_estimator)

k = {date[j]:max(30/delta_secondes[j],2) for j in range(nb_days)}

if rho_bool :
    for date_idx in date:#date:

        rho_est[date_idx] = Rho_direct(0,-1,{"Y" : data["p"][data["date"] == date_idx], "T":T, "d": d}) #data["p"][data["date"] == date_idx] "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:], data["p"][data["date"] == date_idx] "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:]
        rho_est[date_idx].setParam(Vol_PA, Quart_PA, (k[date_idx]*np.sqrt(rho_est[date_idx].delta)*np.ones(1),),("triang_ker","manual",None,None), (k[date_idx]*np.sqrt(rho_est[date_idx].delta)*np.ones(1),), ("triang_ker", "manual"))
        rho_est[date_idx].estim()

        noise_est[date_idx] = Noise_Realized(0,-1,{"Y" : data["p"][data["date"] == date_idx], "T":T, "d": d})
        noise_est[date_idx].estim()

        for b in block_list:
            rho_est_local[(date_idx,b)] = Rho_Local(0,-1,{"Y":  data["p"][data["date"] == date_idx], "T":T, "d": d, "estClass" : Rho_direct, "b":b}) # "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:],"noiseVar" : presim.noiseArgs[0],
            rho_est_local[(date_idx,b)].setParam(Vol_PA,Quart_PA,(k[date_idx]*np.sqrt(rho_est_local[(date_idx,b)].delta)*np.ones(1),),("triang_ker","manual",None,None),(k[date_idx]*np.sqrt(rho_est_local[(date_idx,b)].delta)*np.ones(1),),("triang_ker","manual"))
            rho_est_local[(date_idx,b)].estim()

    rho_values = np.array([rho_est[key][0] for key in date])

    rho_local_values ={}
    for b in block_list :
        rho_local_values[b] = np.array([[sub[0] for sub in rho_est_local[(key,b)].sub_estimator] for key in date])

    summary = {}
    for b in block_list:
        summary[b] = np.zeros((nb_days,1+b))
        summary[b][:,0] = rho_values

        for i in range(nb_days):
            summary[b][i,1:] = rho_local_values[b][i]


    ratio_QMLE = {}
    avar_QMLE = np.array([rho_est[key].avar_qmle() for key in date])

    for b in block_list :
        ratio_QMLE[b] = np.array([np.sqrt(b)*np.sum([sub.avar_qmle() for sub in rho_est_local[(key,b)].sub_estimator]) for key in date])/avar_QMLE[:,0]

    ratio_QMLE_mean = [ratio_QMLE[b].mean() for b in block_list]

    ratio_RK = {}
    avar_RK = np.array([rho_est[key].avar_rk(kernel_type) for key in date])

    for b in block_list:
        ratio_RK[b] = np.array(
            [np.sqrt(b) * np.sum([sub.avar_rk(kernel_type) for sub in rho_est_local[(key, b)].sub_estimator]) for key in
             date]) / avar_RK[:, 0]

    ratio_RK_mean = [ratio_RK[b].mean() for b in block_list]

    rho_values_oracle = np.array([rho_est[key].rho[0] for key in date])

    rho_local_values_oracle ={}
    for b in block_list :
        rho_local_values_oracle[b] = np.array([[sub.rho[0] for sub in rho_est_local[(key,b)].sub_estimator] for key in date])


    summary_oracle = {}
    for b in block_list:
        summary_oracle[b] = np.zeros((nb_days,1+b))
        summary_oracle[b][:,0] = rho_values_oracle

        for i in range(date.size):
            summary_oracle[b][i,1:] = rho_local_values_oracle[b][i]

k_reco = np.array([np.sqrt(noise_est[key][0]/(Psi(None, None, "triang_ker")*rho_est[key].IVest[0]))/np.sqrt(rho_est[key].delta) for key in date])

if QMLE_bool :
    QMLE_est = {}
    QMLE_est_local = {}
    Vol_Local = localize(Vol_estimator)

    for date_idx in date:#date:
        # presim.Y[date_idx,:] ,"IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:],
        QMLE_est[date_idx] = Vol_QMLE(0,-1,{"Y" : data["p"][data["date"] == date_idx],  "T":T, "d": d}) #data["p"][data["date"] == date_idx] "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:], data["p"][data["date"] == date_idx] "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:]
        QMLE_est[date_idx].estim()

        for b in block_list:
            QMLE_est_local[(date_idx,b)] = Vol_Local(0,-1,{"Y" : data["p"][data["date"] == date_idx], "T":T, "d": d, "estClass" : Vol_QMLE, "b":b}) # "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:],"noiseVar" : presim.noiseArgs[0],
            QMLE_est_local[(date_idx,b)].estim()

    QMLE_values = np.array([QMLE_est[key][0] for key in date])

    QMLE_local_values = {}
    for b in block_list:
        QMLE_local_values[b] = np.array([[sub[0] for sub in QMLE_est_local[(key, b)].sub_estimator] for key in date])

    summary_QMLE = {}
    for b in block_list:
        summary_QMLE[b] = np.zeros((nb_days, 1+b))
        summary_QMLE[b][:, 0] = QMLE_values

        for i in range(nb_days):
            summary_QMLE[b][i, 1:] = QMLE_local_values[b][i]

    various_QMLE = np.zeros((nb_days, 1+len(block_list)))
    various_QMLE[:,0] = QMLE_values
    various_QMLE[:,1:] = np.array([[QMLE_est_local[(key,b)][0] for b in block_list] for key in date])

if RK_bool :

    RK_est = {}
    RK_est_local = {}
    Vol_Local = localize(Vol_estimator)

    for date_idx in date:#date:

        RK_est[date_idx] = Vol_RK(0,-1,{"Y" : data["p"][data["date"] == date_idx],  "T":T, "d": d}) #data["p"][data["date"] == date_idx] "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:], data["p"][data["date"] == date_idx] "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:]
        RK_est[date_idx].setParam(kernel_type, "adaptive", Quart_PA, Vol_PA, Noise_Realized)
        RK_est[date_idx].estim()

        for b in block_list:
            RK_est_local[(date_idx,b)] = Vol_Local(0,-1,{"Y" : data["p"][data["date"] == date_idx],  "T":T, "d": d, "estClass" : Vol_RK, "b":b}) # "IV" : presim.IV[date_idx,:], "Q" : presim.Q[date_idx,:], "R" : presim.R[date_idx,:],"noiseVar" : presim.noiseArgs[0],
            RK_est_local[(date_idx,b)].setParam(kernel_type, "adaptive", Quart_PA, Vol_PA, Noise_Realized)
            RK_est_local[(date_idx,b)].estim()

    RK_values = np.array([RK_est[key][0] for key in date])
    RK_local_values = {}
    for b in block_list:
        RK_local_values[b] = np.array([[sub[0] for sub in RK_est_local[(key, b)].sub_estimator] for key in date])

    summary_RK = {}
    for b in block_list:
        summary_RK[b] = np.zeros((nb_days, 1+b))
        summary_RK[b][:, 0] = RK_values

        for i in range(nb_days):
            summary_RK[b][i, 1:] = RK_local_values[b][i]

    various_RK = np.zeros((nb_days, 1+len(block_list)))
    various_RK[:,0] = RK_values
    various_RK[:,1:] = np.array([[RK_est_local[(key,b)][0] for b in block_list] for key in date])


xi2emp = np.array([ RK_est[key].pre_estimatorNoise[0]/np.sqrt(RK_est[key].T_obs*RK_est[key].pre_estimatorRho.IQest[0]) for key in date])

RK = Vol_RK(0,-1,{"values":np.array([RK_est[key][0] for key in date]), "T" : RK_est[date[0]].T, "d" : RK_est[date[0]].d }, "RK", "fromValues")
QMLE= Vol_QMLE(0,-1,{"values":np.array([QMLE_est[key][0] for key in date]), "T" : QMLE_est[date[0]].T, "d" : QMLE_est[date[0]].d }, "RK", "fromValues")


RK.target = np.array([RK_est[key].target[0] for key in date])
QMLE.target = np.array([QMLE_est[key].target[0] for key in date])

#
diff_QMLE = [various_QMLE[:,i]-various_QMLE[:,0] for i in range(1,5)]
diff_RK = [various_RK[:,i]-various_RK[:,0] for i in range(1,5)]

corr = [np.corrcoef(np.array([diff_QMLE[i], diff_RK[i]]))[0,1] for i in range(4)]
cov = [np.cov(np.array([diff_QMLE[i], diff_RK[i]]))[0,1] for i in range(4)]




###Latex template

def round(x,k=2):
    out = ""
    if x<0:
        x*=-1
        out +="-"

    x_temp = x
    q=0
    if x_temp < 1 :
        q=1

    while x_temp >1:
        x_temp/=10
        q+=1

    y = int(x*10**k)*0.1**k
    if abs(y-x) <= abs(y+0.1**k-x):
        out += str(y)[:k+q+1]
    else :
        out += str(y+0.1**k)[:k+q+1]

    return out

#1- rho
rho_str = {}
rho_str[1] =round(rho_values.mean())
for b in block_list:
    rho_str[b] = tuple([float(round(r)) for r in summary[b].mean(axis=0)[1:]]).__repr__()

#2- mean local rho
mean_rho_local = np.array([round(summary[b][:,1:].mean()) for b in block_list])

ratio_RK_mean = np.array([round(x) for x in ratio_RK_mean])
ratio_QMLE_mean = np.array([round(x) for x in ratio_QMLE_mean])

#3- some summary stats for RK and QMLE

various_QMLE_mean = np.array([round(10000*x,3) for x in various_QMLE.mean(axis=0)])
various_RK_mean = np.array([round(10000*x,3) for x in various_RK.mean(axis=0)])

various_QMLE_std = np.array([round(10000*x,3) for x in various_QMLE.std(axis=0)])
various_RK_std = np.array([round(10000*x,3) for x in various_RK.std(axis=0)])

corr_QMLE_est = [round(np.corrcoef(np.array([various_QMLE[:,i], various_QMLE[:,0]]))[0,1],5) for i in range(1,5)]
corr_RK_est = [round(np.corrcoef(np.array([various_RK[:,i], various_QMLE[:,0]]))[0,1],4) for i in range(5)]


corr_diff = [round(np.corrcoef(np.array([diff_QMLE[i], diff_RK[i]]))[0,1],3) for i in range(4)]


###Some confidence intervals over a month of data
a_values = np.array([RK_est[key].pre_estimatorNoise[0]**0.5 for key in date]) #estimate of the noise std

month = "May"
start_day = 301#119
end_day = 365#start_day + 30
idx = np.array([j for j in range(nb_days) if date[j] >= start_day and date[j] <= end_day])
x_axis =np.arange(1,idx.size+1)
x_labels = np.array([int(key) for key in date if key >= start_day and key <= end_day])
x_labels -= x_labels[0]-1

y_values = {}
y_ci = {}
y_ci_up = {}
y_ci_down = {}

fact = 1e4 #normalizing factor for the estimates

y_values["QMLE"] = fact*QMLE_values[idx]
y_ci["QMLE"] = fact*1.96*np.sqrt(a_values[idx]*avar_QMLE[idx].reshape((len(idx),)))/len_tab[idx]**0.25

y_values["QMLE8"] = fact*various_QMLE[idx,4]
y_ci["QMLE8"] = fact*1.96*np.sqrt(a_values[idx]*ratio_QMLE[8][idx]*avar_QMLE[idx].reshape((len(idx),)))/len_tab[idx]**0.25

y_values["RK"] = fact*RK_values[idx]
y_ci["RK"] = fact*1.96*np.sqrt(a_values[idx]*avar_RK[idx].reshape((len(idx),)))/len_tab[idx]**0.25

y_values["RK8"] = fact*various_RK[idx,4]
y_ci["RK8"] = fact*1.96*np.sqrt(a_values[idx]*ratio_RK[8][idx]*avar_RK[idx].reshape((len(idx),)))/len_tab[idx]**0.25


for key in y_values:
    y_ci_up[key] = y_values[key] +y_ci[key]
    y_ci_down[key] = y_values[key] -y_ci[key]



#####Graph with both QMLE and RK
fig1 = plt.figure()

ax1 = fig1.add_subplot(1,1,1)
plt.xlabel('Days in {1} 2015 (Ticker : {0})'.format(ticker,month))
plt.ylabel('Estimates of daily integrated volatility')
plt.title('Confidence intervals for QMLE, RK, LQMLE and LRK (8 blocks)')
plt.xticks(x_axis,x_labels)

#ax2 = fig1.add_subplot(3,1,2)
#ax3 = fig1.add_subplot(3,1,3)

#ax1.plot(x_axis,y_values["QMLE"],'ro')#,x_axis,y_ci_up["QMLE"],'ro',x_axis,y_ci_down["QMLE"], 'ro')
#ax1.plot(x_axis+0.5,y_values["QMLE8"],'go',x_axis+0.5,y_ci_up["QMLE8"],'go',x_axis+0.5,y_ci_down["QMLE8"], 'go')

#ax3.plot(x_axis,y_ci["QMLE8"]/y_ci["QMLE"], 'bo')
#lower_y = 0.8
#ax3.axis([start_day,end_day,lower_y,1])

x_min = 0
x_max= x_axis[-1]+1
y_min = 1/10*int(0.9*np.min(y_ci_down["QMLE"] )*10)
y_max = 1/10*int(1.1*np.max(y_ci_up["QMLE"])*10)

ax1.axis([x_min,x_max,y_min,y_max])
#ax1.xaxis.set_ticks(x_axis)

x_unit = x_max-x_min
y_unit =  y_max-y_min

rect_width = 0.3

ellip_size = 0.008
#ax2.axis([start_day,end_day,0,3.0])

RK_offset = rect_width + 0.1
for i in (idx-idx[0]):

    #RK
    line_global = ax1.add_patch(
        patches.Rectangle((x_axis[i] - rect_width/2, y_ci_down["QMLE"][i]), rect_width, 2 * y_ci["QMLE"][i], alpha=0.3, color='g',label = 'QMLE'))
    ax1.plot([x_axis[i] - rect_width/2, x_axis[i] + rect_width/2], [y_values["QMLE"][i], y_values["QMLE"][i]], '-', color='g',
             linewidth=2.0)
    line_local = ax1.plot([x_axis[i],x_axis[i]],[y_ci_down["QMLE8"][i], y_ci_up["QMLE8"][i]], '-',color = 'black', linewidth = 1.0, label = 'LQMLE8' )
    ax1.plot([x_axis[i]-0.15, x_axis[i]+0.15], [y_ci_down["QMLE8"][i], y_ci_down["QMLE8"][i]], '-', color='black', linewidth=1.0)
    ax1.plot([x_axis[i] - 0.15, x_axis[i] + 0.15], [y_ci_up["QMLE8"][i], y_ci_up["QMLE8"][i]], '-', color='black',
             linewidth=1.0)
    ellip =patches.Ellipse((x_axis[i], y_values["QMLE8"][i]), ellip_size * x_unit, ellip_size * y_unit, color='black')
    ellip.set_zorder(10)
    ax1.add_patch(ellip)

    #ax1.add_patch(patches.Rectangle((x_axis[i]-0.07,y_ci_down["QMLE"][i]),0.14,2*y_ci["QMLE"][i],alpha=1,color='r'))

    # RK
    line_global_RK = ax1.add_patch(
        patches.Rectangle((x_axis[i] - rect_width / 2 + RK_offset, y_ci_down["RK"][i]), rect_width, 2 * y_ci["RK"][i],
                          alpha=0.3, color='b', label='RK'))
    ax1.plot([x_axis[i] - rect_width / 2 + RK_offset, x_axis[i] + rect_width / 2 + RK_offset], [y_values["RK"][i], y_values["RK"][i]], '-',
             color='b',
             linewidth=2.0)
    line_local_RK = ax1.plot([x_axis[i]+RK_offset, x_axis[i]+RK_offset], [y_ci_down["RK8"][i], y_ci_up["RK8"][i]], '-', color='black',
                          linewidth=1.0, label='LRK8')
    ax1.plot([x_axis[i] - 0.15+RK_offset, x_axis[i] + 0.15+RK_offset], [y_ci_down["RK8"][i], y_ci_down["RK8"][i]], '-', color='black',
             linewidth=1.0)
    ax1.plot([x_axis[i] - 0.15+RK_offset, x_axis[i] + 0.15+RK_offset], [y_ci_up["RK8"][i], y_ci_up["RK8"][i]], '-', color='black',
             linewidth=1.0)
    ellip = patches.Ellipse((x_axis[i]+RK_offset, y_values["RK8"][i]), ellip_size * x_unit, ellip_size * y_unit, color='black')
    ellip.set_zorder(10)
    ax1.add_patch(ellip)

plt.legend(handles=[ line_global,line_local[0], line_global_RK, line_local_RK[0]], loc=2)
plt.savefig(month+".png")
    #myline = ax1.plot([x_axis[i]+0.5,x_axis[i]+0.5],[y_ci_down["QMLE8"][i], y_ci_up["QMLE8"][i]], '--',color = 'black', linewidth = 1.0 )
    #myline =ax3.plot([x_axis[i],x_axis[i]], [0,y_ci["QMLE8"][i]/y_ci["QMLE"][i]], '--',color = 'black', linewidth = 1.0 )



#########

#####Graph with QMLE only
fig1 = plt.figure()

ax1 = fig1.add_subplot(1,1,1)
plt.xlabel('Days in {1} 2015 (Ticker : {0})'.format(ticker,month))
plt.ylabel('Estimates of daily integrated volatility')
plt.title('Confidence intervals for QMLE, RK, LQMLE and LRK (8 blocks)')

#ax2 = fig1.add_subplot(3,1,2)
#ax3 = fig1.add_subplot(3,1,3)

#ax1.plot(x_axis,y_values["QMLE"],'ro')#,x_axis,y_ci_up["QMLE"],'ro',x_axis,y_ci_down["QMLE"], 'ro')
#ax1.plot(x_axis+0.5,y_values["QMLE8"],'go',x_axis+0.5,y_ci_up["QMLE8"],'go',x_axis+0.5,y_ci_down["QMLE8"], 'go')

#ax3.plot(x_axis,y_ci["QMLE8"]/y_ci["QMLE"], 'bo')
#lower_y = 0.8
#ax3.axis([start_day,end_day,lower_y,1])

x_min = 0
x_max= len(x_axis)+1
y_min = 1/10*int(0.9*np.min(y_ci_down["QMLE"])*10)
y_max = 1/10*int(1.1*np.max(y_ci_up["QMLE"])*10)

ax1.axis([x_min,x_max,y_min,y_max])
#ax1.xaxis.set_ticks(x_axis)

x_unit = x_max-x_min
y_unit =  y_max-y_min

rect_width = 0.6

ellip_size = 0.01
#ax2.axis([start_day,end_day,0,3.0])
for i in (idx-idx[0]):

    #QMLE
    line_global = ax1.add_patch(
        patches.Rectangle((x_axis[i] - rect_width/2, y_ci_down["QMLE"][i]), rect_width, 2 * y_ci["QMLE"][i], alpha=0.3, color='b',label = 'QMLE'))
    ax1.plot([x_axis[i] - rect_width/2, x_axis[i] + rect_width/2], [y_values["QMLE"][i], y_values["QMLE"][i]], '-', color='b',
             linewidth=2.0)
    line_local = ax1.plot([x_axis[i],x_axis[i]],[y_ci_down["QMLE8"][i], y_ci_up["QMLE8"][i]], '-',color = 'black', linewidth = 1.0, label = 'LQMLE8' )
    ax1.plot([x_axis[i]-0.15, x_axis[i]+0.15], [y_ci_down["QMLE8"][i], y_ci_down["QMLE8"][i]], '-', color='black', linewidth=1.0)
    ax1.plot([x_axis[i] - 0.15, x_axis[i] + 0.15], [y_ci_up["QMLE8"][i], y_ci_up["QMLE8"][i]], '-', color='black',
             linewidth=1.0)
    ellip =patches.Ellipse((x_axis[i], y_values["QMLE8"][i]), ellip_size * x_unit, ellip_size * y_unit, color='black')
    ellip.set_zorder(10)
    ax1.add_patch(ellip)

    #ax1.add_patch(patches.Rectangle((x_axis[i]-0.07,y_ci_down["QMLE"][i]),0.14,2*y_ci["QMLE"][i],alpha=1,color='r'))


plt.legend(handles=[ line_global,line_local[0]], loc=2)



























