import numpy as np
from pandas import DataFrame, Series
import matplotlib.pyplot as plt
import math as math
#from path import path

np.random.seed(1)

start = 0
end = -1
dailySeconds=23400 #corresponds to the number of seconds considered in a day
M = 10 #nb of Monte-Carlo simulations
T = 1/252 # horizon time
d = 1 #nb of days

# simulation
##Parameters for the Heston
mu = 0.03
rho = -0.75
kappa = 5
gamma = 0.4
alpha = 0.1 #i.e. mean volatility ** 2

##Parameters for the jump
jump_size = .5 #in % of the vol
jump_start,jump_end = 0,1
jump_mode = "unif"

##Parameters for the daily U-shaped vol
A = 0.75
B = 0.25
C = 0.88929198
a = 10.0
b = 10.0

sigma = 1#np.sqrt(0.1)

def riemann(g,k=500):
    return np.sum([g(i/k) for i in range(k)])*1/k

def sigma_u(x):
    return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma

tab = np.array([sigma_u(i/100) for i in np.arange(100)])


def sigma_u_jumps(x):
    if x <= 0.5:
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma
    else :
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma-0.5*sigma

priceArgs = [mu, kappa, alpha, gamma, rho, sigma_u, [jump_size,jump_start,jump_end], jump_mode]


## 5-sec and TBT
for regular_obs in range(1):
    regular_obs=0
    samplingfreq = 5 # corresponds to the sampling frequency in seconds
    if regular_obs == 1:
        n = int(dailySeconds / samplingfreq)
        sim = Simulator(samplingfreq, M, d, dailySeconds, T)
    if regular_obs == 0:
        sim = Simulator(samplingfreq, M, d, dailySeconds, T, regular_obs=0)
        sim.simulObsTimes()
        n = sim.Nmax
### roll
    autoTI = 0.3 # auto of trade indicator
    [roll,TI] = sim.explicativePartRollAuto(knownNoiseArgs=1, auto=autoTI)
### spread
    maxSize = 4
    spread = sim.spreadTick(meanHalfSpread=1, maxSize = maxSize)
### volume
    meanVol = 100
    varVol = 165000
    ARparamVol = 0.017
    volume = sim.volumeordepthAR(mean=meanVol,var=varVol, ARparam =ARparamVol)
### depth
    meanDepth = 180
    varDepth = 27500
    ARparamDepth = 0.47
    depth = sim.volumeordepthAR(mean=meanDepth,var=varDepth, ARparam =ARparamDepth)
### efficient price
    effprice0,volatility = sim.simulSVHeston(priceArgs)
    effprice = np.zeros((M, n + 1))
    for i in range(M):
        for j in range(n + 1):
            effprice[i][j] = effprice0[i][j]
#### add jumps to efficient price
    jump_effprice=1
    if jump_effprice:
        vol = np.sqrt(0.1)
        lambda_jump = T*10
        size_jump = np.sqrt((vol ** 2)*T)# around 50 percent of the total quadratic variation
        time_jump = np.random.exponential(lambda_jump, (M,10))
        time_jump_discrete = np.zeros((M,10))
        positive_jump = np.zeros((M,10))
        nb_jump = np.zeros(M)
        target_square_jump = np.zeros(M)
        for i in range(M):
            time_next_jump = time_jump[i][0]
            ind = 0
            while time_next_jump < T:
                positive_jump[i][ind] = np.random.binomial(1,0.5)
                if regular_obs == 1:
                    time_jump_discrete[i][ind] = int(n*time_next_jump/T) + 1
                if regular_obs == 0:
                    time_jump_discrete[i][ind] = min(range(len(sim.obsTimes[i])), key=abs(sim.obsTimes[i] - time_next_jump).__getitem__)
                if positive_jump[i][ind]:
                    effprice[i][int(time_jump_discrete[i][ind]):(n+1)] = effprice[i][int(time_jump_discrete[i][ind]):(n+1)] + size_jump
                else:
                    effprice[i][int(time_jump_discrete[i][ind]):(n+1)] = effprice[i][int(time_jump_discrete[i][ind]):(n+1)] - size_jump
                ind += 1
                time_next_jump += time_jump[i][ind]
                target_square_jump[i] += (size_jump ** 2)
            nb_jump[i]=ind
### models
#### no residual noise
##### Model 1: signed spread
    tick = 0.0001
    thetaS = 0.86
    mod1info = tick * TI * spread
    mod1explained = (thetaS/2) * mod1info
    mod1obsprice = effprice + mod1explained

##### Model 2: signed spread + TI
    theta2S = 0.90
    theta2T = -0.00001
    mod2infoS = tick * TI * spread
    mod2infoT = TI
    mod2explained = (theta2S/2) * mod2infoS + theta2T * mod2infoT
    mod2obsprice = effprice + mod2explained

##### Model 3: signed spread + TI + 1/Dtime
    theta3S = 0.90
    theta3T = -0.00001
    theta3D =  10 ** (-5)
    mod3infoS = tick * TI * spread
    mod3infoT = TI
    mod3infoD = np.zeros((M,n+1))
    if regular_obs == 1:
        mu = 5
        s2 = 50
        mutilde = (mu ** 2)/s2
        s2tilde = s2/mu
        delta_ts = abs(np.random.gamma(mutilde,s2tilde,(M,n+1)))#samplingfreq+np.random.normal(0,1,(M,n+1))
        ts = np.cumsum(delta_ts, axis=1)
        mod3infoD = TI/(1 + delta_ts)
    if regular_obs == 0:
        for i in range(M):
            mod3infoD[i][0] = 0
            for j in range(n):
                if j+2>sim.nbObs[i]:
                    mod3infoD[i][j+1]=0
                else:
                    mod3infoD[i][j+1]=TI[i][j+1]/(1 + (sim.obsTimes[i][j+1] - sim.obsTimes[i][j])/(T/dailySeconds))
    mod3explained = (theta3S/2) * mod3infoS + theta3T * mod3infoT + theta3D * mod3infoD
    mod3obsprice = effprice + mod3explained

#### non-zero residual noise
##### Model 1: signed spread
    mod1varres = np.var(mod1explained)/9
    mod1resnoise = sim.simulNoiseIID([mod1varres])
    mod1resobsprice = mod1obsprice + mod1resnoise

##### Model 2: signed spread + TI
    mod2varres = np.var(mod2explained)/9
    mod2resnoise = sim.simulNoiseIID([mod2varres])
    mod2resobsprice = mod2obsprice + mod2resnoise

##### Model 3: signed spread + TI + 1/(1+Dtime)
    if regular_obs==1:
        mod3varres = np.var(mod3explained)/9
    if regular_obs==0:
        mod3varrestab = np.zeros(M)
        for i in range(M):
            mod3varrestab[i] = np.var(mod3explained[i][0:np.int(sim.nbObs[i])])
        mod3varres = np.mean(mod3varrestab)/9
    mod3resnoise = sim.simulNoiseIID([mod3varres])
    mod3resobsprice = mod3obsprice + mod3resnoise
#### mix of models and noise
    residual_noise = np.random.binomial(size=M, n=1, p= 0.5)
    mod = np.random.randint(size=M,low=1,high=4)
    modmixobsprice = np.zeros((M, n + 1))
    for i in range(M):
        if residual_noise[i]:
            if mod[i]==1:
                modmixobsprice[i,]=mod1resobsprice[i,]
            if mod[i]==2:
                modmixobsprice[i,]=mod2resobsprice[i,]
            if mod[i]==3:
                modmixobsprice[i,]=mod3resobsprice[i,]
        else:
            if mod[i] == 1:
                modmixobsprice[i,] = mod1obsprice[i,]
            if mod[i] == 2:
                modmixobsprice[i,] = mod2obsprice[i,]
            if mod[i] == 3:
                modmixobsprice[i,] = mod3obsprice[i,]


# estimation
## Model 1 no residual noise QMLEspread
### QMLEexp
#### Unfeasible statistics
    sim.Y = mod1obsprice
    sim.info = TI
    sim.spread = tick * spread
    QMLEexp = Vol_Yingying(start, end, sim.__dict__)
    QMLEexp.estim(infotype="spread")
    IV = np.zeros(M) # IV
    IVJ = np.zeros(M) # IV plus square jumps
    IV4 = np.zeros(M) # integrated quarticity
    JV = np.zeros(M)  # square jump volatility part
    for i in range(M):
        if regular_obs==1:
            IV[i] = np.mean(volatility[i]) * T
            IV4[i] = np.mean(volatility[i] ** 2) * T
        if regular_obs==0:
            for j in range(int(sim.nbObs[i]-1)):
                IV[i] += volatility[i, j] * (sim.obsTimes[i,j+1]-sim.obsTimes[i,j])
                IV4[i] += ((volatility[i,j] ** 2)*(2*timevaryingintensity(sim.obsTimes[i,j],T))) * (sim.obsTimes[i,j+1]-sim.obsTimes[i,j])
        IVJ[i] = IV[i] + target_square_jump[i]
        time_next_jump = time_jump[i][0]
        ind = 0
        while time_next_jump < T:
            if regular_obs==1:
                JV[i] += (size_jump ** 2) * (volatility[i][int(time_jump_discrete[i][ind])] + volatility[i][int(time_jump_discrete[i][ind] - 1)])
            if regular_obs==0:
                JV[i] += (size_jump ** 2) * (volatility[i][int(time_jump_discrete[i][ind])]*2*timevaryingintensity(sim.obsTimes[i,int(time_jump_discrete[i][ind])],T) + volatility[i][int(time_jump_discrete[i][ind] - 1)]*2*timevaryingintensity(sim.obsTimes[i,int(time_jump_discrete[i][ind]-1)],T))
            ind += 1
            time_next_jump += time_jump[i][ind]
    if regular_obs==1:
        Q = IV4 + JV
        QMLEexpSDVol = ((2 * Q * T) / n) ** (1 / 2)
    if regular_obs==0:
        alphainvmean = 0
        K=1000
        for i in range(K):
            alphainvmean += (1/(2*timevaryingintensity((i/K)*T,T)))/K
        Q = alphainvmean*(IV4 + JV)
        QMLEexpSDVol = ((2 * Q * T) / sim.nbObs) ** (1 / 2)

    [QMLEexpStudVol, QMLEexpStudVolSummary] = studentization(estimator=QMLEexp.values,target=IVJ, SD=QMLEexpSDVol, print0=1)
    UthetaS = np.zeros(M)
    for i in range(M):
        UthetaS[i] = np.mean(np.diff(mod1explained[i]) ** 2)
    if regular_obs==1:
        QMLEexpSDThetaS = np.sqrt(IV/UthetaS)/n
    if regular_obs==0:
        QMLEexpSDThetaS = np.sqrt(IV/UthetaS)/sim.nbObs

    QMLEexpBiasThetaS = np.zeros(M)
    for i in range(M):
        for j in range(int(nb_jump[i])):
            if regular_obs==1:
                QMLEexpBiasThetaS[i] += (2*positive_jump[i][j] -1)*size_jump*(mod1explained[i][int(time_jump_discrete[i][j])] - mod1explained[i][int(time_jump_discrete[i][j] -1)])/(n*UthetaS[i])
            if regular_obs==0:
                QMLEexpBiasThetaS[i] += (2 * positive_jump[i][j] - 1) * size_jump * (mod1explained[i][int(time_jump_discrete[i][j])] - mod1explained[i][int(time_jump_discrete[i][j] - 1)]) / (sim.nbObs[i] * UthetaS[i])
    thetaSVector = np.zeros(M)
    thetaSVector += thetaS
    [QMLEexpStudThetaS, QMLEexpStudThetaSSummary] = studentization(estimator=2*QMLEexp.knownNoise_estimatedvalue- QMLEexpBiasThetaS, target=thetaSVector, SD=QMLEexpSDThetaS,print0=1)
#### Feasible statistics
    mod1estprice = np.zeros((M, n + 1))
    for i in range(M):
        mod1estprice[i] = mod1obsprice[i] - QMLEexp.knownNoise_estimatedvalue[i] * mod1info[i]
    alpha0 = 3
    alphatilde = alpha0 * (QMLEexp.values ** (1 / 2))
    omegabar = 0.48
    kn = int(np.sqrt(n))
    Delta = T / n
    un = alphatilde * (Delta ** omegabar)
    Qest = np.zeros(M)
    if regular_obs==1:
        factor1 = 1 / (3 * Delta)
        factor2 = 1 / (kn * Delta)
        for j in range(M):
            Qest[j] = 0
            ret = np.diff(mod1estprice[j])
            for i in range(n):
                if abs(ret[i]) < un[j]:
                    Qest[j] = Qest[j] + factor1 * (ret[i] ** 4)
                else:
                    if kn - 1 < i < n - kn:
                        Qest[j] = Qest[j] + factor2 * (ret[i] ** 2) * np.sum((ret[(i - kn):(i + kn)] ** 2) * (ret[(i - kn):(i + kn)] < un[j]))
    if regular_obs==0:
        alphatilde = alpha0 * (QMLEexp.values ** (1 / 2))
        omegabar = 0.48
        N=sim.nbObs-1
        kntilde = np.floor(np.sqrt(N))
        Deltaloc = np.diff(sim.obsTimes)
        untilde = np.zeros((M, sim.Nmax))
        for i in range(M):
            untilde[i] = alphatilde[i] * (Deltaloc[i] ** omegabar)
        DeltaN = T / N
        factor1 = 1 / DeltaN
        factor2 = 1 / (kntilde * DeltaN)
        for j in range(M):
            ret = np.diff(mod1estprice[j])
            for i in range(int(N[j])):
                if abs(ret[i]) < untilde[j, i] and abs(ret[i + 1]) < untilde[j, i + 1]:
                    Qest[j] += factor1[j] * (ret[i] ** 2) * (ret[i + 1] ** 2)
                if abs(ret[i]) > untilde[j, i]:
                    if kntilde[j] - 1 < i < n - kntilde[j]:
                        Qest[j] += factor2[j] * (ret[i] ** 2) * np.sum((ret[(i - int(kntilde[j])):(i + int(kntilde[j]))] ** 2) * (ret[(i - int(kntilde[j])):(i + int(kntilde[j]))] < untilde[j, i]))

    if regular_obs==1:
        QMLEexpSDVolFeasible = ((2 * (Qest * T)) / n) ** (1 / 2)
    if regular_obs==0:
        QMLEexpSDVolFeasible = ((2 * (Qest * T)) / sim.nbObs) ** (1 / 2)

    [QMLEexpStudVolFeasible, QMLEexpStudVolSummaryFeasible] = studentization(estimator=QMLEexp.values, target=IVJ, SD=QMLEexpSDVolFeasible,print0=1)
    IVest = np.zeros(M)
    for i in range(M):
        ret = np.diff(mod1estprice[i])
        if regular_obs==1:
            for j in range(n):
                IVest[i] += (ret[j] ** 2)*(ret[j] < un[i])
        if regular_obs==0:
            for j in range(int(N[i])):
                IVest[i] += (ret[j] ** 2)*(ret[j] < un[i])
    if regular_obs==1:
        QMLEexpSDThetaSFeasible = np.sqrt(IVest / UthetaS) / n
    if regular_obs==0:
        QMLEexpSDThetaSFeasible = np.sqrt(IVest / UthetaS) / N
    [QMLEexpStudThetaSFeasible, QMLEexpStudThetaSSummaryFeasible] = studentization(estimator=2 * QMLEexp.knownNoise_estimatedvalue, target=thetaSVector, SD=QMLEexpSDThetaS,print0=1)
    #intalphainv=0
    #for i in range(1000):
    #    intalphainv += 1/(1000 * timevaryingintensity((T*i)/1000,T))

### QMLEerr
#### Unfeasible statistics
    QMLEerr = Vol_QMLE(start, end, sim.__dict__)
    QMLEerr.estim(infotype="spread")
    QMLEerrSDVol = QMLEexpSDVol * (3 ** (1/2))
    [QMLEerrStudVol, QMLEerrStudVolSummary] = studentization(estimator=QMLEerr.values,target=IVJ, SD=QMLEerrSDVol, print0=1)
    [QMLEerrStudThetaS, QMLEerrStudThetaSSummary] = studentization(estimator=2*QMLEerr.knownNoise_estimatedvalue1- QMLEexpBiasThetaS, target=thetaSVector, SD=QMLEexpSDThetaS,print0=1)
    if regular_obs==1:
        QMLEerrSDResNoise = ((T * Q) ** (1 / 2)) / (n ** (3 / 2))
    if regular_obs == 0:
        QMLEerrSDResNoise = ((T * Q) ** (1 / 2)) / (sim.nbObs ** (3 / 2))
    [QMLEerrStudResNoise, QMLEerrStudResNoiseSummary] = studentization(estimator=QMLEerr.noise_estimator.values, target=0, SD=QMLEerrSDResNoise,print0=1)
#### Feasible statistics
    QMLEerrSDVolFeasible = QMLEexpSDVolFeasible * (3 ** (1 / 2))
    [QMLEerrStudVolFeasible, QMLEerrStudVolSummaryFeasible] = studentization(estimator=QMLEerr.values, target=IVJ, SD=QMLEerrSDVolFeasible,print0=1)
    [QMLEerrStudThetaSFeasible, QMLEerrStudThetaSSummaryFeasible] = studentization(estimator=2 * QMLEerr.knownNoise_estimatedvalue1, target=thetaSVector, SD=QMLEexpSDThetaSFeasible,print0=1)
    if regular_obs==1:
        QMLEerrSDResNoiseFeasible = ((T * Qest) ** (1 / 2)) / (n ** (3 / 2))
    if regular_obs==0:
        QMLEerrSDResNoiseFeasible = ((T * Qest) ** (1 / 2)) / (sim.nbObs ** (3 / 2))
    [QMLEerrStudResNoiseFeasible, QMLEerrStudResNoiseSummaryFeasible] = studentization(estimator=QMLEerr.noise_estimator.values,target=0, SD=QMLEerrSDResNoiseFeasible, print0=1)
## Model 1 non zero residual noise QMLEerr spread
### Unfeasible statistics
    sim.Y = mod1resobsprice
    QMLEreserr = Vol_QMLE(start, end, sim.__dict__)
    QMLEreserr.estim(infotype="spread")
    if regular_obs==1:
        QMLEreserrSDVol = (((5*(T ** (1))*((mod1varres/IVJ) ** (1/2))*Q) + (3*(mod1varres ** (1/2))*(IVJ ** (3/2)))) ** (1/2))/(n ** (1/4))
    if regular_obs==0:
        QMLEreserrSDVol = (((5*(T ** (1))*((mod1varres/IVJ) ** (1/2))*Q) + (3*(mod1varres ** (1/2))*(IVJ ** (3/2)))) ** (1/2))/(sim.nbObs ** (1/4))
    [QMLEresStudVol, QMLEresStudVolSummary] = studentization(estimator=QMLEreserr.values,target=IVJ, SD=QMLEreserrSDVol, print0=1)
    VthetaS = np.zeros(M)
    for i in range(M):
        VthetaS[i] = np.mean(mod1explained[i] ** 2)
    if regular_obs==1:
        QMLEreserrSDThetaS = (mod1varres/(n*VthetaS)) ** (1/2)
    if regular_obs==0:
        QMLEreserrSDThetaS = (mod1varres/(sim.nbObs*VthetaS)) ** (1/2)
    [QMLEresStudThetaS, QMLEresStudThetaSSummary] = studentization(estimator=2*QMLEreserr.knownNoise_estimatedvalue1, target=thetaSVector, SD=QMLEreserrSDThetaS,print0=1)
    if regular_obs==1:
        QMLEreserrSDResNoise = ((2/n) ** (1/2)) * mod1varres
    if regular_obs==0:
        QMLEreserrSDResNoise = ((2/sim.nbObs) ** (1/2)) * mod1varres
    [QMLEresStudResNoise, QMLEresStudResNoiseSummary] = studentization(estimator=QMLEreserr.noise_estimator.values, target=mod1varres, SD=QMLEreserrSDResNoise,print0=1)
### Feasible statistics
    mod1resestprice = np.zeros((M, n + 1))
    for i in range(M):
        mod1resestprice[i] = mod1resobsprice[i] - QMLEreserr.knownNoise_estimatedvalue1[i] * mod1info[i]
    Qestres = np.zeros(M)
    if regular_obs==1:
        for j in range(M):
            ret = np.diff(mod1resestprice[j])
            for i in range(n):
                if abs(ret[i]) < un[j]:
                    Qestres[j] = Qestres[j] + factor1 * (ret[i] ** 4)
                else:
                    if kn - 1 < i < n - kn:
                        Qestres[j] = Qestres[j] + factor2 * (ret[i] ** 2) * np.sum((ret[(i - kn):(i + kn)] ** 2) * (ret[(i - kn):(i + kn)] < un[j]))
    if regular_obs==0:
        alphatilderes = alpha0 * (QMLEreserr.values ** (1 / 2))
        untilderes = np.zeros((M, sim.Nmax))
        for i in range(M):
            untilderes[i] = alphatilderes[i] * (Deltaloc[i] ** omegabar)
        for j in range(M):
            ret = np.diff(mod1resestprice[j])
            for i in range(int(N[j])):
                if abs(ret[i]) < untilderes[j, i] and abs(ret[i + 1]) < untilderes[j, i + 1]:
                    Qest[j] += factor1[j] * (ret[i] ** 2) * (ret[i + 1] ** 2)
                if abs(ret[i]) > untilderes[j, i]:
                    if kntilde[j] - 1 < i < n - kntilde[j]:
                        Qest[j] += factor2[j] * (ret[i] ** 2) * np.sum(
                            (ret[(i - int(kntilde[j])):(i + int(kntilde[j]))] ** 2) * (
                            ret[(i - int(kntilde[j])):(i + int(kntilde[j]))] < untilderes[j, i]))
    if regular_obs==1:
        QMLEreserrSDVolFeasible = (((5 *T) * (((abs(QMLEreserr.noise_estimator.values) / QMLEreserr.values) ** (1 / 2)) * Qestres) + (3 * (abs(QMLEreserr.noise_estimator.values) ** (1 / 2)) * (QMLEreserr.values ** (3 / 2)))) ** (1 / 2)) / (n ** (1 / 4))
    if regular_obs==0:
        QMLEreserrSDVolFeasible = (((5 *T) * (((abs(QMLEreserr.noise_estimator.values) / QMLEreserr.values) ** (1 / 2)) * Qestres) + (3 * (abs(QMLEreserr.noise_estimator.values) ** (1 / 2)) * (QMLEreserr.values ** (3 / 2)))) ** (1 / 2)) / (sim.nbObs ** (1 / 4))
    [QMLEresStudVolFeasible, QMLEresStudVolSummaryFeasible] = studentization(estimator=QMLEreserr.values, target=IVJ,SD=QMLEreserrSDVolFeasible, print0=1)
    [QMLEresStudThetaSFeasible, QMLEresStudThetaSSummaryFeasible] = studentization(estimator=2 * QMLEreserr.knownNoise_estimatedvalue1, target=thetaSVector, SD=QMLEreserrSDThetaS, print0=1)
    if regular_obs==1:
        QMLEreserrSDResNoiseFeasible = ((2 / n) ** (1 / 2)) * abs(QMLEreserr.noise_estimator.values)
    if regular_obs==0:
        QMLEreserrSDResNoiseFeasible = ((2 / sim.nbObs) ** (1 / 2)) * abs(QMLEreserr.noise_estimator.values)
    [QMLEresStudResNoiseFeasible, QMLEresStudResNoiseSummaryFeasible] = studentization(estimator=QMLEreserr.noise_estimator.values,target=mod1varres, SD=QMLEreserrSDResNoiseFeasible, print0=1)

### Noise and proportion of variance explained estimation
#### No residual noise
##### Model 1
###### CI1
    [QMLEerrResNoise, QMLEerrResNoiseSummary] = studentization(estimator=QMLEerr.noise_estimator.values,target=0, SD=1, print0=1)
    QMLEerrCI1size = 2*1.96*QMLEerrSDResNoiseFeasible
    print(np.mean(QMLEerrCI1size))
    QMLEerrCI1left = QMLEerr.noise_estimator.values - QMLEerrCI1size/2
    QMLEerrCI1right = QMLEerr.noise_estimator.values + QMLEerrCI1size / 2
    QMLEerrCI1coverage = np.logical_and(QMLEerrCI1left < 0, QMLEerrCI1right > 0)
    print(np.mean(QMLEerrCI1coverage))

    pi = np.zeros(M)
    varExplained = np.zeros(M)
    for i in range(M):
        if regular_obs==1:
            varExplained[i] = np.var(QMLEerr.knownNoise_estimatedvalue1[i] * mod1info[i])
        if regular_obs==0:
            varExplained[i] = np.var(QMLEerr.knownNoise_estimatedvalue1[i] * mod1info[i,0:int(sim.nbObs[i])])
        pi[i] = 1 - QMLEerr.noise_estimator[i] / (QMLEerr.noise_estimator[i] + varExplained[i])
    [piSummary1, piSummary2] = studentization(estimator=pi, target=1, SD=1,print0=1)
    if regular_obs==1:
        piSD = n ** (-3 / 2) / varExplained * np.sqrt(Qest * T)
    if regular_obs==0:
        piSD = sim.nbObs ** (-3 / 2) / varExplained * np.sqrt(Qest * T)
    piCI1size = 2 * 1.96 * piSD
    print(np.mean(piCI1size))
    piCI1left = pi - piCI1size / 2
    piCI1right = pi + piCI1size / 2
    piCI1coverage = np.logical_and(piCI1left < 1, piCI1right > 1)
    print(np.mean(piCI1coverage))
###### CI2
    if regular_obs==1:
        eta_smallnoise = abs(n * QMLEerr.noise_estimator.values) / T
    if regular_obs==0:
        eta_smallnoise = abs(sim.nbObs * QMLEerr.noise_estimator.values) / T
    sigma2_smallnoise = QMLEerr.values / T
    phi_smallnoise = 1 - 1 / (2 * eta_smallnoise) * (
    np.sqrt(sigma2_smallnoise * (4 * eta_smallnoise + sigma2_smallnoise)) - sigma2_smallnoise)
    gamma2_smallnoise = eta_smallnoise / phi_smallnoise
    if regular_obs==1:
        var_smallnoise = QMLEerrSDResNoiseFeasible ** 2 + n ** (-3) * (
        phi_smallnoise ** 2 * (2 - phi_smallnoise ** 2) * Qest * T / (
        1 - phi_smallnoise ** 2) ** 2 + gamma2_smallnoise ** 2 * phi_smallnoise * (1 + phi_smallnoise ** 2) * (
        phi_smallnoise ** 2 + 3 * phi_smallnoise + 4) / (1 + phi_smallnoise) ** 3 * T ** 2)
    if regular_obs==0:
        var_smallnoise = QMLEerrSDResNoiseFeasible ** 2 + sim.nbObs ** (-3) * (
        phi_smallnoise ** 2 * (2 - phi_smallnoise ** 2) * Qest * T / (
        1 - phi_smallnoise ** 2) ** 2 + gamma2_smallnoise ** 2 * phi_smallnoise * (1 + phi_smallnoise ** 2) * (
        phi_smallnoise ** 2 + 3 * phi_smallnoise + 4) / (1 + phi_smallnoise) ** 3 * T ** 2)
    QMLEerrSDResNoise2Feasible = np.sqrt(var_smallnoise)
    QMLEerrCI2size = 2 * 1.96 * QMLEerrSDResNoise2Feasible
    print(np.mean(QMLEerrCI2size))
    QMLEerrCI2left = QMLEerr.noise_estimator.values - QMLEerrCI2size / 2
    QMLEerrCI2right = QMLEerr.noise_estimator.values + QMLEerrCI2size / 2
    QMLEerrCI2coverage = np.logical_and(QMLEerrCI2left < 0, QMLEerrCI2right > 0)
    print(np.mean(QMLEerrCI2coverage))
    if regular_obs==1:
        std_varphi_smallnoise = n ** (-1) * QMLEerr.noise_estimator.values /varExplained * np.sqrt((QMLEerr.values + 3 * eta_smallnoise) / UthetaS)/ QMLEerr.knownNoise_estimatedvalue1  # last term comes from the delta method applied to varExp
        piSD2 = np.sqrt(var_smallnoise / varExplained ** 2 + std_varphi_smallnoise ** 2)
    if regular_obs==0:
        std_varphi_smallnoise = sim.nbObs ** (-1) * QMLEerr.noise_estimator.values /varExplained * np.sqrt((QMLEerr.values + 3 * eta_smallnoise) / UthetaS)/ QMLEerr.knownNoise_estimatedvalue1  # last term comes from the delta method applied to varExp
        piSD2 = np.sqrt(var_smallnoise / varExplained ** 2 + std_varphi_smallnoise ** 2)
    piCI2size = 2 * 1.96 * piSD2
    print(np.mean(piCI2size))
    piCI2left = pi - piCI2size / 2
    piCI2right = pi + piCI2size / 2
    piCI2coverage = np.logical_and(piCI2left < 1, piCI2right > 1)
    print(np.mean(piCI2coverage))
###### CI3
    QMLEerrCI3size = 2 * 1.96 * QMLEreserrSDResNoiseFeasible
    print(np.mean(QMLEerrCI3size))
    QMLEerrCI3left = QMLEerr.noise_estimator.values - QMLEerrCI3size / 2
    QMLEerrCI3right = QMLEerr.noise_estimator.values + QMLEerrCI3size / 2
    QMLEerrCI3coverage = np.logical_and(QMLEerrCI3left < 0, QMLEerrCI3right > 0)
    print(np.mean(QMLEerrCI3coverage))
    std_varphi_largenoise = n**(-1/2)*np.sqrt(abs(QMLEerr.noise_estimator.values)/UthetaS)
    piSD3 = np.sqrt(4*abs(QMLEerr.noise_estimator.values)**4/((2*QMLEerr.knownNoise_estimatedvalue1)**2*varExplained**2)*std_varphi_largenoise**2 + 1/varExplained**2*QMLEreserrSDResNoiseFeasible**2)
    piCI3size = 2 * 1.96 * piSD3
    print(np.mean(piCI3size))
    piCI3left = pi - piCI3size / 2
    piCI3right = pi + piCI3size / 2
    piCI3coverage = np.logical_and(piCI3left < 1, piCI3right > 1)
    print(np.mean(piCI3coverage))
##### Model 2
    sim.Y = mod2obsprice
    sim.info = TI
    sim.spread = tick * spread
    QMLE2err = Vol_QMLE(start, end, sim.__dict__)
    QMLE2err.estim(infotype="spreadRoll")
    sim.Y = mod2resobsprice
    QMLE2reserr = Vol_QMLE(start, end, sim.__dict__)
    QMLE2reserr.estim(infotype="spreadRoll")
    mod2estprice = np.zeros((M, n + 1))
    for i in range(M):
        mod2estprice[i] = mod2obsprice[i] - QMLE2err.knownNoise_estimatedvalue1[i] * mod2infoT[i] - QMLE2err.knownNoise_estimatedvalue2[i] * mod2infoS[i]
    Q2est = np.zeros(M)
    if regular_obs==1:
        for j in range(M):
            ret = np.diff(mod2estprice[j])
            for i in range(n):
                if abs(ret[i]) < un[j]:
                    Q2est[j] = Q2est[j] + factor1 * (ret[i] ** 4)
                else:
                    if kn - 1 < i < n - kn:
                        Q2est[j] = Q2est[j] + factor2 * (ret[i] ** 2) * np.sum((ret[(i - kn):(i + kn)] ** 2) * (ret[(i - kn):(i + kn)] < un[j]))
    if regular_obs==0:
        alphatilde2 = alpha0 * (QMLE2err.values ** (1 / 2))
        untilde2 = np.zeros((M, sim.Nmax))
        for i in range(M):
            untilde2[i] = alphatilde2[i] * (Deltaloc[i] ** omegabar)
        for j in range(M):
            ret = np.diff(mod2estprice[j])
            for i in range(int(N[j])):
                if abs(ret[i]) < untilde2[j, i] and abs(ret[i + 1]) < untilde2[j, i + 1]:
                    Q2est[j] += factor1[j] * (ret[i] ** 2) * (ret[i + 1] ** 2)
                if abs(ret[i]) > untilde2[j, i]:
                    if kntilde[j] - 1 < i < n - kntilde[j]:
                        Q2est[j] += factor2[j] * (ret[i] ** 2) * np.sum(
                            (ret[(i - int(kntilde[j])):(i + int(kntilde[j]))] ** 2) * (
                            ret[(i - int(kntilde[j])):(i + int(kntilde[j]))] < untilde2[j, i]))
    mod2resestprice = np.zeros((M, n + 1))
    for i in range(M):
        mod2resestprice[i] = mod2resobsprice[i] - QMLE2reserr.knownNoise_estimatedvalue1[i] * mod2infoT[i] - QMLE2reserr.knownNoise_estimatedvalue2[i] * mod2infoS[i]
    Q2estres = np.zeros(M)
    if regular_obs==1:
        for j in range(M):
            Q2estres[j] = 0
            ret = np.diff(mod2resestprice[j])
            for i in range(n):
                if abs(ret[i]) < un[j]:
                    Q2estres[j] = Q2estres[j] + factor1 * (ret[i] ** 4)
                else:
                    if kn - 1 < i < n - kn:
                        Q2estres[j] = Q2estres[j] + factor2 * (ret[i] ** 2) * np.sum((ret[(i - kn):(i + kn)] ** 2) * (ret[(i - kn):(i + kn)] < un[j]))
    if regular_obs==0:
        alphatilde2res = alpha0 * (QMLE2reserr.values ** (1 / 2))
        untilde2res = np.zeros((M, sim.Nmax))
        for i in range(M):
            untilde2res[i] = alphatilde2res[i] * (Deltaloc[i] ** omegabar)
        for j in range(M):
            ret = np.diff(mod2resestprice[j])
            for i in range(int(N[j])):
                if abs(ret[i]) < untilde2res[j, i] and abs(ret[i + 1]) < untilde2res[j, i + 1]:
                    Q2estres[j] += factor1[j] * (ret[i] ** 2) * (ret[i + 1] ** 2)
                if abs(ret[i]) > untilde2res[j, i]:
                    if kntilde[j] - 1 < i < n - kntilde[j]:
                        Q2estres[j] += factor2[j] * (ret[i] ** 2) * np.sum(
                            (ret[(i - int(kntilde[j])):(i + int(kntilde[j]))] ** 2) * (ret[(i - int(kntilde[j])):(i + int(kntilde[j]))] < untilde2res[j, i]))
###### CI1
    [QMLE2errResNoise, QMLE2errResNoiseSummary] = studentization(estimator=QMLE2err.noise_estimator.values, target=0, SD=1, print0=1)
    if regular_obs==1:
        QMLE2errSDResNoiseFeasible = ((T * Q2est) ** (1 / 2)) / (n ** (3 / 2))
    if regular_obs==0:
        QMLE2errSDResNoiseFeasible = ((T * Q2est) ** (1 / 2)) / (sim.nbObs ** (3 / 2))
    QMLE2errCI1size = 2 * 1.96 * QMLE2errSDResNoiseFeasible
    print(np.mean(QMLE2errCI1size))
    QMLE2errCI1left = QMLE2err.noise_estimator.values - QMLE2errCI1size / 2
    QMLE2errCI1right = QMLE2err.noise_estimator.values + QMLE2errCI1size / 2
    QMLE2errCI1coverage = np.logical_and(QMLE2errCI1left < 0, QMLE2errCI1right > 0)
    print(np.mean(QMLE2errCI1coverage))
    pi2 = np.zeros(M)
    varExplained2 = np.zeros(M)
    for i in range(M):
        if regular_obs==1:
            varExplained2[i] = np.var(QMLE2err.knownNoise_estimatedvalue1[i] * mod2infoT[i] + QMLE2err.knownNoise_estimatedvalue2[i] * mod2infoS[i])
        if regular_obs==0:
            varExplained2[i] = np.var(QMLE2err.knownNoise_estimatedvalue1[i] * mod2infoT[i,0:int(sim.nbObs[i])] + QMLE2err.knownNoise_estimatedvalue2[i] * mod2infoS[i,0:int(sim.nbObs[i])])
        pi2[i] = 1 - QMLE2err.noise_estimator[i] / (QMLE2err.noise_estimator[i] + varExplained2[i])
    [pi2Summary1, pi2Summary2] = studentization(estimator=pi2, target=1, SD=1, print0=1)
    if regular_obs==1:
        pi2SD = n ** (-3 / 2) / varExplained2 * np.sqrt(Q2est * T)
    if regular_obs==0:
        pi2SD = sim.nbObs ** (-3 / 2) / varExplained2 * np.sqrt(Q2est * T)
    pi2CI1size = 2 * 1.96 * pi2SD
    print(np.mean(pi2CI1size))
    pi2CI1left = pi2 - pi2CI1size / 2
    pi2CI1right = pi2 + pi2CI1size / 2
    pi2CI1coverage = np.logical_and(pi2CI1left < 1, pi2CI1right > 1)
    print(np.mean(pi2CI1coverage))
###### CI2
    eta_smallnoise2 = abs(n * QMLE2err.noise_estimator.values) / T
    sigma2_smallnoise2 = QMLE2err.values / T
    phi_smallnoise2 = 1 - 1 / (2 * eta_smallnoise2) * (
        np.sqrt(sigma2_smallnoise2 * (4 * eta_smallnoise2 + sigma2_smallnoise2)) - sigma2_smallnoise2)
    gamma2_smallnoise2 = eta_smallnoise2 / phi_smallnoise2
    var_smallnoise2 = QMLE2errSDResNoiseFeasible ** 2 + n ** (-3) * (
        phi_smallnoise2 ** 2 * (2 - phi_smallnoise2 ** 2) * Q2est * T / (
            1 - phi_smallnoise2 ** 2) ** 2 + gamma2_smallnoise2 ** 2 * phi_smallnoise2 * (1 + phi_smallnoise2 ** 2) * (
            phi_smallnoise2 ** 2 + 3 * phi_smallnoise2 + 4) / (1 + phi_smallnoise2) ** 3 * T ** 2)
    QMLE2errSDResNoise2Feasible = np.sqrt(var_smallnoise2)
    QMLE2errCI2size = 2 * 1.96 * QMLE2errSDResNoise2Feasible
    print(np.mean(QMLE2errCI2size))
    QMLE2errCI2left = QMLE2err.noise_estimator.values - QMLE2errCI2size / 2
    QMLE2errCI2right = QMLE2err.noise_estimator.values + QMLE2errCI2size / 2
    QMLE2errCI2coverage = np.logical_and(QMLE2errCI2left < 0, QMLE2errCI2right > 0)
    print(np.mean(QMLE2errCI2coverage))
    std_varphi_smallnoise2 = n ** (-1) * QMLE2err.noise_estimator.values / varExplained2 * np.sqrt((
                                                                                                QMLE2err.values + 3 * eta_smallnoise2) / UthetaS) / QMLE2err.knownNoise_estimatedvalue1  # last term comes from the delta method applied to varExp
    pi2SD = np.sqrt(var_smallnoise2 / varExplained2 ** 2 + std_varphi_smallnoise2 ** 2)
    pi2CI2size = 2 * 1.96 * pi2SD
    print(np.mean(pi2CI2size))
    pi2CI2left = pi - pi2CI2size / 2
    pi2CI2right = pi + pi2CI2size / 2
    pi2CI2coverage = np.logical_and(pi2CI2left < 1, pi2CI2right > 1)
    print(np.mean(pi2CI2coverage))

##### Model 3
    sim.Y = mod3obsprice
    sim.info = TI
    sim.spread = tick * spread
    sim.ts = sim.obsTimes/(T/dailySeconds)
    QMLE3err = Vol_QMLE(start, end, sim.__dict__)
    QMLE3err.estim(infotype="spreadRollTs")
    sim.Y = mod2resobsprice
    QMLE3reserr = Vol_QMLE(start, end, sim.__dict__)
    QMLE3reserr.estim(infotype="spreadRollTs")
    mod2estprice = np.zeros((M, n + 1))
    for i in range(M):
        mod2estprice[i] = mod2obsprice[i] - QMLE2err.knownNoise_estimatedvalue1[i] * mod2infoT[i] - \
                          QMLE2err.knownNoise_estimatedvalue2[i] * mod2infoS[i]
    Q2est = np.zeros(M)
    for j in range(M):
        Q2est[j] = 0
        ret = np.diff(mod2estprice[j])
        for i in range(n):
            if abs(ret[i]) < un[j]:
                Q2est[j] = Q2est[j] + factor1 * (ret[i] ** 4)
            else:
                if kn - 1 < i < n - kn:
                    Q2est[j] = Q2est[j] + factor2 * (ret[i] ** 2) * np.sum(
                        (ret[(i - kn):(i + kn)] ** 2) * (ret[(i - kn):(i + kn)] < un[j]))
    mod2resestprice = np.zeros((M, n + 1))
    for i in range(M):
        mod2resestprice[i] = mod2resobsprice[i] - QMLE2reserr.knownNoise_estimatedvalue1[i] * mod2infoT[i] - \
                             QMLE2reserr.knownNoise_estimatedvalue2[i] * mod2infoS[i]
    Q2estres = np.zeros(M)
    for j in range(M):
        Q2estres[j] = 0
        ret = np.diff(mod2resestprice[j])
        for i in range(n):
            if abs(ret[i]) < un[j]:
                Q2estres[j] = Q2estres[j] + factor1 * (ret[i] ** 4)
            else:
                if kn - 1 < i < n - kn:
                    Q2estres[j] = Q2estres[j] + factor2 * (ret[i] ** 2) * np.sum(
                        (ret[(i - kn):(i + kn)] ** 2) * (ret[(i - kn):(i + kn)] < un[j]))


    ###### CI1
    [QMLE2errResNoise, QMLE2errResNoiseSummary] = studentization(estimator=QMLE2err.noise_estimator.values, target=0,
                                                                 SD=1, print0=1)

    QMLE2errSDResNoiseFeasible = ((T * Q2est) ** (1 / 2)) / (n ** (3 / 2))
    QMLE2errCI1size = 2 * 1.96 * QMLE2errSDResNoiseFeasible
    print(np.mean(QMLE2errCI1size))
    QMLE2errCI1left = QMLE2err.noise_estimator.values - QMLE2errCI1size / 2
    QMLE2errCI1right = QMLE2err.noise_estimator.values + QMLE2errCI1size / 2
    QMLE2errCI1coverage = np.logical_and(QMLE2errCI1left < 0, QMLE2errCI1right > 0)
    print(np.mean(QMLE2errCI1coverage))

    pi2 = np.zeros(M)
    varExplained2 = np.zeros(M)
    for i in range(M):
        varExplained2[i] = np.var(
            QMLE2err.knownNoise_estimatedvalue1[i] * mod2infoT[i] + 2 * QMLE2err.knownNoise_estimatedvalue2[i] *
            mod2infoS[i])
        pi2[i] = 1 - QMLE2err.noise_estimator[i] / (
            QMLE2err.noise_estimator[i] + varExplained2[i])
    [pi2Summary1, pi2Summary2] = studentization(estimator=pi2, target=1, SD=1, print0=1)
    pi2SD = n ** (-3 / 2) / varExplained2 * np.sqrt(Q2est * T)
    pi2CI1size = 2 * 1.96 * pi2SD
    print(np.mean(pi2CI1size))
    pi2CI1left = pi2 - pi2CI1size / 2
    pi2CI1right = pi2 + pi2CI1size / 2
    pi2CI1coverage = np.logical_and(pi2CI1left < 1, pi2CI1right > 1)
    print(np.mean(pi2CI1coverage))
    ###### CI2
    eta_smallnoise2 = abs(n * QMLE2err.noise_estimator.values) / T
    sigma2_smallnoise2 = QMLE2err.values / T
    phi_smallnoise2 = 1 - 1 / (2 * eta_smallnoise2) * (
        np.sqrt(sigma2_smallnoise2 * (4 * eta_smallnoise2 + sigma2_smallnoise2)) - sigma2_smallnoise2)
    gamma2_smallnoise2 = eta_smallnoise2 / phi_smallnoise2
    var_smallnoise2 = QMLE2errSDResNoiseFeasible ** 2 + n ** (-3) * (
        phi_smallnoise2 ** 2 * (2 - phi_smallnoise2 ** 2) * Q2est * T / (
            1 - phi_smallnoise2 ** 2) ** 2 + gamma2_smallnoise2 ** 2 * phi_smallnoise2 * (1 + phi_smallnoise2 ** 2) * (
            phi_smallnoise2 ** 2 + 3 * phi_smallnoise2 + 4) / (1 + phi_smallnoise2) ** 3 * T ** 2)
    QMLE2errSDResNoise2Feasible = np.sqrt(var_smallnoise2)
    QMLE2errCI2size = 2 * 1.96 * QMLE2errSDResNoise2Feasible
    print(np.mean(QMLE2errCI2size))
    QMLE2errCI2left = QMLE2err.noise_estimator.values - QMLE2errCI2size / 2
    QMLE2errCI2right = QMLE2err.noise_estimator.values + QMLE2errCI2size / 2
    QMLE2errCI2coverage = np.logical_and(QMLE2errCI2left < 0, QMLE2errCI2right > 0)
    print(np.mean(QMLE2errCI2coverage))
    std_varphi_smallnoise2 = n ** (-1) * QMLE2err.noise_estimator.values / varExplained2 * np.sqrt((
                                                                                                       QMLE2err.values + 3 * eta_smallnoise2) / UthetaS) / QMLE2err.knownNoise_estimatedvalue1  # last term comes from the delta method applied to varExp
    pi2SD = np.sqrt(var_smallnoise2 / varExplained2 ** 2 + std_varphi_smallnoise2 ** 2)
    pi2CI2size = 2 * 1.96 * piSD2
    print(np.mean(pi2CI2size))
    pi2CI2left = pi - pi2CI2size / 2
    pi2CI2right = pi + pi2CI2size / 2
    pi2CI2coverage = np.logical_and(pi2CI2left < 1, pi2CI2right > 1)
    print(np.mean(pi2CI2coverage))

#### Non zero residual noise
##### Model 1
###### CI1
    [QMLEreserrResNoise, QMLEreserrResNoiseSummary] = studentization(estimator=QMLEreserr.noise_estimator.values,target=0, SD=1, print0=1)
    QMLEreserrCI1size = 2*1.96*QMLEerrSDResNoiseFeasible
    print(np.mean(QMLEreserrCI1size))
    QMLEreserrCI1left = QMLEreserr.noise_estimator.values - QMLEreserrCI1size/2
    QMLEreserrCI1right = QMLEreserr.noise_estimator.values + QMLEreserrCI1size / 2
    QMLEreserrCI1coverage = np.logical_and(QMLEreserrCI1left < mod1varres, QMLEreserrCI1right > mod1varres)
    print(np.mean(QMLEreserrCI1coverage))

    pires = np.zeros(M)
    varExplainedres = np.zeros(M)
    for i in range(M):
        pires[i] = 1 - QMLEreserr.noise_estimator[i] / (QMLEreserr.noise_estimator[i] + np.var(2* QMLEreserr.knownNoise_estimatedvalue1[i] * mod1explained[i]))
        varExplainedres[i] = np.var(2 * QMLEreserr.knownNoise_estimatedvalue1[i] * mod1explained[i])
    [piresSummary1, piresSummary2] = studentization(estimator=pires, target=.9, SD=1,print0=1)
    piresSD = n ** (-3 / 2) / varExplainedres * np.sqrt(Qestres * T)
    piresCI1size = 2 * 1.96 * piresSD
    print(np.mean(piresCI1size))
    piresCI1left = pires - piresCI1size / 2
    piresCI1right = pires + piresCI1size / 2
    piresCI1coverage = np.logical_and(piresCI1left < .9, piresCI1right > .9)
    print(np.mean(piresCI1coverage))
###### CI2
    eta_smallnoiseres = abs(n * QMLEreserr.noise_estimator.values) / T
    sigma2_smallnoiseres = QMLEreserr.values / T
    phi_smallnoiseres = 1 - 1 / (2 * eta_smallnoiseres) * (
    np.sqrt(sigma2_smallnoiseres * (4 * eta_smallnoiseres + sigma2_smallnoiseres)) - sigma2_smallnoiseres)
    gamma2_smallnoiseres = eta_smallnoiseres / phi_smallnoiseres
    var_smallnoiseres = QMLEerrSDResNoiseFeasible ** 2 + n ** (-3) * (
    phi_smallnoiseres ** 2 * (2 - phi_smallnoiseres ** 2) * Qestres * T / (
    1 - phi_smallnoiseres ** 2) ** 2 + gamma2_smallnoiseres ** 2 * phi_smallnoiseres * (1 + phi_smallnoiseres ** 2) * (
    phi_smallnoiseres ** 2 + 3 * phi_smallnoiseres + 4) / (1 + phi_smallnoiseres) ** 3 * T ** 2)
    QMLEreserrSDResNoise2Feasible = np.sqrt(var_smallnoiseres)
    QMLEreserrCI2size = 2 * 1.96 * QMLEreserrSDResNoise2Feasible
    print(np.mean(QMLEreserrCI2size))
    QMLEreserrCI2left = QMLEreserr.noise_estimator.values - QMLEreserrCI2size / 2
    QMLEreserrCI2right = QMLEreserr.noise_estimator.values + QMLEreserrCI2size / 2
    QMLEreserrCI2coverage = np.logical_and(QMLEreserrCI2left < mod1varres, QMLEreserrCI2right > mod1varres)
    print(np.mean(QMLEreserrCI2coverage))
    std_varphi_smallnoiseres = n ** (-1) * QMLEreserr.noise_estimator.values /varExplainedres * np.sqrt((QMLEreserr.values + 3 * eta_smallnoiseres) / UthetaS)/ QMLEreserr.knownNoise_estimatedvalue1  # last term comes from the delta method applied to varExp
    piresSD2 = np.sqrt(var_smallnoiseres / varExplainedres ** 2 + std_varphi_smallnoiseres ** 2)
    piresCI2size = 2 * 1.96 * piresSD2
    print(np.mean(piresCI2size))
    piresCI2left = pires - piresCI2size / 2
    piresCI2right = pires + piresCI2size / 2
    piresCI2coverage = np.logical_and(piresCI2left < .9, piresCI2right > .9)
    print(np.mean(piresCI2coverage))
###### CI3
    QMLEreserrCI3size = 2 * 1.96 * QMLEreserrSDResNoiseFeasible
    print(np.mean(QMLEreserrCI3size))
    QMLEreserrCI3left = QMLEreserr.noise_estimator.values - QMLEreserrCI3size / 2
    QMLEreserrCI3right = QMLEreserr.noise_estimator.values + QMLEreserrCI3size / 2
    QMLEreserrCI3coverage = np.logical_and(QMLEreserrCI3left < 0, QMLEreserrCI3right > 0)
    print(np.mean(QMLEreserrCI3coverage))
    std_varphi_largenoiseres = n**(-1/2)*np.sqrt(abs(QMLEreserr.noise_estimator.values)/UthetaS)
    piSD3res = np.sqrt(4*abs(QMLEreserr.noise_estimator.values)**4/((2*QMLEreserr.knownNoise_estimatedvalue1)**2*varExplainedres**2)*std_varphi_largenoiseres**2 + 1/varExplainedres**2*QMLEreserrSDResNoiseFeasible**2)
    piCI3sizeres = 2 * 1.96 * piSD3res
    print(np.mean(piCI3sizeres))
    piCI3leftres = pires - piCI3sizeres / 2
    piCI3rightres = pires + piCI3sizeres / 2
    piCI3coverageres = np.logical_and(piCI3leftres < .9, piCI3rightres > .9)
    print(np.mean(piCI3coverageres))
##### Model 2
###### CI1
    [QMLE2reserrResNoise, QMLE2reserrResNoiseSummary] = studentization(estimator=QMLE2reserr.noise_estimator.values,target=0, SD=1, print0=1)
    QMLE2reserrCI1size = 2*1.96*QMLE2errSDResNoiseFeasible
    print(np.mean(QMLE2reserrCI1size))
    QMLE2reserrCI1left = QMLE2reserr.noise_estimator.values - QMLE2reserrCI1size/2
    QMLE2reserrCI1right = QMLE2reserr.noise_estimator.values + QMLE2reserrCI1size / 2
    QMLE2reserrCI1coverage = np.logical_and(QMLE2reserrCI1left < mod1varres, QMLE2reserrCI1right > mod1varres)
    print(np.mean(QMLE2reserrCI1coverage))
    pi2res = np.zeros(M)
    varExplained2res = np.zeros(M)
    for i in range(M):
        varExplained2res[i] = np.var(QMLE2reserr.knownNoise_estimatedvalue1[i] * mod2infoT[i] + QMLE2reserr.knownNoise_estimatedvalue2[i] * mod2infoS[i])
        pi2res[i] = 1 - QMLE2reserr.noise_estimator[i] / (
        QMLE2reserr.noise_estimator[i] + varExplained2res[i])
    [pi2resSummary1, pi2resSummary2] = studentization(estimator=pi2res, target=.9, SD=1,print0=1)
    pi2resSD = n ** (-3 / 2) / varExplained2res * np.sqrt(Q2estres * T)
    pi2resCI1size = 2 * 1.96 * pi2resSD
    print(np.mean(pi2resCI1size))
    pi2resCI1left = pi2res - pi2resCI1size / 2
    pi2resCI1right = pi2res + pi2resCI1size / 2
    pi2resCI1coverage = np.logical_and(pi2resCI1left < .9, pi2resCI1right > .9)
    print(np.mean(pi2resCI1coverage))
###### CI2
    eta_smallnoiseres2 = abs(n * QMLE2reserr.noise_estimator.values) / T
    sigma2_smallnoiseres2 = QMLE2reserr.values / T
    phi_smallnoiseres2 = 1 - 1 / (2 * eta_smallnoiseres2) * (
    np.sqrt(sigma2_smallnoiseres2 * (4 * eta_smallnoiseres2 + sigma2_smallnoiseres2)) - sigma2_smallnoiseres2)
    gamma2_smallnoiseres2 = eta_smallnoiseres2 / phi_smallnoiseres2
    var_smallnoiseres2 = QMLE2errSDResNoiseFeasible ** 2 + n ** (-3) * (
    phi_smallnoiseres2 ** 2 * (2 - phi_smallnoiseres2 ** 2) * Q2estres * T / (
    1 - phi_smallnoiseres2 ** 2) ** 2 + gamma2_smallnoiseres2 ** 2 * phi_smallnoiseres2 * (1 + phi_smallnoiseres2 ** 2) * (
    phi_smallnoiseres2 ** 2 + 3 * phi_smallnoiseres2 + 4) / (1 + phi_smallnoiseres2) ** 3 * T ** 2)
    QMLE2reserrSDResNoise2Feasible = np.sqrt(var_smallnoiseres2)
    QMLE2reserrCI2size = 2 * 1.96 * QMLE2reserrSDResNoise2Feasible
    print(np.mean(QMLE2reserrCI2size))
    QMLE2reserrCI2left = QMLE2reserr.noise_estimator.values - QMLE2reserrCI2size / 2
    QMLE2reserrCI2right = QMLE2reserr.noise_estimator.values + QMLE2reserrCI2size / 2
    QMLE2reserrCI2coverage = np.logical_and(QMLE2reserrCI2left < mod2varres, QMLE2reserrCI2right > mod2varres)
    print(np.mean(QMLE2reserrCI2coverage))
    std_varphi_smallnoiseres2 = 0
    pi2resSD2 = np.sqrt(var_smallnoiseres2 / varExplained2res ** 2 + std_varphi_smallnoiseres2 ** 2)
    pi2resCI2size = 2 * 1.96 * pi2resSD2
    print(np.mean(pi2resCI2size))
    pi2resCI2left = pi2res - pi2resCI2size / 2
    pi2resCI2right = pi2res + pi2resCI2size / 2
    pi2resCI2coverage = np.logical_and(pi2resCI2left < .9, pi2resCI2right > .9)
    print(np.mean(pi2resCI2coverage))
### finite sample fit: estimation with the general model
    sim.Y = mod1obsprice
    sim.info = TI
    sim.spread = tick * spread
    sim.ts = sim.obsTimes / (T / dailySeconds)
    sim.volume = volume
    sim.volLim = depth
    QMLEfit1 = Vol_QMLE(start, end, sim.__dict__)
    QMLEfit1.estim(infotype="spreadRollVolTsVollim")
    print("P1 mean: ", np.mean(QMLEfit1.knownNoise_estimatedvalue1))
    print("P2 mean: ", np.mean(2 * QMLEfit1.knownNoise_estimatedvalue2))
    print("P3 mean: ", np.mean(QMLEfit1.knownNoise_estimatedvalue3))
    print("P4 mean: ", np.mean(QMLEfit1.knownNoise_estimatedvalue4))
    print("P5 mean: ", np.mean(QMLEfit1.knownNoise_estimatedvalue5))
    print("P1 std: ", np.std(QMLEfit1.knownNoise_estimatedvalue1))
    print("P2 std: ", np.std(2 * QMLEfit1.knownNoise_estimatedvalue2))
    print("P3 std: ", np.std(QMLEfit1.knownNoise_estimatedvalue3))
    print("P4 std: ", np.std(QMLEfit1.knownNoise_estimatedvalue4))
    print("P5 std: ", np.std(QMLEfit1.knownNoise_estimatedvalue5))

    sim.Y = mod1resobsprice
    QMLEfit1res = Vol_QMLE(start, end, sim.__dict__)
    QMLEfit1res.estim(infotype="spreadRollVolTsVollim")
    print("P1 mean: ", np.mean(QMLEfit1res.knownNoise_estimatedvalue1))
    print("P2 mean: ", np.mean(2 * QMLEfit1res.knownNoise_estimatedvalue2))
    print("P3 mean: ", np.mean(QMLEfit1res.knownNoise_estimatedvalue3))
    print("P4 mean: ", np.mean(QMLEfit1res.knownNoise_estimatedvalue4))
    print("P5 mean: ", np.mean(QMLEfit1res.knownNoise_estimatedvalue5))
    print("P1 std: ", np.std(QMLEfit1res.knownNoise_estimatedvalue1))
    print("P2 std: ", np.std(2 * QMLEfit1res.knownNoise_estimatedvalue2))
    print("P3 std: ", np.std(QMLEfit1res.knownNoise_estimatedvalue3))
    print("P4 std: ", np.std(QMLEfit1res.knownNoise_estimatedvalue4))
    print("P5 std: ", np.std(QMLEfit1res.knownNoise_estimatedvalue5))

    sim.Y = mod2obsprice
    QMLEfit2 = Vol_QMLE(start, end, sim.__dict__)
    QMLEfit2.estim(infotype="spreadRollVolTsVollim")
    print("P1 mean: ", np.mean(QMLEfit2.knownNoise_estimatedvalue1))
    print("P2 mean: ", np.mean(2 * QMLEfit2.knownNoise_estimatedvalue2))
    print("P3 mean: ", np.mean(QMLEfit2.knownNoise_estimatedvalue3))
    print("P4 mean: ", np.mean(QMLEfit2.knownNoise_estimatedvalue4))
    print("P5 mean: ", np.mean(QMLEfit2.knownNoise_estimatedvalue5))
    print("P1 std: ", np.std(QMLEfit2.knownNoise_estimatedvalue1))
    print("P2 std: ", np.std(2 * QMLEfit2.knownNoise_estimatedvalue2))
    print("P3 std: ", np.std(QMLEfit2.knownNoise_estimatedvalue3))
    print("P4 std: ", np.std(QMLEfit2.knownNoise_estimatedvalue4))
    print("P5 std: ", np.std(QMLEfit2.knownNoise_estimatedvalue5))

    sim.Y = mod2resobsprice
    QMLEfit2res = Vol_QMLE(start, end, sim.__dict__)
    QMLEfit2res.estim(infotype="spreadRollVolTsVollim")
    print("P1 mean: ", np.mean(QMLEfit2res.knownNoise_estimatedvalue1))
    print("P2 mean: ", np.mean(2 * QMLEfit2res.knownNoise_estimatedvalue2))
    print("P3 mean: ", np.mean(QMLEfit2res.knownNoise_estimatedvalue3))
    print("P4 mean: ", np.mean(QMLEfit2res.knownNoise_estimatedvalue4))
    print("P5 mean: ", np.mean(QMLEfit2res.knownNoise_estimatedvalue5))
    print("P1 std: ", np.std(QMLEfit2res.knownNoise_estimatedvalue1))
    print("P2 std: ", np.std(2 * QMLEfit2res.knownNoise_estimatedvalue2))
    print("P3 std: ", np.std(QMLEfit2res.knownNoise_estimatedvalue3))
    print("P4 std: ", np.std(QMLEfit2res.knownNoise_estimatedvalue4))
    print("P5 std: ", np.std(QMLEfit2res.knownNoise_estimatedvalue5))

    sim.Y = mod3obsprice
    QMLEfit3 = Vol_QMLE(start, end, sim.__dict__)
    QMLEfit3.estim(infotype="spreadRollVolTsVollim")
    print("P1 mean: ", np.mean(QMLEfit3.knownNoise_estimatedvalue1))
    print("P2 mean: ", np.mean(2 * QMLEfit3.knownNoise_estimatedvalue2))
    print("P3 mean: ", np.mean(QMLEfit3.knownNoise_estimatedvalue3))
    print("P4 mean: ", np.mean(QMLEfit3.knownNoise_estimatedvalue4))
    print("P5 mean: ", np.mean(QMLEfit3.knownNoise_estimatedvalue5))
    print("P1 std: ", np.std(QMLEfit3.knownNoise_estimatedvalue1))
    print("P2 std: ", np.std(2 * QMLEfit3.knownNoise_estimatedvalue2))
    print("P3 std: ", np.std(QMLEfit3.knownNoise_estimatedvalue3))
    print("P4 std: ", np.std(QMLEfit3.knownNoise_estimatedvalue4))
    print("P5 std: ", np.std(QMLEfit3.knownNoise_estimatedvalue5))

    sim.Y = mod3resobsprice
    QMLEfit3res = Vol_QMLE(start, end, sim.__dict__)
    QMLEfit3res.estim(infotype="spreadRollVolTsVollim")
    print("P1 mean: ", np.mean(QMLEfit3res.knownNoise_estimatedvalue1))
    print("P2 mean: ", np.mean(2 * QMLEfit3res.knownNoise_estimatedvalue2))
    print("P3 mean: ", np.mean(QMLEfit3res.knownNoise_estimatedvalue3))
    print("P4 mean: ", np.mean(QMLEfit3res.knownNoise_estimatedvalue4))
    print("P5 mean: ", np.mean(QMLEfit3res.knownNoise_estimatedvalue5))
    print("P1 std: ", np.std(QMLEfit3res.knownNoise_estimatedvalue1))
    print("P2 std: ", np.std(2 * QMLEfit3res.knownNoise_estimatedvalue2))
    print("P3 std: ", np.std(QMLEfit3res.knownNoise_estimatedvalue3))
    print("P4 std: ", np.std(QMLEfit3res.knownNoise_estimatedvalue4))
    print("P5 std: ", np.std(QMLEfit3res.knownNoise_estimatedvalue5))
### Information criteria
    model=21
    sim.info = TI
    sim.spread = tick * spread
    sim.ts = sim.obsTimes / (T / dailySeconds)
    sim.volume = volume
    sim.volLim = depth

    if model==10:
        sim.Y = mod1obsprice
    if model==20:
        sim.Y = mod2obsprice
    if model==30:
        sim.Y = mod3obsprice
    if model==11:
        sim.Y = mod1resobsprice
    if model==21:
        sim.Y = mod2resobsprice
    if model==31:
        sim.Y = mod3resobsprice
    QMLEIC11 = Vol_QMLE(start, end, sim.__dict__)
    QMLEIC11.estim(infotype="spread",returnLogLik=True)
    BIC11= np.log(sim.nbObs) - 2*QMLEIC11.loglik
    QMLEIC12 = Vol_QMLE(start, end, sim.__dict__)
    QMLEIC12.estim(infotype="spreadRoll", returnLogLik=True)
    BIC12 = 2*np.log(sim.nbObs) - 2 * QMLEIC12.loglik
    QMLEIC13 = Vol_QMLE(start, end, sim.__dict__)
    QMLEIC13.estim(infotype="spreadRollTs", returnLogLik=True)
    BIC13 = 3 * np.log(sim.nbObs) - 2 * QMLEIC13.loglik
    QMLEIC15 = Vol_QMLE(start, end, sim.__dict__)
    QMLEIC15.estim(infotype="spreadRollVolTsVollim", returnLogLik=True)
    BIC15 = 5 * np.log(sim.nbObs) - 2 * QMLEIC15.loglik
    BIC1min=np.zeros(M)
    for i in range(M):
        BIC1min[i] = min(BIC11[i],BIC12[i],BIC13[i],BIC15[i])
    minBIC11 = (BIC1min == BIC11)
    minBIC12 = (BIC1min == BIC12)
    minBIC13 = (BIC1min == BIC13)
    minBIC15 = (BIC1min == BIC15)
    print("BIC1 mean: ", np.mean(BIC11))
    print("BIC2 mean: ", np.mean(BIC12))
    print("BIC3 mean: ", np.mean(BIC13))
    print("BIC5 mean: ", np.mean(BIC15))
    print("propBIC1 mean: ", np.mean(minBIC11))
    print("propBIC2 mean: ", np.mean(minBIC12))
    print("propBIC3 mean: ", np.mean(minBIC13))
    print("propBIC5 mean: ", np.mean(minBIC15))
    GIC111 = np.sqrt(sim.nbObs) - 2 * QMLEIC11.loglik
    GIC112 = 2 * np.sqrt(sim.nbObs) - 2 * QMLEIC12.loglik
    GIC113 = 3 * np.sqrt(sim.nbObs) - 2 * QMLEIC13.loglik
    GIC115 = 5 * np.sqrt(sim.nbObs) - 2 * QMLEIC15.loglik
    GIC11min = np.zeros(M)
    for i in range(M):
        GIC11min[i] = min(GIC111[i], GIC112[i], GIC113[i], GIC115[i])
    minGIC111 = (GIC11min == GIC111)
    minGIC112 = (GIC11min == GIC112)
    minGIC113 = (GIC11min == GIC113)
    minGIC115 = (GIC11min == GIC115)
    print("GIC11 mean: ", np.mean(GIC111))
    print("GIC12 mean: ", np.mean(GIC112))
    print("GIC13 mean: ", np.mean(GIC113))
    print("GIC15 mean: ", np.mean(GIC115))
    print("propGIC11 mean: ", np.mean(minGIC111))
    print("propGIC12 mean: ", np.mean(minGIC112))
    print("propGIC13 mean: ", np.mean(minGIC113))
    print("propGIC15 mean: ", np.mean(minGIC115))
    GIC211 = (sim.nbObs ** (2/3)) - 2 * QMLEIC11.loglik
    GIC212 = 2 * (sim.nbObs ** (2/3)) - 2 * QMLEIC12.loglik
    GIC213 = 3 * (sim.nbObs ** (2/3)) - 2 * QMLEIC13.loglik
    GIC215 = 5 * (sim.nbObs ** (2/3)) - 2 * QMLEIC15.loglik
    GIC21min = np.zeros(M)
    for i in range(M):
        GIC21min[i] = min(GIC211[i], GIC212[i], GIC213[i], GIC215[i])
    minGIC211 = (GIC21min == GIC211)
    minGIC212 = (GIC21min == GIC212)
    minGIC213 = (GIC21min == GIC213)
    minGIC215 = (GIC21min == GIC215)
    print("GIC21 mean: ", np.mean(GIC211))
    print("GIC22 mean: ", np.mean(GIC212))
    print("GIC23 mean: ", np.mean(GIC213))
    print("GIC25 mean: ", np.mean(GIC215))
    print("propGIC21 mean: ", np.mean(minGIC211))
    print("propGIC22 mean: ", np.mean(minGIC212))
    print("propGIC23 mean: ", np.mean(minGIC213))
    print("propGIC25 mean: ", np.mean(minGIC215))
### volatility estimation
    sim.Y = modmixobsprice
    QMLEroll = Vol_QMLE(start, end, sim.__dict__)
    QMLEroll.estim(infotype="roll")
    QMLEspread = Vol_QMLE(start, end, sim.__dict__)
    QMLEspread.estim(infotype="spread")
    QMLEts = Vol_QMLE(start, end, sim.__dict__)
    QMLEts.estim(infotype="ts")
    QMLEspreadRoll = Vol_QMLE(start, end, sim.__dict__)
    QMLEspreadRoll.estim(infotype="spreadRoll")
    QMLEspreadRollTs = Vol_QMLE(start, end, sim.__dict__)
    QMLEspreadRollTs.estim(infotype="spreadRollTs")
    QMLEgeneral = Vol_QMLE(start, end, sim.__dict__)
    QMLEgeneral.estim(infotype="spreadRollVolTsVollim")
    QMLE = Vol_QMLE(start, end, sim.__dict__)
    QMLE.estim()
    PAE = Vol_PA(0, -1, sim.__dict__)
    PAE.setParam()
    PAE.estim()
    kernel_type = "th2"
    RK = Vol_RK(0, -1, sim.__dict__)
    RK.setParam(kernel_type, "adaptive", Quart_PA, Vol_PA, Noise_Realized)
    RK.estim()

    np.mean(QMLEroll - IV)
    np.std(QMLEroll - IV)
    np.mean(QMLEspread - IV)
    np.std(QMLEspread - IV)
    np.mean(QMLEts - IV)
    np.std(QMLEts - IV)
    np.mean(QMLEspreadRoll - IV)
    np.std(QMLEspreadRoll - IV)
    np.mean(QMLEspreadRollTs - IV)
    np.std(QMLEspreadRollTs - IV)
    np.mean(QMLEgeneral - IV)
    np.std(QMLEgeneral - IV)
    np.mean(QMLE - IV)
    np.std(QMLE - IV)
    np.mean(PAE - IV)
    np.std(PAE - IV)
    np.mean(RK - IV)
    np.std(RK - IV)

#### construction of QMLEBIC

    QMLEIC12 = Vol_QMLE(start, end, sim.__dict__)
    QMLEIC12.estim(infotype="spreadRoll", returnLogLik=True)
    BIC12 = 2*np.log(sim.nbObs) - 2 * QMLEIC12.loglik
    QMLEIC13 = Vol_QMLE(start, end, sim.__dict__)
    QMLEIC13.estim(infotype="spreadRollTs", returnLogLik=True)
    BIC13 = 3 * np.log(sim.nbObs) - 2 * QMLEIC13.loglik
    QMLEIC15 = Vol_QMLE(start, end, sim.__dict__)
    QMLEIC15.estim(infotype="spreadRollVolTsVollim", returnLogLik=True)
    BIC15 = 5 * np.log(sim.nbObs) - 2 * QMLEIC15.loglik
    BIC1min=np.zeros(M)
    for i in range(M):
        BIC1min[i] = min(BIC11[i],BIC12[i],BIC13[i],BIC15[i])
    minBIC11 = (BIC1min == BIC11)
    minBIC12 = (BIC1min == BIC12)
    minBIC13 = (BIC1min == BIC13)
    minBIC15 = (BIC1min == BIC15)
    print("BIC1 mean: ", np.mean(BIC11))
    print("BIC2 mean: ", np.mean(BIC12))
    print("BIC3 mean: ", np.mean(BIC13))
    print("BIC5 mean: ", np.mean(BIC15))
    print("propBIC1 mean: ", np.mean(minBIC11))
    print("propBIC2 mean: ", np.mean(minBIC12))
    print("propBIC3 mean: ", np.mean(minBIC13))
    print("propBIC5 mean: ", np.mean(minBIC15))

##################### OLD VERSION
model=1 # 0 for Roll, 1 for signed spread model
if model == 0:
    knownnoiseparam=0.0001
if model == 1:
    knownnoiseparam=0.80
    meanHalfSpread = 0.000125
    varHalfSpread = 10 ** (-8)
    ARparam = 0.6
regular_obs = 1 # 1 for regular observations, 0 for non regular

#### time-varying volatility and no price jumps
#####Parameters for the Heston
mu = 0.03
rho = -0.75
kappa = 5
gamma = 0.4
alpha = 0.1 #i.e. mean volatility ** 2

#####Parameters for the jump
jump_size = .5 #in % of the vol
jump_start,jump_end = 0,1
jump_mode = "unif"

####Parameters for the daily U-shaped vol
A = 0.75
B = 0.25
C = 0.88929198
a = 10.0
b = 10.0

sigma = 1#np.sqrt(0.1)

def riemann(g,k=500):
    return np.sum([g(i/k) for i in range(k)])*1/k

def sigma_u(x):
    return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma

tab = np.array([sigma_u(i/100) for i in np.arange(100)])


def sigma_u_jumps(x):
    if x <= 0.5:
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma
    else :
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma-0.5*sigma

priceArgs = [mu, kappa, alpha, gamma, rho, sigma_u, [jump_size,jump_start,jump_end], jump_mode]

if regular_obs == 1:
    sim = Simulator(samplingfreq,M,d,dailySeconds,T)
if regular_obs == 0:
    sim = Simulator(samplingfreq,M,d,dailySeconds,T, regular_obs=0)
    sim.simulObsTimes()
if model == 0:
    sim.simulGlobal(priceFun=sim.simulSVHeston,priceArgs=priceArgs,noiseFun=sim.simulNoiseIID,noiseArgs=[varerror,start,end,T],  knownNoiseArgs=knownnoiseparam, infotype="roll", recordMode=True)
if model == 1:
    sim.simulGlobal(priceFun=sim.simulSVHeston,priceArgs=priceArgs,noiseFun=sim.simulNoiseIID,noiseArgs=[varerror,start,end,T],  knownNoiseArgs=knownnoiseparam, infotype="spread", recordMode=True)
    spread=sim.spread
obsprice=sim.Y
info= sim.info

#### time-varying volatility and price jumps (add the code that follows to obtain jumps)
lambda_jump = T
size_jump = np.sqrt((volatility ** 2)*T)# around 50 percent of the total quadratic variation
time_jump = np.random.exponential(lambda_jump, (M,10))
for i in range(M):
    nfin = 0
    if regular_obs == 1:
        nfin = n
    if regular_obs == 0:
        nfin = sim.nbObs[i]
    time_next_jump = time_jump[i][0]
    ind = 0
    while time_next_jump < T :
        positive_jump = np.random.binomial(1,0.5)
        if regular_obs == 1:
            time_jump_discrete = int(n*time_next_jump/T)
        if regular_obs == 0:
            time_jump_discrete = min(range(len(sim.obsTimes[i])), key=abs(sim.obsTimes[i] - time_next_jump).__getitem__)
        if positive_jump:
            obsprice[i][time_jump_discrete:n] = obsprice[i][time_jump_discrete:n] + size_jump
        else:
            obsprice[i][time_jump_discrete:n] = obsprice[i][time_jump_discrete:n] - size_jump
        ind += 1
        time_next_jump += time_jump[i][ind]

# estimation
QMLE = Vol_QMLE(start, end, sim.__dict__)
QMLE.estim()

QMLEerr = Vol_QMLE(start, end, sim.__dict__)
QMLEerr.estim(infotype="spread")
explained_variance_spread = np.zeros(M)
residual_noise_spread= np.zeros(M)
for i in range(M):
    explained_variance_spread[i] = 1 - QMLEerr.noise_estimator[i] / (QMLEerr.noise_estimator[i] + np.var(QMLEerr.knownNoise_estimatedvalue1[i] * spread[i] * info[i]))
    residual_noise_spread[i] = QMLEerr.noise_estimator[i]
print("explained variance QMLE dynamic Roll:", explained_variance_spread)
print("residual noise QMLE dynamic Roll:",residual_noise_spread)

QMLESpreadRoll = Vol_QMLE(start, end, sim.__dict__)
QMLESpreadRoll.estim(infotype="spreadRoll")
explained_variance_spreadRoll = np.zeros(M)
for i in range(M):
    explained_variance_spreadRoll[i] = 1 - QMLESpreadRoll.noise_estimator[i] / (QMLESpreadRoll.noise_estimator[i] + np.var(
        QMLESpreadRoll.knownNoise_estimatedvalue2[i] * spread[i] * info[i] + QMLESpreadRoll.knownNoise_estimatedvalue1[i] * info[i]))
print("explained variance spreadRoll:", explained_variance_spreadRoll)

QMLERoll = Vol_QMLE(start, end, sim.__dict__)
QMLERoll.estim(infotype="roll")
explained_variance_roll = np.zeros(M)
for i in range(M):
    explained_variance_roll[i] = 1 - QMLERoll.noise_estimator[i] / (QMLERoll.noise_estimator[i] + np.var(
        QMLERoll.knownNoise_estimatedvalue[i] * info[i]))
print("explained variance Roll:", explained_variance_roll)

# confidence interval assuming residual noise is zero
theor_std_noise = T * volatility ** 2/(n ** (3/2))
#quarticity = T * (volatility ** 4)
std_pi = np.zeros(M)
for i in range(M):
    std_pi[i] = theor_std_noise/((QMLEerr.noise_estimator[i] + np.var(QMLEerr.knownNoise_estimatedvalue1[i] * spread[i] * info[i]))-QMLEerr.noise_estimator[i])
confIntLow = explained_variance_spread - 1.96 * std_pi
confIntUp = explained_variance_spread + 1.96 * std_pi

#confindence interval assuming variance of residual noise is fixed
theor_std_noise2 = np.sqrt(2) * varerror/(n ** (1/2))
std_pi2 = np.zeros(M)
for i in range(M):
    std_pi2[i] = theor_std_noise/((QMLEerr.noise_estimator[i] + np.var(QMLEerr.knownNoise_estimatedvalue1[i] * spread[i] * info[i]))-QMLEerr.noise_estimator[i])
confIntLow2 = explained_variance_spread - 1.96 * std_pi
confIntUp2 = explained_variance_spread + 1.96 * std_pi

### Noise estimator RV/2n on the estimated price
estimate = (T * (volatility ** 2))/(2*n)
o = effprice + error
res_est = np.zeros(M)
for i in range(M):
    res_est[i] = - (1/(2*n))*np.sum(np.diff(o[i][0:(n-1)]) * np.diff(o[i][1:n]))

### RV
RV = np.zeros(M)
for i in range(M):
    RV[i] = np.sum(np.diff(effprice0[i]) ** 2)
studentization(estimator=RV,target=IV, SD=np.sqrt(2*IV4), print0=1)