% Matlab code for gdls_multiple %
%data = load(filename); % insert filename
rng(2017)

data = load('/home/4059944817/Downloads/fourier/hadcrust.txt'); 
y = data(:,3);
pd = 1; 
%{
pd =0 for constant only 
pd=1 for both constant and trend
%}

ma = 0;  
%{
ma = 0 for the upper biased estimator 
ma= 1 for the median unbiased estimator
%}

maxn = 3; 
%{
Select the maximum number of frequencies from {1,2,3,4,5}
%}

sig = 0; 
%{
Select the siginificance level for the sequential procedure
          sig = 0 for  1 
              = 1 for  5 
              = 2 for 10 
%}

T = size(y,1); %the number of observations   

maxp = round(12*(T/100)^(1/4)); %maximum number of lag length   

%Please do not change the following code

if sig == 0
    cv = chi2inv(0.99,2); % 1% critical value
elseif sig == 1
    cv = chi2inv(0.95,2); % 5% critical value
elseif sig == 2
    cv = chi2inv(0.90,2); % 10% critical value
end
constant = ones(T,1); 
trend = (1:T)';
seqamaxn = (1:maxn)';
sint=sin(2*pi*trend*seqamaxn'/T); % check
cost=cos(2*pi*trend*seqamaxn'/T);

vwald = zeros(maxn,1); 
iwald = zeros(maxn,1);

n=1;
while n<=maxn
    if pd==0
        reg = horzcat(constant,sint(:,1:n),cost(:,1:n));
        if n==1
            R1 = horzcat(zeros(2,1),[1;0],[0;1]);
        else
            R1 = horzcat(zeros(2,1),zeros(2,(n-1)),[1;0],zeros(2,(n-1)),[0;1]);
        end
    elseif pd==1
        reg = horzcat(constant,trend,sint(:,1:n),cost(:,1:n));
        if n==1
            R1 = horzcat(zeros(2,2),[1;0],[0;1]);
        else
            R1 = horzcat(zeros(2,2),zeros(2,(n-1)),[1;0],zeros(2,(n-1)),[0;1]);
        end
    end
	cbbar21 = cbbar(n,pd); 
    khat = mic1(y,reg,cbbar21,0,maxp,0); %modified AIC
    [ahat,amu] = RF(y,khat,pd,n,ma);
    [b, VCV] = QFGLS(y,reg,khat,amu);
    vwald(n) = (R1*b)'*inv(R1*VCV*R1')*(R1*b);
    iwald(n) = vwald(n)>cv; %modify(must)
    n=n+1;
end

sumwald = sum(iwald);
if sumwald == 0
    nhat = 0;
elseif sumwald > 0
	[maxflip,maxindc] = max(flip(iwald));
    nhat = maxn-(maxindc-1);
end

% Output
disp('Estimation Results(general to specific)');
n = nhat;
X = ['n                     =', num2str(nhat)];
disp(X);

if n == 0
	disp('n=0(no nonlinearity)');

elseif n > 0
    if pd == 0
        reg = horzcat(constant,sint(:,1:n),cost(:,1:n));
    elseif pd == 1
        reg = horzcat(constant,trend,sint(:,1:n),cost(:,1:n));
    end
    cbbar21 = cbbar(n,pd);
    khat = mic1(y,reg,cbbar21,0,maxp,0);
    [ahat,amu] = RF(y,khat,pd,n,ma);
    [b,VCV] = QFGLS(y,reg,khat,amu);
    std_n = sqrt(diag(VCV)); %I rewite because of competitive function
    X = ['alpha(OLS)            =', num2str(ahat)];
    disp(X);
    
    if ma == 1
        X = ['alpha(median unbiased)=' , num2str(amu)];
        disp(X);
    elseif ma == 0
        X = ['alpha(upper biased)   =', num2str(amu)];
        disp(X);
    end
    
	CR=(T^0.5)*abs(amu-1);	
    amus=amu*(CR>1)+1*(CR<=1);
    X = ['alpha(super efficient)=', num2str(amus)];
    disp(X);
    disp('        coef    std');
    X = ['constant  ', num2str(b(1)),'     ', num2str(std_n(1))];
    disp(X);
    if pd == 1
        X = ['trend  ', num2str(b(2)),'     ', num2str(std_n(2))];
        disp(X);
    end
    i=1;
    while i<=n
        X = ['sin(2*pi*' i '/T) ', num2str(b(i+pd+1)),'     ', num2str(std_n(i+pd+1))];
        disp(X);
        X = ['cos(2*pi*' i '/T) ', num2str(b(n+i+pd+1)),'     ', num2str(std_n(n+i+pd+1))];
        disp(X);
    i=i+1;
    end
end
disp('Note that when alpha(super Efficient)=1, the constant term is not estimated.');

%Define functions used above
%lagn(x,n) => x{t-n}
function y = lagn(x,n)
	if n>0
		y = [zeros(n,size(x,2)) ; trimr(x,0,n)]; 
    else
		y = [trimr(x,abs(n),0) ; zeros(abs(n),size(x,2))];
	end
end

%diffe(x,n) with n>0 => x{t}-x{t-n} 
function y = diffe(x,n) %diff function in matlab
	if n==0
		y = x;
    else
		y = [zeros(n,size(x,2)) ; trimr(x,n,0) - trimr(lagn(x,n),n,0)];
	end
end

%{
This function is to take the autocovariance functions of x as
ACF(x) = [R(0), R(1),...,R(T-1)]". Thus, R[1]=R(0), R[2]=R(1), and so on
%} 
function R = ACV(x)
    T = size(x,1);
    R = zeros(T,1); 
    xbar = mean(x)';  %meanc
    i = 1;
    while i <= T
        j = i-1;
        R(i) = (x(1:T-j,1)-xbar)'*(x(1+j:T,1)-xbar)/T;
        i = i+1;    
    end
end

%Andrews'(1991) method using Quadratic Spectral window
function h0 = h0W(x)
    T=size(x,1);  
    %[C,R] = qr(x(2:T),x(1:T-1));
    %b=R\C; %olsqr(may need to be fixed?)
    b=x(1:T-1)\x(2:T);
    a=(4*(b^2))/((1-b)^4);
    R = ACV(x);
    lamda = zeros(T-1,1);
    s=(1:T-1)';
    m = 1.3221*((a*T)^(1/5));
    delta = (6*pi*s)/(5*m);
    i=1;
    while i<=T-1
        lamda(i) = 3*((sin(delta(i))/delta(i))-cos(delta(i)))/(delta(i)^2);
        i = i+1;
    end
    h0 = (R(1) + 2*lamda'*R(2:T,1));   
end

%the values of Tau50 and Tau85 for the case of multiple frequencies@
function [t50,t85] = pct(n,pd)
    if pd == 0
        if n == 1
            t50 = -2.3918; t85 = -3.2567;
        elseif n == 2
            t50 = -2.9906; t85 = -3.9311;
        elseif n == 3
            t50 = -3.5081; t85 = -4.4874;
        elseif n == 4
            t50 = -3.9803; t85 = -4.9912;
        elseif n == 5
            t50 = -4.3629; t85 = -5.4442;
        end
    elseif pd == 1
        if n == 1
            t50 = -3.0861; t85 = -3.8254;
        elseif n == 2
            t50 = -3.7941; t85 = -4.5035;
        elseif n == 3
            t50 = -4.3977; t85 = -5.1021;
        elseif n == 4
            t50 = -4.9210; t85 = -5.6368;
        elseif n == 5
            t50 = -5.4066; t85 = -6.1052;
        end
    end
end

function cbbar2 = cbbar(n,pd)
    if pd == 0
        if n == 1
            cbbar2 = -12.25;
        elseif n == 2
            cbbar2 = -16.25;
        elseif n == 3
            cbbar2 = -19.50;
        elseif n == 4
            cbbar2 = -21.75;
        elseif n == 5
            cbbar2 = -24.75;
        end
    elseif pd == 1
        if n == 1
            cbbar2 = -22.00;
        elseif n == 2
            cbbar2 = -30.00;
        elseif n == 3
            cbbar2 = -36.25;
        elseif n == 4
            cbbar2 = -42.50;
        elseif n == 5
            cbbar2 = -46.75;
        end
    end
end

%{
Roy-Fuller estimator
x: dependent variable
p: lag length
%}
function [ahat,amu] = RF(x,p,pd,n,ma)
    T=size(x,1);
    dep=x; 
    
    if pd==0
        reg=[ones(T,1),sin(2*pi*(1:T)'*(1:n)/T), cos(2*pi*(1:T)'*(1:n)/T)];
    elseif pd==1
        reg=[ones(T,1),(1:T)',sin(2*pi*(1:T)'*(1:n)/T),cos(2*pi*(1:T)'*(1:n)/T)];
    end
            
    u = (eye(T)-reg*pinv(reg'*reg)*reg')*dep;             
    du = diffe(u,1);
    depa = u; 
    rega = lagn(u,1);
    i=1;
    while i<=p
        rega=[rega,lagn(du,i)];
        i=i+1;
    end 
    depa = trimr(depa,p+1,0);
    rega = trimr(rega,p+1,0);
    bhat=inv(rega'*rega)*(rega'*depa);
    ehat = depa-rega*bhat;
    ss = ehat'*ehat/size(ehat,1);
    vbhat = ss*inv(rega'*rega);
    ahat = bhat(1);
    tau1=(ahat-1)/sqrt(vbhat(1,1));

    [t50,t85]=pct(n,pd);

    if ma==1
        tpct = t50;%the median unbiased estimator
    elseif ma==0
        tpct = t85;%the upper biased estimator
    end
    
    a=10; 
    r=size(reg,2); 
    IP=round((p+2)/2); %check int function in GAUSS  
    c1=(1+r)*T;
    c2=((1+r)*T-(tpct^2)*(IP+T))/(tpct*(a+tpct)*(IP+T));
    if (tau1>tpct)
        ctau=-tau1; 
    elseif (tau1 <= tpct)*(tau1 > -a) == 1
        ctau=IP*(tau1/T)-(1+r)/(tau1+c2*(tau1+a));
    elseif (tau1 <= -a)*(tau1 > -sqrt(c1)) == 1
        ctau=IP*(tau1/T)-(1+r)/tau1;
    elseif (tau1 <= -sqrt(c1))
        ctau=0;
    end
    amu = ahat + ctau*sqrt(vbhat(1,1));
    amu= 1*(amu >= 1)+amu*(abs(amu)<1); % amu< -1 case?
end


%{
 Quasi Feasible GLS
x: dependent variable
reg: deterministic components
p: lag length
ahat: the estimate of the sum of the autoregressive coefficients
%}
function [b, VCV] = QFGLS(x,reg,p,ahat)
    T=size(x,1);
    dep=x;
    dx=diffe(x,1);
    u = (eye(T)-reg*inv(reg'*reg)*reg')*dep; 
    du = diffe(u,1);

    %---Estimation of alpha----   
    CR=(T^0.5)*abs(ahat-1);
    amus=ahat*(CR>1)+1*(CR<=1);
    ad = (1-amus^2)^0.5;

    %-----QFGLS-----
    depg=[(ad*dep(1)),(trimr(dep,1,0)-amus*trimr(dep,0,1))']';
    regg=[(ad*reg(1,:))', (trimr(reg,1,0)-amus*trimr(reg,0,1))']';
    b=pinv(regg'*regg)*regg'*depg; %use pinv alternetive of sweeping method
    v=depg-regg*b;

    %----Estimation of long-run variance---
    if (p==0)
        h0=v'*v/(size(v,1));
    elseif (p > 0)
        if (amus == 1)  
            h0 = h0W(v);
        elseif (abs(amus) < 1)
            j=1;
            while j <= p
                if (j == 1)
                    regx=[lagn(u,j), lagn(du,j)];
                else
                    regx=[regx , lagn(du,j)];
                end
                j=j+1;
            end 
            depx = u;        
            depx = trimr(u,p+1,0);    
            regx = trimr(regx,p+1,0);
            %[C,R] = qr(depx,regx); %olsqr2 in GAUSS
            coef = regx\depx;
            e = depx - regx*coef;
            fit = regx*coef;     
            h0=e'*e/size(e,1);         
        end
    end

    VCV=(h0)*pinv(regg'*regg);
end

function krule = mic1(y,reg,cbbar2,penalty,kmax,kmin)
    nt=size(y,1);
    [yt,ssra]=glsd(y,reg,cbbar2); 
    krule=s2ar(yt,penalty,kmax,kmin); 
    
end

function kopt = s2ar(yts,penalty,kmax,kmin)
    nt=size(yts,1);
    nomin=9999999999;
    tau=zeros(kmax+1,1);
    s2e=999*ones(kmax+1,1);
    dyts=diffe(yts,1);
    reg=lagn(yts,1);
    i=1;
    while i <= kmax
        reg=[reg ,lagn(dyts,i)];
    i=i+1;
    end
    dyts0=dyts;
    reg0=reg;

    %loop over k
    dyts0 = trimr(dyts,kmax+1,0);
    reg0 = trimr(reg,kmax+1,0);
    sumy=sum(reg0(:,1).*reg0(:,1)); %check .*
    nef=nt-kmax-1;
    k=kmin;
    while k <= kmax
        b=reg0(:,1:k+1)\dyts0;
        e=dyts0-reg0(:,1:k+1)*b;
        s2e(k+1)=e'*e/nef;
        tau(k+1)=(b(1)*b(1))*sumy/s2e(k+1);
        k=k+1;
    end

    kk=(0:kmax)';
    if penalty == 0
        mic=log(s2e)+2.0*(kk+tau)./nef; %aic
    else
        mic=log(s2e)+log(nef)*(kk)./nef; %bic
    end
    mic2 = mic';
    [~,minindc] = min(mic2); %check
    kopt=minindc-1;
end

function [yt,ssr]=glsd(y,z,cbbar2)
    nt=size(y,1);
    abar=1+cbbar2/nt;
    ya=zeros(nt,1);
    za=zeros(nt,size(z,2));
    ya(1:1,1)=y(1:1,1);
    za(1:1,:)=z(1:1,:);
    ya(2:nt,1)=y(2:nt,1)-abar*y(1:nt-1,1);
    za(2:nt,:)=z(2:nt,:)-abar*z(1:nt-1,:);
    bhat=inv(za'*za)*za'*ya;
    yt=y-z*bhat;
    ssr=(ya-za*bhat)'*(ya-za*bhat);
end

function z = trimr(x,n1,n2)
  [n ,~] = size(x);
  if (n1+n2) >= n
     error('Attempting to trim too much in trimr');
  end
  h1 = n1+1;   
  h2 = n-n2;
  z = x(h1:h2,:);
end