*****************************************************************
*   This program is to replicate the results in table 2
*****************************************************************

CALENDAR 1975 1 12
ALLOCATE  2007:12
open data data.xls
data(format=xls,org=columns)
/*
imp is the seasonally adjusted US import price index
ppi is the seasonally adjusted US producer price index
*/

*variables used in the regressions*
set p = ppi
set s = imp
set dp = 100*log(p/p{1})
set ds = 100*log(s/s{1})

set z1 = dp{1}
set z2 = (dp{1}+dp{2})/2
set z3 = (dp{1}+dp{2}+dp{3})/3
set z4 = (dp{1}+dp{2}+dp{3}+dp{4})/4
set z5 = (dp{1}+dp{2}+dp{3}+dp{4}+dp{5})/5
set z6 = (dp{1}+dp{2}+dp{3}+dp{4}+dp{5}+dp{6})/6


*This is the case of d=1. Choose zi for the case of d=i*
 set z = z1

 set z_1 = z
 set z_2 = z**2
 set z_3 = z**3
 set nds01 = ds*z
 set nds02 = ds*(z**2)
 set nds03 = ds*(z**3)
 set nds11 = ds{1}*z
 set nds12 = ds{1}*(z**2)
 set nds13 = ds{1}*(z**3)
 set nds21 = ds{2}*z
 set nds22 = ds{2}*(z**2)
 set nds23 = ds{2}*(z**3)
 set nds31 = ds{3}*z
 set nds32 = ds{3}*(z**2)
 set nds33 = ds{3}*(z**3)
 set nds41 = ds{4}*z
 set nds42 = ds{4}*(z**2)
 set nds43 = ds{4}*(z**3)
 set nds51 = ds{5}*z
 set nds52 = ds{5}*(z**2)
 set nds53 = ds{5}*(z**3)
 set ndp11 = dp{1}*z
 set ndp12 = dp{1}*(z**2)
 set ndp13 = dp{1}*(z**3)
 set ndp21 = dp{2}*z
 set ndp22 = dp{2}*(z**2)
 set ndp23 = dp{2}*(z**3)
 set ndp31 = dp{3}*z
 set ndp32 = dp{3}*(z**2)
 set ndp33 = dp{3}*(z**3)
 set ndp41 = dp{4}*z
 set ndp42 = dp{4}*(z**2)
 set ndp43 = dp{4}*(z**3)
 set ndp51 = dp{5}*z
 set ndp52 = dp{5}*(z**2)
 set ndp53 = dp{5}*(z**3)
 set ndp61 = dp{6}*z
 set ndp62 = dp{6}*(z**2)
 set ndp63 = dp{6}*(z**3)

linreg(noprint) dp 1975:1 2007:12
  # constant dp{1 to 6} ds{0 to 5} $
    nds01 nds02 nds03 nds11 nds12 nds13 nds21 nds22 nds23 nds31 nds32 nds33 nds41 nds42 nds43 nds51 nds52 nds53 $
    ndp11 ndp12 ndp13 ndp21 ndp22 ndp23 ndp31 ndp32 ndp33 ndp41 ndp42 ndp43 ndp51 ndp52 ndp53 ndp61 ndp62 ndp63
compute rss1 = %rss
linreg(noprint) dp 1975:1 2007:12
  # constant dp{1 to 6} ds{0 to 5} $
    nds01 nds02 nds11 nds12 nds21 nds22 nds31 nds32 nds41 nds42 nds51 nds52 $
    ndp11 ndp12 ndp21 ndp22 ndp31 ndp32 ndp41 ndp42 ndp51 ndp52 ndp61 ndp62
compute rss0 = %rss
compute df1 = 2*6
compute df2 = %nobs-4*2*6-1
compute F3 = ((rss0-rss1)/df1)/(rss0/df2)
cdf(noprint) ftest f3 df1 df2
compute pF = %SIGNIF
disp 'F3=' F3  'p-value =' pF

linreg(noprint) dp 1975:1 2007:12
  # constant dp{1 to 6} ds{0 to 5} $
    nds01 nds02 nds11 nds12 nds21 nds22 nds31 nds32 nds41 nds42 nds51 nds52 $
    ndp11 ndp12 ndp21 ndp22 ndp31 ndp32 ndp41 ndp42 ndp51 ndp52 ndp61 ndp62
compute rss1 = %rss
linreg(noprint) dp 1975:1 2007:12
  # constant dp{1 to 6} ds{0 to 5} $
    nds02 nds12 nds22 nds32 nds42 nds52 $
    ndp12 ndp22 ndp32 ndp42 ndp52 ndp62
compute rss0 = %rss
compute df1 = 2*6
compute df2 = %nobs-3*2*6-1
compute F13 = ((rss0-rss1)/df1)/(rss0/df2)
cdf(noprint) ftest f13 df1 df2
compute pF = %SIGNIF
disp 'F1|3=' F13  'p-value =' pF

linreg(noprint) dp 1975:1 2007:12
  # constant dp{1 to 6} ds{0 to 5} $
    nds01 nds02 nds03 nds11 nds12 nds13 nds21 nds22 nds23 nds31 nds32 nds33 nds41 nds42 nds43 nds51 nds52 nds53 $
    ndp11 ndp12 ndp13 ndp21 ndp22 ndp23 ndp31 ndp32 ndp33 ndp41 ndp42 ndp43 ndp51 ndp52 ndp53 ndp61 ndp62 ndp63
compute rss1 = %rss
linreg(noprint) dp 1975:1 2007:12
  # constant dp{1 to 6} ds{0 to 5} $
    nds02 nds12 nds22 nds32 nds42 nds52 $
    ndp12 ndp22 ndp32 ndp42 ndp52 ndp62
compute rss0 = %rss
compute df1 = 2*2*6
compute df2 = %nobs-4*2*6-1
compute F13 = ((rss0-rss1)/df1)/(rss0/df2)
cdf(noprint) ftest f3 df1 df2
compute pF = %SIGNIF
disp 'F13=' F13  'p-value =' pF















