*****************************************************************
*   This program is to estimate ESTAR, symmetric DLSTAR,
*   and asymmetric DLSTAR.
*****************************************************************

CALENDAR 1975 1 12
ALLOCATE  2007:12
open data data.xls
data(format=xls,org=columns)
/*
imp is the seasonally adjusted US import price index
ppi is the seasonally adjusted US producer price index
*/

*variables used in the regressions*
set p = ppi
set s = imp
set dp = 100*log(p/p{1})
set ds = 100*log(s/s{1})

*******
*ESTAR*
*******
set z = (dp{1}+dp{2}+dp{3})/3
STATISTICS(fractiles, noprint) z
compute std = sqrt(%variance)
set z_big = (z>%FRACT90)+(z<%FRACT10)

nonlin(paraset=base)  c0 $
                       bp1 bp3 bp4 $
                       bs0 bs1 bs4  bs5 $
                       c0_out  bp5_out $
                       bs2_out bs4_out gam
nonlin(paraset=const) gam>=0
frml estar1 = c0 $
             +bp1*dp{1}+bp3*dp{3}+bp4*dp{4} $
             +bs0*ds+bs1*ds{1}+bs4*ds{4}+bs5*ds{5} $
            +(c0_out+bp5_out*dp{5} $
            +(1-bs0)*ds+bs2_out*ds{2}+bs4_out*ds{4}) $
            *(1-exp(-gam*(z/std)**2))

set ds_big = z_big*ds
set ds_big1 = z_big*ds{1}
set ds_big2 = z_big*ds{2}
set ds_big3 = z_big*ds{3}
set ds_big4 = z_big*ds{4}
set ds_big5 = z_big*ds{5}
set dp_big1 = z_big*dp{1}
set dp_big2 = z_big*dp{2}
set dp_big3 = z_big*dp{3}
set dp_big4 = z_big*dp{4}
set dp_big5 = z_big*dp{5}
set dp_big6 = z_big*dp{6}
linreg(noprint) dp
  # constant dp{1 to 6} ds{0 to 5} $
    ds_big ds_big1 ds_big2 ds_big3 ds_big4 ds_big5 $
    dp_big1 dp_big2 dp_big3 dp_big4 dp_big5 dp_big6

compute c0=%beta(1), $
      bp1=%beta(2), bp2=%beta(3), bp3=%beta(4), bp4=%beta(5),  bp5=%beta(6), bp6=%beta(7),$
      bs0=%beta(8), bs1=%beta(9),bs2=%beta(10), bs3=%beta(11),bs4=%beta(12),bs5=%beta(13), $
      bs1_out=%beta(15), bs2_out=%beta(16), bs3_out=%beta(17), bs4_out=%beta(18), bs5_out=%beta(19), $
      bp1_out=%beta(20), bp2_out=%beta(21), bp3_out=%beta(22), bp4_out=%beta(23), bp5_out=%beta(24), bp6_out=%beta(25), $
      gam=1, c0_out=0
nlls(frml=estar1, paraset=base+const, iterations=300, method=gauss, subiterations=30, vcv) dp


**************************
*****Symmetric DLSTAR*****
**************************
set z = dp{1}
STATISTICS(fractiles, noprint) z
compute std = sqrt(%variance)
set z_big = (z>%FRACT90)+(z<%FRACT10)

nonlin(paraset=base)  c0  $
                       bp1 bp3 bp5 $
                       bs0 bs1 bs2 bs5 $
                       bs1_out bs2_out bs4_out bs5_out $
                       bp4_out bp5_out bp6_out $
                       gam loc
frml dlstar1 = c0 $
             +bp1*dp{1}+bp3*dp{3}+bp5*dp{5} $
             +bs0*ds+bs1*ds{1}+bs2*ds{2}+bs5*ds{5} $
             +((1-bs0)*ds+bs1_out*ds{1}+bs2_out*ds{2}+bs4_out*ds{4}+bs5_out*ds{5} $
             +bp4_out*dp{4}+bp5_out*dp{5}+bp6_out*dp{6}) $
             *(1/(1+exp(-gam*(z-loc)/std))+1/(1+exp(gam*(z+loc)/std)))

set ds_big = z_big*ds
set ds_big1 = z_big*ds{1}
set ds_big2 = z_big*ds{2}
set ds_big3 = z_big*ds{3}
set ds_big4 = z_big*ds{4}
set ds_big5 = z_big*ds{5}
set dp_big1 = z_big*dp{1}
set dp_big2 = z_big*dp{2}
set dp_big3 = z_big*dp{3}
set dp_big4 = z_big*dp{4}
set dp_big5 = z_big*dp{5}
set dp_big6 = z_big*dp{6}
linreg(noprint) dp
  # constant dp{1 to 6} ds{0 to 5} $
    ds_big ds_big1 ds_big2 ds_big3 ds_big4 ds_big5 $
    dp_big1 dp_big2 dp_big3 dp_big4 dp_big5 dp_big6

compute c0=%beta(1), c0_out=0, $
      bp1=%beta(2), bp2=%beta(3), bp3=%beta(4), bp4=%beta(5),bp5=%beta(6),bp6=%beta(7), $
      bs0=%beta(8), bs1=%beta(9),bs2=%beta(10), bs3=%beta(11),bs4=%beta(12),bs5=%beta(13), $
      bs1_out=%beta(15), bs2_out=%beta(16), bs3_out=%beta(17), bs4_out=%beta(18),bs5_out=%beta(19), $
      bp1_out=%beta(20),bp2_out=%beta(21),bp3_out=%beta(22),bp4_out=%beta(23),bp5_out=%beta(24),bp6_out=%beta(25), $
      gam=1, loc=2.0
nlls(frml=dlstar1, paraset=base, iterations=300, method=gauss, subiterations=30, vcv) dp


***************************
*****Asymmetric DLSTAR*****
***************************
set z = dp{1}
STATISTICS(fractiles, noprint) z
compute std = sqrt(%variance)
set z_big = (z>%FRACT90)+(z<%FRACT10)

nonlin(paraset=base)  c0  $
                       bp1 bp3 bp5 $
                       bs0 bs1 bs2 bs5 $
                       bs1_out bs2_out bs4_out bs5_out $
                       bp1_out bp5_out bp6_out $
                       gam1 gam2 loc1 loc2
frml dlstar2 = c0 $
               +bp1*dp{1}+bp3*dp{3}+bp5*dp{5} $
               +bs0*ds+bs1*ds{1}+bs2*ds{2}+bs5*ds{5} $
               +((1-bs0)*ds+bs1_out*ds{1}+bs2_out*ds{2}+bs4_out*ds{4}+bs5_out*ds{5} $
               +bp1_out*dp{1}+bp5_out*dp{5}+bp6_out*dp{6}) $
               *(1/(1+exp(-gam1*(z-loc1)/std))+1/(1+exp(gam2*(z+loc2)/std)))

set ds_big = z_big*ds
set ds_big1 = z_big*ds{1}
set ds_big2 = z_big*ds{2}
set ds_big3 = z_big*ds{3}
set ds_big4 = z_big*ds{4}
set ds_big5 = z_big*ds{5}
set dp_big1 = z_big*dp{1}
set dp_big2 = z_big*dp{2}
set dp_big3 = z_big*dp{3}
set dp_big4 = z_big*dp{4}
set dp_big5 = z_big*dp{5}
set dp_big6 = z_big*dp{6}
linreg(noprint) dp
  # constant dp{1 to 6} ds{0 to 5} ds_big ds_big1 ds_big2 ds_big3 ds_big4 ds_big5 dp_big1 dp_big2 dp_big3 dp_big4 dp_big5 dp_big6

compute c0=%beta(1), c0_out=0, $
      bp1=%beta(2), bp2=%beta(3), bp3=%beta(4), bp4=%beta(5),bp5=%beta(6),bp6=%beta(7), $
      bs0=%beta(8), bs1=%beta(9),bs2=%beta(10), bs3=%beta(11),bs4=%beta(12),bs5=%beta(13), $
      bs1_out=%beta(15), bs2_out=%beta(16), bs3_out=%beta(17), bs4_out=%beta(18),bs5_out=%beta(19), $
      bp1_out=%beta(20),bp2_out=%beta(21),bp3_out=%beta(22),bp4_out=%beta(23),bp5_out=%beta(24),bp6_out=%beta(25), $
      gam1=1, gam2=1, loc1=2.0, loc2=2.0
nlls(frml=dlstar2, paraset=base, iterations=300, method=gauss, subiterations=30, vcv) dp

















