//<numertools.h>
// 130614 C++流の書き換え
// 130622 一部インライン化
// 141120 GoldDivのreturn文の変更
// 150612 optsearchとsolveqの基底クラス(仮想クラス化)を移動。実装は派生クラスで定義
//   optsearchx,optsearchy,optsearchxy→getobjvalとoptprocfuncの実装が必要。     
//   solveqx,solveqxy→calvalfuncとsolvprocfuncの実装が必要。
#include <cmath>
#include <cstdio>
extern double xmin, xmax, ymin, ymax ;
extern double xini1, xini2, yini1, yini2 ;
extern double epsi0, epsi1, epsigld, misfval3 ;
extern int cntlid ;
extern FILE* outps ;
#if !defined( ___class_optsearchx )
#define ___class_optsearchx
class optsearchx {
 protected:
  double paramy, param1, param2 ;
  double xminval, xmaxval, optvalx ;
  virtual double optprocfunc( double, double ) = 0 ;
 public:
  optsearchx() ;
  virtual ~optsearchx() {}
  virtual double getobjval( double x ) = 0 ;
  double getoptvalx() const { return optvalx ; }
} ;
#endif
#if !defined( ___class_optsearchy )
#define ___class_optsearchy
class optsearchy {
 protected:
  double paramx, param1, param2 ;
  double yminval, ymaxval, optvaly ;
  virtual double optprocfunc( double, double ) = 0 ;
 public:
  optsearchy() ;
  virtual ~optsearchy() {}
  virtual double getobjval( double y ) = 0 ;
  double getoptvaly() const { return optvaly ; }
} ;
#endif
#if !defined( ___class_optsearchxy )
#define ___class_optsearchxy
class optsearchxy {
 protected:
  double param1, param2 ;
  double xminval, xmaxval, optvalx ;
  double yminval, ymaxval, optvaly ;
  virtual double optprocfunc( double, double ) = 0 ;
 public:
  optsearchxy() ;
  virtual ~optsearchxy() { } ;
  virtual double getobjval( double ) = 0 ;
  double getoptvalx() const { return optvalx ; }
  double getoptvaly() const { return optvaly ; }
} ;
#endif
#if !defined( ___class_solveqx )
#define ___class_solveqx
class solveqx {
 protected:
  double fxdat, xinival1, xinival2, solutx ;
  double yval, param1, param2 ;
  virtual double solvprocfunc( double, double ) = 0 ;
 public:
  solveqx() ;
  virtual ~solveqx() {}
  virtual double calvalfunc( double x ) = 0 ;
  double getsolutx() const { return solutx ; }
} ;
#endif
#if !defined( ___class_solveqxy )
#define ___class_solveqxy
class solveqxy {
 protected:
  double fxdat, xinival1, xinival2, solutx ;
  double fydat, yinival1, yinival2, soluty ;
  double yval, param1, param2 ;
  virtual double solvprocfunc( double, double ) = 0 ;
 public:
  solveqxy() ;
  virtual ~solveqxy() {} 
  virtual double calvalfunc( double ) = 0 ;
  double getsolutx() const { return solutx ; }
  double getsoluty() const { return soluty ; }
} ;
#endif
#if !defined( ___class_numertools )
#define ___class_numertools
class normdis {
 public:
  normdis( double x, double mean, double std ) ;
  ~normdis() {}
  double getprob() const { return prob ; }
  double getdens() const { return dens ; }
 private:
  double prob, dens ;
  double probnor( double z ) ;
  double densnor( double z ) ;
} ;
//double Secant( double x2, double y2, double x1, double y1 ) ;
inline double Secant( double x2, double y2, double x1, double y1 ) {
  return x2 - (x1 - x2) * y2 / (y1 - y2) ;
}
template <typename T>
double ProcSecant( T *md, double x1ini, double x2ini, double epsi ) {
  int i = 0 ;
  double x1 = x1ini, x2 = x2ini, newx ;
  double y1 = md->calvalfunc( x1 ), y2 = md->calvalfunc( x2 ) ;
  while (::cntlid == 0) {
//      fprintf( ::outps, "%s %10.6f %10.6f %10.6f %10.6f\n", "acmsecant", x1, y1, x2, y2 );
    if (i++ > 200) return ::misfval3 ;
    newx = Secant( x2, y2, x1, y1 ) ;
    x1 = x2 ;
    y1 = y2 ;
    x2 = newx ;
    y2 = md->calvalfunc( x2 ) ;
    if (fabs( y2 ) < epsi) return x2 ;
  }
//   fprintf( ::outps, "%s\n", "stop secant" ) ;
  return ::misfval3 ;
}
//double GoldDiv( int cntl, double rmin, double rmax ) ;
inline double GoldDiv( int cntl, double rmin, double rmax ) {
  double glddiv = 1.0 - 2.0 / (1.0 + sqrt( 5.0 )) ;
  double glddivval ;
  if (cntl == 1) glddivval = glddiv * (rmax - rmin) + rmin ;
  if (cntl == 2) glddivval = (1.0 - glddiv) * (rmax - rmin) + rmin ;
  return glddivval ;
}
template <typename T>
double ProcGoldDiv( T *md, double rmin, double rmax, double epsi ) {
  int i = 0 ;
  double x1 = GoldDiv( 1, rmin, rmax ), x2 = GoldDiv( 2, rmin, rmax ) ;
  double y1 = md->getobjval( x1 ), y2 = md->getobjval( x2 ) ;
  while (::cntlid == 0) {
//        printf( "%d %f %f %f %f\n", i, x1, y1, x2, y2 ) ;
    if ( y1 >= y2 ) {
      rmax = x2 ;
      x2 = x1 ;
      y2 = y1 ;
      x1 = GoldDiv( 1, rmin, rmax ) ;
      y1 = md->getobjval( x1 ) ;
    }
    else {
      rmin = x1 ;
      x1 = x2 ;
      y1 = y2 ;
      x2 = GoldDiv( 2, rmin, rmax ) ;
      y2 = md->getobjval( x2 ) ;
    }
    if (i++ > 200) return ::misfval3 ;
    if (fabs( x1 - x2 ) < epsi) {
//	 fprintf( ::outps, "%s %d %f %f %f %f\n", "optsearch: ", i, x1, y1, x2, y2 ) ;
      if (y1 >= y2) return x1 ;
      else return x2 ;
    }
  }
  return ::misfval3 ;
}
#endif
