#include "ndtmodel5.h"
givendata& f1() ;
firmdata& f() ;
firmdata::firmdata()
  : ez(0.0), sz(0.0), vz(0.0), covz(0.0), year(f1().year),
    bcpr(f1().bcprop), t(f1().t), ndpr(f1().ndtprop), emp(0.0), smp(0.0), 
    rf(0.0), lamb(0.0) {
  ez = f1().ez1 * year ;
  sz = f1().sz1 * sqrt( year ) ;
  vz = sz * sz ;
  emp = pow( (1.0 + f1().emp1), year ) - 1.0 ;
  smp = f1().smp1 * sqrt( year ) ;
  covz = f1().corrmpz * smp * sz ;
  rf = pow( (1.0 + f1().rf1), year ) - 1.0 ;
  lamb = ( emp - rf ) / ( smp * smp ) ;
}
basicfirm::basicfirm()
  : ufirmv(0.0), rrrfirm(0.0), ndtv(0.0),
    npb(0.0), nden(0.0), zeropb(0.0), zeroden(0.0) {
  setprob( 0.0, &zeropb, &zeroden ) ;
  ufirmv = procfirmmv() ;
  ndtv = f().ndpr * ufirmv ;
  setprob( ndtv, &npb, &nden ) ;
//   printf( "%10.5f %8.5f %8.5f\n", ufirmv, upb, zeropb ) ;
  rrrfirm = rrrequi() ;
}
basicfirm::basicfirm( const basicfirm& rhs ){
  copymembers( rhs ) ;
}
basicfirm& basicfirm::operator=( const basicfirm& rhs ){
  copymembers( rhs ) ;
  return *this ;
}
void basicfirm::copymembers( const basicfirm& oth ){
  ufirmv = oth.getufirmv() ;
  ndtv = oth.getndtv() ;
  npb = oth.getnpb() ;
  nden = oth.getnden() ;
  zeropb = oth.getzeropb() ;
  zeroden = oth.getzeroden() ;
  rrrfirm = oth.getrrr() ;
}
double basicfirm::valfirm( double fmmv ) {
  return (cffirmave( fmmv ) - f().lamb*cffirmcov( fmmv ))/(1.0 + f().rf) ; 
}
double basicfirm::cffirmave( double fmmv ) {
  double ndtvtmp = f().ndpr * fmmv ;
  double npbtmp, ndentmp ;
  setprob( ndtvtmp, &npbtmp, &ndentmp ) ;
  return f().ez*(1.0 - f().t + f().t*npbtmp - zeropb) 
    + f().vz*(zeroden - f().t*ndentmp) + f().t*ndtvtmp*(1.0 - npbtmp) ;
}
double basicfirm::cffirmcov( double fmmv ) {
  double ndtvtmp = f().ndpr * fmmv ;
  double npbtmp, ndentmp ;
  setprob( ndtvtmp, &npbtmp, &ndentmp ) ;
  return f().covz*(1.0 - f().t + f().t*npbtmp - zeropb) ;
}
double basicfirm::rrrequi() {
  return f().rf + f().lamb*cffirmcov( ufirmv )/ufirmv ; 
//   return cfequiave( x ) / equimv - 1.0 ; 
}
double basicfirm::procfirmmv() {
  double fmv ;
  ::cntlid = 0 ;
  if ((fmv = ProcSecant( this, 0.01, f().ez, ::epsi)) == ::misfval3 ) {
    printf( "%s\n", "not convergent in firm value" ) ;
    exit( 1 ) ;
  }
  return fmv ;
}
double basicfirm::calvalfunc( double fmmv ) {
  return fmmv - valfirm( fmmv ) ;
}
void basicfirm::setprob( double val, double *pb, double *den ) {
  normdis nr( val, f().ez, f().sz ) ;
  *pb = nr.getprob() ;
  *den = nr.getdens() ;
  //   printf( " %10.5f %10.5f %10.5f\n", val, *pb, *den ) ;
}
ndtmodel5::ndtmodel5( double dcash )
  : uf(), dcntl(0), dbpay(dcash), debtmv(0.0), equimv(0.0), firmmv(0.0),
    txsvmv(0.0), bkcsmv(0.0), debtrr(0.0), equirr(0.0), wacc(0.0),
    dbrati(0.0),
    lpb(0.0), lden(0.0), lb(0.0), lbpb(0.0), lbden(0.0),
    ulb(0.0), ulbpb(0.0), ulbden(0.0), phi(0.0), phipb(0.0), phiden(0.0) {
  calmodel() ;
}
ndtmodel5::ndtmodel5( const ndtmodel5& rhs ) {
  copymembers( rhs ) ;
}
ndtmodel5& ndtmodel5::operator=( const ndtmodel5& rhs ){
  copymembers( rhs ) ;
  return *this ;
}
void ndtmodel5::calmodel() {
  if (dbpay == 0.0) {
    firmmv = equimv = uf.getufirmv() ;
    wacc = equirr = uf.getrrr() ;
  }
  else {
    uf.setprob( dbpay, &lpb, &lden ) ;
    proccaldebt() ;
    if (dcntl != 0) {
      lb = dbpay - debtmv ; uf.setprob( lb, &lbpb, &lbden ) ;
      ulb = uf.getndtv() + dbpay - debtmv ;
      uf.setprob( ulb, &ulbpb, &ulbden ) ;
      phi = (dbpay - f().t*ulb)/(1.0 - f().t) ;
      uf.setprob( phi, &phipb, &phiden ) ;
      equimv = valequi() ;
      firmmv = valfirm() ;
      txsvmv = valtxsv() ;
      bkcsmv = valbkcs() ;
      dbrati = debtmv/firmmv ;
      debtrr = rrrdebt() ;
      equirr = rrrequi() ;
      wacc = ((1.0 - f().t)*debtrr*debtmv + equirr*equimv)/firmmv ;
    }
  }
}
void ndtmodel5::proccaldebt() {
  dcntl = 1 ; double tmpdmv1 = procdebtmv() ;
  dcntl = 2 ; double tmpdmv2 = procdebtmv() ;
//  printf( "%5.2f %7.4f %7.4f %7.4f %7.4f\n", dbpay, tmpdmv1, tmpdmv2, tmpdmv3, tmpdmv4) ; 
  dcntl = 0 ;
  if (tmpdmv1 != ::misfval3 && tmpdmv1 <= uf.getndtv()) {
    debtmv = tmpdmv1 ; dcntl = 1 ;
  }
  else if (tmpdmv2 != ::misfval3 && tmpdmv2 > uf.getndtv()) {
    debtmv = tmpdmv2 ; dcntl = 2 ;
  }
}
void ndtmodel5::copymembers( const ndtmodel5& oth ) {
  uf = oth.getuf() ;
  dcntl = oth.getid() ;
  dbpay = oth.getdbpay() ;
  debtmv = oth.getdebtmv() ;
  equimv = oth.getequimv() ;
  firmmv = oth.getfirmmv() ;
  txsvmv = oth.gettxsvmv() ;
  bkcsmv = oth.getbkcsmv() ;
  debtrr = oth.getdebtrr() ;
  equirr = oth.getequirr() ;
  wacc = oth.getwacc() ;
  dbrati = oth.getdbrati() ;
  lpb = oth.getbnkprob() ;
  lden = oth.getbnkden() ;
  lb = oth.getlb() ;
  lbpb = oth.getlbpb() ;
  lbden = oth.getlbden() ;
  ulb = oth.getulb() ;
  ulbpb = oth.getulbpb() ;
  ulbden = oth.getulbden() ;
  phi = oth.getphi() ;
  phipb = oth.getphipb() ;
  phiden = oth.getphiden() ;
}
double ndtmodel5::procdebtmv() {
   double dmv ;
   ::cntlid = 0 ;
   if ((dmv = ProcSecant( this, 0.001, dbpay, ::epsi )) == ::misfval3) {
     printf( "%s\n", "not convergent in debt value" ) ;
     exit( 1 ) ;
   }
   return dmv ;
}
double ndtmodel5::calvalfunc( double dbmv ) {
  return dbmv - valdebt( dbmv ) ;
}
double ndtmodel5::valfirm() {
  return debtmv + equimv ;
}
double ndtmodel5::valequi() {
  return (cfequiave() - f().lamb*cfequicov())/(1.0 + f().rf) ; 
}
double ndtmodel5::valdebt( double dbmv ) {
  double tmpave, tmpcov ;
  switch(dcntl) {
  case 1:
    lb = dbpay - dbmv ;
    uf.setprob( lb, &lbpb, &lbden ) ;
//   printf( "%8.5f %8.5f\n", lpb, kpb ) ;
    tmpave = cfdebtave1() ; tmpcov = cfdebtcov1() ; break ;
  case 2:
    lb = dbpay - dbmv ;
    ulb = uf.getndtv() + dbpay - dbmv ;
    phi = (dbpay - f().t*ulb)/(1.0 - f().t) ; 
    uf.setprob( lb, &lbpb, &lbden ) ;
    uf.setprob( ulb, &ulbpb, &ulbden ) ;
    uf.setprob( phi, &phipb, &phiden ) ;
//   printf( "%8.5f %8.5f\n", lpb, kpb ) ;
    tmpave = cfdebtave2() ; tmpcov = cfdebtcov2() ; break ;
  }
  return (tmpave - f().lamb*tmpcov)/(1.0 + f().rf) ;
}
double ndtmodel5::valtxsv() {
  return (cftxsvave() - f().lamb*cftxsvcov())/(1.0 + f().rf) ; 
}
double ndtmodel5::valbkcs() {
  return (cfbkcsave() - f().lamb*cfbkcscov())/(1.0 + f().rf) ;
}
double ndtmodel5::cfdebtave1() {
  return dbpay*(1.0 - lpb) 
    + f().ez*(lpb - uf.getzeropb()) - f().vz*(lden - uf.getzeroden())
    - f().bcpr*(f().ez*(lbpb - uf.getzeropb())
		- f().vz*(lbden - uf.getzeroden())) ;
}
double ndtmodel5::cfdebtcov1() {
  return f().covz*(lpb - uf.getzeropb()
		   - f().bcpr*(lbpb - uf.getzeropb() - lb*lbden)) ;
}
double ndtmodel5::cfdebtave2() {
  return dbpay*(1.0 - phipb) + f().t*ulb*(phipb - ulbpb)
    + f().ez*((1.0 - f().t)*phipb + f().t*ulbpb - uf.getzeropb())
    - f().vz*((1.0 - f().t)*phiden + f().t*ulbden - uf.getzeroden()) 
    - f().bcpr*(f().ez*(lbpb - uf.getzeropb())
		- f().vz*(lbden - uf.getzeroden())) ;
}
double ndtmodel5::cfdebtcov2() {
  return f().covz*
    ((1.0 - f().t)*phipb + f().t*ulbpb - uf.getzeropb()
     - f().bcpr*(lbpb - uf.getzeropb() - lb*lbden)) ;
}
double ndtmodel5::cfequiave() {
  double tmpave ;
  switch(dcntl) {
  case 1:
    tmpave = f().ez*(1.0 - f().t + f().t*ulbpb - lpb)
      + f().vz*(lden - f().t*ulbden)
      - dbpay*(1.0 - lpb) + f().t*ulb*(1.0 - ulbpb) ; break ;
  case 2:
    tmpave = (1.0 - f().t)*(f().ez*(1.0 - phipb) + f().vz*phiden)
      - dbpay*(1.0 - phipb) + f().t*ulb*(1.0 - phipb) ; break ;
  }
  return tmpave ;
}
double ndtmodel5::cfequicov() {
  double tmpcov ;
  switch(dcntl) {
  case 1:
    tmpcov = f().covz*(1.0 - f().t + f().t*ulbpb - lpb) ; break; 
  case 2:
    tmpcov = f().covz*(1.0 - f().t)*(1.0 - phipb) ; break ;
  }
  return tmpcov ;
}
double ndtmodel5::cftxsvave() {
  double tmptsave ;
  tmptsave = f().t*(lb*(1.0 - ulbpb) - uf.getndtv()*(ulbpb - uf.getnpb())
		    + f().ez*(ulbpb - uf.getnpb())
		    - f().vz*(ulbden - uf.getnden())) ;
  return tmptsave ;
}
double ndtmodel5::cftxsvcov() {
  double tmptscov ;
  tmptscov = f().covz*f().t*(ulbpb - uf.getnpb()) ;
  return tmptscov ;
}
double ndtmodel5::cfbkcsave() {
  double tmpbcave ;
  tmpbcave = f().bcpr*(f().ez*(lbpb - uf.getzeropb())
		       - f().vz*(lbden - uf.getzeroden())) ;
  return tmpbcave ;
}
double ndtmodel5::cfbkcscov() {
  double tmpbccov ;
  tmpbccov = f().covz*f().bcpr*(lbpb - uf.getzeropb() - lb*lbden) ;
  return tmpbccov ;
}
double ndtmodel5::rrrequi() {
  return f().rf + f().lamb*cfequicov()/equimv ; 
//   return cfequiave( x ) / equimv - 1.0 ; 
}
double ndtmodel5::rrrdebt() {
  if (dbpay == 0.0) return 0.0 ;
  double tmprrrdb ;
  switch(dcntl) {
  case 1:
    tmprrrdb = f().rf + f().lamb*cfdebtcov1()/debtmv ; break ;
  case 2:
    tmprrrdb = f().rf + f().lamb*cfdebtcov2()/debtmv ; break ;
//     return cfdebtave( x ) / debtmv - 1.0 ; 
  }
  return tmprrrdb ;
}
// maximization using GoldenDivision
optsearchx_dc::optsearchx_dc() : optsearchx() {
  ::cntlid = 0 ;
  if ((optvalx = ProcGoldDiv( this, xminval, xmaxval, ::epsi_gld )) 
      == ::misfval3) 
// fprintf( ::outps, "%s %5d\n", "error: no maximum value in x", ::tcode ) ;
    printf( "%s\n", "error: no maximum value in x" ) ;
}
double optsearchx_dc::getobjval( double x ) {
  return optsearchx::getobjval( x ) ;
}
double optsearchx_dc::optprocfunc( double dbcash, double dummy ) {
  ndtmodel5 lf(dbcash) ;
  return lf.getfirmmv() ;
}
