// ndtmodel4.h：倒産コストの定義変更。ndtmodel2からの派生
// 141120 C++流の全面的書き換え→program3/ndtmodel1と完全一致
// 141128 ndtmodel2へのバージョンアップ
// 141208 dcntl(計算の管理を明確化)の追加
// 141211 計算に直接必要なデータをstaticに(グローバル変数を使わない)
// 141229 倒産コストの定義変更→ndtmodel4に。
// 150612 optsearch変更に伴う修正
#include <cmath>
#include <cstdio>
#include <cstdlib>
#include "numertools.h"
#if !defined( ___class_ndtmodel4 )
    #define ___class_ndtmodel4
extern double year, ez1, sz1, corrmpz ;
extern double bcprop, t, ndtprop ;
extern double rf1, emp1, smp1 ;
extern int cntlid ;
extern double epsi, epsi_gld, misfval3, xmin, xmax ;
class givendata {
 public:
  double year, ez1, sz1, corrmpz, bcprop, t, ndtprop ;
  double rf1, emp1, smp1 ;
};
class firmdata {
 public:
  firmdata() ;
  ~firmdata() {}
  double ez, sz, vz, covz, year, bcpr, t, ndpr, emp, smp, rf, lamb ;
};
class basicfirm {
 private:
  double ufirmv, rrrfirm, ndtv ;
  double npb, nden, zeropb, zeroden ;
  void copymembers( const basicfirm& rhs ) ;
  double procfirmmv() ;
  double valfirm( double fmmv ) ;
  double cffirmave( double fmmv ) ;
  double cffirmcov( double fmmv ) ;
  double rrrequi() ;
 public:
  basicfirm() ;
  basicfirm( const basicfirm& rhs ) ;
  basicfirm& operator=( const basicfirm& rhs ) ;
  ~basicfirm() {}
  void setprob( double val, double *pb, double *den ) ;
  double calvalfunc( double fmmv ) ;
  double getufirmv() const { return ufirmv ; }
  double getndtv() const { return ndtv ; }
  double getnpb() const { return npb ; }
  double getnden() const { return nden ; }
  double getzeropb() const { return zeropb ; }
  double getzeroden() const { return zeroden ;}
  double getrrr() const { return rrrfirm ; }
} ;
class ndtmodel4 {
 private:
  basicfirm uf ;
  int dcntl ;
  double dbpay, debtmv, equimv, firmmv, txsvmv, bkcsmv ;
  double debtrr, equirr, wacc, dbrati ;
  double lpb, lden, ulb, ulbpb, ulbden, phi, phipb, phiden ;
  void calmodel() ;
  void copymembers(const ndtmodel4& oth ) ;
  double procdebtmv() ;
  double valfirm() ;
  double valequi() ;
  double valdebt() ;
  double valdebt2( double dbmv ) ;
  double valtxsv() ;
  double valbkcs() ;
  double cfequiave() ;
  double cfequicov() ;
  double cfdebtave() ;
  double cfdebtave2() ;
  double cfdebtcov() ;
  double cfdebtcov2() ;
  double cftxsvave() ;
  double cftxsvcov() ;
  double cfbkcsave() ;
  double cfbkcscov() ;
  double rrrequi() ;
  double rrrdebt() ;
 public:
  explicit ndtmodel4( double dbcash ) ;
  ndtmodel4( const ndtmodel4& rhs ) ;
  ndtmodel4& operator=( const ndtmodel4& rhs ) ;
  ~ndtmodel4() {}
  double calvalfunc( double dbmv ) ;
  basicfirm getuf() const { return uf ; }
  int getid() const { return dcntl ; }
  double getdbpay() const { return dbpay ; }
  double getequimv() const { return equimv ; }
  double getdebtmv() const { return debtmv ; }
  double getfirmmv() const { return firmmv ; }
  double getufirmv() const { return uf.getufirmv() ; }
  double gettxsvmv() const { return txsvmv ; }
  double getbkcsmv() const { return bkcsmv ; }
  double getequirr() const { return equirr ; }
  double getdebtrr() const { return debtrr ; }
  double getwacc() const { return wacc ; }
  double getdbrati() const { return dbrati ; }
  double getbnkprob() const { return lpb ; }
  double getbnkden() const { return lden; }
  double getulb() const { return  ulb; }
  double getulbpb() const { return ulbpb ; }
  double getulbden() const { return ulbden ; }
  double getphi() const { return phi ; }
  double getphipb() const { return phipb ; }
  double getphiden() const { return phiden ; }
} ;
#endif
#if !defined( ___class_optsearchx_dc )
#define ___class_optsearchx_dc
class optsearchx_dc : public optsearchx {
 protected:
  virtual double optprocfunc( double dbcash, double dummy ) ;
 public:
  optsearchx_dc() ;
  virtual ~optsearchx_dc() {}
  virtual double getobjval( double x ) ;
} ;
#endif
