#include "ndtmodel4.h"
givendata& f1() ;
firmdata& f() ;
firmdata::firmdata()
  : ez(0.0), sz(0.0), vz(0.0), covz(0.0), year(f1().year),
    bcpr(f1().bcprop), t(f1().t), ndpr(f1().ndtprop), emp(0.0), smp(0.0),
    rf(0.0), lamb(0.0) {
  ez = f1().ez1 * year ;
  sz = f1().sz1 * sqrt( year ) ;
  vz = sz * sz ;
  emp = pow( (1.0 + f1().emp1), year ) - 1.0 ;
  smp = f1().smp1 * sqrt( year ) ;
  covz = f1().corrmpz * smp * sz ;
  rf = pow( (1.0 + f1().rf1), year ) - 1.0 ;
  lamb = ( emp - rf ) / ( smp * smp ) ;
}
basicfirm::basicfirm()
  : ufirmv(0.0), rrrfirm(0.0), ndtv(0.0),
    npb(0.0), nden(0.0), zeropb(0.0), zeroden(0.0) {
  setprob( 0.0, &zeropb, &zeroden ) ;
  ufirmv = procfirmmv() ;
  ndtv = f().ndpr * ufirmv ;
  setprob( ndtv, &npb, &nden ) ;
//   printf( "%10.5f %8.5f %8.5f\n", ufirmv, upb, zeropb ) ;
  rrrfirm = rrrequi() ;
}
basicfirm::basicfirm( const basicfirm& rhs ){
  copymembers( rhs ) ;
}
basicfirm& basicfirm::operator=( const basicfirm& rhs ){
  copymembers( rhs ) ;
  return *this ;
}
void basicfirm::copymembers( const basicfirm& oth ){
  ufirmv = oth.getufirmv() ;
  ndtv = oth.getndtv() ;
  npb = oth.getnpb() ;
  nden = oth.getnden() ;
  zeropb = oth.getzeropb() ;
  zeroden = oth.getzeroden() ;
  rrrfirm = oth.getrrr() ;
}
double basicfirm::valfirm( double fmmv ) {
  return (cffirmave( fmmv ) - f().lamb*cffirmcov( fmmv ))/(1.0 + f().rf) ; 
}
double basicfirm::cffirmave( double fmmv ) {
  double ndtvtmp = f().ndpr * fmmv ;
  double npbtmp, ndentmp ;
  setprob( ndtvtmp, &npbtmp, &ndentmp ) ;
  return f().ez*(1.0 - f().t + f().t*npbtmp - zeropb) 
    + f().vz*(zeroden - f().t*ndentmp) + f().t*ndtvtmp*(1.0 - npbtmp) ;
}
double basicfirm::cffirmcov( double fmmv ) {
  double ndtvtmp = f().ndpr * fmmv ;
  double npbtmp, ndentmp ;
  setprob( ndtvtmp, &npbtmp, &ndentmp ) ;
  return f().covz*(1.0 - f().t + f().t*npbtmp - zeropb) ;
}
double basicfirm::rrrequi() {
  return f().rf + f().lamb*cffirmcov( ufirmv )/ufirmv ; 
//   return cfequiave( x ) / equimv - 1.0 ; 
}
double basicfirm::procfirmmv() {
   double fmv ;
   ::cntlid = 0 ;
   if ((fmv = ProcSecant( this, 1.0, f().ez, ::epsi )) == ::misfval3) {
      printf( "%s\n", "not convergent in firm value" ) ;
      exit( 1 ) ;
   }
   return fmv ;
}
double basicfirm::calvalfunc( double fmmv ) {
  return fmmv - valfirm( fmmv ) ;
}
void basicfirm::setprob( double val, double *pb, double *den ) {
  normdis nr( val, f().ez, f().sz ) ;
  *pb = nr.getprob() ;
  *den = nr.getdens() ;
  //   printf( " %10.5f %10.5f %10.5f\n", val, *pb, *den ) ;
}
ndtmodel4::ndtmodel4( double dcash )
  : uf(), dcntl(0), dbpay(dcash), debtmv(0.0), equimv(0.0), firmmv(0.0),
    txsvmv(0.0), bkcsmv(0.0), debtrr(0.0), equirr(0.0), wacc(0.0),
    dbrati(0.0),
    lpb(0.0), lden(0.0), ulb(0.0), ulbpb(0.0), ulbden(0.0),
    phi(0.0), phipb(0.0), phiden(0.0) {
  calmodel() ;
}
ndtmodel4::ndtmodel4( const ndtmodel4& rhs ) {
  copymembers( rhs ) ;
}
ndtmodel4& ndtmodel4::operator=( const ndtmodel4& rhs ){
  copymembers( rhs ) ;
  return *this ;
}
void ndtmodel4::calmodel() {
  uf.setprob( dbpay, &lpb, &lden ) ;
  if (dbpay == 0.0) {
    equimv = firmmv = uf.getufirmv() ;
    equirr = wacc = uf.getrrr() ; 
  }
  else {
    dcntl = 1 ;
    debtmv = valdebt() ;
    if (debtmv > uf.getndtv()) {
      debtmv = procdebtmv() ;
      if (debtmv > uf.getndtv()) dcntl = 2 ;
      else dcntl = 4 ;
    }
    ulb = uf.getndtv() + dbpay - debtmv ;
    uf.setprob( ulb, &ulbpb, &ulbden ) ;
    phi = (dbpay - f().t*ulb)/(1.0 - f().t) ; 
    uf.setprob( phi, &phipb, &phiden ) ;
    equimv = valequi() ; firmmv = valfirm() ;
    txsvmv = valtxsv() ; bkcsmv = valbkcs() ;
    dbrati = debtmv/firmmv ;
    debtrr = rrrdebt() ; equirr = rrrequi() ;
    wacc = ((1.0 - f().t)*debtrr*debtmv + equirr*equimv)/firmmv ;
  }
}
void ndtmodel4::copymembers( const ndtmodel4& oth ) {
  uf = oth.getuf() ;
  dcntl = oth.getid() ;
  dbpay = oth.getdbpay() ;
  debtmv = oth.getdebtmv() ;
  equimv = oth.getequimv() ;
  firmmv = oth.getfirmmv() ;
  txsvmv = oth.gettxsvmv() ;
  bkcsmv = oth.getbkcsmv() ;
  debtrr = oth.getdebtrr() ;
  equirr = oth.getequirr() ;
  wacc = oth.getwacc() ;
  dbrati = oth.getdbrati() ;
  lpb = oth.getbnkprob() ;
  lden = oth.getbnkden() ;
  ulb = oth.getulb() ;
  ulbpb = oth.getulbpb() ;
  ulbden = oth.getulbden() ;
  phi = oth.getphi() ;
  phipb = oth.getphipb() ;
  phiden = oth.getphiden() ;
}
double ndtmodel4::procdebtmv() {
   double dmv ;
   ::cntlid = 0 ;
   if ((dmv = ProcSecant( this, 1.0, dbpay, ::epsi )) == ::misfval3) {
      printf( "%s\n", "not convergent in debt value" ) ;
      exit( 1 ) ;
   }
   return dmv ;
}
double ndtmodel4::calvalfunc( double dbmv ) {
  return dbmv - valdebt2( dbmv ) ;
}
double ndtmodel4::valfirm() {
  if (dcntl != 4) return debtmv + equimv ; 
  else return ::misfval3 ;
}
double ndtmodel4::valequi() {
  if (dcntl != 4) 
    return (cfequiave() - f().lamb*cfequicov())/(1.0 + f().rf) ;
  else
    return ::misfval3 ;
}
double ndtmodel4::valdebt() {
  return (cfdebtave() - f().lamb*cfdebtcov())/(1.0 + f().rf) ;
}
double ndtmodel4::valdebt2( double dbmv ) {
  ulb = uf.getndtv() + dbpay - dbmv ;
  uf.setprob( ulb, &ulbpb, &ulbden ) ;
  phi = (dbpay - f().t*ulb)/(1.0 - f().t) ; 
  uf.setprob( phi, &phipb, &phiden ) ;
  return (cfdebtave2() - f().lamb*cfdebtcov2())/(1.0 + f().rf) ;
}
double ndtmodel4::valtxsv() {
  if (dcntl != 4) 
    return (cftxsvave() - f().lamb*cftxsvcov())/(1.0 + f().rf) ; 
  else
    return ::misfval3 ;
}
double ndtmodel4::valbkcs() {
  if (dcntl != 4)
    return (cfbkcsave() - f().lamb*cfbkcscov())/(1.0 + f().rf) ;
  else
    return ::misfval3 ;
}
double ndtmodel4::cfdebtave() {
  double tmpval ;
  tmpval = dbpay*(1.0 - lpb)
    + (1.0 - f().bcpr)*(f().ez*(lpb - uf.getzeropb())
			- f().vz*(lden - uf.getzeroden())) ;
  return tmpval ;
}
double ndtmodel4::cfdebtcov() {
  double tmpval ;
  tmpval = f().covz*((1.0 - f().bcpr)*(lpb - uf.getzeropb())
		     + f().bcpr*dbpay*lden) ;
  return tmpval ;
}
double ndtmodel4::cfdebtave2() {
  return dbpay*(1.0 - phipb) + f().t*ulb*(phipb - ulbpb)
    + f().ez*((1.0 - f().t)*phipb + f().t*ulbpb - uf.getzeropb())
    - f().vz*((1.0 - f().t)*phiden + f().t*ulbden - uf.getzeroden())
    - f().bcpr*(f().ez*(phipb - uf.getzeropb())
		- f().vz*(phiden - uf.getzeroden())) ;
}
double ndtmodel4::cfdebtcov2() {
  return f().covz*
    ((1.0 - f().t)*phipb + f().t*ulbpb - uf.getzeropb()
     - f().bcpr*(phipb - uf.getzeropb() - phi*phiden)) ;
}
double ndtmodel4::cfequiave() {
  double tmpval ;
  switch (dcntl) {
  case 1:
    tmpval = f().ez*(1.0 - f().t + f().t*ulbpb - lpb)
      - f().vz*(f().t*ulbden - lden)
      + f().t*ulb*(1.0 - ulbpb) - dbpay*(1.0 - lpb) ; break ;
  case 2:
    tmpval = (1.0 - f().t)*(f().ez*(1.0 - phipb) + f().vz*phiden)
      + f().t*ulb*(1.0 - phipb) - dbpay*(1.0 - phipb) ; break ;
  }
  return tmpval ;
}
double ndtmodel4::cfequicov() {
  double tmpval ;
  switch (dcntl) {
  case 1:
    tmpval = f().covz*(1.0 - f().t + f().t*ulbpb - lpb) ; break ;
  case 2:
    tmpval = f().covz*(1.0 - f().t)*(1.0 - phipb) ; break ;
  }
  return tmpval ;
}
double ndtmodel4::cftxsvave() {
  return f().t*((dbpay - debtmv)*(1.0 - ulbpb)
		- uf.getndtv()*(ulbpb - uf.getnpb())
		+ f().ez*(ulbpb - uf.getnpb())
		- f().vz*(ulbden - uf.getnden())) ;
}
double ndtmodel4::cftxsvcov() {
  return f().covz*f().t*(ulbpb - uf.getnpb()) ;
}
double ndtmodel4::cfbkcsave() {
  double tmpval ;
  switch (dcntl) {
  case 1:
    tmpval = f().bcpr*(f().ez*(lpb - uf.getzeropb())
		     - f().vz*(lden - uf.getzeroden())) ; break ;
  case 2:
    tmpval = f().bcpr*(f().ez*(phipb - uf.getzeropb()) 
		       - f().vz*(phiden - uf.getzeroden())) ; break ;
  }
  return tmpval ;
}
double ndtmodel4::cfbkcscov() {
  double tmpval ;
  switch (dcntl) {
  case 1:
    tmpval = f().covz*f().bcpr*(lpb - uf.getzeropb() - dbpay*lden) ; break ;
  case 2:
    tmpval = f().covz*f().bcpr*(phipb - uf.getzeropb()
				- phi*phiden) ; break ;
  }
  return tmpval ;
}
double ndtmodel4::rrrequi() {
  double tmpval ;
  if (dcntl != 4) tmpval = f().rf + f().lamb * cfequicov()/equimv ;
  else tmpval = ::misfval3 ;
  return tmpval ;
//   return cfequiave( x ) / equimv - 1.0 ; 
}
double ndtmodel4::rrrdebt() {
  double tmpval ;
  if (dbpay == 0.0) tmpval = 0.0 ;
  switch (dcntl) {
  case 1:
    tmpval = f().rf + f().lamb * cfdebtcov()/debtmv ; break ;
  case 2:
    tmpval = f().rf + f().lamb * cfdebtcov2()/debtmv ; break ;
  case 4:
    tmpval = ::misfval3 ; break ;
  }
  return tmpval ;
//     return cfdebtave( x ) / debtmv - 1.0 ; 
}
// maximization using GoldenDivision
optsearchx_dc::optsearchx_dc() : optsearchx() {
  ::cntlid = 0 ;
  if ((optvalx = ProcGoldDiv( this, xminval, xmaxval, ::epsi_gld )) 
      == ::misfval3) 
// fprintf( ::outps, "%s %5d\n", "error: no maximum value in x", ::tcode ) ;
    printf( "%s\n", "error: no maximum value in x" ) ;
}
double optsearchx_dc::getobjval( double x ) {
  return optsearchx::getobjval( x ) ;
}
double optsearchx_dc::optprocfunc( double dbcash, double dummy ) {
  ndtmodel4 lf(dbcash) ;
  return lf.getfirmmv() ;
}
