//<m5v3agcivsim10.cc>
// 090124 データ期間3の変更に伴う再計算
//        agcmodel4の変更に伴うprintdataの変更
// 090125 checkstatusの追加
//        propivst = 0.15   ===>  outfile is *****5p?.txt
//        propivst = 0.1    ===>  outifle is *****5p?1.txt
//        propivst = 0.05   ===>  outfile is *****5p?2.txt
// 130614 C++流の書き換え
// 130623 前バージョンm4v5と完全一致するよう収束パラメタ−の調整
// 130624 プリントの書式変更：簡潔に(Ver2)
// 150612 数値計算ルーチンの変更(Ver3)
// 150806 p3データの再計算。
// 150822 simulation用の書き換え
// 161229 公開用に一部更新：コメントアウトの変更…元のm5v3agcivsim1.ccと同じもの。
#include <cmath>
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include "agcmodel5.h"
FILE *indat, *outps, *outval, *outest ;
char outvalfile[80] = "data/simuivval2.txt" ; //experiment用
//char outvalfile[80] = "data/simuivval21.txt" ; //searchdebt用
int tcode, cntlid, firmini, firmend, nfirm, status ;
double year = 10.0, t = 0.3, ndprop = 1.0, bcprop = 0.4 ;
double rf1, emp1, smp1, shrrstd1, rf, emp, smp, lamb ;
double mvequi, mvdebt, corrmpcf ;
double prop_epsi0 = 0.00000000001, epsi0 ;
double prop_epsi1 = 0.00000001, epsi1 ;
double prop_epsigld = 0.000000001, epsigld ;
double misfval3 = -999.999 ;
double propivst = 0.05, ivst = 2.0, wacct_base, wacct_data ;
double dbcf_base, std_base, ecfu_base, acp_base, mvequi_base, mvdebt_base ;
double xmin, xmax, ymin, ymax ;
double xini1, xini2, yini1, yini2 ;
double xmin_ivst, xmax_ivst ;
double parafp = 3.0, intval_ecfu = 0.4, intval_dbcf = 0.4, intval_std = 0.3 ;
class solveqx_ivst : public solveqx {
protected:
  virtual double solvprocfunc( double ecfu, double dbcf ) ;
public:
  solveqx_ivst( double dtfx, double y ) ;
  virtual ~solveqx_ivst() {}
  virtual double calvalfunc( double x ) ;
} ;
class solveqxy_ivst : public solveqxy {
protected:
  virtual double solvprocfunc( double ecfu, double dbcf ) ;
public:
  solveqxy_ivst( double dtfx, double dtfy ) ; 
  virtual ~solveqxy_ivst() {} 
  virtual double calvalfunc( double y ) ; 
} ;
class optsearchx_retinv : public optsearchx {
protected:
  virtual double optprocfunc( double ivdeb, double dummy ) ;
public:
  optsearchx_retinv() ;
  virtual ~optsearchx_retinv() {}
  virtual double getobjval( double x ) ;
} ;
class optsearchx_ivst : public optsearchx {
protected:
  virtual double optprocfunc( double sdv, double dummy ) ;
public:
  optsearchx_ivst( double ecfu, double dbcf ) ;
  virtual ~optsearchx_ivst() {}
  virtual double getobjval( double x ) ;
} ;
class agcivst {
protected:
  double ratretinv1, taxrrinv1 ;
  double chgreturn1( double ret, double inv ) ;
  void printhead() ;
  void printdata( const ModelFirm& d ) ;
  void printdataivst( double ivdeb, const AgcModel& d ) ;
  int checkstatus( double ivdeb, const AgcModel& d ) ;
  AgcModel findsolution( double mveq, double mvdb ) ;
public:
  agcivst() ;
  agcivst( double ivdeb, int cntl ) ;
  virtual ~agcivst() {}
  double getreturn1() const { return ratretinv1 ; }
} ;
class agcsetting_sim {
private:
  void setvalue_findata() ;
  void setfixedparam( double valu ) ;
public:
  agcsetting_sim( double valu ) ;
  ~agcsetting_sim() {}
} ;
class procagcivst_sim : public agcivst {
private:
  void experiment1( double ec, double ac ) ;
  void procsimuagciv( double ecfu, double acp ) ;
  void searchdebt( double ecfu, double acp ) ;
  void calagcivst( double ecfu, double acp ) ;
  void setfixedparam2_ivst() ;
public:
  procagcivst_sim( double ecfu, double acp ) ;
  virtual ~procagcivst_sim() {}
} ;
solveqx_ivst::solveqx_ivst( double dtfx, double y ) : solveqx() {
  fxdat = dtfx ; xinival1 = ::xini1 ; xinival2 = ::xini2 ;
  yval = y ; 
  if ((solutx = ProcSecant( this, xinival1, xinival2, ::epsi1 )) 
      == ::misfval3) 
    fprintf( ::outps, "%s %5d\n", "error: no solution in x", ::tcode ) ;
}
double solveqx_ivst::calvalfunc( double x ) {
  return solveqx::calvalfunc( x ) ;
}
double solveqx_ivst::solvprocfunc( double ecfu, double dbcf ) {
  optsearchx_ivst op( ecfu, dbcf ) ;
  AgcModel f( dbcf, op.getoptvalx(), ecfu, ::acp_base ) ;
  return f.getequimv() ;
}
solveqxy_ivst::solveqxy_ivst( double dtfx, double dtfy ) : solveqxy() {
  fprintf( ::outps, "%s %5d\n", "solve equations started", ::tcode ) ;
  fxdat = dtfx ; xinival1 = ::xini1 ; xinival2 = ::xini2 ;
  fydat = dtfy ; yinival1 = ::yini1 ; yinival2 = ::yini2 ;
  if ((soluty = ProcSecant( this, yinival1, yinival2, ::epsi1 )) 
      == ::misfval3)
    fprintf( ::outps, "%s %5d\n", "error: no solution in y", ::tcode ) ;
}
double solveqxy_ivst::calvalfunc( double y ) {
  solveqx_ivst fx( fxdat, y ) ;
  solutx = fx.getsolutx() ;
  return fydat - solvprocfunc( solutx, y ) ;
}
double solveqxy_ivst::solvprocfunc( double ecfu, double dbcf ) {
  optsearchx_ivst op( ecfu, dbcf ) ;
  AgcModel f( dbcf, op.getoptvalx(), ecfu, ::acp_base ) ;
  return (1.0 - ::dbcf_base / dbcf) * f.getdebtmv() ;
}
optsearchx_retinv::optsearchx_retinv() : optsearchx() {
  xminval = ::xmin_ivst ;
  xmaxval = ::xmax_ivst ;
  if ((optvalx = ProcGoldDiv( this, xminval, xmaxval, ::epsi1 )) 
      == ::misfval3) 
    fprintf( ::outps, "%s %5d\n", "error: no maximum value in x", ::tcode ) ;
}
double optsearchx_retinv::getobjval( double x ) {
  return optsearchx::getobjval( x ) ;
}
double optsearchx_retinv::optprocfunc( double ivdeb, double dummy ) {
  agcivst f( ivdeb, 0 ) ;
  return -f.getreturn1() ;
}
optsearchx_ivst::optsearchx_ivst( double ecfu, double dbcf ) : optsearchx() {
  xminval = ::std_base * ecfu / ::ecfu_base ;
  xmaxval = xminval * ( 1.0 + ::intval_std ) ;
  param1 = ecfu ; param2 = dbcf ;
  if ((optvalx = ProcGoldDiv( this, xminval, xmaxval, ::epsi1 )) 
      == ::misfval3) 
     fprintf( ::outps, "%s %5d\n", "error: no maximum value in x", ::tcode ) ;
}
double optsearchx_ivst::getobjval( double x ) {
  return optsearchx::getobjval( x ) ;
}
double optsearchx_ivst::optprocfunc( double sdv, double dummy) {
  AgcModel f( param2, sdv, param1, ::acp_base ) ;
  return f.getequimv() ;
}
agcsetting_sim::agcsetting_sim( double valu ) {
  ::tcode = 9999 ;
  setvalue_findata() ;
  setfixedparam( valu ) ;
  ::wacct_data = ::misfval3 ;
}
void agcsetting_sim::setvalue_findata() {
  ::corrmpcf = 0.4 ;
  ::emp1 = 0.13 ;
  ::smp1 = 0.25 ;
  ::rf1 = 0.06 ;
  ::shrrstd1 = 0.25 ;
  ::mvequi = 99.99 ;
  ::mvdebt = 99.99 ;
  ::rf = pow( (1.0 + ::rf1), ::year ) - 1.0 ;
  ::emp = pow( (1.0 + ::emp1), ::year ) - 1.0 ;
  ::smp = ::smp1 * sqrt( ::year ) ;
  ::lamb = ( ::emp - ::rf ) / ( ::smp * ::smp ) ;
}
void agcsetting_sim::setfixedparam( double valu ) {
  ::xmin = 0.00001 ;      // x is debt cash payment
  ::xmax = valu * ::parafp ;
  ::ymin = 0.00001 ;  // y is standard deviation of ecf
  ::ymax = valu * ::parafp ;
  ::epsi0 = ::prop_epsi0 * valu ;
  ::epsi1 = ::prop_epsi1 * valu ;
  ::epsigld = ::prop_epsigld * valu ;
}
agcivst::agcivst()
  : ratretinv1(0.0), taxrrinv1(0.0) {}
agcivst::agcivst( double ivdeb, int cntl ) {
  AgcModel fl2 = findsolution( ::mvequi_base + ::ivst - ivdeb, ivdeb ) ;
  if (fl2.getezconst() - ::ecfu_base - ::ivst > 0.0) {
    ratretinv1 = chgreturn1( fl2.getezconst() - ::ecfu_base, ::ivst ) ;
    taxrrinv1 = (1.0 - ::t) * ratretinv1 ;
  }
  else {
    ratretinv1 = ::misfval3 ; taxrrinv1 = ::misfval3 ;
  } 
  if ( cntl != 0 ) {
    ::status = checkstatus( ivdeb, fl2 ) ;
    printdataivst( ivdeb, fl2 ) ; 
    ModelFirm fm2( fl2 ) ; printdata( fm2 ) ;
    //if (ratretinv1 > ::misfval3 * 0.9)
    //  fprintf( ::outest, "%5d %9.6f %9.6f %9.6f %3d\n",
    //	       ::tcode, ::wacct_data, ::wacct_base, taxrrinv1, ::status ) ;
  }
}
AgcModel agcivst::findsolution( double mveq, double ivdb ) {
  solveqxy_ivst sv( mveq, ivdb ) ;
  optsearchx_ivst ov( sv.getsolutx(), sv.getsoluty() ) ;
  return AgcModel( sv.getsoluty(), ov.getoptvalx(),
		   sv.getsolutx(), ::acp_base ) ;
}
void agcivst::printhead() {
   fprintf( ::outval, "TOSYOU CODE:%5d %6d\n", ::tcode, ::nfirm ) ;
   fprintf( ::outval, "debtcashflow initial values: %10.6f %10.6f\n",
	    ::xmin, ::xmax ) ;
   fprintf( ::outval, "stddev initial values: %10.6f %10.6f\n",
	    ::ymin, ::ymax ) ;
   fprintf( ::outval, "ecfconst solution invest: %10.6f %10.6f\n",
	    ::xini1, ::xini2 ) ;
   fprintf( ::outval, "debt cf solution invest: %10.8f %10.8f\n",
	    ::yini1, ::yini2 ) ;
   fprintf( ::outval,
       "tax rate = %4.2f  bankruptcy cost (proportion = %5.3f)\n",
	    ::t, ::bcprop ) ;
   fprintf( ::outval, "non-debt tax shield (proportion = %5.3f)\n", ::ndprop ) ;
   fprintf( ::outval, 
       "market portfolio: average = %7.5f  std.dev = %7.5f  lambda = %9.5f\n",
	    ::emp1, ::smp1, ::lamb ) ;
   fprintf( ::outval,
       "riskless rate of interest = %7.5f  correlation = %8.5f\n",
	    ::rf1, ::corrmpcf ) ;
   fprintf( ::outval, 
       "data: equity = %10.6f  debt = %10.6f  firm = %10.6f\n\n",
	    ::mvequi, ::mvdebt, ::mvequi + ::mvdebt ) ;
   printf( "TOSYOU CODE:%5d %6d\n", ::tcode, ::nfirm ) ;
   printf( "tax rate = %4.2f  bankruptcy cost (proportion = %5.3f)\n",
	   ::t, ::bcprop ) ;
   printf( "non-debt tax shield (proportion = %5.3f)\n", ::ndprop ) ;
   printf( 
      "market portfolio: average = %7.5f  std.dev = %7.5f  lambda = %9.5f\n",
      ::emp1, ::smp1, ::lamb ) ;
   printf( "riskless rate of interest = %7.5f  correlation = %8.5f\n",
	   ::rf1, ::corrmpcf ) ;
   printf( "data: equity = %10.6f  debt = %10.6f  firm = %10.6f\n\n",
	   ::mvequi, ::mvdebt, ::mvequi + ::mvdebt ) ;
}
void agcivst::printdata( const ModelFirm& d ) {
   fprintf( ::outval,
       "agency cost: EZC - k L (EZC:ecfconst = %10.6f, k:agcpara = %10.8f)\n",
	    d.getezconst(), d.getagcpara() ) ;
   fprintf( ::outval, "liq.cash: %2.0fY average (1Y) = %10.6f (%8.5f) : ",
	    ::year, d.getez(), d.getez1() ) ;
   fprintf( ::outval, "loss rate %7.4f\n", 1.0 - d.getez()/d.getezconst() ) ;
   fprintf( ::outval, "liq.cash: %2.0fY std.dev. (1Y) = %10.6f (%8.5f)\n",
	    ::year, d.getsz(), d.getsz1() );
   fprintf( ::outval, "%8s%8s%10s%8s%9s%9s %9s%9s%9s\n",
	    "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "WACCt",
	    "valequi", "valdebt", "valfirm" ) ;
   fprintf( ::outval, "%8.4f%8.5f%10.5f%8.5f%9.5f%9.5f %9.4f%9.4f%9.4f\n",
	    d.getdbpay(), d.getbnkprob(), d.getequirr(), d.getdebtrr(),
	    d.getwacc(), d.getwacct(), d.getequimv(), d.getdebtmv(),
	    d.getfirmv() ) ;
   fprintf( ::outval, "%8s%8s%8s%8s\n", "dbratio", "ROA", "ROA1", "debtcf1" ) ;
   fprintf( ::outval, "%8.5f%8.5f%8.5f%8.5f\n\n", d.getdbrati(),
	    d.getez1()/d.getfirmv(), d.getroa(), d.getdbpay1() ) ;
   printf( 
      "agency cost: EZC - k L (EZC:ecfconst = %10.6f, k:agcpara = %10.8f)\n",
      d.getezconst(), d.getagcpara() ) ;
   printf( "liq.cash: %2.0fY average (1Y) = %10.5f (%8.5f) : ",
	   ::year, d.getez(), d.getez1() ) ;
   printf( "loss rate %7.4f\n", 1.0 - d.getez()/d.getezconst() ) ;
   printf( "liq.cash: %2.0fY std.dev. (1Y) = %10.5f (%8.5f)\n",
	   ::year, d.getsz(), d.getsz1() ) ;
   printf( "%8s%8s%8s%8s%8s%8s%9s%9s%9s\n",
	   "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "WACCt", 
	   "valequi", "valdebt", "valfirm" ) ;
   printf( "%8.4f%8.5f%8.5f%8.5f%8.5f%8.5f%9.4f%9.4f%9.4f\n", d.getdbpay(),
	   d.getbnkprob(), d.getequirr(), d.getdebtrr(), d.getwacc(),
	   d.getwacct(), d.getequimv(), d.getdebtmv(), d.getfirmv() ) ;
   printf( "%8s%8s%8s%8s\n", "dbratio", "ROA", "ROA1", "debtcf1" ) ;
   printf( "%8.5f%8.5f%8.5f%8.5f\n\n", d.getdbrati(), 
	   d.getez1()/d.getfirmv(), d.getroa(), d.getdbpay1() ) ; 
}
void agcivst::printdataivst( double ivdeb, const AgcModel& d ) {
  fprintf( ::outval, 
	   "debt amount = %8.4f   investment = %8.4f   debt ratio = %8.5f\n",
	   ivdeb, ::ivst, ivdeb / ::ivst ) ;
  fprintf( ::outval, "RRR on investment = %9.6f      after tax = %9.6f\n",
	   ratretinv1, taxrrinv1 ) ;
  fprintf( ::outval, 
      "search range of Y std.dev.:   minimum = %10.6f   maximum = %10.6f\n",
	   ::std_base*d.getezconst()/::ecfu_base,
	   ::std_base*d.getezconst()/::ecfu_base*(1.0+::intval_std) ) ;
  fprintf( ::outval,
       "old shareholders wealth = %9.4f    old bondholders = %10.4f\n",
	    d.getequimv()-::ivst+ivdeb, d.getdebtmv()-ivdeb );
  fprintf( ::outval, "Calculatio Status ===> %3d\n\n", ::status ) ;
  printf( "debt amount = %8.4f   investment = %8.4f   debt ratio = %8.5f\n",
	  ivdeb, ::ivst, ivdeb/::ivst ) ;
  printf( "RRR on investment = %9.6f      after tax = %9.6f\n",
	  ratretinv1, taxrrinv1 ) ;
  printf( 
     "search range of Y std.dev.:   minimum = %10.5f   maximum = %10.5f\n",
     ::std_base*d.getezconst()/::ecfu_base,
     ::std_base*d.getezconst()/::ecfu_base*(1.0+::intval_std) ) ;
  printf( "old shareholders wealth = %9.4f    old bondholders = %10.4f\n\n",
	   d.getequimv()-::ivst+ivdeb, d.getdebtmv()-ivdeb ) ;
}
double agcivst::chgreturn1( double ret, double inv ) {
  return pow( 1.0 + (ret-inv)/inv, 1.0/::year ) - 1.0 ;
}
int agcivst::checkstatus( double ivdeb, const AgcModel& d ) {
  int idcntl ;
  if ( ratretinv1 != ::misfval3 ) {
    if ( ivdeb/::ivst > 0.99999 ) idcntl = 0 ;
    else if ( ivdeb/::ivst < 0.00001 ) idcntl = 1 ;
    else idcntl = 2 ;
    if ( d.getsz() < ::std_base*d.getezconst()/::ecfu_base*1.00001 )
      return idcntl ;
    else if (d.getsz() > ::std_base * d.getezconst() / ::ecfu_base
	     * (1.0 + ::intval_std) * 0.9999) 
      return 3 + idcntl ;
    else return 6 + idcntl ;
  }
  else return 9 ;
}
procagcivst_sim::procagcivst_sim( double ecfu, double acp ) : agcivst() {
  agcsetting_sim a( ecfu ) ;
  experiment1( ecfu, acp ) ;
//  searchdebt( ecfu, acp ) ;
}
void procagcivst_sim::procsimuagciv( double ecfu, double acp ) {
  ::nfirm++ ; ::cntlid = 0 ; calagcivst( ecfu, acp ) ;
}
void procagcivst_sim::calagcivst( double ecfu, double acp ) {
  ::ecfu_base = ecfu ; ::acp_base = acp ;
  optsearchxy_dcsd op( ::ecfu_base, ::acp_base ) ;
  ::dbcf_base = op.getoptvalx() ; ::std_base = op.getoptvaly() ;
  AgcModel fl( ::dbcf_base, ::std_base, ::ecfu_base, ::acp_base ) ;
  ModelFirm fm( fl ) ;
  ::mvequi_base = fm.getequimv() ; ::mvdebt_base = fm.getdebtmv() ;
  ::wacct_base = fm.getwacct() ;
  setfixedparam2_ivst() ;
  printhead() ; printdata( fm ) ; 
  optsearchx_retinv r ;
  agcivst a2( r.getoptvalx(), 2 ) ;
}
void procagcivst_sim::searchdebt( double ecfu, double acp ) {
  ::ecfu_base = ecfu ; ::acp_base = acp ;
  optsearchxy_dcsd op( ::ecfu_base, ::acp_base ) ;
  ::dbcf_base = op.getoptvalx() ; ::std_base = op.getoptvaly() ;
  AgcModel fl( ::dbcf_base, ::std_base, ::ecfu_base, ::acp_base ) ;
  ModelFirm fm( fl ) ;
  ::mvequi_base = fm.getequimv() ; ::mvdebt_base = fm.getdebtmv() ;
  ::wacct_base = fm.getwacct() ;
  setfixedparam2_ivst() ;
  printhead() ; printdata( fm ) ; 
  double increm = ::ivst/20.0 ;
  for ( double ivdeb = 0.0 ; ivdeb <= ::ivst ; ivdeb += increm )
    agcivst a1( ivdeb, 1 ) ;
  agcivst a2( ::ivst, 1 ) ;
}
void procagcivst_sim::setfixedparam2_ivst() {
  ::xini1 = ::ecfu_base ;    // xini is for ecfu.
  ::xini2 = ::ecfu_base * ( 1.0 + ::intval_ecfu ) ;
  ::yini1 = ::dbcf_base * 0.95 ;      // yini is for dbcf.
  ::yini2 = ::dbcf_base * (1.0 + ::intval_dbcf) ;
  //::ivst = ( ::mvequi + ::mvdebt ) * ::propivst ;
  ::xmin_ivst = 0.0 ;
  ::xmax_ivst = ::ivst ;
}
void procagcivst_sim::experiment1( double ec, double ac ) {   
   procsimuagciv( ec, ac ) ;
   procsimuagciv( ec, ac*0.8 ) ;
   procsimuagciv( ec, ac*0.9 ) ;
   procsimuagciv( ec, ac*1.1 ) ;
   procsimuagciv( ec, ac*1.2 ) ;
   procsimuagciv( ec*0.8, ac ) ;
   procsimuagciv( ec*0.9, ac ) ;
   procsimuagciv( ec*1.1, ac ) ;
   procsimuagciv( ec*1.2, ac ) ;
   ::ivst = 1.0 ;
   procsimuagciv( ec, ac ) ;
   ::ivst = 3.0 ;
   procsimuagciv( ec, ac ) ;
   ::ivst = 5.0 ;
   procsimuagciv( ec, ac ) ;
   //::ivst = 10.0 ; 
   //procsimuagciv( ec, ac ) ;
   ::ivst = 2.0 ;
   ::bcprop = 0.1 ; 
   procsimuagciv( ec, ac ) ;
   ::bcprop = 0.2 ;
   procsimuagciv( ec, ac ) ;
   ::bcprop = 0.3 ;
   procsimuagciv( ec, ac ) ;
   ::bcprop = 0.5 ;
   procsimuagciv( ec, ac ) ; ::bcprop = 0.4 ;
   ::t = 0.25 ;
   procsimuagciv( ec, ac ) ;
   ::t = 0.35 ;
   procsimuagciv( ec, ac ) ;
   ::t = 0.4 ;
   procsimuagciv( ec, ac ) ; ::t = 0.3 ;
   double tmplamb = ::lamb ;
   ::lamb = tmplamb * 0.5 ;
   procsimuagciv( ec, ac ) ;
   ::lamb = tmplamb * 1.5 ;
   procsimuagciv( ec, ac ) ;
   ::lamb = tmplamb * -0.5 ;
   procsimuagciv( ec, ac ) ; ::lamb = tmplamb ;
   double tmpcorr = ::corrmpcf ;
   ::corrmpcf = 0.2 ;
   procsimuagciv( ec, ac ) ;
   ::corrmpcf = 0.8 ;
   procsimuagciv( ec, ac ) ;
   ::corrmpcf = -0.1 ;
   procsimuagciv( ec, ac ) ; ::corrmpcf = tmpcorr ;
}
int main() {
  double ecfu = 50.0, acp = 0.09 ;
  ::outps = fopen( "process.txt", "w" ) ;
  ::outval = fopen( ::outvalfile, "w" ) ;
  ::nfirm = 0 ;
  procagcivst_sim fiv( ecfu, acp ) ;
  fclose( ::outval ) ;
  fclose( ::outps ) ; 
}
