// m5v3agcval5p4.cc
// main procedure for AgcModel
// 130614 C++流の書き換え
// 130623 前バージョンm4v5と完全一致するよう収束パラメタ−の調整
// 130624 プリントの書式変更：簡潔に（Ver2)
// 150612 数値計算ルーチンの変更(Ver3)
// 150805 p4データの再計算。パラメタはp3データと同じ。
// 150810 valdataファイルを一括処理できるようエラー時の出力変更。
#include <cmath>
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include "agcmodel5.h"
FILE *indat, *outps, *outval, *outlss, *outest ;
int bkit = 1, tcode ;
int firmini = 0, firmend = 592, nfirm, cntlid ;
char indatafile[80] = "data/fvst51p4.txt" ; 
char inivalfile[80] = "data/inidata5p4m5v3.txt" ;
char outvalfile[80] = "data/valdata5p4m5v3.txt" ;
char lossfile[80] = "data/lossdata5p4m5v3.txt" ;
char estifile[80] = "data/estidata5p4m5v3.txt" ;
double bkcost[3] = {0.1, 0.3, 0.5} ;
double year = 10.0, t = 0.45, ndprop = 1.0, bcprop ;
double rf1, emp1, smp1, rf, emp, smp, lamb ;
double mvequi, mvdebt, corrmpcf ;
double prop_epsi0 = 0.000000001, epsi0 ;
double prop_epsi1 = 0.00001, epsi1 ;
double prop_epsigld = 0.000001, epsigld ;
double misfval3 = -999.999 ;
double xmin, xmax, ymin, ymax ;
double xini1, xini2, yini1, yini2 ;
double parafp = 3.0, intval = 0.02 ;
/* parameters for simulation
 *  ecf: expected value of (EBIT+liquidation vaule)
 *   ecfconst: expected value of (EBIT+liquidation vaule) for all equity firm
 *  scf: standard deviation of (EBIT+liquidation value)
 *  corrmpcf: correlation between (EBIT+liquidation value) 
 *           and rate of return on the market portfolio,
 *  rf: riskless rate of interest,  rf1: per 1 year, 
 *  emp: expected rate of return on the market portfolio
 *   emp1: per 1 year
 *  smp: standard deviation of rate of return on the market portfolio
 *   smp1: per 1 year
 *  lamb: price of risk
 *  t: corporate income tax rate
 *  bcprop: proportional financial distress cost
 *  ndprop: proportional non-debt tax shield
 */
class agcprocval {
public:
  agcprocval() ;
  ~agcprocval() {}
private:
  void printhead() ;
  void printdata(const ModelFirm& fm ) ;
  int set_data() ;
  void procagency() ;
  void setvalue_findata( float *z ) ;
  int readfile_findata( int *zi, float *z ) ;
  int set_initialvalue( double *ptecf, double *ptacp ) ;
  int readfile_inival( double *ecf, double *acp ) ; 
  void setfixedparam( double valu ) ;
  void setfixedparam2( double ecf, double acp ) ;
  int checkcomp( const AgcModel& d ) ;
} ;
agcprocval::agcprocval() {
  switch( set_data() ) {
  case 5:
    fprintf( ::outval, "TOSYOU CODE:%5d %s\n\n", 
	     ::tcode, "error: initial value inappropriate" ) ;
    break ;
  case 7:
    fprintf( ::outval, "%s\n\n", "error: data inappropriate" ) ;
    break ;
  case 0:
    ::cntlid = 0 ; procagency() ;
  }
}
void agcprocval::procagency() {
  solveqxy_shdb sl( ::mvequi, ::mvdebt ) ;
  optsearchxy_dcsd op( sl.getsolutx(), sl.getsoluty() ) ;
  AgcModel fm( op.getoptvalx(), op.getoptvaly(),
	      sl.getsolutx(), sl.getsoluty() ) ;
  switch( checkcomp( fm ) ) {
  case 9:
    printf( "TOSYOU CODE:%5d %s\n\n", ::tcode, "solution not found" ) ;
    fprintf( ::outval, "TOSYOU CODE:%5d %s\n\n", ::tcode,
	     "error: solution not found" ) ;
    break ;
  case 6:
    printf( "TOSYOU CODE:%5d %s\n\n", ::tcode, "convergent problem" ) ;
    fprintf( ::outval, "TOSYOU CODE:%5d %s\n\n", ::tcode,
	     "error: convergent problem" ) ;
    break ;
  case 0:
    ::nfirm++ ;
    printhead() ;
    ModelFirm fm1( fm ) ; printdata( fm1 ) ;
  }
}
int agcprocval::set_data() {
  int zi[2] ;
  float z[8] ;
  double ecfini, acpini ;
  ::bcprop = ::bkcost[::bkit] ;
  if (readfile_findata( zi, z ) == 0) { 
    setvalue_findata( z ) ;
    ::tcode = zi[0] ;
    setfixedparam( ::mvequi + ::mvdebt ) ;
    if (set_initialvalue( &ecfini, &acpini ) == 0) {
      setfixedparam2( ecfini, acpini ) ; return 0 ;
    }
    else return 5 ;
  }
  else return 7 ;
}
int agcprocval::set_initialvalue( double *ptecf, double *ptacp ) {
  if ( readfile_inival( ptecf, ptacp ) != 0 ) return 5 ;
  else if (( *ptecf <= ::misfval3 * 0.9 ) ||
	   ( *ptacp <= ::misfval3 * 0.9 )) return 6 ; 
  else return 0 ;
}
int agcprocval::readfile_inival( double *ecf, double *acp ) { 
  int code, id = 9 ;
  float z1, z2 ;
  FILE *inini = fopen( ::inivalfile, "r" ) ;
  for ( ; ; ) {
    if (fscanf( inini, "%4d%13f%13f\n", &code, &z1, &z2 ) == 3) {
      if (code == ::tcode) {
	*ecf = double(z1) ; *acp = double(z2) ;
	id = 0 ; break ;
      }
    }
    else break ;
  }
  fclose( inini ) ;
  return id ;
}
void agcprocval::setvalue_findata( float *z ) {
  ::corrmpcf = double(z[0]) ;
  ::emp1 = double(z[1]) ;
  ::smp1 = double(z[2]) ;
  ::rf1 = double(z[3]) ;
  ::mvequi = double(z[5]) / 100.0 ;
  ::mvdebt = double(z[6]) / 100.0 ;
  ::rf = pow( (1.0 + ::rf1), ::year ) - 1.0 ;
  ::emp = pow( (1.0 + ::emp1), ::year ) - 1.0 ;
  ::smp = ::smp1 * sqrt( ::year ) ;
  ::lamb = ( ::emp - ::rf ) / ( ::smp * ::smp ) ;
}
void agcprocval::setfixedparam( double valu ) {
  ::xmin = 0.00001 ;      // x is debt cash payment
  ::xmax = valu * ::parafp ;
  ::ymin = 0.00001 ;  // y is standard deviation of ecf
  ::ymax = valu * ::parafp ;
  ::epsi0 = ::prop_epsi0 * valu ;
  ::epsi1 = ::prop_epsi1 * valu ;
  ::epsigld = ::prop_epsigld * valu ;
}
void agcprocval::setfixedparam2( double ecf, double acp ) {
  ::xini1 = ecf * ( 1.0 - ::intval ) ;
  ::xini2 = ecf * ( 1.0 + ::intval ) ;
  ::yini1 = acp * ( 1.0 - ::intval ) ;
  ::yini2 = acp * ( 1.0 + ::intval ) ;
}
int agcprocval::readfile_findata( int *zi, float *z ) {
  int i = 9 ;
  if (fscanf( ::indat, "%5d%5d%10f%10f%10f%10f%10f%13f%13f%13f\n",
	      &zi[0], &zi[1],
	      &z[0], &z[1], &z[2], &z[3], &z[4], &z[5], &z[6], &z[7] ) == 10)
    i = 0 ;
  return i ;
}
int agcprocval::checkcomp( const AgcModel& d ) {
  if (( d.getezconst() == ::misfval3 ) ||
      ( d.getagcpara() == ::misfval3 )) return 9 ;
  else if (( d.getdbpay() < ::xmin * 1.01 ) ||
	   ( d.getdbpay() > ::xmax * 0.99 )) return 6 ;
  else if (( d.getsz() < ::ymin * 1.01 ) ||
	   ( d.getsz() > ::ymax * 0.99 )) return 6 ;
  else return 0 ;
}
void agcprocval::printhead() {
  fprintf( ::outval, "TOSYOU CODE:%5d %6d\n", ::tcode, ::nfirm ) ;
  fprintf( ::outval, "debtcashflow initial values: %10.6f %10.6f\n",
	   ::xmin, ::xmax ) ;
  fprintf( ::outval, "stddev initial values: %10.6f %10.6f\n",
	   ::ymin, ::ymax ) ;
  fprintf( ::outval, "ecfconst solution interval: %10.6f %10.6f\n",
	   ::xini1, ::xini2 ) ;
  fprintf( ::outval, "agcparam solution interval: %10.8f %10.8f\n",
	   ::yini1, ::yini2 ) ;
  fprintf( ::outval,
	   "tax rate = %4.2f  bankruptcy cost (proportion = %5.3f)\n",
	   ::t, ::bcprop ) ;
  fprintf( ::outval, "non-debt tax shield (proportion = %5.3f)\n", ::ndprop ) ;
  fprintf( ::outval, 
       "market portfolio: average = %7.5f  std.dev = %7.5f  lambda = %9.5f\n",
	   ::emp1, ::smp1, ::lamb ) ;
  fprintf( ::outval,
       "riskless rate of interest = %7.5f  correlation = %8.5f\n",
	    ::rf1, ::corrmpcf ) ;
  fprintf( ::outval, 
       "data: equity = %10.6f  debt = %10.6f  firm = %10.6f\n\n",
	   ::mvequi, ::mvdebt, ::mvequi + ::mvdebt ) ;
  printf( "TOSYOU CODE:%5d %6d\n", ::tcode, ::nfirm ) ;
  printf( "tax rate = %4.2f  bankruptcy cost (proportion = %5.3f)\n",
	  ::t, ::bcprop ) ;
  printf( "non-debt tax shield (proportion = %5.3f)\n", ::ndprop ) ;
  printf(
      "market portfolio: average = %7.5f  std.dev = %7.5f  lambda = %9.5f\n",
      ::emp1, ::smp1, ::lamb ) ;
  printf( "riskless rate of interest = %7.5f  correlation = %8.5f\n",
	  ::rf1, ::corrmpcf ) ;
  printf( "data: equity = %10.6f  debt = %10.6f  firm = %10.6f\n\n",
	  ::mvequi, ::mvdebt, ::mvequi + ::mvdebt ) ;
}
void agcprocval::printdata( const ModelFirm& d ) {
  fprintf( ::outval, 
       "agency cost: EZC - k L (EZC:ecfconst = %10.6f, k:agcpara = %10.8f)\n", 
	   d.getezconst(), d.getagcpara() ) ;
  fprintf( ::outval, "liq.cash: %2.0fY average (1Y) = %10.6f (%8.5f) : ", 
	   ::year, d.getez(), d.getez1() ) ;
  fprintf( ::outval, "loss rate %7.4f\n", 1.0 - d.getez()/d.getezconst() ) ;
  fprintf( ::outval, "liq.cash: %2.0fY std.dev. (1Y) = %10.6f (%8.5f)\n",
	   ::year, d.getsz(), d.getsz1() );
  fprintf( ::outval, "%8s%8s%10s%8s%9s%9s %9s%9s%9s\n",
	   "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "WACCt",
	   "valequi", "valdebt", "valfirm" ) ;
  fprintf( ::outval, "%8.4f%8.5f%10.5f%8.5f%9.5f%9.5f %9.4f%9.4f%9.4f\n",
	   d.getdbpay(), d.getbnkprob(), d.getequirr(), d.getdebtrr(), 
	   d.getwacc(), d.getwacct(), 
	   d.getequimv(), d.getdebtmv(), d.getfirmv() ) ;
  fprintf( ::outval, "%8s%8s%8s%8s\n", "dbratio", "ROA", "ROA1", "debtcf1" ) ;
  fprintf( ::outval, "%8.5f%8.5f%8.5f%8.5f\n\n", 
	   d.getdbrati(), d.getez1() / d.getfirmv(), 
	   d.getroa(), d.getdbpay1() ) ;
  printf( 
     "agency cost: EZC - k L (EZC:ecfconst = %10.6f, k:agcpara = %10.8f)\n",
     d.getezconst(), d.getagcpara() ) ;
  printf( "liq.cash: %2.0fY average (1Y) = %10.5f (%8.5f) : ",
	  ::year, d.getez(), d.getez1() ) ;
  printf( "loss rate %7.4f\n", 1.0 - d.getez()/d.getezconst() ) ;
  printf( "liq.cash: %2.0fY std.dev. (1Y) = %10.5f (%8.5f)\n",
	  ::year, d.getsz(), d.getsz1() ) ;
  printf( "%8s%8s%8s%8s%8s%8s%9s%9s%9s\n",
	  "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "WACCt",
	  "valequi", "valdebt", "valfirm" ) ;
  printf( "%8.4f%8.5f%8.5f%8.5f%8.5f%8.5f%9.4f%9.4f%9.4f\n",
	  d.getdbpay(), d.getbnkprob(), d.getequirr(), d.getdebtrr(), 
	  d.getwacc(), d.getwacct(),
	  d.getequimv(), d.getdebtmv(), d.getfirmv() ) ;
  printf( "%8s%8s%8s%8s\n", "dbratio", "ROA", "ROA1", "debtcf1" ) ;
  printf( "%8.5f%8.5f%8.5f%8.5f\n\n", 
	  d.getdbrati(), d.getez1() / d.getfirmv(), 
	  d.getroa(), d.getdbpay1() ) ; 
  fprintf( ::outest, "%5d %5.2f %12.6f %12.6f %12.6f %12.8f\n",
	   ::tcode, ::bcprop, d.getdbpay(), d.getsz(),
	   d.getezconst(), d.getagcpara() ) ;
  fprintf( ::outlss, "%5d %12.6f %12.6f %12.6f %12.6f %12.6f %12.6f\n",
	   ::tcode, 1.0 - d.getez()/d.getezconst(), d.getagcpara(), 
	   d.getdebtrr(), d.getez1(), d.getsz1(), d.getdbpay1() ) ;
}
int main() {
  ::outps = fopen( "process.txt", "w" ) ;
  ::outval = fopen( ::outvalfile, "w" ) ;
  ::outest = fopen( ::estifile, "w" ) ;
  ::outlss = fopen( ::lossfile, "w" ) ;
  ::indat = fopen( ::indatafile, "r" ) ;
  ::nfirm = 0 ;
  int ifirm = 0 ;
  while ( ifirm < ::firmend ) {
    if ( ifirm >= ::firmini ) agcprocval firm ;
    ifirm++ ;
  }
  fclose( ::indat ) ;
  fclose( ::outval ) ;
  fclose( ::outlss ) ;
  fclose( ::outest ) ;
  fclose( ::outps ) ; 
}
