// m5v3agcsimu1.cc
// main procedure for AgcModel(m5v3) simulation
#include <cmath>
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include "agcmodel5.h"
FILE *outps, *outval ;
int bkit = 1, tcode ;
int firmini, firmend, nfirm, cntlid ;
char outvalfile[80] = "data/simuval2.txt" ;
double bkcost[3] = {0.1, 0.3, 0.5} ;
double year = 10.0, t = 0.3, ndprop = 1.0, bcprop ;
double rf1, emp1, smp1, rf, emp, smp, lamb ;
double mvequi, mvdebt, corrmpcf ;
double prop_epsi0 = 0.000000001, epsi0 ;
double prop_epsi1 = 0.000001, epsi1 ;
double prop_epsigld = 0.0000001, epsigld ;
double misfval3 = -999.999 ;
double xmin, xmax, ymin, ymax ;
double xini1, xini2, yini1, yini2 ;
double parafp = 1.5, intval = 0.02 ;
/* parameters for simulation
 *  ecf: expected value of (EBIT+liquidation vaule)
 *   ecfconst: expected value of (EBIT+liquidation vaule) for all equity firm
 *  scf: standard deviation of (EBIT+liquidation value)
 *  corrmpcf: correlation between (EBIT+liquidation value) 
 *           and rate of return on the market portfolio,
 *  rf: riskless rate of interest,  rf1: per 1 year, 
 *  emp: expected rate of return on the market portfolio
 *   emp1: per 1 year
 *  smp: standard deviation of rate of return on the market portfolio
 *   smp1: per 1 year
 *  lamb: price of risk
 *  t: corporate income tax rate
 *  bcprop: proportional financial distress cost
 *  ndprop: proportional non-debt tax shield
 */
class agcsimu {
public:
  agcsimu() ;
  ~agcsimu() {}
private:
  int set_data() ;
  void setfixedparam( double valu ) ;
  void setvalue_findata() ;
  void procbankrupt( double std, double ecp ) ;
  void procagency( double ecp, double acp ) ;
  int checkcomp( const AgcModel& d ) ;
  void procexperiment1() ;
  void procexperiment2() ;   
  void procexperiment3() ;   
  void printhead() ;
  void printdata( const ModelFirm& fm ) ;
} ;
agcsimu::agcsimu() {
  switch( set_data() ) {
  case 0:
    ::cntlid = 0 ; procexperiment1() ;
    ::cntlid = 0 ; procexperiment2() ;
    ::cntlid = 0 ; procexperiment3() ;
  }
}
int agcsimu::set_data() {
  ::bcprop= ::bkcost[::bkit] ;
  setvalue_findata() ;
  setfixedparam( 50.0 ) ;
  return 0 ;
}
void agcsimu::setfixedparam( double valu ) {
  ::xmin = 0.00001 ;      // x is debt cash payment
  ::xmax = valu * ::parafp ;
  ::ymin = 0.00001 ;  // y is standard deviation of ecf
  ::ymax = valu * ::parafp ;
  ::epsi0 = ::prop_epsi0 * valu ;
  ::epsi1 = ::prop_epsi1 * valu ;
  ::epsigld = ::prop_epsigld * valu ;
  ::xini1 = 0.0 ;
  ::xini2 = 0.0 ;
  ::yini1 = 0.0 ;
  ::yini2 = 0.0 ;
}
void agcsimu::setvalue_findata() {
   ::corrmpcf = 0.4 ;
   ::emp1 = 0.13 ;
   ::smp1 = 0.25 ;
   ::rf1 = 0.06 ;
   ::tcode = 9999 ;
   ::mvdebt = 99.99 ;
   ::mvequi = 99.99 ;
   ::rf = pow( (1.0 + ::rf1), ::year ) - 1.0 ;
   ::emp = pow( (1.0 + ::emp1), ::year ) - 1.0 ;
   ::smp = ::smp1 * sqrt( ::year ) ;
   ::lamb = ( ::emp - ::rf ) / ( ::smp * ::smp ) ;
}
void agcsimu::procbankrupt( double std, double ecp ) {
  optsearchx_dc op( std, ecp, 0.0 ) ;
  AgcModel fm( op.getoptvalx(), std, ecp, 0.0 ) ;
  switch( checkcomp( fm ) ) {
  case 9:
    printf( "TOSYOU CODE:%5d %s\n\n", ::tcode, "solution not found" ) ;
    fprintf( ::outval, "TOSYOU CODE:%5d %s\n\n", ::tcode,
	     "error: solution not found" ) ;
    break ;
  case 6:
    printf( "TOSYOU CODE:%5d %s\n\n", ::tcode, "convergent problem" ) ;
    fprintf( ::outval, "TOSYOU CODE:%5d %s\n\n", ::tcode,
	     "error: convergent problem" ) ;
    break ;
  case 0:
    ::nfirm++ ;
    printhead() ;
    ModelFirm fm1( fm ) ; printdata( fm1 ) ;
  }
}
void agcsimu::procagency( double ecp, double acp ) {
  optsearchxy_dcsd op( ecp, acp ) ;
  AgcModel fm( op.getoptvalx(), op.getoptvaly(), ecp, acp ) ;
  switch( checkcomp( fm ) ) {
  case 9:
    printf( "TOSYOU CODE:%5d %s\n\n", ::tcode, "solution not found" ) ;
    fprintf( ::outval, "TOSYOU CODE:%5d %s\n\n", ::tcode,
	     "error: solution not found" ) ;
    break ;
  case 6:
    printf( "TOSYOU CODE:%5d %s\n\n", ::tcode, "convergent problem" ) ;
    fprintf( ::outval, "TOSYOU CODE:%5d %s\n\n", ::tcode,
	     "error: convergent problem" ) ;
    break ;
  case 0:
    ::nfirm++ ;
    printhead() ;
    ModelFirm fm1( fm ) ; printdata( fm1 ) ;
   }
}
int agcsimu::checkcomp( const AgcModel& d ) {
  if (( d.getezconst() == ::misfval3 ) ||
      ( d.getagcpara() == ::misfval3 )) return 9 ;
  else if (( d.getdbpay() < ::xmin * 1.01 ) ||
	   ( d.getdbpay() > ::xmax * 0.99 )) return 6 ;
  else if (( d.getsz() < ::ymin * 1.01 ) ||
	   ( d.getsz() > ::ymax * 0.99 )) return 6 ;
  else return 0 ;
}
void agcsimu::procexperiment1() {
   double stdcf = 3.0 * sqrt( ::year ) ;
   ::bcprop = 0.1 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   ::bcprop = 0.2 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   ::bcprop = 0.3 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   ::bcprop = 0.5 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   ::bcprop = 0.6 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   ::bcprop = 0.7 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   ::bcprop = 0.8 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   ::bcprop = 0.9 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   ::bcprop = 0.4 ;
   procbankrupt( stdcf, 50.0 ) ; // scf1=3.0 ecfconst=50.0 agcpara=0.0 
   procbankrupt( stdcf, 30.0 ) ; // scf1=3.0 ecfconst=30.0 agcpara=0.0 
   procbankrupt( stdcf, 35.0 ) ; // scf1=3.0 ecfconst=35.0 agcpara=0.0 
   procbankrupt( stdcf, 40.0 ) ; // scf1=3.0 ecfconst=40.0 agcpara=0.0 
   procbankrupt( stdcf, 45.0 ) ; // scf1=3.0 ecfconst=45.0 agcpara=0.0 
   procbankrupt( stdcf, 55.0 ) ; // scf1=3.0 ecfconst=55.0 agcpara=0.0 
   procbankrupt( stdcf, 60.0 ) ; // scf1=3.0 ecfconst=60.0 agcpara=0.0 
   procbankrupt( stdcf, 65.0 ) ; // scf1=3.0 ecfconst=65.0 agcpara=0.0 
   procbankrupt( stdcf, 70.0 ) ; // scf1=3.0 ecfconst=70.0 agcpara=0.0 
}
void agcsimu::procexperiment2() {   
   ::bcprop = 0.4 ;
   procagency( 50.0, 0.0 ) ;   // ecfconst=50.0 agcpara=0.0
   procagency( 30.0, 0.0 ) ;   // ecfconst=30.0 agcpara=0.0
   procagency( 35.0, 0.0 ) ;   // ecfconst=35.0 agcpara=0.0
   procagency( 40.0, 0.0 ) ;   // ecfconst=40.0 agcpara=0.0
   procagency( 45.0, 0.0 ) ;   // ecfconst=45.0 agcpara=0.0
   procagency( 55.0, 0.0 ) ;   // ecfconst=55.0 agcpara=0.0
   procagency( 60.0, 0.0 ) ;   // ecfconst=60.0 agcpara=0.0
   procagency( 65.0, 0.0 ) ;   // ecfconst=65.0 agcpara=0.0
   procagency( 70.0, 0.0 ) ;   // ecfconst=70.0 agcpara=0.0
   procagency( 50.0, 0.01 ) ;  // ecfconst=50.0 agcpara=0.01
   procagency( 50.0, 0.03 ) ;  // ecfconst=50.0 agcpara=0.03
   procagency( 50.0, 0.05 ) ;  // ecfconst=50.0 agcpara=0.05
   procagency( 50.0, 0.07 ) ;  // ecfconst=50.0 agcpara=0.07
   procagency( 50.0, 0.09 ) ;  // ecfconst=50.0 agcpara=0.09
   procagency( 50.0, 0.11 ) ;  // ecfconst=50.0 agcpara=0.11
   procagency( 50.0, 0.13 ) ;  // ecfconst=50.0 agcpara=0.13
   procagency( 50.0, 0.15 ) ;  // ecfconst=50.0 agcpara=0.15
   procagency( 50.0, 0.17 ) ;  // ecfconst=50.0 agcpara=0.17
   procagency( 50.0, 0.18 ) ;  // ecfconst=50.0 agcpara=0.18
}
void agcsimu::procexperiment3() {   
   ::bcprop = 0.1 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::bcprop = 0.2 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::bcprop = 0.3 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::bcprop = 0.5 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::bcprop = 0.6 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::bcprop = 0.7 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::bcprop = 0.4 ;
   procagency( 35.0, 0.09 ) ; // ecfconst=35.0 agcpara=0.09
   procagency( 40.0, 0.09 ) ; // ecfconst=40.0 agcpara=0.09
   procagency( 45.0, 0.09 ) ; // ecfconst=45.0 agcpara=0.09
   procagency( 55.0, 0.09 ) ; // ecfconst=55.0 agcpara=0.09
   procagency( 60.0, 0.09 ) ; // ecfconst=60.0 agcpara=0.09
   procagency( 65.0, 0.09 ) ; // ecfconst=65.0 agcpara=0.09
   procagency( 70.0, 0.09 ) ; // ecfconst=70.0 agcpara=0.09
   ::t = 0.2 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::t = 0.25 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::t = 0.35 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::t = 0.4 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
   ::t = 0.45 ;
   procagency( 50.0, 0.09 ) ; // ecfconst=50.0 agcpara=0.09
}
void agcsimu::printhead() {
  fprintf( ::outval, "TOSYOU CODE:%5d %6d\n", ::tcode, ::nfirm ) ;
  fprintf( ::outval, "debtcashflow initial values: %10.6f %10.6f\n",
	   ::xmin, ::xmax ) ;
  fprintf( ::outval, "stddev initial values: %10.6f %10.6f\n",
	   ::ymin, ::ymax ) ;
  fprintf( ::outval, "ecfconst solution interval: %10.6f %10.6f\n",
	   ::xini1, ::xini2 ) ;
  fprintf( ::outval, "agcparam solution interval: %10.8f %10.8f\n",
	   ::yini1, ::yini2 ) ;
  fprintf( ::outval,
	   "tax rate = %4.2f  bankruptcy cost (proportion = %5.3f)\n",
	   ::t, ::bcprop ) ;
  fprintf( ::outval, "non-debt tax shield (proportion = %5.3f)\n", ::ndprop ) ;
  fprintf( ::outval, 
       "market portfolio: average = %7.5f  std.dev = %7.5f  lambda = %9.5f\n",
	   ::emp1, ::smp1, ::lamb ) ;
  fprintf( ::outval,
       "riskless rate of interest = %7.5f  correlation = %8.5f\n",
	    ::rf1, ::corrmpcf ) ;
  fprintf( ::outval, 
       "data: equity = %10.6f  debt = %10.6f  firm = %10.6f\n\n",
	   ::mvequi, ::mvdebt, ::mvequi + ::mvdebt ) ;
  printf( "TOSYOU CODE:%5d %6d\n", ::tcode, ::nfirm ) ;
  printf( "tax rate = %4.2f  bankruptcy cost (proportion = %5.3f)\n",
	  ::t, ::bcprop ) ;
  printf( "non-debt tax shield (proportion = %5.3f)\n", ::ndprop ) ;
  printf(
      "market portfolio: average = %7.5f  std.dev = %7.5f  lambda = %9.5f\n",
      ::emp1, ::smp1, ::lamb ) ;
  printf( "riskless rate of interest = %7.5f  correlation = %8.5f\n",
	  ::rf1, ::corrmpcf ) ;
  printf( "data: equity = %10.6f  debt = %10.6f  firm = %10.6f\n\n",
	  ::mvequi, ::mvdebt, ::mvequi + ::mvdebt ) ;
}
void agcsimu::printdata( const ModelFirm& d ) {
  fprintf( ::outval, 
       "agency cost: EZC - k L (EZC:ecfconst = %10.6f, k:agcpara = %10.8f)\n", 
	   d.getezconst(), d.getagcpara() ) ;
  fprintf( ::outval, "liq.cash: %2.0fY average (1Y) = %10.6f (%8.5f) : ", 
	   ::year, d.getez(), d.getez1() ) ;
  fprintf( ::outval, "loss rate %7.4f\n", 1.0 - d.getez()/d.getezconst() ) ;
  fprintf( ::outval, "liq.cash: %2.0fY std.dev. (1Y) = %10.6f (%8.5f)\n",
	   ::year, d.getsz(), d.getsz1() );
  fprintf( ::outval, "%8s%8s%10s%8s%9s%9s %9s%9s%9s\n",
	   "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "WACCt",
	   "valequi", "valdebt", "valfirm" ) ;
  fprintf( ::outval, "%8.4f%8.5f%10.5f%8.5f%9.5f%9.5f %9.4f%9.4f%9.4f\n",
	   d.getdbpay(), d.getbnkprob(), d.getequirr(), d.getdebtrr(), 
	   d.getwacc(), d.getwacct(), 
	   d.getequimv(), d.getdebtmv(), d.getfirmv() ) ;
  fprintf( ::outval, "%8s%8s%8s%8s\n", "dbratio", "ROA", "ROA1", "debtcf1" ) ;
  fprintf( ::outval, "%8.5f%8.5f%8.5f%8.5f\n\n", 
	   d.getdbrati(), d.getez1() / d.getfirmv(), 
	   d.getroa(), d.getdbpay1() ) ;
  printf( 
     "agency cost: EZC - k L (EZC:ecfconst = %10.6f, k:agcpara = %10.8f)\n",
     d.getezconst(), d.getagcpara() ) ;
  printf( "liq.cash: %2.0fY average (1Y) = %10.5f (%8.5f) : ",
	  ::year, d.getez(), d.getez1() ) ;
  printf( "loss rate %7.4f\n", 1.0 - d.getez()/d.getezconst() ) ;
  printf( "liq.cash: %2.0fY std.dev. (1Y) = %10.5f (%8.5f)\n",
	  ::year, d.getsz(), d.getsz1() ) ;
  printf( "%8s%8s%8s%8s%8s%8s%9s%9s%9s\n",
	  "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "WACCt",
	  "valequi", "valdebt", "valfirm" ) ;
  printf( "%8.4f%8.5f%8.5f%8.5f%8.5f%8.5f%9.4f%9.4f%9.4f\n",
	  d.getdbpay(), d.getbnkprob(), d.getequirr(), d.getdebtrr(), 
	  d.getwacc(), d.getwacct(),
	  d.getequimv(), d.getdebtmv(), d.getfirmv() ) ;
  printf( "%8s%8s%8s%8s\n", "dbratio", "ROA", "ROA1", "debtcf1" ) ;
  printf( "%8.5f%8.5f%8.5f%8.5f\n\n", 
	  d.getdbrati(), d.getez1() / d.getfirmv(), 
	  d.getroa(), d.getdbpay1() ) ; 
}
int main() {
  ::outps = fopen( "process.txt", "w" ) ;
  ::outval = fopen( ::outvalfile, "w" ) ;
  ::nfirm = 0 ;
  agcsimu a1 ;
  fclose( ::outps ) ; 
  fclose( ::outval ) ;
}
