// m5v3agcini5p4.cc
// initial value calculation for AgcModel
// 080520 投資の計算に伴うデータ変更による修正：shrrstdの追加
// 090119 データ期間3の変更に伴う再計算
// 130614 C++流の書き換え and 収束計算の変更
// 130623 前バージョンm4v5と完全一致するよう収束パラメタ−の調整
// 150805 p4データの再計算。パラメタはp3データと同じ
#include <cmath>
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include "agcmodel5.h"
FILE *indat, *outps, *outini ;
int bkit = 1, tcode ;
int firmini = 0, firmend = 592, cntlid ;
char indatafile[80] = "data/fvst51p4.txt" ; 
char outinifile[80] = "data/inidata5p4m5v3.txt" ;
double bkcost[3] = {0.1, 0.3, 0.5} ;
double year = 10.0, t = 0.45, ndprop = 1.0, bcprop ;
double rf1, emp1, smp1, rf, emp, smp, lamb ;
double mvequi, mvdebt, corrmpcf ;
double prop_epsi0 = 0.000000001, epsi0 ;
double prop_epsi1 = 0.00001, epsi1 ;
double prop_epsigld = 0.000001, epsigld ;
double misfval3 = -999.999, distini = 1000000.0 ;
double xmin, xmax, ymin, ymax ;
double xini1, xini2, yini1, yini2 ;
double ecpminmp = 1.5, ecpmaxmp = 8.5, acpmin = 0.01, acpmax = 0.7 ; 
/* parameters for simulation
 *  ecf: expected value of (EBIT+liquidation vaule)
 *   ecfconst: expected value of (EBIT+liquidation vaule) for all equity firm
 *  scf: standard deviation of (EBIT+liquidation value)
 *  corrmpcf: correlation between (EBIT+liquidation value) 
 *           and rate of return on the market portfolio,
 *  rf: riskless rate of interest,  rf1: per 1 year, 
 *  emp: expected rate of return on the market portfolio
 *   emp1: per 1 year
 *  smp: standard deviation of rate of return on the market portfolio
 *   smp1: per 1 year
 *  lamb: price of risk
 *  t: corporate income tax rate
 *  bcprop: proportional financial distress cost
 *  ndprop: proportional non-debt tax shield
 */
class agcprocini {
 public:
   agcprocini() ;
   ~agcprocini() {}
 private:
   void printinival( const AgcModel& d ) ;
   int set_data() ;
   void procini() ;
   void findinival( double valu, double *ecpoptini, double *acpoptini ) ;
   double proccaldist( int id, double ecp, double acp ) ;
   void setvalue_findata( float *z ) ;
   int readfile_findata( int *zi, float *z ) ;
   void setfixedparam( double valu ) ;
   int checkinival( double valu, double ecp, double acp ) ;
} ;
agcprocini::agcprocini() {
  switch( set_data() ) {
  case 7:
    printf( "%s\n\n", "data inappropriate" ) ;
    break ;
  case 0:
    ::cntlid = 0 ;
    procini() ;
  }
}
void agcprocini::procini() {
  double ecfini, acpini, dist ;
  findinival( ::mvequi+::mvdebt, &ecfini, &acpini ) ;
  if ((checkinival( ::mvequi + ::mvdebt, ecfini, acpini ) == 0) &&
      ((dist = proccaldist( 1, ecfini, acpini )) != ::misfval3)) {
    fprintf( ::outini, "%4d %12.5f %12.7f\n", ::tcode, ecfini, acpini ) ;
    printf( "dist= %7.5f\n", dist ) ;
  }
  else {
    fprintf( outini, "%4d %12.3f %12.3f\n", ::tcode, ::misfval3, ::misfval3 ) ;
    printf( " %s\n", "initial values not appropriate" ) ;
  }
}
void agcprocini::findinival( double valu,
			     double *ecpoptini, double *acpoptini ) {
  double mindist = ::distini, dist ;
  double ecpmin = valu * ::ecpminmp, ecpmax = valu * ::ecpmaxmp ;
  double ecpdif = (ecpmax - ecpmin) / 50.0 ;
  double acpdif = (::acpmax - ::acpmin) / 50.0 ;
  for ( double ecp = ecpmin ; ecp <= ecpmax ; ecp += ecpdif ) {
    for ( double acp = ::acpmin ; acp <= ::acpmax ; acp += acpdif ) {
      dist = proccaldist( 0, ecp, acp ) ;
      if (( dist > 0.0 ) && ( dist < mindist )) {
	mindist = dist ;
	*ecpoptini = ecp ;
	*acpoptini = acp ;
	printf( "%4d %12.5f %12.5f %12.5f\n", ::tcode, ecp, acp, dist ) ;
      }
    }
  }
}
int agcprocini::checkinival( double valu, double ecp, double acp ) {
   double ecpmin = valu * ::ecpminmp, ecpmax = valu * ::ecpmaxmp ;
   if (((ecpmin * 1.01 < ecp) && (ecp < ecpmax * 0.99)) &&
       ((::acpmin * 1.01 < acp) && (acp < ::acpmax * 0.99))) return 0 ;
   else return 1 ;
}
double agcprocini::proccaldist( int id, double ecp, double acp ) {
  optsearchxy_dcsd op( ecp, acp ) ;
  if (((::xmin * 1.1 < op.getoptvalx()) &&
       (op.getoptvalx() < ::xmax * 0.9)) &&
      ((::ymin * 1.1 < op.getoptvaly()) &&
       (op.getoptvaly() < ::ymax * 0.9))) {
    AgcModel fl( op.getoptvalx(), op.getoptvaly(), ecp, acp ) ;
    if ( id == 1 ) printinival( fl ) ;
    return pow((fl.getequimv()-::mvequi), 2) 
      + pow((fl.getdebtmv()-::mvdebt), 2) ;
  }
  else return ::misfval3 ;
}
int agcprocini::set_data() {
   int zi[2] ;
   float z[8] ;
   ::bcprop = ::bkcost[::bkit] ;
   if (readfile_findata( zi, z ) == 0 ) { 
     setvalue_findata( z ) ;
     ::tcode = zi[0] ;
     setfixedparam( ::mvequi+::mvdebt ) ; return 0 ;
   }
   else return 7 ;
}
void agcprocini::setvalue_findata( float *z ) {
   ::corrmpcf = double(z[0]) ;
   ::emp1 = double(z[1]) ;
   ::smp1 = double(z[2]) ;
   ::rf1 = double(z[3]) ;
   ::mvequi = double(z[5]) / 100.0 ;
   ::mvdebt = double(z[6]) / 100.0 ;
   ::rf = pow( (1.0 + ::rf1), ::year ) - 1.0 ;
   ::emp = pow( (1.0 + ::emp1), ::year ) - 1.0 ;
   ::smp = ::smp1 * sqrt( ::year ) ;
   ::lamb = ( ::emp - ::rf ) / ( ::smp * ::smp ) ;
}
void agcprocini::setfixedparam( double valu ) {
  ::xmin = 0.00001 ;      // x is debt cash payment
  ::xmax = valu * ::ecpmaxmp ;
  ::ymin = 0.00001 ;  // y is standard deviation of ecf
  ::ymax = valu * 3.7 ;
  ::epsi0 = ::prop_epsi0 * valu ;
  ::epsi1 = ::prop_epsi1 * valu ;
  ::epsigld = ::prop_epsigld * valu ;
}
int agcprocini::readfile_findata( int *zi, float *z ) {
   int i = 9 ;
   if ( fscanf( ::indat, "%5d%5d%10f%10f%10f%10f%10f%13f%13f%13f\n",
	       &zi[0], &zi[1],
	       &z[0], &z[1], &z[2], &z[3], &z[4], &z[5], &z[6], &z[7] ) == 10 )
     i = 0 ;
   return i ;
}
void agcprocini::printinival( const AgcModel& d ) {
  printf( "%4d ecfcst=%5.2f acp=%7.5f dcf=%6.2f sZ=%7.3f ve=%7.3f vb=%7.3f\n",
	  ::tcode, d.getezconst(), d.getagcpara(), d.getdbpay(),
	  d.getsz(), d.getequimv(), d.getdebtmv() ) ;
}
int main( void ) {
  ::indat = fopen( ::indatafile, "r" ) ;
  ::outps = fopen( "process.txt", "w" ) ;
  ::outini = fopen( ::outinifile, "w" ) ;
  for (int i = 0 ; i < ::firmend ; i++) {
    if ( i >= ::firmini ) agcprocini firm ;
    else break ;
  }
  fclose( ::outps ) ; 
  fclose( ::outini ) ;
  fclose( ::indat ) ;
}
