// m5v3agceffect2.cc
// simulation for agecny effect 2
// 081216 modify the mistake found in m4agceffect1.cc
//        change an example for debt-overhang
// 161230 m5v3への対応。m4と結果一致(effectsum2)。
//        ただしprintdataの変更によりeffect2は若干異なる
#include <cmath>
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include "agcmodel5.h"
FILE *outps, *outval, *outest ;
int tcode, nfirm, cntlid, printcntl = 1 ;
char outfile[80] = "data/effect2m5v3.txt" ;
char outsumfile[80] = "data/effectsum2m5v3.txt" ;
double year = 10.0, t = 0.45, ndprop = 1.0, bcprop = 0.3 ;
double rf1, emp1, smp1, rf, emp, smp, lamb ;
double mvequi, mvdebt, corrmpcf ;
double prop_epsi0 = 0.0000001, epsi0 ;
double prop_epsi1 = 0.0000001, epsi1 ;
double prop_epsigld = 0.0000001, epsigld ;
double misfval3 = -999.999 ;
double xmin, xmax, ymin, ymax ;
double xini1, xini2, yini1, yini2 ;
double xi[9] = { 293, 9, 7, 6, 5, -5, -10, -15, -20 } ;
/* parameters for simulation
 *  ecf: expected value of (EBIT+liquidation vaule)
 *   ecfconst: expected value of (EBIT+liquidation vaule) for all equity firm
 *  scf: standard deviation of (EBIT+liquidation value)
 *  corrmpcf: correlation between (EBIT+liquidation value) 
 *           and rate of return on the market portfolio,
 *  rf: riskless rate of interest,  rf1: per 1 year, 
 *  emp: expected rate of return on the market portfolio
 *   emp1: per 1 year
 *  smp: standard deviation of rate of return on the market portfolio
 *   smp1: per 1 year
 *  lamb: price of risk
 *  t: corporate income tax rate
 *  bcprop: proportional financial distress cost
 *  ndprop: proportional non-debt tax shield
 */
class agceffect {
 protected:
  double ecfconst, scfconst, ufirm, equi, debt, firm ;
  double preequi, ivst ;
  void printdata( ModelFirm& d, int cntl ) ;
  void printdata_summary_header( double valu ) ;
  void printdata_summary( AgcModel& d ) ;
  void setfixedparam( double valu ) ;
  void setvalue_findata() ;
  void procdebtover( double dbpay ) ;
  void procassetsub( double dbpay ) ;
  AgcModel calmodel( double dbpay, double stdcf, double expcf ) ;
  void proccomp() ;
 public:
  agceffect() ;
  ~agceffect() {}
} ;
agceffect::agceffect() {
  for ( int i = 0; i < 5 ; i++ ) ecfconst += ::xi[i] ;
  scfconst = 10 * sqrt( ::year ) ;
  proccomp() ;
}
void agceffect::proccomp() {
  setfixedparam( 1.0 ) ;
  setvalue_findata() ;
  ::cntlid = 0 ;
  double dbpay ;
  //debt overhang
  dbpay = 0 ; procdebtover( dbpay ) ;
  dbpay = 265 ; procdebtover( dbpay ) ;
  dbpay = 272 ; procdebtover( dbpay ) ;
  dbpay = 283 ; procdebtover( dbpay ) ;
  dbpay = 287 ; procdebtover( dbpay ) ;
  dbpay = 289 ; procdebtover( dbpay ) ;
  //asset substitution
  dbpay = 268 ; procassetsub( dbpay ) ;
  dbpay = 288 ; procassetsub( dbpay ) ;
  dbpay = 300 ; procassetsub( dbpay ) ;
  dbpay = 305 ; procassetsub( dbpay ) ;
  dbpay = 310 ; procassetsub( dbpay ) ;
}
AgcModel agceffect::calmodel( double dbpay, double stdcf, double expcf ) {
  AgcModel fl( dbpay, stdcf, expcf, 0.0 ) ;
  printdata_summary( fl ) ;
  ModelFirm fl1(fl) ; printdata( fl1, ::printcntl ) ; 
  return fl ;
}
void agceffect::printdata_summary_header( double valu ) {
  fprintf( ::outest, "\n%6.1f\n", valu ) ;
  printf( "\n%6.1f\n", valu ) ;
}
void agceffect::printdata_summary( AgcModel& d ) {
  fprintf ( ::outest, "%8.2f &%10.3f &%5.1f &%8.2f &%7.1f &%8.2f\n", d.getequimv(), d.getequimv()-preequi, ivst, d.getfirmv(), d.getez(), d.getsz() ) ;
  printf ( "%8.2f %10.3f %5.1f %8.2f %7.1f %8.2f\n", d.getequimv(), d.getequimv()-preequi, ivst, d.getfirmv(), d.getez(), d.getsz() ) ;
}
void agceffect::procdebtover( double dpay ) {
  double ecf = ::xi[0], scf = scfconst * ecf / ecfconst ;
  preequi = 0.0 ; ivst = 0.0 ; printdata_summary_header( dpay ) ;
  AgcModel fo = calmodel( dpay, scf, ecf ) ; preequi = fo.getequimv() ;
  for ( int i = 1 ; i < 5 ; i++ ) {
    ecf += ::xi[i] ; scf = scfconst * ecf / ecfconst ; ivst = 2.0 ;
    AgcModel f = calmodel( dpay, scf, ecf ) ; preequi = f.getequimv() ;
  }
}
void agceffect::procassetsub( double dpay ) {
  double ecf = ecfconst, scf = scfconst ;
  preequi = 0.0 ; ivst = 0.0 ; printdata_summary_header( dpay ) ;
  AgcModel f0 = calmodel( dpay, scf, ecf ) ; preequi = f0.getequimv() ;
  for ( int i = 5 ; i < 9 ; i++ ) {
    ecf = ecfconst+::xi[i] ; scf = scfconst * ecf / ecfconst ; ivst = 2.0 ;
    AgcModel f1 = calmodel( dpay, 3.0*scf, ecf ) ; 
  }
}
void agceffect::setfixedparam( double valu ) {
  ::xmin = 0.0001 ;      // x is debt cash payment
  ::xmax = 500.0 ;
  ::ymin = 0.00001 ;  // y is standard deviation of ecf
  ::ymax = 200.0 ;
  ::epsi0 = ::prop_epsi0 * valu ;
  ::epsi1 = ::prop_epsi1 * valu ;
  ::epsigld = ::prop_epsigld * valu ;
  ::xini1 = 0.0 ;
  ::xini2 = 0.0 ;
  ::yini1 = 0.0 ;
  ::yini2 = 0.0 ;
}
void agceffect::setvalue_findata() {
   ::corrmpcf = 0.4 ;
   ::emp1 = 0.07706 ;
   ::smp1 = 0.17885 ;
   ::rf1 = 0.054 ;
   ::tcode = 9999 ;
   ::mvdebt = 99.99 ;
   ::mvequi = 99.99 ;
   ::rf = pow( (1.0 + ::rf1), ::year ) - 1.0 ;
   ::emp = pow( (1.0 + ::emp1), ::year ) - 1.0 ;
   ::smp = ::smp1 * sqrt( ::year ) ;
   ::lamb = ( ::emp - ::rf ) / ( ::smp * ::smp ) ;
}
void agceffect::printdata( ModelFirm& d, int cntl ) {
// cntl=0:file+console   cntl=1:file  cntl=2:console
  if ( cntl == 0 || cntl == 1 ) {
    fprintf( ::outval, "agency cost: EZC - k L (EZC:ecfconst = %10.6f, k:agcpara = %10.8f)\n", d.getezconst(), d.getagcpara() ) ;
    fprintf( ::outval, "liq.cash: %2.0fY average (1Y) = %10.6f (%8.5f) : ", ::year, d.getez(), d.getez1() ) ;
    fprintf( ::outval, "loss rate %7.4f\n", 1.0 - d.getez()/d.getezconst() ) ;
    fprintf( ::outval, "liq.cash: %2.0fY std.dev. (1Y) = %10.6f (%8.5f)\n", ::year, d.getsz(), d.getsz1() );
    fprintf( ::outval, "tax rate = %4.2f  bankruptcy cost (proportion = %5.3f)\n", ::t, ::bcprop ) ;
    fprintf( ::outval, "non-debt tax shield (proportion = %5.3f)\n", ::ndprop ) ;
    fprintf( ::outval, "market portfolio: average = %7.5f  std.dev = %7.5f  lambda = %9.5f\n", ::emp1, ::smp1, ::lamb ) ;
    fprintf( ::outval, "riskless rate of interest = %7.5f  correlation = %8.5f\n", ::rf1, ::corrmpcf ) ;
    fprintf( ::outval, "data: equity = %10.6f  debt = %10.6f  firm = %10.6f\n\n", ::mvequi, ::mvdebt, ::mvequi + ::mvdebt ) ;
    fprintf( ::outval, "%8s%8s%10s%8s%9s%9s %9s%9s%9s\n", "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "WACCt","valequi", "valdebt", "valfirm" ) ;
    fprintf( ::outval, "%8.4f%8.5f%10.5f%8.5f%9.5f%9.5f %9.4f%9.4f%9.4f\n", d.getdbpay(), d.getbnkprob(), d.getequirr(), d.getdebtrr(), d.getwacc(), d.getwacct(), d.getequimv(), d.getdebtmv(), d.getfirmv() ) ;
    fprintf( ::outval, "%8s%8s%8s\n", "dbratio", "ROA", "ROA1" ) ;
    fprintf( ::outval, "%8.5f%8.5f%8.5f\n\n", d.getdbrati(), d.getez1()/d.getfirmv(), d.getroa() ) ;
  }
  if ( cntl == 0 || cntl == 2 ) {
    printf( "agency cost: EZC - k L (EZC:ecfconst = %10.6f, k:agcpara = %10.8f)\n", d.getezconst(), d.getagcpara() ) ;
    printf( "liq.cash: %2.0fY average (1Y) = %10.5f (%8.5f) : ", ::year, d.getez(), d.getez1() ) ;
    printf( "loss rate %7.4f\n", 1.0 - d.getez()/d.getezconst() ) ;
    printf( "liq.cash: %2.0fY std.dev. (1Y) = %10.5f (%8.5f)\n", ::year, d.getsz(), d.getsz1() ) ;
    printf( "tax rate = %4.2f  bankruptcy cost (proportion = %5.3f)\n", ::t, ::bcprop ) ;
    printf( "non-debt tax shield (proportion = %5.3f)\n", ::ndprop ) ;
    printf( "market portfolio: average = %7.5f  std.dev = %7.5f  lambda = %9.5f\n", ::emp1, ::smp1, ::lamb ) ;
    printf( "riskless rate of interest = %7.5f  correlation = %8.5f\n", ::rf1, ::corrmpcf ) ;
    printf( "data: equity = %10.6f  debt = %10.6f  firm = %10.6f\n\n", ::mvequi, ::mvdebt, ::mvequi + ::mvdebt ) ;
    printf( "%8s%8s%8s%8s%8s%8s%9s%9s%9s\n", "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "WACCt", "valequi", "valdebt", "valfirm" ) ;
    printf( "%8.4f%8.5f%8.5f%8.5f%8.5f%8.5f%9.4f%9.4f%9.4f\n", d.getdbpay(), d.getbnkprob(), d.getequirr(), d.getdebtrr(), d.getwacc(), d.getwacct(), d.getequimv(), d.getdebtmv(), d.getfirmv() ) ;
    printf( "%8s%8s%8s\n", "dbratio", "ROA", "ROA1" ) ;
    printf( "%8.5f%8.5f%8.5f\n\n", d.getdbrati(), d.getez1()/d.getfirmv(), d.getroa() ) ; 
  }
}
int main() {
  ::outps = fopen( "process.txt", "w" ) ;
  ::outval = fopen( ::outfile, "w" ) ;
  ::outest = fopen( ::outsumfile, "w" ) ;
  ::nfirm = 0 ;
  agceffect a1 ;
  fclose( ::outps ) ;
  fclose( ::outval ) ;
  fclose( ::outest ) ;
}
