//<agcmodel5.h>
// agency cost model: EZ = EZC - a * L : fixed version of model3
// 080521 L52をコメントアウト
// 090121 ez1とsz1の修正＋dbpay1の追加
// 130614 C++流の書き換えand procsecantの収束方法を変更
// 130622 数値計算を外部化(ProcSecantとProcGoldDiv)，その他クラス名の大幅変更
// 141116 修正：AgcModel::copyparams()のbkprop→bkcostに修正…多分無害
// 150531 optsearchxyとsolveqxyの派生をやめる(基底クラス化)。
//        optsearchxyとsolveqxyから派生させる際，「D is a B」原則が明確に。
// 150612 optsearchとsolveqの基底クラスを純粋仮想化(numertoolsへ)
//        すべてのoptsearchとsolveqの実装を派生クラスで。
#include <cmath>
#include <cstdio>
#include "numertools.h"
extern FILE *outps ;
extern int tcode, cntlid ;
extern double year, bcprop, t, ndprop, corrmpcf ;
extern double rf, smp, lamb ;
extern double xmin, xmax, ymin, ymax ;
extern double xini1, xini2, yini1, yini2 ;
extern double epsi0, epsi1, epsigld, misfval3 ;
#if !defined( ___class_AgcModel )
#define ___class_AgcModel
class AgcModel {
 public:
  AgcModel() ;
  AgcModel( double dcpy, double sdz, double ecpr, double acpr ) ;
  AgcModel( const AgcModel& oth ) ;
  ~AgcModel() {}
  AgcModel& operator=( const AgcModel& rhs ) ;
  double calvalfunc( double v ) ;
  double getdbpay() const { return dbpay ; }
  double getequimv() const { return equimv ; }
  double getdebtmv() const { return debtmv ; }
  double getfirmv() const { return firmv ; }
  double getbnkprob() const { return dfprob ; }
  double getbkcost() const { return bkcost ; }
  double getez() const { return ez ; }
  double getsz() const { return sz ; }
  double getcovz() const { return covz ; }
  double getezconst() const { return ezcst ; }
  double getagcpara() const { return agcpr ; }
  double getcfequicov() const {return CFequicov ; }
  double getcfdebtcov() const {return CFdebtcov ; }
 private:
  double dbpay, sz, ezcst, agcpr ;
  double ez, vz, covz, debtmv, equimv, firmv ;
  double dfprob, dfdens, vtax, vtxprob, vtxdens, bkcost, bkprob, bkdens ;
  double CFequicov, CFdebtcov ;
  void copyparams( const AgcModel& F ) ;
  void proccalcntl() ;
  double procfirmv() ;
  void setprob( double val, double* pb, double* den ) ;
  void compprob1( double *lpb, double *lden ) ;
  void compprob2( double *bc, double *kpb, double *kden ) ;
  void compprob3( double *vlb, double *vlbpb, double *vlbden ) ; 
  double valfirm( double v ) ;
  double valequi() ;
  double valdebt() ;
  double cfequiave() ;
  double cfequicov() ;
  double cfdebtave() ;
  double cfdebtcov() ;
} ;
#endif
#if !defined( ___class_ModelFirm )
#define ___class_ModelFirm
class ModelFirm {
 public:
  ModelFirm() ;
  ModelFirm( const AgcModel& firm ) ;
  ModelFirm( const ModelFirm& oth ) ;
  ~ModelFirm() {}
  ModelFirm& operator=( const ModelFirm& rhs ) ;
  double getdbpay() const { return F.getdbpay() ; }
  double getequimv() const { return F.getequimv() ; }
  double getdebtmv() const { return F.getdebtmv() ; }
  double getfirmv() const { return F.getfirmv() ; }
  double getbnkprob() const { return F.getbnkprob() ; }
  double getbkcost() const { return F.getbkcost() ; }
  double getez() const { return F.getez() ; }
  double getsz() const { return F.getsz() ; }
  double getcovz() const { return F.getcovz() ; }
  double getezconst() const { return F.getezconst() ; }
  double getagcpara() const { return F.getagcpara() ; }
  double getdbpay1() const { return dbpay1 ; }
  double getez1() const { return ez1 ; }
  double getsz1() const { return sz1 ; }
  double getdebtrr() const { return debtrr1 ; }
  double getequirr() const { return equirr1 ; }
  double getwacc() const { return wacc1 ; }
  double getwacct() const { return wacct1 ; }
  double getdbrati() const { return dbrati ; }
  double getroa() const { return roa1 ; }
  AgcModel getAgcModel() const {return F ;}
 private:
  AgcModel F ;
  double ez1, sz1, dbpay1 ;
  double debtrr1, equirr1, wacc1, wacct1, dbrati, roa1 ;
  double rrrequi() ;
  double rrrdebt() ;
  double chgtermto1( double ratret ) ;
  double chgtermto1coef( double ratret ) ;
  void copyparams( const ModelFirm& F ) ;
} ;
#endif
#if !defined( ___class_optsearchx_dc )
#define ___class_optsearchx_dc
class optsearchx_dc : public optsearchx {
 protected:
  virtual double optprocfunc( double dbcash, double stddev ) ;
 public:
  optsearchx_dc( double pry, double pr1, double pr2 ) ;
  virtual ~optsearchx_dc() {}
  virtual double getobjval( double x ) ;
} ;
#endif
#if !defined( ___class_optsearchxy_dcsd )
#define ___class_optsearchxy_dcsd
class optsearchxy_dcsd : public optsearchxy {
 protected:
  virtual double optprocfunc( double dbcash, double stddev ) ;
 public:
  optsearchxy_dcsd( double pr1, double pr2 ) ;
  virtual ~optsearchxy_dcsd() {} ;
  virtual double getobjval( double y ) ;
} ;
#endif
#if !defined( ___class_solveqx_sh )
#define ___class_solveqx_sh
class solveqx_sh : public solveqx {
 protected:
  virtual double solvprocfunc( double ecp, double acp ) ;
 public:
  solveqx_sh( double dtfx, double y ) ;
  virtual ~solveqx_sh() {}
  virtual double calvalfunc( double x ) ;
} ;
#endif
#if !defined( ___class_solveqxy_shdb )
#define ___class_solveqxy_shdb
class solveqxy_shdb : public solveqxy {
 protected:
  virtual double solvprocfunc( double ecp, double acp ) ;
 public:
  solveqxy_shdb( double dtfx, double dtfy ) ; 
  virtual ~solveqxy_shdb() {} 
  virtual double calvalfunc( double y ) ;
} ;
#endif

