//<agcmodel5.cc>
#include "agcmodel5.h"
// core computation of agcmodel
AgcModel::AgcModel()
  : dbpay(0.0), sz(0.0), ezcst(0.0), agcpr(0.0),
    ez(0.0), vz(0.0), covz(0.0), debtmv(0.0), equimv(0.0), firmv(0.0),
    dfprob(0.0), dfdens(0.0), vtax(0.0), vtxprob(0.0), vtxdens(0.0), 
    bkcost(0.0), bkprob(0.0), bkdens(0.0), CFequicov(0.0), CFdebtcov(0.0) {}
AgcModel::AgcModel( double dcpy, double sdz, double ecpr, double acpr )
  : dbpay(dcpy), sz(sdz), ezcst(ecpr), agcpr(acpr),
    ez(0.0), vz(0.0), covz(0.0), debtmv(0.0), equimv(0.0), firmv(0.0),
    dfprob(0.0), dfdens(0.0), vtax(0.0), vtxprob(0.0), vtxdens(0.0), 
    bkcost(0.0), bkprob(0.0), bkdens(0.0), CFequicov(0.0), CFdebtcov(0.0) {
  ::cntlid = 0 ;
  ez = ezcst - agcpr * dbpay ;
  vz = sz * sz ;
  covz = ::corrmpcf * ::smp * sz ;
  proccalcntl();
}
AgcModel::AgcModel( const AgcModel& oth ) {
  copyparams( oth ) ;
}
AgcModel& AgcModel::operator=( const AgcModel& rhs ) {
  copyparams( rhs ) ;
  return *this ;
}
void AgcModel::copyparams( const AgcModel& F ) {
  dbpay = F.getdbpay() ;
  sz = F.getsz() ;
  ezcst = F.getezconst() ;
  agcpr = F.getagcpara() ;
  ez = F.getez() ;
  covz = F.getcovz() ;
  equimv = F.getequimv() ;
  debtmv = F.getdebtmv() ;
  firmv = F.getfirmv() ;
  dfprob = F.getbnkprob() ;
  bkcost = F.getbkcost() ;
  CFequicov = F.getcfequicov() ;
  CFdebtcov = F.getcfdebtcov() ;
}
double AgcModel::calvalfunc( double v ) {
  return v - valfirm( v ) ;
}
void AgcModel::proccalcntl() {
  compprob1( &dfprob, &dfdens ) ;
  if (procfirmv() != firmv) {
    fprintf( ::outps, "%s %5d\n", 
	     "error AgcModel-2: firm value is not consistent", ::tcode ) ;
    ::cntlid = 1 ;
  }
}
double AgcModel::procfirmv() {
  double fmv ;
  if ((fmv = ProcSecant( this, 0.01*ez, 2.0*ez, ::epsi0 )) == ::misfval3) {
    fprintf( ::outps,
	     "%s %5d\n", "error AgcModel: not convergent in firm value",
	     ::tcode ) ;
  }
  return fmv ;
}
void AgcModel::setprob( double val, double *pb, double *den ) {
  normdis nr( val, ez, sz ) ;
  *pb = nr.getprob() ;
  *den = nr.getdens() ;
//   printf( " %10.5f %10.5f %10.5f\n", val, *pb, *den ) ;
}
void AgcModel::compprob1( double *lpb, double *lden ){
  setprob( dbpay, lpb, lden ) ;
}
void AgcModel::compprob2( double *bc, double *kpb, double *kden ){
  *bc = ::bcprop * firmv ;
  setprob( *bc, kpb, kden ) ;
}
void AgcModel::compprob3( double *vlb, double *vlbpb, double *vlbden ) { 
  *vlb = ::ndprop * firmv + dbpay - debtmv ;
  setprob( *vlb, vlbpb, vlbden ) ;
}
double AgcModel::valfirm( double v ) {
  firmv = v ;
  compprob2( &bkcost, &bkprob, &bkdens ) ;
  debtmv = valdebt() ;
  compprob3( &vtax, &vtxprob, &vtxdens ) ;
  equimv = valequi() ;
  return debtmv + equimv ;
}
double AgcModel::valequi() {
  CFequicov = cfequicov() ;
  return (cfequiave() - ::lamb * CFequicov) / (1.0 + ::rf) ; 
}
double AgcModel::valdebt() {
  CFdebtcov = cfdebtcov() ;
  return (cfdebtave() - ::lamb * CFdebtcov) / (1.0 + ::rf) ;
}
double AgcModel::cfdebtave() {
  if ( dbpay < bkcost ) return dbpay * (1.0 - dfprob) ;
  else 
    return dbpay * (1.0 - dfprob) - bkcost * (dfprob - bkprob) 
      + ez * (dfprob - bkprob ) - vz * (dfdens - bkdens) ;
}
double AgcModel::cfdebtcov() {
  if ( dbpay < bkcost ) return covz * dbpay * dfdens ;
  else 
    return covz * (dfprob - bkprob + bkcost * dfdens) ;
}
double AgcModel::cfequiave() {
  return ez * (1.0 - ::t + ::t * vtxprob - dfprob) 
    + vz * (dfdens - ::t * vtxdens)
    - dbpay * (1.0 - dfprob) + ::t * vtax * (1.0 - vtxprob) ;
}
double AgcModel::cfequicov() {
  return covz * (1.0 - ::t + ::t * vtxprob - dfprob) ;
}
// other computation from agcmodel 
ModelFirm::ModelFirm() 
  : F(), ez1(0.0), sz1(0.0), dbpay1(0.0), debtrr1(0.0), equirr1(0.0), 
    wacc1(0.0), wacct1(0.0), dbrati(0.0), roa1(0.0) {}
ModelFirm::ModelFirm( const AgcModel& firm ) 
  : F(firm), ez1(0.0), sz1(0.0), dbpay1(0.0), debtrr1(0.0), equirr1(0.0), 
    wacc1(0.0), wacct1(0.0), dbrati(0.0), roa1(0.0) {
  dbrati = F.getdebtmv() / F.getfirmv() ;
  debtrr1 = chgtermto1( rrrdebt() ) ;
  equirr1 = chgtermto1( rrrequi() ) ;
  wacc1 = (debtrr1 * F.getdebtmv() + equirr1 * F.getequimv()) / F.getfirmv() ;
  wacct1 = ((1.0 - ::t) * debtrr1 * F.getdebtmv() + equirr1 * F.getequimv()) 
    / F.getfirmv() ;
  roa1 = chgtermto1( (F.getezconst() - F.getfirmv()) / F.getfirmv() ) ;
  ez1 = (F.getez() - F.getfirmv()) * chgtermto1coef( wacc1 ) ;
  sz1 = F.getsz() * ez1 / F.getez() ; 
  dbpay1 = (F.getdbpay() - F.getdebtmv()) * chgtermto1coef( debtrr1 ) ;
}
ModelFirm::ModelFirm( const ModelFirm& oth ) {
  copyparams( oth ) ;
}
ModelFirm& ModelFirm::operator=( const ModelFirm& rhs ) {
  copyparams( rhs ) ;
  return *this ;
}
void ModelFirm::copyparams( const ModelFirm& firm ) {
  F = firm.getAgcModel() ;
  ez1 = firm.getez1() ;
  sz1 = firm.getsz1() ;
  dbpay1 = firm.getdbpay1() ;
  debtrr1 = firm.getdebtrr() ;
  equirr1 = firm.getequirr() ;
  wacc1 = firm.getwacc() ;
  wacct1 = firm.getwacct() ;
  dbrati = firm.getdbrati() ;
  roa1 = firm.getroa() ;
}
double ModelFirm::rrrequi() {
  return ::rf + ::lamb * F.getcfequicov() / F.getequimv() ; 
}
double ModelFirm::rrrdebt() {
  if ( F.getdbpay() == 0.0 ) return 0.0 ;
  return ::rf + ::lamb * F.getcfdebtcov() / F.getdebtmv() ; 
}
double ModelFirm::chgtermto1( double ratret ) {
  return pow( 1.0 + ratret, 1.0/::year ) - 1.0 ;
}
double ModelFirm::chgtermto1coef( double ratret ) {
  return ratret / (pow( 1.0 + ratret, ::year ) - 1.0) ;
}
// maximization using GoldenDivision
optsearchx_dc::optsearchx_dc( double pry, double pr1, double pr2 ) 
  : optsearchx() {
  paramy = pry ; param1 = pr1 ; param2 = pr2 ;
  if ((optvalx = ProcGoldDiv( this, xminval, xmaxval, ::epsigld )) 
      == ::misfval3) 
    fprintf( ::outps, "%s %5d\n", "error: no maximum value in x", ::tcode ) ;
}
double optsearchx_dc::getobjval( double x ) {
  return optsearchx::getobjval( x ) ;
}
double optsearchx_dc::optprocfunc( double dbcash, double stddev ) {
  AgcModel f( dbcash, stddev, param1, param2 ) ;
  return f.getfirmv() ;
}
optsearchxy_dcsd::optsearchxy_dcsd( double pr1, double pr2 ) 
  : optsearchxy() {
  param1 = pr1 ; param2 = pr2 ;
  if ((optvaly = ProcGoldDiv( this, yminval, ymaxval, epsigld ))
      == ::misfval3)
    fprintf( ::outps, "%s %5d\n", "error: no maximum value in y", ::tcode ) ;
}
double optsearchxy_dcsd::getobjval( double y ) {
  optsearchx_dc x( y, param1, param2 ) ;
  optvalx = x.getoptvalx() ;
  return optprocfunc( optvalx, y ) ;
}
double optsearchxy_dcsd::optprocfunc( double dbcash, double stddev ) {
  AgcModel f( dbcash, stddev, param1, param2 ) ;
  return f.getequimv() ;
}
// Solve parameter x and y from 2 equations of fx and fy 
solveqx_sh::solveqx_sh( double dtfx, double y ) 
  : solveqx() {
  fxdat = dtfx ; yval = y ;
  if ((solutx = ProcSecant( this, xinival1, xinival2, ::epsi1 )) 
      == ::misfval3) 
    fprintf( ::outps, "%s %5d\n", "error: no solution in x", ::tcode ) ;
}
double solveqx_sh::calvalfunc( double x ) {
  return solveqx::calvalfunc( x ) ;
}
double solveqx_sh::solvprocfunc( double ecp, double acp ) {
  optsearchxy_dcsd opt( ecp, acp ) ;
  double dcash = opt.getoptvalx() ;
  double stdcf = opt.getoptvaly() ;
  AgcModel f( dcash, stdcf, ecp, acp ) ;
  return f.getequimv() ;
}
solveqxy_shdb::solveqxy_shdb( double dtfx, double dtfy )
  : solveqxy() {
  fxdat = dtfx ; fydat = dtfy ;
  //  fprintf( ::outps, "%s %5d\n", "solve equations started", ::tcode ) ;
  if ((soluty = ProcSecant( this, yinival1, yinival2, ::epsi1 )) 
      == ::misfval3)
    fprintf( ::outps, "%s %5d\n", "error: no solution in y", ::tcode ) ;
}
double solveqxy_shdb::calvalfunc( double y ) {
  solveqx_sh fx( fxdat, y ) ;
  solutx = fx.getsolutx() ;
  return fydat - solvprocfunc( solutx, y ) ;
}
double solveqxy_shdb::solvprocfunc( double ecp, double acp ) {
  optsearchxy_dcsd opt( ecp, acp ) ;
  double dcash = opt.getoptvalx() ;
  double stdcf = opt.getoptvaly() ;
  AgcModel f( dcash, stdcf, ecp, acp ) ;
  return f.getdebtmv() ;
}
