#include "numertools.h"
// maximization using GoldenDivision
optsearchx::optsearchx()
  : paramy(0.0), param1(0.0), param2(0.0),
    xminval(::xmin), xmaxval(::xmax), optvalx(0.0) {}
double optsearchx::getobjval( double x ) {
  return optprocfunc( x, paramy ) ;
 }
optsearchy::optsearchy()
  : paramx(0.0), param1(0.0), param2(0.0), 
    yminval(::ymin), ymaxval(::ymax), optvaly(0.0) {}
double optsearchy::getobjval( double y ) {
  return optprocfunc( paramx, y ) ;
}
optsearchxy::optsearchxy()
  : param1(0.0), param2(0.0), 
    xminval(::xmin), xmaxval(::xmax), optvalx(0.0), 
    yminval(::ymin), ymaxval(::ymax), optvaly(0.0) {}
// Solve parameter x and y from 2 equations of fx and fy 
solveqx::solveqx() 
  : fxdat(0.0), xinival1(::xini1), xinival2(::xini2), solutx(0.0),
    yval(0.0), param1(0.0), param2(0.0) {}
double solveqx::calvalfunc( double x ) {
  return fxdat - solvprocfunc( x, yval ) ;
}
solveqxy::solveqxy() 
  : fxdat(0.0), xinival1(::xini1), xinival2(::xini2), solutx(0.0),
    fydat(0.0), yinival1(::yini1), yinival2(::yini2), soluty(0.0),
    yval(0.0), param1(0.0), param2(0.0) {}
// Normal Distribution
normdis::normdis( double x, double xmean, double xstd ) {
  double z = (x - xmean) / xstd ;
  prob = probnor( z ) ;
  dens = densnor( z ) / xstd ;
}
double normdis::probnor( double z ) {
  double d1 = 0.0498673470 ;
  double d2 = 0.0211410061 ;
  double d3 = 0.0032776263 ;
  double d4 = 0.0000380036 ;
  double d5 = 0.0000488906 ;
  double d6 = 0.0000053830 ;
  double zz = fabs( z ), w, p ;
  if ( zz > 4.777 ) p = 1.0 ;
  else {
    w = 1.0 + d1 * zz + d2 * pow( zz, 2.0 ) + d3 * pow( zz, 3.0 )
      + d4 * pow( zz, 4.0 ) + d5 * pow( zz, 5.0 ) + d6 * pow( zz, 6.0 ) ;
    p = 1.0 - pow( w, -16.0 ) / 2.0 ;
  }
  if ( z > 0.0 ) return p ;
  else return 1.0 - p ;
}
double normdis::densnor( double z ) {
  double pi = 3.14159265358979324 ;
  double zz = - z * z / 2.0 ;
  return exp( zz ) / sqrt( 2.0 * pi ) ;
}
/*
int main() {
normdis nr( 3.1, 3.0, 2.0 ) ;
printf( "%15.15f %15.15f\n", nr.getdens(), nr.getprob() ) ;
}
 */
