#include "ndtmodel2.h"
givendata& f1() ;
firmdata& f() ;
firmdata::firmdata()
  : ez(0.0), sz(0.0), vz(0.0), covz(0.0), year(f1().year),
    bcpr(f1().bcprop), t(f1().t), ndpr(f1().ndtprop), emp(0.0), smp(0.0),
    rf(0.0), lamb(0.0) {
  ez = f1().ez1 * year ;
  sz = f1().sz1 * sqrt( year ) ;
  vz = sz * sz ;
  emp = pow( (1.0 + f1().emp1), year ) - 1.0 ;
  smp = f1().smp1 * sqrt( year ) ;
  covz = f1().corrmpz * smp * sz ;
  rf = pow( (1.0 + f1().rf1), year ) - 1.0 ;
  lamb = ( emp - rf ) / ( smp * smp ) ;
}
basicfirm::basicfirm()
  : ufirmv(0.0), rrrfirm(0.0), bkcost(0.0), ndtv(0.0),
    npb(0.0), nden(0.0), zeropb(0.0), zeroden(0.0), kpb(0.0), kden(0.0) {
  setprob( 0.0, &zeropb, &zeroden ) ;
  ufirmv = procfirmmv() ;
  ndtv = f().ndpr * ufirmv ;
  setprob( ndtv, &npb, &nden ) ;
//   printf( "%10.5f %8.5f %8.5f\n", ufirmv, upb, zeropb ) ;
  bkcost = f().bcpr * ufirmv ;
  setprob( bkcost, &kpb, &kden ) ;
  rrrfirm = rrrequi() ;
}
basicfirm::basicfirm( const basicfirm& rhs ){
  copymembers( rhs ) ;
}
basicfirm& basicfirm::operator=( const basicfirm& rhs ){
  copymembers( rhs ) ;
  return *this ;
}
void basicfirm::copymembers( const basicfirm& oth ){
  ufirmv = oth.getufirmv() ;
  bkcost = oth.getbkcost() ;
  ndtv = oth.getndtv() ;
  npb = oth.getnpb() ;
  nden = oth.getnden() ;
  zeropb = oth.getzeropb() ;
  zeroden = oth.getzeroden() ;
  kpb = oth.getkpb() ;
  kden = oth.getkden() ;
  rrrfirm = oth.getrrr() ;
}
double basicfirm::valfirm( double fmmv ) {
  return (cffirmave( fmmv ) - f().lamb*cffirmcov( fmmv ))/(1.0 + f().rf) ; 
}
double basicfirm::cffirmave( double fmmv ) {
  double ndtvtmp = f().ndpr * fmmv ;
  double npbtmp, ndentmp ;
  setprob( ndtvtmp, &npbtmp, &ndentmp ) ;
  return f().ez*(1.0 - f().t + f().t*npbtmp - zeropb) 
    + f().vz*(zeroden - f().t*ndentmp) + f().t*ndtvtmp*(1.0 - npbtmp) ;
}
double basicfirm::cffirmcov( double fmmv ) {
  double ndtvtmp = f().ndpr * fmmv ;
  double npbtmp, ndentmp ;
  setprob( ndtvtmp, &npbtmp, &ndentmp ) ;
  return f().covz*(1.0 - f().t + f().t*npbtmp - zeropb) ;
}
double basicfirm::rrrequi() {
  return f().rf + f().lamb*cffirmcov( ufirmv )/ufirmv ; 
//   return cfequiave( x ) / equimv - 1.0 ; 
}
double basicfirm::procfirmmv() {
   double fmv ;
   ::cntlid = 0 ;
   if ((fmv = ProcSecant( this, 1.0, f().ez, ::epsi )) == ::misfval3) {
      printf( "%s\n", "not convergent in firm value" ) ;
      exit( 1 ) ;
   }
   return fmv ;
}
double basicfirm::calvalfunc( double fmmv ) {
  return fmmv - valfirm( fmmv ) ;
}
void basicfirm::setprob( double val, double *pb, double *den ) {
  normdis nr( val, f().ez, f().sz ) ;
  *pb = nr.getprob() ;
  *den = nr.getdens() ;
  //   printf( " %10.5f %10.5f %10.5f\n", val, *pb, *den ) ;
}
ndtmodel2::ndtmodel2( double dcash )
  : uf(), dcntl(0), dbpay(dcash), debtmv(0.0), equimv(0.0), firmmv(0.0),
    txsvmv(0.0), bkcsmv(0.0), debtrr(0.0), equirr(0.0), wacc(0.0),
    dbrati(0.0),
    lpb(0.0), lden(0.0), ulb(0.0), ulbpb(0.0), ulbden(0.0),
    phi(0.0), phipb(0.0), phiden(0.0) {
  calmodel() ;
}
ndtmodel2::ndtmodel2( const ndtmodel2& rhs ) {
  copymembers( rhs ) ;
}
ndtmodel2& ndtmodel2::operator=( const ndtmodel2& rhs ){
  copymembers( rhs ) ;
  return *this ;
}
void ndtmodel2::calmodel() {
  uf.setprob( dbpay, &lpb, &lden ) ;
  if (dbpay == 0.0) {
    equimv = firmmv = uf.getufirmv() ;
    equirr = wacc = uf.getrrr() ; 
  }
  else {
    if (dbpay <= uf.getbkcost()) dcntl = 1 ;
    else dcntl = 2 ;
    debtmv = valdebt() ;
    if (debtmv > uf.getndtv()) {
      debtmv = procdebtmv() ;
      if (debtmv > uf.getndtv()) dcntl = 3 ;
      else dcntl = 4 ;
    }
    ulb = uf.getndtv() + dbpay - debtmv ;
    uf.setprob( ulb, &ulbpb, &ulbden ) ;
    phi = (dbpay - f().t*ulb)/(1.0 - f().t) ; 
    uf.setprob( phi, &phipb, &phiden ) ;
    equimv = valequi() ; firmmv = valfirm() ;
    txsvmv = valtxsv() ; bkcsmv = valbkcs() ;
    dbrati = debtmv/firmmv ;
    debtrr = rrrdebt() ; equirr = rrrequi() ;
    wacc = ((1.0 - f().t)*debtrr*debtmv + equirr*equimv)/firmmv ;
  }
}
void ndtmodel2::copymembers( const ndtmodel2& oth ) {
  uf = oth.getuf() ;
  dcntl = oth.getid() ;
  dbpay = oth.getdbpay() ;
  debtmv = oth.getdebtmv() ;
  equimv = oth.getequimv() ;
  firmmv = oth.getfirmmv() ;
  txsvmv = oth.gettxsvmv() ;
  bkcsmv = oth.getbkcsmv() ;
  debtrr = oth.getdebtrr() ;
  equirr = oth.getequirr() ;
  wacc = oth.getwacc() ;
  dbrati = oth.getdbrati() ;
  lpb = oth.getbnkprob() ;
  lden = oth.getbnkden() ;
  ulb = oth.getulb() ;
  ulbpb = oth.getulbpb() ;
  ulbden = oth.getulbden() ;
  phi = oth.getphi() ;
  phipb = oth.getphipb() ;
  phiden = oth.getphiden() ;
}
double ndtmodel2::procdebtmv() {
   double dmv ;
   ::cntlid = 0 ;
   if ((dmv = ProcSecant( this, 1.0, dbpay, ::epsi )) == ::misfval3) {
      printf( "%s\n", "not convergent in debt value" ) ;
      exit( 1 ) ;
   }
   return dmv ;
}
double ndtmodel2::calvalfunc( double dbmv ) {
  return dbmv - valdebt2( dbmv ) ;
}
double ndtmodel2::valfirm() {
  if (dcntl != 4) return debtmv + equimv ; 
  else return ::misfval3 ;
}
double ndtmodel2::valequi() {
  if (dcntl != 4) 
    return (cfequiave() - f().lamb*cfequicov())/(1.0 + f().rf) ;
  else
    return ::misfval3 ;
}
double ndtmodel2::valdebt() {
  return (cfdebtave() - f().lamb*cfdebtcov())/(1.0 + f().rf) ;
}
double ndtmodel2::valdebt2( double dbmv ) {
  ulb = uf.getndtv() + dbpay - dbmv ;
  phi = (dbpay - f().t*ulb)/(1.0 - f().t) ; 
  uf.setprob( ulb, &ulbpb, &ulbden ) ;
  uf.setprob( phi, &phipb, &phiden ) ;
  return (cfdebtave2() - f().lamb*cfdebtcov2())/(1.0 + f().rf) ;
}
double ndtmodel2::valtxsv() {
  if (dcntl != 4) 
    return (cftxsvave() - f().lamb*cftxsvcov())/(1.0 + f().rf) ; 
  else
    return ::misfval3 ;
}
double ndtmodel2::valbkcs() {
  if (dcntl != 4)
    return (cfbkcsave() - f().lamb*cfbkcscov())/(1.0 + f().rf) ;
  else
    return ::misfval3 ;
}
double ndtmodel2::cfdebtave() {
//   printf( "%8.5f %8.5f\n", lpb, kpb ) ;
  double tmpval ;
  switch (dcntl) {
  case 1:
    tmpval = dbpay*(1.0 - lpb) ; break ;
  case 2:
    tmpval = dbpay*(1.0 - lpb) - uf.getbkcost()*(lpb - uf.getkpb()) 
      + f().ez*(lpb - uf.getkpb()) - f().vz*(lden - uf.getkden()) ; break ;
  }
  return tmpval ;
}
double ndtmodel2::cfdebtcov() {
  double tmpval ;
  switch (dcntl) {
  case 1:
    tmpval = f().covz*dbpay*lden ; break ;
  case 2:
    tmpval = f().covz*(lpb - uf.getkpb() + uf.getbkcost()*lden) ; break ;
  }
  return tmpval ;
}
double ndtmodel2::cfdebtave2() {
//   printf( "%8.5f %8.5f\n", lpb, kpb ) ;
  return dbpay*(1.0 - ulbpb) - uf.getbkcost()*(phipb - uf.getkpb())
    - (1.0 - f().t)*phi*(phipb - ulbpb)
    + f().ez*((1.0 - f().t)*phipb + f().t*ulbpb - uf.getkpb())
    - f().vz*((1.0 - f().t)*phiden + f().t*ulbden - uf.getkden()) ;
}
double ndtmodel2::cfdebtcov2() {
  return f().covz*
    ((1.0 - f().t)*phipb + f().t*ulbpb - uf.getkpb()
     + uf.getbkcost()*phiden) ;
}
double ndtmodel2::cfequiave() {
  double tmpval ;
  switch (dcntl) {
  case 1:
  case 2:
    tmpval = f().ez*(1.0 - f().t + f().t*ulbpb - lpb)
      + f().vz*(lden - f().t*ulbden)
      - dbpay*(1.0 - lpb) + f().t*ulb*(1.0 - ulbpb) ; break ;
  case 3:
    tmpval = (1.0 - f().t)
      *((f().ez - phi)*(1.0 - phipb) + f().vz*phiden) ; break ;
  }
  return tmpval ;
}
double ndtmodel2::cfequicov() {
  double tmpval ;
  switch (dcntl) {
  case 1:
  case 2:
    tmpval = f().covz*(1.0 - f().t + f().t*ulbpb - lpb) ; break ;
  case 3:
    tmpval = f().covz*(1.0 - f().t)*(1.0 - phipb) ; break ;
  }
  return tmpval ;
}
double ndtmodel2::cftxsvave() {
  return f().t*((dbpay - debtmv)*(1.0 - ulbpb)
		  - uf.getndtv()*(ulbpb - uf.getnpb())
		  + f().ez*(ulbpb - uf.getnpb())
		  - f().vz*(ulbden - uf.getnden())) ;
}
double ndtmodel2::cftxsvcov() {
  return f().covz*f().t*(ulbpb - uf.getnpb()) ;
}
double ndtmodel2::cfbkcsave() {
  double tmpval ;
  switch (dcntl) {
  case 1:
    tmpval = f().ez*(lpb - uf.getzeropb())
      - f().vz*(lden - uf.getzeroden()) ; break ;
  case 2:
    tmpval = uf.getbkcost()*(lpb - uf.getkpb())
      + f().ez*(uf.getkpb() - uf.getzeropb()) 
      - f().vz*(uf.getkden() - uf.getzeroden()) ; break ;
  case 3:
    tmpval = uf.getbkcost()*(phipb - uf.getkpb())
      + f().ez*(uf.getkpb() - uf.getzeropb()) 
      - f().vz*(uf.getkden() - uf.getzeroden()) ; break ;
  }
  return tmpval ;
}
double ndtmodel2::cfbkcscov() {
  double tmpval ;
  switch (dcntl) {
  case 1:
    tmpval = f().covz*(lpb - uf.getzeropb() - dbpay*lden) ; break ;
  case 2:
    tmpval = f().covz*(uf.getkpb() - uf.getzeropb()
		       - uf.getbkcost()*lden) ; break ;
  case 3:
    tmpval = f().covz*(uf.getkpb() - uf.getzeropb()
		       - uf.getbkcost()*phiden) ; break ;
  }
  return tmpval ;
}
double ndtmodel2::rrrequi() {
  double tmpval ;
  if (dcntl != 4) tmpval = f().rf + f().lamb * cfequicov()/equimv ;
  else tmpval = ::misfval3 ;
  return tmpval ;
//   return cfequiave( x ) / equimv - 1.0 ; 
}
double ndtmodel2::rrrdebt() {
  double tmpval ;
  if (dbpay == 0.0) tmpval = 0.0 ;
  switch (dcntl) {
  case 1:
  case 2:
    tmpval = f().rf + f().lamb * cfdebtcov()/debtmv ; break ;
  case 3:
    tmpval = f().rf + f().lamb * cfdebtcov2()/debtmv ; break ;
  case 4:
    tmpval = ::misfval3 ; break ;
  }
  return tmpval ;
//     return cfdebtave( x ) / debtmv - 1.0 ; 
}
// maximization using GoldenDivision
optsearchx_dc::optsearchx_dc() : optsearchx() {
  ::cntlid = 0 ;
  if ((optvalx = ProcGoldDiv( this, xminval, xmaxval, ::epsi_gld )) 
      == ::misfval3) 
    // fprintf( ::outps, "%s %5d\n", "error: no maximum value in x", ::tcode ) ;
    printf( "%s\n", "error: no maximum value in x" ) ;
}
double optsearchx_dc::getobjval( double x ) {
  return optsearchx::getobjval( x ) ;
}
double optsearchx_dc::optprocfunc( double dbcash, double dummy ) {
  ndtmodel2 lf(dbcash) ;
  return lf.getfirmmv() ;
}
