// ndtmain21.cc：ndtmodel2用のコントロール
// 141120 ndtmodel1をC++流に変更したことに伴う変更
// 141128 ndtmodel2へのバージョンアップ
// 141211 データ取り込み方法の変更
// 141215 ndtpara.hをこのファイルに統合
// 141218 シミュレーション対応：静的変数の扱いは難しい→この方法以外に上手くいかない。
// 141229 プロセスの些細な修正
// 150202 テキストの修正：旧版の結果を復元(ファイル名*****1~3.txt)
// 150209 テキストの修正：新版の結果を試行(ファイル名*****4~6.txt)
// 150612 optsearchの変更に伴う修正：firmval8.txtで実験→結果一致
// 161228 公開用にファイル名・コメントアウトの変更…基本的には元のndtmain2.ccと同じ
#include <cstdio>
#include "ndtmodel2.h"
char ofile[][60] = {"data/ndtmodel2/firmval5.txt"} ;
char ofiletax[][60] = {"data/ndtmodel2/ndtsimutax5.txt",
		       "data/ndtmodel2/ndttabtax5.txt" };
char ofileez[][60] = {"data/ndtmodel2/ndtsimuez5.txt",
		      "data/ndtmodel2/ndttabez5.txt" };
char ofilesz[][60] = {"data/ndtmodel2/ndtsimusz5.txt",
		      "data/ndtmodel2/ndttabsz5.txt" };
char ofilebcpr[][60] = {"data/ndtmodel2/ndtsimubcpr5.txt",
			"data/ndtmodel2/ndttabbcpr5.txt" };
char ofilendpr[][60] = {"data/ndtmodel2/ndtsimundpr5.txt",
			"data/ndtmodel2/ndttabndpr5.txt" };
char ofilebctax[][60] = {"data/ndtmodel2/ndtsimubctax5.txt",
			 "data/ndtmodel2/ndttabbctax5.txt" };
char ofilehomgn[][60] = {"data/ndtmodel2/ndtsimuhomgn5.txt",
			 "data/ndtmodel2/ndttabhomgn5.txt" };
int cntlid = 0 ;
double epsi = 0.00000001, epsi_gld = 0.0000001, misfval3 = -999.999 ;
double xini1=0.0, xini2=0.0, yini1=0.0, yini2=0.0 ;
double xmin, xmax, ymin=0.0, ymax=0.0 ; 
double tmpval, tmpval2 ;
double  year = 10.0, ez1 = 10.0, sz1 = 9.0, corrmpz = 0.4 ;
//double bcprop = 0.8, t = 0.45, ndtprop = 1.0 ;//ファイル名*****1.txt
//double bcprop = 0.0, t = 0.45, ndtprop = 2.0 ;//ファイル名*****2.txt
//double bcprop = 0.8, t = 0.45, ndtprop = 1.6 ;//ファイル名*****3.txt
//double bcprop = 0.4, t = 0.3, ndtprop = 1.0 ;//ファイル名*****4.txt
double bcprop = 0.0, t = 0.3, ndtprop = 2.0 ;//ファイル名*****5.txt
//double bcprop = 0.4, t = 0.3, ndtprop = 1.4 ;//ファイル名*****6.txt
//double bcprop = 0.1, t = 0.3, ndtprop = 1.0 ;//ファイル名*****7.txt
//double bcprop = 0.5, t = 0.35, ndtprop = 1.0 ;//ファイル名*****8.txt
double  rf1 = 0.06, emp1 = 0.13, smp1 = 0.25 ;
givendata& f1() {
  static givendata g1 ;
  g1.year = ::year ;
  g1.ez1 = ::ez1 ;
  g1.sz1 = ::sz1 ;
  g1.corrmpz = ::corrmpz ;
  g1.bcprop = ::bcprop ;
  g1.t = ::t ;
  g1.ndtprop = ::ndtprop ;
  g1.rf1 = ::rf1 ;
  g1.emp1 = ::emp1 ;
  g1.smp1 = ::smp1 ;
  return g1 ;
}
firmdata& f() {
  static firmdata fd ;
  return fd ;
}
double chgtermto1( double year, double val ) {
  return pow( 1.0 + val, 1.0 / year ) - 1.0 ;
}
void printhead( FILE* out, const basicfirm& d ) {
   fprintf( out, "\nliq.cash: 10Y average (1Y) = %6.3f (%6.3f) 10Y std.dev. (1Y)= %6.3f (%6.3f)\n", f().ez, f1().ez1, f().sz, f1().sz1 ) ;
   fprintf( out, "unlevered firm value = %8.5f\n", d.getufirmv() ) ;
   fprintf( out, "tax rate = %4.2f bankruptcy cost = %7.3f  (proportion = %5.3f)\n", f().t, d.getbkcost(), f().bcpr ) ;
   fprintf( out, "non-debt tax shield = %8.5f  (proportion = %5.3f)\n", d.getndtv(), f().ndpr ) ;
   fprintf( out, "market portfolio: average = %7.4f  std.dev = %5.2f  correlation = %5.3f\n", f1().emp1, f1().smp1, f1().corrmpz ) ;
   fprintf( out, "riskless rate of interest = %7.4f  risk price = %7.4f\n\n", f1().rf1, f().lamb ) ;
   fprintf( out, "%2s%8s%8s%10s%8s%9s %9s%9s %9s%9s%9s %10s%9s\n",
	    "id", "debtcf", "default", "rrrequi", "rrrdebt", "WACC", "valequi", "valdebt", "valfirm", "valtxsv", "valbkcs", "dbratio", "corrMM" ) ;
}
template<typename model>
void printdata( int id, FILE* out, const model& d ) {
  if (id == 1) fprintf( out, "\n%s\n", "->optimal debt corner solution" ) ;
  else if (id == 0) fprintf( out, "\n%s\n", "->optimal debt cash payment" ) ;
  fprintf( out, "%2d", d.getid() ) ;
  fprintf( out, "%8.3f%8.5f%10.5f%8.5f%9.5f %9.5f%9.5f%10.5f %8.5f %8.5f %10.5f %8.5f\n", d.getdbpay(), d.getbnkprob(), chgtermto1( f().year, d.getequirr() ), chgtermto1( f().year, d.getdebtrr() ), chgtermto1( f().year, d.getwacc() ), d.getequimv(), d.getdebtmv(), d.getfirmmv(), d.gettxsvmv(), d.getbkcsmv(), d.getdbrati(), d.getufirmv()+f().t*d.getdebtmv() ) ;
}
void proccntl( int ni, FILE* out[], double stepsize ) {
  double prncntl = 0 ;
  double dcashopt, dcashmax ;
  ndtmodel2 ufirm(0.0) ;
  printhead( out[0], ufirm.getuf() ) ;
  for (double dcash = 0.0 ; dcash <= f().ez*1.5 ; dcash += stepsize) {
    ndtmodel2 lf(dcash) ;
    if (lf.getequimv() < 0.0) break;
    else {
      printdata( 9, out[0], lf ) ;
      dcashmax = dcash ;
    }
  }
  ::xmin = 0.0 ;
  ::xmax = dcashmax ;
  optsearchx_dc op ;
  if (op.getoptvalx() >= ::xmax*0.999) prncntl = 1 ;
  ndtmodel2 lfopt(op.getoptvalx()) ;
  for (int i = 0 ; i < ni ; i++) printdata( prncntl, out[i], lfopt ) ;
}
void firmval() {
  int ni = 1 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofile[i], "w" ) ;
  proccntl( ni, out, 0.5 ) ;
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
}
void ez1change( double tmp ) {
  f1().ez1 = tmp ;
  f().ez = f1().ez1 * f().year ;
}
void ezsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofileez[i], "w" ) ;
  ::tmpval = ::ez1 ;
  for (::ez1 = 7.0 ; ::ez1 <= 12.0 ; ::ez1 += 1.0) {
    ez1change( ::ez1 ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::ez1 = ::tmpval ; ez1change( ::ez1 ) ;
}
void sz1change( double tmp ) {
  f1().sz1 = tmp ;
  f().sz = f1().sz1 * sqrt( f().year ) ;
  f().vz = f().sz * f().sz ;
  f().covz = f1().corrmpz * f().smp * f().sz ;
}
void szsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilesz[i], "w" ) ;
  ::tmpval = ::sz1 ;
  for (::sz1 = 6.0 ; ::sz1 <= 15.0 ; ::sz1 += 1.0) {
    sz1change( ::sz1 ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::sz1 = ::tmpval ; sz1change( ::sz1 ) ;
}
void taxchange( double tmp ) {
  f().t = f1().t = tmp ;
}
void taxsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofiletax[i], "w" ) ;
  ::tmpval = ::t ;
  for (::t = 0.2 ; ::t <= 0.5 ; ::t += 0.05) {
    taxchange( ::t ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::t = ::tmpval ; taxchange( ::t ) ;
}
void bcprchange( double tmp ) {
  f().bcpr = f1().bcprop = tmp ;
}
void bcprsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilebcpr[i], "w" ) ;
  ::tmpval = ::bcprop ;
  for (::bcprop = 0.2 ; ::bcprop <= 1.0 ; ::bcprop += 0.1) {
    bcprchange( ::bcprop ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::bcprop = ::tmpval ; bcprchange( ::bcprop ) ;
}
void ndprchange( double tmp ) {
  f().ndpr = f1().ndtprop = tmp ;
}
void ndprsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilendpr[i], "w" ) ;
  ::tmpval = ::ndtprop ;
  for (::ndtprop = 1.5 ; ::ndtprop <= 2.3 ; ::ndtprop += 0.1) {//ファイル名**5
//  for (::ndtprop = 1.2 ; ::ndtprop <= 2.0 ; ::ndtprop += 0.2) {//ファイル名**6
    ndprchange( ::ndtprop ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::ndtprop = ::tmpval ; ndprchange( ::ndtprop ) ;
}
void bctaxsimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilebctax[i], "w" ) ;
  ::tmpval = ::bcprop ; tmpval2 = ::t ;
  for (::bcprop = 0.2 ; ::bcprop <= 1.0 ; ::bcprop += 0.2) {
    bcprchange( ::bcprop ) ;
    for (::t = 0.2 ; ::t <= 0.45 ; ::t += 0.05) {
      taxchange( ::t ) ;
      proccntl( ni, out, 1.5 ) ;
    }
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::bcprop = ::tmpval ; bcprchange( ::bcprop ) ;
  ::t = ::tmpval2 ; taxchange( ::t ) ;
}
void homgensimu() {
  int ni = 2 ;
  FILE* out[ni] ;
  for (int i = 0 ; i < ni ; i++) out[i] = fopen( ::ofilehomgn[i], "w" ) ;
  ::tmpval = ::ez1 ; ::tmpval2 = ::sz1 ;
  for (::ez1 = 7.0 ; ::ez1 <= 12.0 ; ::ez1 += 1.0) {
    ez1change( ::ez1 ) ;
    ::sz1 = ::tmpval2*::ez1/::tmpval ; 
    sz1change( ::sz1 ) ;
    proccntl( ni, out, 1.5 ) ;
  }
  for (int i = 0 ; i < ni ; i++) fclose( out[i] ) ;
  ::ez1 = ::tmpval ; ez1change( ::ez1 ) ;
  ::sz1 = ::tmpval2 ; sz1change( ::sz1 ) ;
}
int main() {
  firmval() ;
//  ezsimu() ;
//  szsimu() ;
//  taxsimu() ;
//  bcprsimu() ;
  ndprsimu() ;
//  bctaxsimu() ;
//  homgensimu() ;
}
