### VERSION 2 (For Round 1 Bernoulli)
### BIAS COMPUTATION
#Numerical simulation: computing the bias for various blocks
# likelihood
paths= 10000#nb of paths for Monte Carlo
biasnu =0
biasa=0
biasb=0
for (a in 1:1)
{
  nu=.6 
  a = 1.7 
  b= 6 
  MC1=0 
  MC2=0
  MC3=0
  H=120 #horizon in seconds
  Bu = 0 # burn part 
  for (i in 1:paths)
  {
    # simulation and fit in the parametric model
    s = simulateHawkes(lambda0= nu, alpha= a, beta= b, horizon= H + Bu)
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(1000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(1000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][s[[1]] > Bu] - Bu)
      return (f)
    }
    
    p = c(0.1,0.2,0.3)
    opt=optim(par=p,fn=lik)
    MC1[i] = opt$par[1]
    MC2[i] = opt$par[2]
    MC3[i] = opt$par[3]
    if (MC3[i] > 15)
    {
      MC3[i]=15
    }
  }
  biasnu[a] = mean(MC1) - lambda0
  biasa[a] = mean(MC2) - alpha
  biasb[a] = mean(MC3) - beta
}

### STUDENTIZATION
### PARAMETRIC CASE
T=12000 #horizon time in seconds
nu=0.7/10000
a=1.7/10000
b=6/10000
n=10000
h=sqrt(n)
B=floor(n/h)
dt=1 #for Riemnann sum of Hessian matrix
P =10 #nb of path
blockLength = h*T/n
estnu=0 
esta=0
estb=0
for (i in 1:P)
{
  locestnu=0
  locesta=0
  locestb=0
  locAVARnu=0
  locAVARa=0
  locAVARb=0
  s = simulateHawkes(lambda0= nu*n, alpha= a*n, beta= b*n, horizon=T)
  for (j in 1:B)
  {
    #fit the model
    init = 1 + (j-1)*h*T/n
    fin = j*h*T/n
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(1000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(1000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][(s[[1]] > init) & (s[[1]] < fin)] - init)
      return (f)
    }
    p = c(0.1,0.2,0.3)
    opt=optim(par=p,fn=lik)
    locestnu[j] = opt$par[1]
    locesta[j] = opt$par[2]
    locestb[j] = opt$par[3]
    #compute the AVAR
    locAVARnu[j]=0
    locAVARa[j]=0
    locAVARb[j]=0
    lambdaexc = 0
    lambda = nu + lambdaexc
    dlambdaa=0
    dlambdab=0
    for (k in 1:(blockLength/dt))
    {
      locAVARnu[j]=locAVARnu[j] + 1/lambda
      locAVARa[j]=locAVARa[j] + dlambdaa^2/lambda
      locAVARb[j]=locAVARb[j] + dlambdab^2/lambda
      curTime = init + dt*k
      lambdaexc = locesta[j]*lambdaexc*exp(-dt*locestb[j])
      
      
    }
  }
  estnu[i] = mean(locestnu)
  esta[i] = mean(locesta)
  estb[i] = mean(locestb)
}


### ESTIMATIoN OF AVAR
M = 1000 #for Riemnann sum of Hessian matrix
dt=T*n/M
for (i in 1:M)
{
  
}



### VERSION 1
# Note that likelihoodHawkes returns -loglikelihood
data = read.csv(file="C:/Users/yoann/Dropbox/work/research/003-Time-VaryingSelfExcitingProcess(withSimonClinet)/R/data/output/ask/40611LimitOrderList.csv",
                        sep=',', header=TRUE)
obs_times = data[,1]
obs_times = unique(obs_times)
obs_times = obs_times - 36000
N=length(obs_times)
obs_times[2:(N+1)]= obs_times
obs_times[1]=0
duration = obs_times[2:(N+1)] - obs_times[1:N]

lik = function(param) 
{
  if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
  {
    return(10000000)
  }
  if (param[2] > param[3] - 0.0001)
  {
    return(10000000)
  }
  #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[2:5001])
  f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[-1])
  return (f)
}

p = c(1,5,10)
o=optim(par=p,fn=lik)
o
f=acdFit(durations=duration[1:756], model = "ACD", dist = "exponential", order = c(1,1))
f

h=200
B=floor(7*3600/h)
out1=0
out2=0
out3=0
out01=0
out02=0
out03=0
out0v1=0
out0v2=0
out0v3=0
Nh=0
#s=0 computing the approximation of integral from condition
for(i in 1:B)
{
  init = h*(i-1)
  fin = h*i
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(10000000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(10000000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init)
  }
  opt = optim(par=p,fn=lik)
  out1[i] = opt$par[1]
  out2[i] = opt$par[2]
  out3[i] = opt$par[3]
  #s[i]= exp(-out2[i]*obs_times[init]) - exp(-out2[i]*obs_times[fin])
  Nh[i]=length(obs_times[(obs_times > init) & (obs_times < fin)])
  
  f=acdFit(durations=duration[(obs_times > init) & (obs_times < fin)], model = "ACD", dist = "exponential", optimFnc= "solnp")#, order = c(1,1.1))#, startPara=c(.1,.2,.3)) # change to have exact same block as in hawkes
  # problem with last block
  out01[i] = f$parameterInference[1,1]
  out02[i] = f$parameterInference[2,1]
  out03[i] = f$parameterInference[3,1]
  out0v1[i] = f$parameterInference[1,2]
  out0v2[i] = f$parameterInference[2,2]
  out0v3[i] = f$parameterInference[3,2]
}

plot(out1,ylim=c(0,3))
points(out2/10, col="red")
points(out3/15, col="blue")

plot(out01)
points(out0v1, col="red")
plot(out02)
points(out0v2, col="red")
plot(out03)
points(out0v3, col="red")

#mean deviation
m1 = mean(abs(out01[2:(B-1)] - out01[1:(B-2)]))
m2 = mean(abs(out02[2:(B-1)] - out02[1:(B-2)]))
m3 = mean(abs(out03[2:(B-1)] - out03[1:(B-2)]))
m1
m2
m3

mleout1=0
mleout2=0
mleout3=0
meanout1=0
meanout2=0
meanout3=0
K=20
for(i in 1:(B-K))
{
  init = 2 + h*(i-1)
  fin = h*(K-1+i) + 1 
  
  lik = function(param) 
  {
    if (param[2] > param[3] - 0.0001)
    {
      return(1000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], (obs_times[init:fin]-obs_times[init-1]))
    #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[1:100])
    return (f)
  }
  
  opt = optim(par=p,fn=lik)
  mleout1[i] = opt$par[1]
  mleout2[i] = opt$par[2]
  mleout3[i] = opt$par[3]
  meanout1[i]=mean(out1[i:(K-1i)])
  meanout2[i]=mean(out2[i:(K-1+i)])
  meanout3[i]=mean(out3[i:(K-1+i)])
}
plot(out1[(K+1):B])
points(mleout1,col="red")
points(meanout1,col="blue")
plot(out2[(K+1):B])
points(mleout2,col="red")
points(meanout2,col="blue")
plot(out3[(K+1):B])
points(mleout3,col="red")
points(meanout3,col="blue")



##### Numerical simulations commence la la Clineeeee########
#Numerical simulation: computing the bias for various blocks
# likelihood
paths= 1#nb of paths
bias1 =0
bias2=0
bias3=0
for (a in 1:paths)
{
  lambda0=.6 + Alambda0*cos((a-1)*2*pi/20)
  alpha = 1.7 + Aalpha*cos((a-1)*2*pi/20)
  beta = 6 + Abeta*cos((a-1)*2*pi/20)
  MC1=0 #MLE on parametric model
  MC2=0
  MC3=0
  MM1=0 #new estimator on parametric model
  MM2=0
  MM3=0
  M01=0 # MLE on time-varying parameter model
  M02=0
  M03=0
  M001=0 # MLE on time-varying parameter model
  M002=0
  M003=0
  H=120 #horizon in seconds
  Bu = 400 # burn part 
  for (i in 1:paths)
  {
    # simulation and fit in the parametric model
    s = simulateHawkes(lambda0= lambda0, alpha= alpha, beta= beta, horizon= H + Bu)
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(1000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(1000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][s[[1]] > Bu] - Bu)
      return (f)
    }
    
    p = c(0.1,0.2,0.3)
    opt=optim(par=p,fn=lik)
    MC1[i] = opt$par[1]
    MC2[i] = opt$par[2]
    MC3[i] = opt$par[3]
    if (MC3[i] > 15)
    {
      MC3[i]=15
    }
  }
  bias1[a] = mean(MC1) - lambda0
  bias2[a] = mean(MC2) - alpha
  bias3[a] = mean(MC3) - beta
}

### estimators
M1=0 #parameters for the naive estimator
M2=0
M3=0
M01=0 #parameters for the MLE on the whole dataset
M02=0
M03=0
MBC1=0
MBC2=0
MBC3=0
paths=1
for(a in 1:paths)
{
horizon=12000
burn = 0
Alambda0=.3
Aalpha = 0.85
Abeta = 4.5
#K=10000
#h=100  
lambda0=.6 + Alambda0
alpha=1.7 + Aalpha
beta=6 + Abeta
intensity=lambda0
#lambdaI = 1.5
#lambdaF = 1
#alphaI = 3
#alphaF = 12
#betaI = 10
#betaF = 15
u=runif(1)
obs_times = -log(u)/intensity
time=obs_times
intensity[1]=lambda0[1]
#lambda0[2] = lambda0[1]*exp(-theta*time) + mu1*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[1]
#alpha[2] = alpha[1]*exp(-theta*time) + mu2*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[2]
#beta[2] = beta[1]*exp(-theta*time) + mu3*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[3]
#lambda0= seq(from=lambda0, to=lambda0, length.out=N)
#alpha= seq(from=alpha, to=alpha, length.out=N)
#beta= seq(from=beta, to=beta, length.out=N)
compt=0
i=2
while (obs_times[i-1] < horizon + burn)
{
  lambda0[i] = .6 + Alambda0*cos(obs_times[i-1]*2*pi/horizon)
  alpha[i] = 1.7 + Aalpha*cos(obs_times[i-1]*2*pi/horizon)
  beta[i] = 6 + Abeta*cos(obs_times[i-1]*2*pi/horizon)
  intensity[i]=lambda0[i]
  for (j in 1:(i-1))
  {
    intensity[i] = intensity[i] + alpha[j]*exp(-beta[j]*(obs_times[i-1]-obs_times[j]))
  }
  intens1= intensity[i]
  time = 0
  t= TRUE
  compt[i]=1
  while (t)
  {
    u=runif(1)
    time = -log(u)/intens1 + time
    d=runif(1)
    intens2= lambda0[i]
    for (j in 1:(i-1))
    {
      intens2 = intens2 + alpha[j]*exp(-beta[j]*(obs_times[i-1]+ time-obs_times[j]))
    }
    if (d < intens2/intens1)
    {
      t=FALSE 
    } else {
      intens1 = intens2
    }
    compt[i] = compt[i]+1
  }
  obs_times[i] = obs_times[i-1] + time
  i = i+1
  
  #brownian_increment = rnorm(n=3,mean=0,sd=(exp(2*theta*time)-1)^(1/2))
  #lambda0[i+1] = lambda0[i]*exp(-theta*time) + mu1*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[1]
  #alpha[i+1] = alpha[i]*exp(-theta*time) + mu2*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[2]
  #beta[i+1] = beta[i]*exp(-theta*time) + mu3*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[3]
}

lik = function(param) 
{
  if (param[2] > param[3] - 0.0001)
  {
    return(10000000)
  }
  if (param[2] < 0)
  {
    return(1000000000)
  }
  #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[-1])
  f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[1:(i-2)][obs_times[1:(i-2)] > burn] - burn)
  return (f)
}

p = c(0.1,0.5,1)
opt = optim(par=p,fn=lik)
M01[a] = opt$par[1]
M02[a] = opt$par[2]
M03[a] = opt$par[3]

h=120
B=floor(horizon/h)
out1=0
out2=0
out3=0
outBC1=0
outBC2=0
outBC3=0
for(j in 1:B)
{
  init = burn + h*(j-1)
  fin = burn + h*j
  
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(10000000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(10000000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
    return (f)
  }
  
  opt = optim(par=p,fn=lik)
  out1[j] = opt$par[1]
  out2[j] = opt$par[2]
  out3[j] = opt$par[3]
  outBC1[j] = opt$par[1] #- bias1[floor((j-1)/5)+1]
  outBC2[j] = opt$par[2] #- bias2[floor((j-1)/5)+1]
  outBC3[j] = opt$par[3] #- bias3[floor((j-1)/5)+1]
  out3[out3 > 15] = 15
  outBC3[outBC3 > 15] = 15
}
M1[a]=mean(out1)
M2[a]=mean(out2)
M3[a]=mean(out3)
MBC1[a]=mean(outBC1)
MBC2[a]=mean(outBC2)
MBC3[a]=mean(outBC3)
}
#faut aller jusque la la Clinasse!



B=floor(N/h)
out1=0
out2=0
out3=0
for(i in 1:(B-1))
{
  init = 2 + h*(i-1)
  fin = h*i + 1 
  
  lik = function(param) 
  {
    if (param[2] > param[3] - 0.0001)
    {
      return(1000)
    }
    if (param[2] < 0)
    {
      return(1000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], (obs_times[init:fin]-obs_times[init-1]))
    #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[1:100])
    return (f)
  }
  
  opt = optim(par=p,fn=lik)
  out1[i] = opt$par[1]
  out2[i] = opt$par[2]
  out3[i] = opt$par[3]
}
M1[a]=mean(out1)
M2[a]=mean(out2)
M3[a]=mean(out3)
}
M1
M2
M3
M01
M02
M03


#Numerical simulation: checking the bias of the MLE and the divergence of the LPE
# likelihood
lambda0=.3
alpha=0.85
beta=1.5
MC1=0 #MLE on parametric model
MC2=0
MC3=0
MM1=0 #new estimator on parametric model
MM2=0
MM3=0
M01=0 # MLE on time-varying parameter model
M02=0
M03=0
M001=0 # MLE on time-varying parameter model
M002=0
M003=0
H=170 #horizon in seconds
Bu = 400 # burn part 
for (i in 1:10000)
{
  # simulation and fit in the parametric model
  s = simulateHawkes(lambda0= lambda0, alpha= alpha, beta= beta, horizon= H + Bu)
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(1000000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(1000000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][s[[1]] > Bu] - Bu)
    return (f)
  }
  
  p = c(0.1,0.2,0.3)
  opt=optim(par=p,fn=lik)
  MC1[i] = opt$par[1]
  MC2[i] = opt$par[2]
  MC3[i] = opt$par[3]
  if (MC3[i] > 15)
  {
    MC3[i]=15
  }
}
mean(MC1)
mean(MC2)
mean(MC3)

  h=120
  B=floor(H/h)
  out1=0
  out2=0
  out3=0
  for(j in 1:B)
  {
    init = Bu + h*(j-1)
    fin = Bu + h*j
    
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(10000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(10000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][(s[[1]] > init) & (s[[1]] < fin)] - init) 
    
      return (f)
    }
    
    opt = optim(par=p,fn=lik)
    out1[j] = opt$par[1]
    out2[j] = opt$par[2]
    out3[j] = opt$par[3]
  }
  MM1[i]=mean(out1)
  MM2[i]=mean(out2)
  MM3[i]=mean(out3)
}


# simulation and fit in block-varying parameter model
lambda0=c(0.9726847, 1.8548606, 1.6062339, 1.1842354, 1.2367515, 1.2994035, 1.1123222, 1.1302951, 0.8442995, 1.1728966, 0.8065788, 1.0069190)
alpha=c(5.0519373, 23.5177174, 21.4224392, 10.9600574, 15.3177587, 11.9075346, 6.8919283, 16.3644190, 5.7788237,9.8528831, 8.1837429, 7.7094902)
beta=c(11.046383, 68.252449, 63.968320, 24.313779, 37.140055, 32.277861, 17.373488, 45.212817, 13.469571, 26.869148, 21.482270, 21.594299)
MC1=0 #MLE 
MC2=0
MC3=0
MM1=0 #LPE
MM2=0
MM3=0
H=3600 #horizon in seconds
Bu = 100 # burn part 
h=300
B=floor(H/h)
for (i in 1:1000)
{
  s = simulateHawkes(lambda0= lambda0[1], alpha= alpha[1], beta= beta[1], horizon= Bu)
  obs_times=s[[1]]
  l = length(obs_times)
  out1=0
  out2=0
  out3=0
  for(j in 1:B)
  {
    s = simulateHawkes(lambda0= lambda0[j], alpha= alpha[j], beta= beta[j], horizon= h)
    l2 = length(s[[1]])
    obs_times[(l+1):(l+l2)]=s[[1]] + h*(j-1) + Bu
    l = length(obs_times)
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(10000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(10000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]]) 
      return (f)
    }
    
    opt = optim(par=p,fn=lik)
    out1[j] = opt$par[1]
    out2[j] = opt$par[2]
    out3[j] = opt$par[3]
  }
  MM1[i]=mean(out1)
  MM2[i]=mean(out2)
  MM3[i]=mean(out3)
  
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(1000000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(1000000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[obs_times > Bu] - Bu)
    return (f)
  }
  
  p = c(0.1,0.2,0.3)
  opt=optim(par=p,fn=lik)
  MC1[i] = opt$par[1]
  MC2[i] = opt$par[2]
  MC3[i] = opt$par[3]
  
}




  # simulation and fit in time-varying parameter model
  intensity=lambda0
  lambdaI = 1.5
  lambdaF = 1
  alphaI = 3
  alphaF = 12
  betaI = 10
  betaF = 15
  u=runif(1)
  obs_times = -log(u)/intensity
  time=obs_times
  lambda0m= seq(from=lambda0, to=lambda0, length.out=N)
  alpham= seq(from=alpha, to=alpha, length.out=N)
  betam= seq(from=beta, to=beta, length.out=N)
  k=2
  while (obs_times[k-1] < H)
  {
    intensity[k]=lambda0m[k]
    for (j in 1:(k-1))
    {
      intensity[k] = intensity[k] + alpham[j]*exp(-betam[j]*(obs_times[k-1]-obs_times[j]))
    }
    intens1= intensity[k]
    time = 0
    t= TRUE
    while (t)
    {
      u=runif(1)
      time = -log(u)/intens1 + time
      d=runif(1)
      intens2= lambda0m[k]
      for (j in 1:(k-1))
      {
        intens2 = intens2 + alpham[j]*exp(-betam[j]*(obs_times[k-1]+ time-obs_times[j]))
      }
      if (d < intens2/intens1)
      {
        t=FALSE 
      } else {
        intens1 = intens2
      }
    }
    obs_times[k] = obs_times[k-1] + time
    #brownian_increment = rnorm(n=3,mean=0,sd=(exp(2*theta*time)-1)^(1/2))
    #lambda0[i+1] = lambda0[i]*exp(-theta*time) + mu1*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[1]
    #alpha[i+1] = alpha[i]*exp(-theta*time) + mu2*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[2]
    #beta[i+1] = beta[i]*exp(-theta*time) + mu3*(1- exp(-theta*time)) + (sigma/(2*theta)^(1/2))*exp(-theta*time) * brownian_increment[3]
    k=k+1
  }
  
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(1000000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(1000000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[obs_times > 400] - 400)
    return (f)
  }
  
  p = c(0.1,0.2,0.3)
  opt=optim(par=p,fn=lik)
  M01[i] = opt$par[1]
  M02[i] = opt$par[2]
  M03[i] = opt$par[3]
  
  out1=0
  out2=0
  out3=0
  for(j in 1:B)
  {
    init = 400 + h*(j-1)
    fin = 400 + h*j
    
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(10000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(10000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
      
      return (f)
    }
    
    opt = optim(par=p,fn=lik)
    out1[j] = opt$par[1]
    out2[j] = opt$par[2]
    out3[j] = opt$par[3]
  }
  M001[i]=mean(out1)
  M002[i]=mean(out2)
  M003[i]=mean(out3)
}









mean=0
for (i in 1:3825)
{
  mean[i]=mean(MC1[1:i])
}


NPE1 = 0# stands for Normalized Parametric Estimator
NPE2 = 0
NPE3 = 0
l = 0 # stands for length
for (n in 1:1000)
{
  s = simulateHawkes(lambda0= n, alpha=n*2, beta=n*4, horizon=500)
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(1000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(1000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]])
    return (f)
  }
  
  p = c(0.1,0.2,0.3)
  opt=optim(par=p,fn=lik)
  NPE1[n] = opt$par[1]/n
  NPE2[n] = opt$par[2]/n
  NPE3[n] = opt$par[3]/n
  l[n]=length(s[[1]])
}

n=5
s = simulateHawkes(lambda0= n, alpha=n*2, beta=n*4, horizon=1000)
lik = function(param) 
{
  if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
  {
    return(1000)
  }
  if (param[2] > param[3] - 0.0001)
  {
    return(1000)
  }
  f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]])
  return (f)
}

p = c(0.1,0.2,0.3)
opt=optim(par=p,fn=lik)
NPE1 = opt$par[1]/n
NPE2 = opt$par[2]/n
NPE3 = opt$par[3]/n

LPE1=0
LPE2=0
LPE3=0
for (i in 1:100)
{
  liki = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(1000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(1000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][((i-1)*100 + 2):(i*100 + 1)] - s[[1]][(i-1)*100 + 1])
    return (f)
  }
  
  p = c(0.1,0.2,0.3)
  opt=optim(par=p,fn=liki)
  LPE1[i] = opt$par[1]/n
  LPE2[i] = opt$par[2]/n
  LPE3[i] = opt$par[3]/n 
}


# testing if it depends on the initial state
s = simulateHawkes(lambda0= 1, alpha=2, beta=4, horizon=1000)
lik = function(param) 
{
  if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
  {
    return(1000)
  }
  if (param[2] > param[3] - 0.0001)
  {
    return(1000)
  }
  #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[-1])
  f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]])
}
p= c(0.1,0.2,0.3)
opt=optim(par=p,fn=lik)

s = simulateHawkes(lambda0= 1, alpha=2, beta=4, horizon=1000)
lik = function(param) 
{
  if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
  {
    return(1000)
  }
  if (param[2] > param[3] - 0.0001)
  {
    return(1000)
  }
  #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[-1])
  f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s[[1]][-1] - s[[1]][1])
}
p= c(0.1,0.2,0.3)
opt2=optim(par=p,fn=lik)

# check the autosimilarity
  s = c(6,8,9)
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(1000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(1000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], s)
    return (f)
  }
  p= c(0.2,0.4,0.6)
  opt2=optim(par=p,fn=lik)
  opt2
  