data = read.csv(file="C:/Users/yoann/documents/data/appleTrades2015.csv",
                sep=',', header=TRUE)
d=data
days=unique(d[2])[[1]]


dai=0
fitnuMLE=0
fitaMLE=0
fitbMLE=0
sdnuMLE=0
sdaMLE=0
sdbMLE=0

T = 21600 # from 10am to 4pm in seconds
h=1800
B=floor(T/h)
Ndays=251
fitnulocal=array(dim=c(Ndays,B))
fitalocal=array(dim=c(Ndays,B))
fitblocal=array(dim=c(Ndays,B))
sdnulocal=array(dim=c(Ndays,B))
sdalocal=array(dim=c(Ndays,B))
sdblocal=array(dim=c(Ndays,B))

for (da in days[1:Ndays])
{
print(da)
dai=dai+1
obs_times = d[(d[,2]==da),3]
obs_times=obs_times[((obs_times > 36000)&(obs_times < 57600))]
obs_times = unique(obs_times)
obs_times = obs_times - 36000
N=length(obs_times)
lik = function(param) 
{
  if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
  {
    return(1000000)
  }
  if (param[2] > param[3] - 0.0001)
  {
    return(1000000)
  }
  #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[-1])
  f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times)
  return (f)
}

p = c(0.1,0.2,0.3)
opt = optim(par=p,fn=lik)
fitnuMLE[dai] = opt$par[1]
fitaMLE[dai] = opt$par[2]
fitbMLE[dai] = opt$par[3]
init=0
fin=T
invminFisher = function(param) 
{
  F = matrix(data=0,ncol=3, nrow=3)
  o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
  leng = length(o)-1
  tn = o[leng+1]
  Aoz = 0
  Boz=0
  coz = 0
  for (i in 2:(leng+1))
  {
    F[1,1] = F[1,1] - (1/(param[1] + param[2]*Aoz)^2)
    F[1,2] = F[1,2] - (Aoz/(param[1] + param[2]*Aoz)^2)
    F[1,3] = F[1,3] + (param[2]*Boz)/(param[1] + param[2]*Aoz)^2
    F[2,2] = F[2,2] - (Aoz/(param[1] + param[2]*Aoz))^2
    F[2,3] = F[2,3] - (exp(-param[3]*(tn - o[i]))*(tn - o[i])/param[3]) - ((exp(-param[3]*(tn - o[i])) - 1)/param[3]^2) - (Boz/(param[1] + param[2]*Aoz)) + ((param[2]*Aoz*Boz)/(param[1] + param[2]*Aoz)^2)
    F[3,3] = F[3,3] + (exp(-param[3]*(tn - o[i]))*((tn - o[i])^2)*param[2]/param[3]) + (2*exp(-param[3]*(tn - o[i]))*(tn - o[i])*param[2]/param[3]^2) + (2*(exp(-param[3]*(tn - o[i]))-1)*param[2]/param[3]^3) + (coz*param[2])/(param[1] + param[2]*Aoz) - ((Boz*param[2])/(param[1] + param[2]*Aoz))^2
    Aoz = (Aoz + 1)*exp(-param[3]*(o[i+1] - o[i]))
    Boz = Boz*exp(-param[3]*(o[i+1] - o[i])) + ((o[i+1] - o[i])*Aoz)
    coz = coz*exp(-param[3]*(o[i+1] - o[i])) + (((o[i+1] - o[i])^2)*Aoz)
    #print(Aoz)
  }
  F[2,1] = F[1,2]
  F[3,1] = F[1,3]
  F[3,2] = F[2,3]
  inv = solve(-F)
  #print(F)
  return (inv)
}
inv1=invminFisher(c(fitnuMLE[dai],fitaMLE[dai],fitbMLE[dai]))
sdnuMLE[dai] = sqrt(inv1[1,1])
sdaMLE[dai] = sqrt(inv1[2,2])
sdbMLE[dai] = sqrt(inv1[3,3])


for(j in 1:B)
{
  init = h*(j-1)
  fin =  h*j
  obslik = obs_times[(obs_times > init) & (obs_times < fin)]
  obslik = obslik[-1] - init
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(10000000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(10000000)
    }
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
    return (f)
  }
  
  opt = optim(par=p,fn=lik)
  fitnulocal[dai,j] = opt$par[1]
  fitalocal[dai,j] = opt$par[2]
  fitblocal[dai,j] = opt$par[3]
  
  invminFisher = function(param) 
  {
    F = matrix(data=0,ncol=3, nrow=3)
    o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
    leng = length(o)-1
    tn = o[leng+1]
    Aoz = 0
    Boz=0
    coz = 0
    for (i in 2:(leng+1))
    {
      F[1,1] = F[1,1] - (1/(param[1] + param[2]*Aoz)^2)
      F[1,2] = F[1,2] - (Aoz/(param[1] + param[2]*Aoz)^2)
      F[1,3] = F[1,3] + (param[2]*Boz)/(param[1] + param[2]*Aoz)^2
      F[2,2] = F[2,2] - (Aoz/(param[1] + param[2]*Aoz))^2
      F[2,3] = F[2,3] - (exp(-param[3]*(tn - o[i]))*(tn - o[i])/param[3]) - ((exp(-param[3]*(tn - o[i])) - 1)/param[3]^2) - (Boz/(param[1] + param[2]*Aoz)) + ((param[2]*Aoz*Boz)/(param[1] + param[2]*Aoz)^2)
      F[3,3] = F[3,3] + (exp(-param[3]*(tn - o[i]))*((tn - o[i])^2)*param[2]/param[3]) + (2*exp(-param[3]*(tn - o[i]))*(tn - o[i])*param[2]/param[3]^2) + (2*(exp(-param[3]*(tn - o[i]))-1)*param[2]/param[3]^3) + (coz*param[2])/(param[1] + param[2]*Aoz) - ((Boz*param[2])/(param[1] + param[2]*Aoz))^2
      Aoz = (Aoz + 1)*exp(-param[3]*(o[i+1] - o[i]))
      Boz = Boz*exp(-param[3]*(o[i+1] - o[i])) + ((o[i+1] - o[i])*Aoz)
      coz = coz*exp(-param[3]*(o[i+1] - o[i])) + (((o[i+1] - o[i])^2)*Aoz)
      #print(Aoz)
    }
    F[2,1] = F[1,2]
    F[3,1] = F[1,3]
    F[3,2] = F[2,3]
    inv = solve(-F)
    #print(F)
    return (inv)
  }
  inv1=invminFisher(c(fitnuMLE[dai],fitaMLE[dai],fitbMLE[dai]))
  sdnulocal[dai,j] = sqrt(inv1[1,1])
  sdalocal[dai,j] = sqrt(inv1[2,2])
  sdblocal[dai,j] = sqrt(inv1[3,3])
  
}
#plot(fitnulocal[dai,])
#plot(fitalocal[dai,])
#plot(fitblocal[dai,])
}
plot(colMeans(fitnulocal[1:228,2:11]))
plot(colMeans(fitalocal[1:228,2:11]))
plot(colMeans(fitblocal[1:228,2:11]))
plot(colMeans(fitalocal[1:228,2:11]/fitblocal[1:228,2:11]))

### fit model III in simulations
ModelIII = function(t, param) # param a 3-dimensional parameter which corresponds to (beta1, beta2, beta3)
{
  return (exp(param[1]) + ((exp(param[2]) + exp(param[3]))^2)*(t/T - exp(param[2])/(exp(param[2]) + exp(param[3])))^2)
}

meanfitalocal = colMeans(fitalocal[1:228,2:11])
meanfitblocal = colMeans(fitblocal[1:228,2:11])
lengmean = length(meanfitalocal)
distModelIII = function(param)
{
  return(sum((ModelIII(0:(lengmean-1)*T/(lengmean-1),param) - meanfitblocal)^2))
}
p=c(1,1,1)
opt=optim(par=p,fn=distModelIII)
opt$par
plot(ModelIII(1:100*T/100,opt$par))
##
#fitted a parameters 2.34743451 -0.04994563  0.40322699
#fitted b parameters 3.6563998 -0.3251952  0.6692799


####plot

par(mfrow=c(3, 7))
par(mar = rep(2, 4))
tim = seq.POSIXt(from=ISOdatetime(year=2015, month=1, day=1, hour=10, min=30, sec = 0), to=ISOdatetime(year=2015, month=1, day=1, hour=15, min=30, sec = 0), length.out=10)
for (i in 104:109)
{
  plot(tim,colMeans(fitnulocal[1:228,2:11]), type="l", ylim=c(min(fitnulocal[i,2:11] - 2*sdnulocal[i,2:11]) - .05, max(fitnulocal[i,2:11] + 2*sdnulocal[i,2:11]) + .05), lwd=5)
  title(main=paste("2015 - 06 -",0,days[i]-151))
  points(tim,fitnulocal[i,2:11], type="l", col="red")
  points(tim,fitnulocal[i,2:11] - 2*sdnulocal[i,2:11], type="l", lty=2, col="blue")
  points(tim,fitnulocal[i,2:11] + 2*sdnulocal[i,2:11], type="l", lty=3, col="blue")
}
for (i in 110:124)
{
  plot(tim,colMeans(fitnulocal[1:228,2:11]), type="l", ylim=c(min(fitnulocal[i,2:11] - 2*sdnulocal[i,2:11]) - .05, max(fitnulocal[i,2:11] + 2*sdnulocal[i,2:11]) + .05), lwd=5)
  title(main=paste("2015 - 06 -",days[i]-151))
  points(tim,fitnulocal[i,2:11], type="l", col="red")
  points(tim,fitnulocal[i,2:11] - 2*sdnulocal[i,2:11], type="l", lty=2, col="blue")
  points(tim,fitnulocal[i,2:11] + 2*sdnulocal[i,2:11], type="l", lty=3, col="blue")
}

par(mfrow=c(3, 7))
par(mar = rep(2, 4))
tim = seq.POSIXt(from=ISOdatetime(year=2015, month=1, day=1, hour=10, min=30, sec = 0), to=ISOdatetime(year=2015, month=1, day=1, hour=15, min=30, sec = 0), length.out=10)
for (i in 104:109)
{
  plot(tim,colMeans(fitalocal[1:228,2:11]), type="l", ylim=c(min(fitalocal[i,2:11] - 2*sdalocal[i,2:11]) - .05, max(fitalocal[i,2:11] + 2*sdalocal[i,2:11]) + .05), lwd=5)
  title(main=paste("2015 - 06 -",0,days[i]-151))
  points(tim,fitalocal[i,2:11], type="l", col="red")
  points(tim,fitalocal[i,2:11] - 2*sdalocal[i,2:11], type="l", lty=2, col="blue")
  points(tim,fitalocal[i,2:11] + 2*sdalocal[i,2:11], type="l", lty=3, col="blue")
}
for (i in 110:124)
{
  plot(tim,colMeans(fitalocal[1:228,2:11]), type="l", ylim=c(min(fitalocal[i,2:11] - 2*sdalocal[i,2:11]) - .05, max(fitalocal[i,2:11] + 2*sdalocal[i,2:11]) + .05), lwd=5)
  title(main=paste("2015 - 06 -",days[i]-151))
  points(tim,fitalocal[i,2:11], type="l", col="red")
  points(tim,fitalocal[i,2:11] - 2*sdalocal[i,2:11], type="l", lty=2, col="blue")
  points(tim,fitalocal[i,2:11] + 2*sdalocal[i,2:11], type="l", lty=3, col="blue")
}

par(mfrow=c(3, 7))
par(mar = rep(2, 4))
tim = seq.POSIXt(from=ISOdatetime(year=2015, month=1, day=1, hour=10, min=30, sec = 0), to=ISOdatetime(year=2015, month=1, day=1, hour=15, min=30, sec = 0), length.out=10)
for (i in 104:109)
{
  plot(tim,colMeans(fitblocal[1:228,2:11]), type="l", ylim=c(min(fitblocal[i,2:11] - 2*sdblocal[i,2:11]) - .05, max(fitblocal[i,2:11] + 2*sdblocal[i,2:11]) + .05), lwd=5)
  title(main=paste("2015 - 06 -",0,days[i]-151))
  points(tim,fitblocal[i,2:11], type="l", col="red")
  points(tim,fitblocal[i,2:11] - 2*sdblocal[i,2:11], type="l", lty=2, col="blue")
  points(tim,fitblocal[i,2:11] + 2*sdblocal[i,2:11], type="l", lty=3, col="blue")
}
for (i in 110:124)
{
  plot(tim,colMeans(fitblocal[1:228,2:11]), type="l", ylim=c(min(fitblocal[i,2:11] - 2*sdblocal[i,2:11]) - .05, max(fitblocal[i,2:11] + 2*sdblocal[i,2:11]) + .05), lwd=5)
  title(main=paste("2015 - 06 -",days[i]-151))
  points(tim,fitblocal[i,2:11], type="l", col="red")
  points(tim,fitblocal[i,2:11] - 2*sdblocal[i,2:11], type="l", lty=2, col="blue")
  points(tim,fitblocal[i,2:11] + 2*sdblocal[i,2:11], type="l", lty=3, col="blue")
}

####
plot(colMeans(fitalocal[1:228,2:11]))
plot(colMeans(fitblocal[1:228,2:11]))
plot(colMeans(fitalocal[1:228,2:11]/fitblocal[1:228,2:11]))


#count the number of daily trades
dai=0
N=0
for (da in days[1:Ndays])
{
  #print(da)
  dai=dai+1
  obs_times = d[(d[,2]==da),3]
  obs_times=obs_times[((obs_times > 37800)&(obs_times < 55800))]
  obs_times = unique(obs_times)
  N[dai]=length(obs_times)
}

## plot sd each day
dai=0
sdnu=0
sda=0
sdb=0
for (da in days[1:Ndays])
{
  #print(da)
  dai=dai+1
  sdnu[dai] = sd(fitnulocal[dai,2:11])
  sda[dai] = sd(fitalocal[dai,2:11])
  sdb[dai] = sd(fitblocal[dai,2:11])
}



############################## fit the estimators 

intpoly = function(tn, param) # return the integral of param[1] + param[2]*x/tn + param[3]*(x/tn)^2 + param[4]*(x/tn)^3 between 0 and tn
{
  return(tn*(param[1] + param[2]/2 + param[3]/3 + param[4]/4))
}

nupoly = function(tn, t, param) # return the value of param[1] + param[2]*x + param[3]*x^2 + param[4]*x^3 at t when tn is final
{
  return(param[1] + param[2]*t/tn + param[3]*(t/tn)^2 + param[4]*(t/tn)^3)
}

M01=0 #parameters for the MLE on the whole dataset
M02=0
M03=0
M001=0 #parameters for Chen estimator
M002=0
M003=0

horizon=18000 # from 1030am to 330pm in seconds
T=horizon
Bmax = 250
Ndays=251
paths=Ndays
out1 =array(dim=c(paths,Bmax))
out2 =array(dim=c(paths,Bmax))
out3 =array(dim=c(paths,Bmax))
out1BC =array(dim=c(paths,Bmax))
out2BC =array(dim=c(paths,Bmax))
out3BC =array(dim=c(paths,Bmax))
out1small =array(dim=c(paths,(Bmax)))
out2small =array(dim=c(paths,(Bmax)))
out3small =array(dim=c(paths,(Bmax)))
out1BCsmall =array(dim=c(paths,(Bmax)))
out2BCsmall =array(dim=c(paths,(Bmax)))
out3BCsmall =array(dim=c(paths,(Bmax)))
out1small2 =array(dim=c(paths,(Bmax)))
out2small2 =array(dim=c(paths,(Bmax)))
out3small2 =array(dim=c(paths,(Bmax)))
out1BCsmall2 =array(dim=c(paths,(Bmax)))
out2BCsmall2 =array(dim=c(paths,(Bmax)))
out3BCsmall2 =array(dim=c(paths,(Bmax)))
out1big =array(dim=c(paths,(Bmax)))
out2big =array(dim=c(paths,(Bmax)))
out3big =array(dim=c(paths,(Bmax)))
out1BCbig =array(dim=c(paths,(Bmax)))
out2BCbig =array(dim=c(paths,(Bmax)))
out3BCbig =array(dim=c(paths,(Bmax)))
out1big2 =array(dim=c(paths,(Bmax)))
out2big2 =array(dim=c(paths,(Bmax)))
out3big2 =array(dim=c(paths,(Bmax)))
out1BCbig2 =array(dim=c(paths,(Bmax)))
out2BCbig2 =array(dim=c(paths,(Bmax)))
out3BCbig2 =array(dim=c(paths,(Bmax)))

pa=0
B=0 # number of blocks
Bbig=0
Bbig2=0
Bsmall=0
Bsmall2=0
N=0 # number of observations
h=0
hbig=0
hbig2=0
hsmall=0
hsmall2=0
for (da in days[1:Ndays])
{
  pa=pa+1
  print(pa)
  nu=0.6082734
  a = 11
  b= 40
  
  obs_times = d[(d[,2]==da),3]
  obs_times=obs_times[((obs_times > 37800)&(obs_times < 55800))]
  obs_times = unique(obs_times)
  obs_times = obs_times - 37800
  N[pa]=length(obs_times)
  
  
  lik = function(param) 
  {
    if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
    {
      return(1000000)
    }
    if (param[2] > param[3] - 0.0001)
    {
      return(1000000)
    }
    #f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[-1])
    f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[1:N[pa]])
    return (f)
  }
  
  p = c(nu,a,b)
  opt = optim(par=p,fn=lik)
  M01[pa] = opt$par[1]
  M02[pa] = opt$par[2]
  M03[pa] = opt$par[3]
  
  init=0
  fin=T
  likChenpony = function(param) #we provide a polynomial of order 3 for nu (corresponding to param[1:4]) on top of alpha and beta (corresponding to param[5:6])
  {
    if ((param[5] < 0) | (param[6] < 0) | (param[1] < nu - .3) | (param[1] > nu + .3))
    {
      return(10000000)
    }
    if (param[5] > param[6] - 0.0001)
    {
      return(10000000)
    }
    o = obs_times[(obs_times > init) & (obs_times < fin)] - obs_times[(obs_times > init) & (obs_times < fin)][1]
    leng = length(o)-1
    tn = o[leng+1]
    if (min(nupoly(tn,o[-1],param[1:4])) <  .1)
    {
      return(10000000)
    }
    Aoz = vector(length=leng)
    Aoz[1]=0
    #f=param[1]*tn
    for (i in 2:(leng))
    {
      #f = f-(param[2]/param[3])*(exp(-param[3]*(tn - o[i])) - 1)
      #f = f- log(param[1] + param[2]*Aoz)
      Aoz[i] = (Aoz[i-1] + 1)*exp(-param[6]*(o[i+1] - o[i]))
    }
    f=intpoly(tn,param[1:4]) - sum((param[5]/param[6])*(exp(-param[6]*(tn - o[-1])) - 1)) - sum(log(nupoly(tn, o[-1],param[1:4]) + param[5]*Aoz))
    return (f)
  }
  p = c(nu,0,0,0,a,b)
  opt = optim(par=p,fn=likChenpony, control=c(maxit=500))
  M001[pa] = intpoly(T,opt$par[1:4])/T
  M002[pa] = opt$par[5]
  M003[pa] = opt$par[6]
  
  h[pa]=4*sqrt(N[pa])
  B[pa]=floor(horizon/h[pa])
  for(j in 1:B[pa])
  {
    init = h[pa]*(j-1)
    fin = h[pa]*j
    if (j == B[pa])
    {
      fin = T
    }
    
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(10000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(10000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
      return (f)
    }
    
    p=c(nu,a,b)
    opt = optim(par=p,fn=lik)
    out1[pa,j] = opt$par[1]
    out2[pa,j] = opt$par[2]
    out3[pa,j] = opt$par[3]
  }
  
  hbig[pa]=2*sqrt(N[pa])
  Bbig[pa]=floor(horizon/hbig[pa])
  for(j in 1:Bbig[pa])
  {
    init = burn + hbig[pa]*(j-1)
    fin = burn + hbig[pa]*j
    if (j == Bbig[pa])
    {
      fin = T
    }
    
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(10000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(10000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
      return (f)
    }
    
    p=c(nu,a,b)
    opt = optim(par=p,fn=lik)
    out1big[pa,j] = opt$par[1]
    out2big[pa,j] = opt$par[2]
    out3big[pa,j] = opt$par[3]
  }
  
  hbig2[pa]=sqrt(N[pa])
  Bbig2[pa]=floor(horizon/hbig2[pa])
  for(j in 1:Bbig2[pa])
  {
    init = burn + hbig2[pa]*(j-1)
    fin = burn + hbig2[pa]*j
    if (j == Bbig2[pa])
    {
      fin = T
    }
    
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(10000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(10000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
      return (f)
    }
    
    p=c(nu,a,b)
    opt = optim(par=p,fn=lik)
    out1big2[pa,j] = opt$par[1]
    out2big2[pa,j] = opt$par[2]
    out3big2[pa,j] = opt$par[3]
  }
  
  hsmall[pa]=8*sqrt(N[pa])
  Bsmall[pa]=floor(horizon/hsmall[pa])
  for(j in 1:Bsmall[pa])
  {
    init = burn + hsmall[pa]*(j-1)
    fin = burn + hsmall[pa]*j
    if (j == Bsmall[pa])
    {
      fin = T
    }
    
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(10000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(10000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
      return (f)
    }
    
    p=c(nu,a,b)
    opt = optim(par=p,fn=lik)
    out1small[pa,j] = opt$par[1]
    out2small[pa,j] = opt$par[2]
    out3small[pa,j] = opt$par[3]
  }
  
  hsmall2[pa]=16*sqrt(N[pa])
  Bsmall2[pa]=floor(horizon/hsmall2[pa])
  for(j in 1:Bsmall2[pa])
  {
    init = burn + hsmall2[pa]*(j-1)
    fin = burn + hsmall2[pa]*j
    if (j == Bsmall2[pa])
    {
      fin = T
    }
    
    lik = function(param) 
    {
      if ((param[1] < 0) | (param[2] < 0) | (param[3] < 0))
      {
        return(10000000)
      }
      if (param[2] > param[3] - 0.0001)
      {
        return(10000000)
      }
      f = likelihoodHawkes(lambda0=param[1], alpha=param[2], beta=param[3], obs_times[(obs_times > init) & (obs_times < fin)] - init) 
      return (f)
    }
    
    p=c(nu,a,b)
    opt = optim(par=p,fn=lik)
    out1small2[pa,j] = opt$par[1]
    out2small2[pa,j] = opt$par[2]
    out3small2[pa,j] = opt$par[3]
  }
}


###bias
whichbias1 = which.min(abs(out1[pa,j] - nuGrid))
whichbias2 = which.min(abs(out2[pa,j] - aGrid))
whichbias3 = which.min(abs(out3[pa,j] - bGrid))
# Model IV
whichbias1 = which.min(abs(out1[pa,j] - nuGrid)/.8 + abs(out2[pa,j] - aGrid)/11 + abs(out3[pa,j] - bGrid)/40)
whichbias2 = whichbias1
whichbias3 = whichbias1

out1BC[pa,j] = out1[pa,j] - biasnuGrid[whichbias1]
out2BC[pa,j] = out2[pa,j] - biasaGrid[whichbias2]
out3BC[pa,j] = out3[pa,j] - biasbGrid[whichbias3]


### get the means
Mout1=0
Mout2=0
Mout3=0
Mout1big=0
Mout2big=0
Mout3big=0
Mout1big2=0
Mout2big2=0
Mout3big2=0
Mout1small=0
Mout2small=0
Mout3small=0
Mout1small2=0
Mout2small2=0
Mout3small2=0
for (i in 1:228)
{
  Mout1[i] = mean(out1[i,1:B[i]])
  Mout2[i] = mean(out2[i,1:B[i]])
  Mout3[i] = mean(out3[i,1:B[i]])
  Mout1big[i] = mean(out1big[i,1:Bbig[i]])
  Mout2big[i] = mean(out2big[i,1:Bbig[i]])
  Mout3big[i] = mean(out3big[i,1:Bbig[i]])
  Mout1big2[i] = mean(out1big2[i,1:(min(250,Bbig2[i]))])
  Mout2big2[i] = mean(out2big2[i,1:(min(250,Bbig2[i]))])
  Mout3big2[i] = mean(out3big2[i,1:(min(250,Bbig2[i]))])
  Mout1small[i] = mean(out1small[i,1:Bsmall[i]])
  Mout2small[i] = mean(out2small[i,1:Bsmall[i]])
  Mout3small[i] = mean(out3small[i,1:Bsmall[i]])
  Mout1small2[i] = mean(out1small2[i,1:Bsmall2[i]])
  Mout2small2[i] = mean(out2small2[i,1:Bsmall2[i]])
  Mout3small2[i] = mean(out3small2[i,1:Bsmall2[i]])
}