#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
    ivol is a package gathering several estimators
    for integrated volatility and related quantities for noisy high-frequency data.

    Original author : Simon Clinet.   simon (at) ms.u-tokyo.ac.jp, http://www.ms.u-tokyo.ac.jp/~simon/

    Current maintainer : Simon Clinet

    There are two main modules in the package.
    - estim contains the main classes to use for the estimations.
    - aux contains auxiliary functions and is not intended to be used directly.
      In particular you should not modify its content unless you know clearly what you are doing.

    More details about the module estim typing

    import ivol.estim as estim; help(estim)

    Note that the package uses some functions from the packages numpy, pandas, scipy, and statsmodels.
    Make sure to have them installed before using this one.

    Example :
    ---------

    from ivol.estim import Vol_QMLE
    import numpy as np

    sigma = np.sqrt(0.1) # annual volatility
    a2 = 0.0002**2 # noise variance
    T = 1/252 # One working day in annual time
    d=1 # One day
    daily_obs = 23400 # One observation evey second

    X = sigma*np.sqrt(T/daily_obs)*np.random.normal(0,1,daily_obs) #efficient log-returns
    U = np.sqrt(a2)*np.random.normal(0,1,daily_obs) #noise
    Y = X+U

    input_data = {"Y": Y, "T":T, "d":d}

    start, end = 0,-1 #start and end indices for the estimation procedure
    est = Vol_QMLE(start,end,input_data) #The QMLE estimator
    est.estim()
    est.info()

    ###A local QMLE on 8 blocks
    from ivol.estim import Vol_estimator, localize

    input_data_local = {"Y": Y, "T":T, "d":d, "b":8, "estClass": Vol_QMLE}

    Vol_local = localize(Vol_estimator)
    est_local = Vol_local(start,end,input_data_local)

    est_local.estim()
    est_local.info()


"""

__version__ = "0.0.1"

#from estim import Estimator, Vol_estimator, Tric_estimator, Quart_estimator, Rho_estimator, Kappa_estimator, Noise_estimator
#from estim import Vol_QMLE, Vol_RK, Vol_PA, Vol_TSRV, Vol_Local
#from estim import Quart_PA
#from estim import Noise_Realized, Noise_QMLE
#from estim import Rho_direct, Kappa_direct
