import numpy as np
from pandas import DataFrame, Series
import matplotlib.pyplot as plt
import math as math
#from path import path

np.random.seed(1)

start = 0
end = -1
dailySeconds=23400 #corresponds to the number of seconds considered in a day
M = 1000 #nb of Monte-Carlo simulations
T = 1/252 # horizon time
d = 1 #nb of days

# simulation
## regular observations
samplingfreq = 30 #corresponds to the sampling frequency in seconds
n = int(dailySeconds/samplingfreq)
varerror= 0 #10 ** (-9)

model=0 # 0 for Roll, 1 for signed spread model
if model == 0:
    knownnoiseparam=0.0001
if model == 1:
    knownnoiseparam=0.80
    meanHalfSpread = 0.000125
    varHalfSpread = 10 ** (-10)
    ARparam = 0.6
regular_obs = 0 # 1 for regular observations, 0 for non regular

#### volatility constant model
volatility = np.sqrt(0.1) # volatility ** 2 = 0.1
target = volatility ** 2
V = 4*(volatility ** 4)
if regular_obs == 1:
    sim = Simulator(samplingfreq,M,d,dailySeconds,T)
if regular_obs == 0:
    sim = Simulator(samplingfreq, M, d, dailySeconds, T, regular_obs=0)
    sim.simulObsTimes()
effprice = sim.simulCV(priceArgs=[volatility])[0]
if model == 0:
    [explicativepart,info] = sim.explicativePartRollAuto([knownnoiseparam], auto=.95)
if model == 1:
    [explicativepart, info, spread] = sim.explicativePartSpread([knownnoiseparam], 0.95, meanHalfSpread, varHalfSpread, ARparam)
error = sim.simulNoiseIID([varerror])

obsprice = effprice + explicativepart + error
sim.Y = obsprice
sim.info = info
if model == 1:
    sim.spread = spread
sim.knownNoiseArgs=knownnoiseparam

#### time-varying volatility and no price jumps
#####Parameters for the Heston
mu = 0.03
rho = -0.75
kappa = 5
gamma = 0.4
alpha = 0.1 #i.e. mean volatility ** 2

#####Parameters for the jump
jump_size = .5 #in % of the vol
jump_start,jump_end = 0,1
jump_mode = "unif"

####Parameters for the daily U-shaped vol
A = 0.75
B = 0.25
C = 0.88929198
a = 10.0
b = 10.0

sigma = 1#np.sqrt(0.1)

def riemann(g,k=500):
    return np.sum([g(i/k) for i in range(k)])*1/k

def sigma_u(x):
    return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma

tab = np.array([sigma_u(i/100) for i in np.arange(100)])


def sigma_u_jumps(x):
    if x <= 0.5:
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma
    else :
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma-0.5*sigma

priceArgs = [mu, kappa, alpha, gamma, rho, sigma_u, [jump_size,jump_start,jump_end], jump_mode]

if regular_obs == 1:
    sim = Simulator(samplingfreq,M,d,dailySeconds,T)
if regular_obs == 0:
    sim = Simulator(samplingfreq,M,d,dailySeconds,T, regular_obs=0)
    sim.simulObsTimes()
if model == 0:
    sim.simulGlobal(priceFun=sim.simulSVHeston,priceArgs=priceArgs,noiseFun=sim.simulNoiseIID,noiseArgs=[varerror,start,end,T],  knownNoiseArgs=knownnoiseparam, infotype="roll", recordMode=True)
if model == 1:
    sim.simulGlobal(priceFun=sim.simulSVHeston,priceArgs=priceArgs,noiseFun=sim.simulNoiseIID,noiseArgs=[varerror,start,end,T],  knownNoiseArgs=knownnoiseparam, infotype="spread", recordMode=True)
    spread=sim.spread
obsprice=sim.Y
info= sim.info


#### time-varying volatility and price jumps (add the code that follows to obtain jumps)
lambda_jump = T
size_jump = np.sqrt((volatility ** 2)*T)# around 50 percent of the total quadratic variation
time_jump = np.random.exponential(lambda_jump, (M,10))
for i in range(M):
    nfin = 0
    if regular_obs == 1:
        nfin = n
    if regular_obs == 0:
        nfin = sim.nbObs[i]
    time_next_jump = time_jump[i][0]
    ind = 0
    while time_next_jump < T :
        positive_jump = np.random.binomial(1,0.5)
        if regular_obs == 1:
            time_jump_discrete = int(n*time_next_jump/T)
        if regular_obs == 0:
            time_jump_discrete = min(range(len(sim.obsTimes[i])), key=abs(sim.obsTimes[i] - time_next_jump).__getitem__)
        if positive_jump:
            obsprice[i][time_jump_discrete:n] = obsprice[i][time_jump_discrete:n] + size_jump
        else:
            obsprice[i][time_jump_discrete:n] = obsprice[i][time_jump_discrete:n] - size_jump
        ind += 1
        time_next_jump += time_jump[i][ind]

# estimation
QMLEerr = Vol_QMLE(start, end, sim.__dict__)
if model == 0:
    QMLEerr.estim(infotype="roll")
if model == 1:
    QMLEerr.estim(infotype="spread")
QMLEerr.values = QMLEerr.values / T
    # QMLEerr.target = target
    #### case where varerror=0
    # QMLEerr.avar = 6*(volatility ** 4)*np.ones(shape=M)
    # QMLEerr.rate = 1/2
    #### case where varerror > 0
    # QMLEerr.avar = np.sqrt(varerror)* (T ** (-(1/2))) * 8 * (volatility ** 3) *np.ones(shape=M)
    # QMLEerr.rate = 1/4
    # time-varying vol and no price jumps
    # QMLEerr.rate = 1/2
    # QMLEerr.target = np.zeros(M)
    # QMLEerr.avar = np.zeros(M)
    # for i in range(M):
    #    QMLEerr.target[i] = QMLEerr.IV[i][n]/T
    #    QMLEerr.avar[i] = 6*QMLEerr.Q[i][n]/(T ** 2)

QMLEexp = Vol_Yingying(start, end, sim.__dict__)
if model == 0:
    QMLEexp.estim(infotype="roll")
if model == 1:
    QMLEexp.estim(infotype="spread")
QMLEexp.values = QMLEexp.values / T
    # QMLEexp.target = target
    # QMLEexp.avar = 2*(volatility ** 4)*np.ones(shape=M)
    # QMLEexp.rate = 1/2
    # time-varying vol and no price jumps
    # QMLEexp.rate = 1/2
    # QMLEexp.target = np.zeros(M)
    # QMLEexp.avar = np.zeros(M)
    # for i in range(M):
    #    QMLEexp.target[i] = QMLEexp.IV[i][n]/T
    #    QMLEexp.avar[i] = 2*QMLEexp.Q[i][n]/(T ** 2)

## S1
V1 = 4*(QMLEexp.values ** 2)
S1 = (nt*((QMLEerr.values - QMLEexp.values) ** 2))/V1
test1 = np.zeros(M)
for i in range(M):
    test1[i] = int((S1[i] > 3.841))
prop1 = np.mean(test1)

## S2
if regular_obs == 1:
    estprice = np.zeros((M,n+1))
if regular_obs == 0:
    estprice = np.zeros((M,sim.Nmax))
V2 = np.zeros(M)
for i in range(M):
    if model==0:
        estprice[i] = obsprice[i] - QMLEexp.knownNoise_estimatedvalue[i] * info[i]
    if model==1:
        estprice[i] = obsprice[i] - QMLEexp.knownNoise_estimatedvalue[i] * info[i] * spread[i]
    if regular_obs == 1:
        V2[i] = (4/(3*(T ** 2)))*n*np.sum(np.diff(estprice[i]) ** 4)
    if regular_obs == 0:
        V2[i] = (4 / (3 * (T ** 2))) * sim.nbObs[i] * np.sum(np.diff(estprice[i][0:(sim.nbObs[i]-1)]) ** 4)
S2 = (n*((QMLEerr.values - QMLEexp.values) ** 2))/V2
test2 = np.zeros(M)
for i in range(M):
    test2[i] = int((S2[i] > 3.841))
prop2 = np.mean(test2)

## S3
alpha0 = 4
alphatilde = alpha0*(QMLEexp.values **(1/2))
omegabar = 0.48
kn = int(np.sqrt(n))
Delta = T/n
un = alphatilde*(Delta ** omegabar)
V3 = np.zeros(M)
factor1 = 4/(3 * T * Delta)
factor2 = 4/(kn * T * Delta)
for j in range(M):
    V3[j] = 0
    ret = np.diff(estprice[j])
    for i in range(n):
        if abs(ret[i]) < un[j]:
            V3[j] = V3[j] + factor1*(ret[i] ** 4)
        else:
            if kn-1 < i < n - kn:
                V3[j] = V3[j] + factor2*(ret[i] ** 2)*np.sum((ret[(i-kn):(i+kn)] ** 2)*(ret[(i-kn):(i+kn)] < un[j]))
S3 = (n * ((QMLEerr.values - QMLEexp.values) ** 2)) / V3
test3 = np.zeros(M)
for i in range(M):
    test3[i] = int((S3[i] > 3.841))
prop3 = np.mean(test3)

## S4
#Vtarget = 4*(target ** 2)*integratedalpha*integratedalphainv
N=np.zeros(M)
if regular_obs == 1:
    estprice = np.zeros((M,n+1))
if regular_obs == 0:
    estprice = np.zeros((M,sim.Nmax+1))
    for i in range(M):
        N[i] = sim.nbObs[i] - 1
V4 = np.zeros(M)
for i in range(M):
    if model==0:
        estprice[i] = obsprice[i] - QMLEexp.knownNoise_estimatedvalue[i] * info[i]
    if model==1:
        estprice[i] = obsprice[i] - QMLEexp.knownNoise_estimatedvalue[i] * info[i] * spread[i]
    if regular_obs == 1:
    V4[i] = (4/(T ** 2))*n*np.sum((np.diff(estprice[i][1:n]) ** 2)*(np.diff(estprice[i][0:(n-1)]) ** 2))
    if regular_obs == 0:
        V4[i] = (4/(T ** 2))*(N[i]+1)*np.sum((np.diff(estprice[i][1:N[i]]) ** 2)*(np.diff(estprice[i][0:(N[i]-1)]) ** 2))
if regular_obs == 1:
    S4 = (n*((QMLEerr.values - QMLEexp.values) ** 2))/V4
if regular_obs == 0:
    S4 = (N * ((QMLEerr.values - QMLEexp.values) ** 2)) / V4
test4 = np.zeros(M)
for i in range(M):
    test4[i] = int((S4[i] > 3.841))
prop4 = np.mean(test4)

## S5 prerequisite: regular_obs==0
alpha0 = 4
alphatilde = alpha0*(QMLEexp.values **(1/2))
omegabar = 0.48
kntilde = np.floor(np.sqrt(N))
Deltaloc = np.diff(sim.obsTimes)
untilde = np.zeros((M,sim.Nmax))
for i in range(M):
    untilde[i] = alphatilde[i]*(Deltaloc[i] ** omegabar)
DeltaN = T/N
V5 = np.zeros(M)
factor1 = 4/(T * DeltaN)
factor2 = 4/(kntilde * T * DeltaN)
for j in range(M):
    V5[j] = 0
    ret = np.diff(estprice[j])
    for i in range(int(N[j])):
        if abs(ret[i]) < untilde[j,i] and abs(ret[i+1]) < untilde[j,i+1]:
            V5[j] = V5[j] + factor1[j]*(ret[i] ** 2)*(ret[i+1] ** 2)
        if abs(ret[i]) > untilde[j, i]:
            if kntilde[j]-1 < i < n - kntilde[j]:
                V5[j] += factor2[j]*(ret[i] ** 2)*np.sum((ret[(i-kntilde[j]):(i+kntilde[j])] ** 2)*(ret[(i-kntilde[j]):(i+kntilde[j])] < untilde[j, i]))
S5 = (N * ((QMLEerr.values - QMLEexp.values) ** 2)) / V5
test5 = np.zeros(M)
for i in range(M):
    test5[i] = int((S5[i] > 3.841))
prop5 = np.mean(test5)









##### OLD VERSION NOT TO USE #######
#default_path = path('/users/Simon/desktop/Local MLE vol code/results/studentizationFinal/xi2small/')

####Boolean for activation/desactivation of estimators
QMLE_est = True
LQMLE_est = False
RK_est = False
LRK_est = False
PA_est = False
Yingying_est = True
Yingying_QMLE_est = True

start = 0 #for the case sample_step =1. Adjusted otherwise
end = -1

real_dailySeconds = 23400
ratio = (start - end - 1) / real_dailySeconds

# set simulation parameter
nbsecond = 1.  # duree entre deux trades en secondes
dailySeconds = 23400 + nbsecond * (start - (end + 1))
M = 1
T_obs = 1/252
T = T_obs + ratio/252

d = 1

#average_IQ = 6.5e-05#2.8e-05 (Model 2) #2.8655471018389605e-05
#xi2 = 0.0002
xi2 = 0

ndaily = int(dailySeconds / nbsecond)
n = int(dailySeconds * d / nbsecond)

##Model Name
modelName = "Model 1"
#default_path +=modelName +"/"

####Parameters for the Heston
mu = 0.03
rho = -0.75
kappa = 5
gamma = 0.4
alpha = 0.1

###Parameters for the jump
if modelName == "Model 1":
    jump_size = 0  # in % of the vol
    jump_start,jump_end=0,1
elif modelName == "Model 2":
    jump_size = .5 #in % of the vol
    jump_start,jump_end = 0,1
elif modelName == "Model 3":
    jump_size = .5  # in % of the vol
    jump_start,jump_end = 0.05,0.7

jump_mode = "unif"

####Parameters for the daily U-shaped vol

coeff= 0
scaling = 1
if modelName == "Model 2":
    coeff = 1
    scaling = 1
elif modelName == "Model 1" :
    coeff = 1.8 #To adjust
    scaling = 1.070189
elif modelName == "Model 3":
    coeff = 1.8
    scaling = 1

A = coeff*0.75/scaling
B = coeff*0.25/scaling
C = 0.88929198/scaling
a = 10.0
b = 10.0

sigma = 1#np.sqrt(0.1)

def riemann(g,k=500):
    return np.sum([g(i/k) for i in range(k)])*1/k

def sigma_u(x):
    return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma

tab = np.array([sigma_u(i/100) for i in np.arange(100)])


def sigma_u_jumps(x):
    if x <= 0.5:
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma
    else :
        return (C + A*np.exp(-a*x) + B*np.exp(-b*(1-x)))*sigma-0.5*sigma

priceArgs = [mu, kappa, alpha, gamma, rho, sigma_u, [jump_size,jump_start,jump_end], jump_mode]


####RK parameters
kernel_type = "th2"

#PA parameters
kernel_pa = "triang_ker"

#### Local parameters

nb_block_min = 2
nb_block_max = 8
block_step = 2
block_list = np.arange(nb_block_min,nb_block_max+1, block_step)

list_size = block_list.size

##Known noise parameters
knownNoiseArgs=0.001


## Simulate the data
print("Simulating trajectories...")
presim = Simulator(nbsecond,M,d,dailySeconds,T)

myPreSim = presim.simulGlobal(priceFun=presim.simulSVHeston,priceArgs=priceArgs,noiseFun=presim.simulNoiseIIDfromXi2,noiseArgs=[xi2,start,end,T_obs],  knownNoiseArgs=knownNoiseArgs, infotype="roll", recordMode=True)
#data_path = "/Volumes/BackupResearch/Data Local Est/xi2small/"+modelName+"/"
#presim.fromCSV(data_path)

rho_mean = presim.rhoGlobal(start,end).mean()
rho_std = presim.rhoGlobal(start,end).std()
kappa_mean = presim.kappaGlobal(start,end).mean()
kappa_std = presim.kappaGlobal(start,end).std()
#presim.simulSVHeston
sample_step = 1
sim = Simulator(nbsecond*sample_step,M,d,dailySeconds,T, modelName)
sim.Y, sim.IV, sim.R, sim.Q = presim.Y[:,::sample_step], presim.IV[:,::sample_step], presim.R[:,::sample_step], presim.Q[:,::sample_step]
sim.noiseArgs = presim.noiseArgs
sim.noiseVar = sim.noiseArgs[0]
sim.info = presim.info ## bien echantilloner quand local ?
sim.knownNoiseArgs = presim.knownNoiseArgs
a2true = sim.noiseArgs[0]

############################Statistical part##################################


######Estimating the various estimators

start_sample = start/sample_step
end_sample = (end+1)/sample_step-1

QMLE = Vol_QMLE(start_sample,end_sample,sim.__dict__,"QMLE"+str(real_dailySeconds/sample_step))
QMLE.spread = 1*abs(QMLE.info)
## test with spread
#for i in range(math.floor(QMLE.Y.size/2)) :
#    QMLE.spread[(2*i)]=10*info[(2*i)]

LQMLE = {nb_blocks : Vol_Local(start_sample, end_sample, sim.__dict__, "LQMLE on {0} blocks for {1} obs".format(nb_blocks,real_dailySeconds/sample_step)) for nb_blocks in block_list}

RK = Vol_RK(start_sample,end_sample,sim.__dict__,"RK"+str(real_dailySeconds/sample_step) )
#RK.setParam(kernel_type,"adaptive",Quart_PA,Vol_PA,Noise_Realized)

LRK = {nb_blocks : Vol_Local(start_sample, end_sample, sim.__dict__, "LRK on {0} blocks for {1} obs".format(nb_blocks,real_dailySeconds/sample_step)) for nb_blocks in block_list}

PA = Vol_PA(start_sample,end_sample,sim.__dict__, "PA"+str(real_dailySeconds/sample_step))
PA.setParam(kernel_pa,"adaptive",Vol_PA,Noise_Realized)

Yingying = Vol_Yingying(start_sample,end_sample,sim.__dict__,"QMLE"+str(real_dailySeconds/sample_step))
Yingying_QMLE = Vol_Yingying_QMLE(start_sample,end_sample,sim.__dict__,"QMLE"+str(real_dailySeconds/sample_step))

for nb_blocks in block_list:
    #LRK[nb_blocks].setParam(nb_blocks,Vol_RK,kernel_type,"adaptive",Quart_PA,Vol_PA,Noise_Realized)
    LQMLE[nb_blocks].setParam(nb_blocks,Vol_QMLE)

if QMLE_est :

    print("performing QMLE estimations...")
    QMLE.estim(infotype="spread")
    QMLE.compute_avar()
    QMLE.compute_best_avar()
    print("Done!")

if RK_est :
    print("performing RK estimations...")
    RK.estim()
    RK.compute_avar()
    RK.compute_avarH()
    RK.compute_best_avar()
    print("Done!")

if PA_est :
    print("performing PA estimations...")
    PA.estim()
    PA.compute_avar()
    PA.compute_best_avar()
    print("Done!")

if Yingying_est :
    print("performing Yingying estimations...")
    Yingying.estim(infotype="roll")
    #PA.compute_avar()
    #PA.compute_best_avar()
    print("Done!")

if Yingying_QMLE_est :
    print("performing Yingying estimations...")
    Yingying_QMLE.estim(infotype="roll")
    #PA.compute_avar()
    #PA.compute_best_avar()
    print("Done!")

for nb_blocks in block_list:
    if LQMLE_est :

        print("performing LQMLE estimations with {0} blocks...".format(nb_blocks))
        LQMLE[nb_blocks].estim()
        LQMLE[nb_blocks].compute_avar()
        LQMLE[nb_blocks].compute_best_avar()
        print("Done!")

    if LRK_est:
        print("performing LRK estimations with {0} blocks...".format(nb_blocks))

        LRK[nb_blocks].estim([RK.pre_estimatorRho.IQest.k * np.sqrt(RK.delta)])
        LRK[nb_blocks].compute_avar()
        LRK[nb_blocks].compute_best_avar()
        print("Done!")

block_list2 = [1]
block_list2.extend(block_list)
block_list2 = np.array(block_list2)

#refine the data by studentization
preData = {"stud_RMSE" : np.zeros(block_list2.size),
           "stud_bias" : np.zeros(block_list2.size),
           "stud_std": np.zeros(block_list2.size),
           "empirical loss": np.zeros(block_list2.size),
           "theoretic loss": np.zeros(block_list2.size),
           "(Student Std)^2 x Theoretic Loss:": np.zeros(block_list2.size),
           "(RMSE)^2 x Theoretic Loss:": np.zeros(block_list2.size)
           }

quantileList = [0.5,2.5,5,95,97.5,99.5]
for q in quantileList:
    preData["quantile{0}%".format(q)] = np.zeros(block_list2.size)

if RK_est or QMLE_est:
    ###RK/LRK student
    studentDataRK = DataFrame(preData,index = block_list2)

    studentDataRK["stud_RMSE"][1] = RK.studentRMSE()
    studentDataRK["stud_bias"][1] = RK.studentBias()
    studentDataRK["stud_std"][1] = RK.studentStd()
    studentDataRK["empirical loss"][1] = RK.empLoss()
    studentDataRK["theoretic loss"][1] = RK.theoLoss()
    studentDataRK["(Student Std)^2 x Theoretic Loss:"][1] = RK.studentStd()**2*RK.theoLoss()
    studentDataRK["(RMSE)^2 x Theoretic Loss:"][1] = RK.studentRMSE() ** 2 * RK.theoLoss()


    for q in quantileList:
        studentDataRK["quantile{0}%".format(q)][1] = RK.studentQuantile(q)

    for nb_blocks in block_list:

        studentDataRK["stud_RMSE"][nb_blocks] = LRK[nb_blocks].studentRMSE()
        studentDataRK["stud_bias"][nb_blocks] = LRK[nb_blocks].studentBias()
        studentDataRK["stud_std"][nb_blocks] = LRK[nb_blocks].studentStd()
        studentDataRK["empirical loss"][nb_blocks] = LRK[nb_blocks].empLoss()
        studentDataRK["theoretic loss"][nb_blocks] = LRK[nb_blocks].theoLoss()
        studentDataRK["(Student Std)^2 x Theoretic Loss:"][nb_blocks] = LRK[nb_blocks].studentStd() ** 2 * LRK[nb_blocks].theoLoss()
        studentDataRK["(RMSE)^2 x Theoretic Loss:"][nb_blocks] = LRK[nb_blocks].studentRMSE() ** 2 * LRK[nb_blocks].theoLoss()

        for q in quantileList:
            studentDataRK["quantile{0}%".format(q)][nb_blocks] = LRK[nb_blocks].studentQuantile(q)


    ###QMLE/LQMLE student
    studentDataQMLE = DataFrame(preData,index = block_list2)

    studentDataQMLE["stud_RMSE"][1] = QMLE.studentRMSE()
    studentDataQMLE["stud_bias"][1] = QMLE.studentBias()
    studentDataQMLE["stud_std"][1] = QMLE.studentStd()
    studentDataQMLE["empirical loss"][1] = QMLE.empLoss()
    studentDataQMLE["theoretic loss"][1] = QMLE.theoLoss()
    studentDataQMLE["(Student Std)^2 x Theoretic Loss:"][1] = QMLE.studentStd()**2*QMLE.theoLoss()
    studentDataQMLE["(RMSE)^2 x Theoretic Loss:"][1] = QMLE.studentRMSE() ** 2 * QMLE.theoLoss()

    for q in quantileList:
        studentDataQMLE["quantile{0}%".format(q)][1] = QMLE.studentQuantile(q)

    for nb_blocks in block_list:

        studentDataQMLE["stud_RMSE"][nb_blocks] = LQMLE[nb_blocks].studentRMSE()
        studentDataQMLE["stud_bias"][nb_blocks] = LQMLE[nb_blocks].studentBias()
        studentDataQMLE["stud_std"][nb_blocks] = LQMLE[nb_blocks].studentStd()
        studentDataQMLE["empirical loss"][nb_blocks] = LQMLE[nb_blocks].empLoss()
        studentDataQMLE["theoretic loss"][nb_blocks] = LQMLE[nb_blocks].theoLoss()
        studentDataQMLE["(Student Std)^2 x Theoretic Loss:"][nb_blocks] = LQMLE[nb_blocks].studentStd() ** 2 * LQMLE[nb_blocks].theoLoss()
        studentDataQMLE["(RMSE)^2 x Theoretic Loss:"][nb_blocks] = LQMLE[nb_blocks].studentRMSE() ** 2 * LQMLE[nb_blocks].theoLoss()

        for q in quantileList:
            studentDataQMLE["quantile{0}%".format(q)][nb_blocks] = LQMLE[nb_blocks].studentQuantile(q)

    #RK.toCsv(default_path)
    #QMLE.toCsv(default_path)

    #for est in LRK.values():
    #    est.toCsv(default_path)
    #    for sub in est.sub_estimator:
    #        sub.toCsv(default_path)

    #for est in LQMLE.values():
    #    est.toCsv(default_path)
    #    for sub in est.sub_estimator:
    #        sub.toCsv(default_path)

    #studentDataRK.to_csv(default_path/"studentDataRK{0}.csv".format(real_dailySeconds/sample_step))
    #studentDataQMLE.to_csv(default_path/"studentDataQMLE{0}.csv".format(real_dailySeconds/sample_step))

if PA_est:
    preDataPA = {"stud_RMSE" : np.zeros(1),
           "stud_bias" : np.zeros(1),
           "stud_std": np.zeros(1),
           "empirical loss": np.zeros(1),
           "theoretic loss": np.zeros(1),
           "(Student Std)^2 x Theoretic Loss:": np.zeros(1),
           "(RMSE)^2 x Theoretic Loss:": np.zeros(1)
           }

    for q in quantileList:
        preDataPA["quantile{0}%".format(q)] = np.zeros(1)
    PA.toCsv(default_path)

    studentDataPA = DataFrame(preDataPA, index = [1])

    studentDataPA["stud_RMSE"][1] = PA.studentRMSE()
    studentDataPA["stud_bias"][1] = PA.studentBias()
    studentDataPA["stud_std"][1] = PA.studentStd()
    studentDataPA["empirical loss"][1] = PA.empLoss()
    studentDataPA["theoretic loss"][1] = PA.theoLoss()
    studentDataPA["(Student Std)^2 x Theoretic Loss:"][1] = PA.studentStd() ** 2 * PA.theoLoss()
    studentDataPA["(RMSE)^2 x Theoretic Loss:"][1] = PA.studentRMSE() ** 2 * PA.theoLoss()

    for q in quantileList:
        studentDataPA["quantile{0}%".format(q)][1] = PA.studentQuantile(q)

    studentDataPA.to_csv(default_path / "studentDataPA{0}.csv".format(real_dailySeconds / sample_step))

Noise_value = 1/np.mean(1/np.sqrt(1/252*(presim.Q[:,end]-presim.Q[:,start])))

###saving the data
#presim2 = Simulator(nbsecond,M,d,dailySeconds,T,modelName)
#presim2.Y, presim2.IV, presim2.R, presim2.Q = presim.Y, presim.IV, presim.R, presim.Q
#presim2.noiseArgs = presim.noiseArgs

#data_path =path("/Volumes/BackupResearch/Data Local Est/xi2small/{0}".format(modelName))#path('/users/Simon/desktop/Local MLE vol code/results/')# Data/'+presim2.name+"/")
#presim.toCSV(data_path)


###Computing rho and kappa